/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.function.BiPredicate;

final class NumberEqualityUtil {
    public static <Score_ extends Score<Score_>> BiPredicate<Number, Number> getEqualityPredicate(ScoreDefinition<Score_> scoreDefinition, Number expectedImpact) {
        if (expectedImpact instanceof Integer) {
            return NumberEqualityUtil.getIntEqualityPredicate(scoreDefinition);
        }
        if (expectedImpact instanceof Long) {
            return NumberEqualityUtil.getLongEqualityPredicate(scoreDefinition);
        }
        if (expectedImpact instanceof BigDecimal) {
            return NumberEqualityUtil.getBigDecimalEqualityPredicate(scoreDefinition);
        }
        throw new IllegalStateException("Impossible state: unknown impact type class (" + expectedImpact.getClass() + ") for impact (" + expectedImpact + ").");
    }

    private static <Score_ extends Score<Score_>> BiPredicate<Number, Number> getIntEqualityPredicate(ScoreDefinition<Score_> scoreDefinition) {
        Class actualImpactType = scoreDefinition.getNumericType();
        if (actualImpactType == Integer.TYPE) {
            return (expected, actual) -> expected.intValue() == actual.intValue();
        }
        if (actualImpactType == Long.TYPE) {
            return (expected, actual) -> expected.longValue() == actual.longValue();
        }
        if (actualImpactType == BigDecimal.class) {
            return (expected, actual) -> BigDecimal.valueOf(expected.intValue()).compareTo((BigDecimal)actual) == 0;
        }
        throw new IllegalStateException("Impossible state: unknown numeric type (" + actualImpactType + ") for score definition (" + scoreDefinition.getClass() + ").");
    }

    private static <Score_ extends Score<Score_>> BiPredicate<Number, Number> getLongEqualityPredicate(ScoreDefinition<Score_> scoreDefinition) {
        Class actualImpactType = scoreDefinition.getNumericType();
        if (actualImpactType == Integer.TYPE) {
            return (expected, actual) -> expected.longValue() == (long)actual.intValue();
        }
        if (actualImpactType == Long.TYPE) {
            return (expected, actual) -> expected.longValue() == actual.longValue();
        }
        if (actualImpactType == BigDecimal.class) {
            return (expected, actual) -> BigDecimal.valueOf(expected.longValue()).compareTo((BigDecimal)actual) == 0;
        }
        throw new IllegalStateException("Impossible state: unknown numeric type (" + actualImpactType + ") for score definition (" + scoreDefinition.getClass() + ").");
    }

    private static <Score_ extends Score<Score_>> BiPredicate<Number, Number> getBigDecimalEqualityPredicate(ScoreDefinition<Score_> scoreDefinition) {
        Class actualImpactType = scoreDefinition.getNumericType();
        if (actualImpactType == Integer.TYPE) {
            return (expected, actual) -> ((BigDecimal)expected).compareTo(BigDecimal.valueOf(actual.intValue())) == 0;
        }
        if (actualImpactType == Long.TYPE) {
            return (expected, actual) -> ((BigDecimal)expected).compareTo(BigDecimal.valueOf(actual.longValue())) == 0;
        }
        if (actualImpactType == BigDecimal.class) {
            return (expected, actual) -> ((BigDecimal)expected).compareTo((BigDecimal)actual) == 0;
        }
        throw new IllegalStateException("Impossible state: unknown numeric type (" + actualImpactType + ") for score definition (" + scoreDefinition.getClass() + ").");
    }

    public static Comparator<Number> getComparison(Number expectedImpact) {
        return Comparator.comparing(a -> {
            if (a instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)a;
                return bigDecimal;
            }
            return BigDecimal.valueOf(a.longValue());
        });
    }

    private NumberEqualityUtil() {
    }
}

