/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactoryService;
import ai.timefold.solver.constraint.streams.common.InnerConstraintFactory;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactoryService;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorType;
import ai.timefold.solver.test.impl.score.stream.ConfiguredConstraintVerifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

final class ScoreDirectorFactoryCache<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>> {
    private final Map<String, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>> scoreDirectorFactoryMap = new HashMap<String, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>>();
    private final ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_> parent;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final ServiceLoader<ScoreDirectorFactoryService<Solution_, Score_>> serviceLoader;

    public ScoreDirectorFactoryCache(ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_> parent, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.parent = Objects.requireNonNull(parent);
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.serviceLoader = ServiceLoader.load(ScoreDirectorFactoryService.class);
    }

    private AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> getScoreDirectorFactoryService() {
        return this.serviceLoader.stream().map(ServiceLoader.Provider::get).filter(s -> s.getSupportedScoreDirectorType() == ScoreDirectorType.CONSTRAINT_STREAMS).map(s -> (AbstractConstraintStreamScoreDirectorFactoryService)s).findFirst().orElseThrow(() -> new IllegalStateException("Constraint Streams implementation was not found on the classpath.\nMaybe include the ai.timefold.solver:timefold-solver-constraint-streams dependency in your project?\nMaybe ensure your uberjar bundles META-INF/services from included JAR files?"));
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction, ConstraintProvider_ constraintProvider, EnvironmentMode environmentMode) {
        AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> scoreDirectorFactoryService = this.getScoreDirectorFactoryService();
        InnerConstraintFactory fullConstraintFactory = (InnerConstraintFactory)scoreDirectorFactoryService.buildConstraintFactory(this.solutionDescriptor, environmentMode);
        List constraints = fullConstraintFactory.buildConstraints(constraintProvider);
        Constraint expectedConstraint = constraintFunction.apply(constraintProvider, (ConstraintFactory)fullConstraintFactory);
        Constraint result = constraints.stream().filter(c -> Objects.equals(c.getConstraintId(), expectedConstraint.getConstraintId())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible state: Constraint provider (" + constraintProvider + ") has no constraint (" + expectedConstraint + ")."));
        String constraintId = result.getConstraintId();
        return this.getScoreDirectorFactory(constraintId, constraintFactory -> new Constraint[]{result}, environmentMode);
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory(String key, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        return this.scoreDirectorFactoryMap.computeIfAbsent(key, k -> this.createScoreDirectorFactory(this.getScoreDirectorFactoryService(), constraintProvider, environmentMode));
    }

    private AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> createScoreDirectorFactory(AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> scoreDirectorFactoryService, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        return scoreDirectorFactoryService.buildScoreDirectorFactory(this.solutionDescriptor, constraintProvider, environmentMode);
    }
}

