/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.api.client.model;

import ai.tock.nlp.api.client.model.NlpEntityValue;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\tJ\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010)\u001a\u00020\fJ\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010/\u001a\u00020\fH\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\u0015\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u0010H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0087\u0001\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u00032\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u00105\u001a\u00020(2\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u000208H\u00d6\u0001J\t\u00109\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015\u00a8\u0006:"}, d2={"Lai/tock/nlp/api/client/model/NlpResult;", "", "intent", "", "intentNamespace", "language", "Ljava/util/Locale;", "entities", "", "Lai/tock/nlp/api/client/model/NlpEntityValue;", "notRetainedEntities", "intentProbability", "", "entitiesProbability", "retainedQuery", "otherIntentsProbabilities", "", "staticResponse", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Ljava/util/List;Ljava/util/List;DDLjava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getIntent", "()Ljava/lang/String;", "getIntentNamespace", "getLanguage", "()Ljava/util/Locale;", "getEntities", "()Ljava/util/List;", "getNotRetainedEntities", "getIntentProbability", "()D", "getEntitiesProbability", "getRetainedQuery", "getOtherIntentsProbabilities", "()Ljava/util/Map;", "getStaticResponse", "firstValue", "role", "entityTextContent", "value", "hasIntent", "", "minProbability", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "hashCode", "", "toString", "nlp-api-client"})
@SourceDebugExtension(value={"SMAP\nNlpResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpResult.kt\nai/tock/nlp/api/client/model/NlpResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n295#2,2:75\n188#3,3:77\n*S KotlinDebug\n*F\n+ 1 NlpResult.kt\nai/tock/nlp/api/client/model/NlpResult\n*L\n67#1:75,2\n72#1:77,3\n*E\n"})
public final class NlpResult {
    @NotNull
    private final String intent;
    @NotNull
    private final String intentNamespace;
    @NotNull
    private final Locale language;
    @NotNull
    private final List<NlpEntityValue> entities;
    @NotNull
    private final List<NlpEntityValue> notRetainedEntities;
    private final double intentProbability;
    private final double entitiesProbability;
    @NotNull
    private final String retainedQuery;
    @NotNull
    private final Map<String, Double> otherIntentsProbabilities;
    @Nullable
    private final String staticResponse;

    public NlpResult(@NotNull String intent, @NotNull String intentNamespace, @NotNull Locale language, @NotNull List<NlpEntityValue> entities, @NotNull List<NlpEntityValue> notRetainedEntities, double intentProbability, double entitiesProbability, @NotNull String retainedQuery, @NotNull Map<String, Double> otherIntentsProbabilities, @Nullable String staticResponse) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)intentNamespace, (String)"intentNamespace");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter(notRetainedEntities, (String)"notRetainedEntities");
        Intrinsics.checkNotNullParameter((Object)retainedQuery, (String)"retainedQuery");
        Intrinsics.checkNotNullParameter(otherIntentsProbabilities, (String)"otherIntentsProbabilities");
        this.intent = intent;
        this.intentNamespace = intentNamespace;
        this.language = language;
        this.entities = entities;
        this.notRetainedEntities = notRetainedEntities;
        this.intentProbability = intentProbability;
        this.entitiesProbability = entitiesProbability;
        this.retainedQuery = retainedQuery;
        this.otherIntentsProbabilities = otherIntentsProbabilities;
        this.staticResponse = staticResponse;
    }

    public /* synthetic */ NlpResult(String string, String string2, Locale locale, List list, List list2, double d, double d2, String string3, Map map, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            d = 1.0;
        }
        if ((n & 0x40) != 0) {
            d2 = 1.0;
        }
        if ((n & 0x100) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x200) != 0) {
            string4 = null;
        }
        this(string, string2, locale, list, list2, d, d2, string3, map, string4);
    }

    @NotNull
    public final String getIntent() {
        return this.intent;
    }

    @NotNull
    public final String getIntentNamespace() {
        return this.intentNamespace;
    }

    @NotNull
    public final Locale getLanguage() {
        return this.language;
    }

    @NotNull
    public final List<NlpEntityValue> getEntities() {
        return this.entities;
    }

    @NotNull
    public final List<NlpEntityValue> getNotRetainedEntities() {
        return this.notRetainedEntities;
    }

    public final double getIntentProbability() {
        return this.intentProbability;
    }

    public final double getEntitiesProbability() {
        return this.entitiesProbability;
    }

    @NotNull
    public final String getRetainedQuery() {
        return this.retainedQuery;
    }

    @NotNull
    public final Map<String, Double> getOtherIntentsProbabilities() {
        return this.otherIntentsProbabilities;
    }

    @Nullable
    public final String getStaticResponse() {
        return this.staticResponse;
    }

    @Nullable
    public final NlpEntityValue firstValue(@NotNull String role) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Iterable $this$firstOrNull$iv = this.entities;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NlpEntityValue it = (NlpEntityValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEntity().getRole(), (Object)role)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final String entityTextContent(@NotNull NlpEntityValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = this.retainedQuery.substring(value.getStart(), value.getEnd());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public final boolean hasIntent(@NotNull String intent, double minProbability) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            Map<String, Double> $this$any$iv = this.otherIntentsProbabilities;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, Double>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Double> element$iv;
                    Map.Entry<String, Double> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)intent, (Object)it.getKey()) && ((Number)it.getValue()).doubleValue() > minProbability)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean hasIntent$default(NlpResult nlpResult, String string, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return nlpResult.hasIntent(string, d);
    }

    @NotNull
    public final String component1() {
        return this.intent;
    }

    @NotNull
    public final String component2() {
        return this.intentNamespace;
    }

    @NotNull
    public final Locale component3() {
        return this.language;
    }

    @NotNull
    public final List<NlpEntityValue> component4() {
        return this.entities;
    }

    @NotNull
    public final List<NlpEntityValue> component5() {
        return this.notRetainedEntities;
    }

    public final double component6() {
        return this.intentProbability;
    }

    public final double component7() {
        return this.entitiesProbability;
    }

    @NotNull
    public final String component8() {
        return this.retainedQuery;
    }

    @NotNull
    public final Map<String, Double> component9() {
        return this.otherIntentsProbabilities;
    }

    @Nullable
    public final String component10() {
        return this.staticResponse;
    }

    @NotNull
    public final NlpResult copy(@NotNull String intent, @NotNull String intentNamespace, @NotNull Locale language, @NotNull List<NlpEntityValue> entities, @NotNull List<NlpEntityValue> notRetainedEntities, double intentProbability, double entitiesProbability, @NotNull String retainedQuery, @NotNull Map<String, Double> otherIntentsProbabilities, @Nullable String staticResponse) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)intentNamespace, (String)"intentNamespace");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter(notRetainedEntities, (String)"notRetainedEntities");
        Intrinsics.checkNotNullParameter((Object)retainedQuery, (String)"retainedQuery");
        Intrinsics.checkNotNullParameter(otherIntentsProbabilities, (String)"otherIntentsProbabilities");
        return new NlpResult(intent, intentNamespace, language, entities, notRetainedEntities, intentProbability, entitiesProbability, retainedQuery, otherIntentsProbabilities, staticResponse);
    }

    public static /* synthetic */ NlpResult copy$default(NlpResult nlpResult, String string, String string2, Locale locale, List list, List list2, double d, double d2, String string3, Map map, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = nlpResult.intent;
        }
        if ((n & 2) != 0) {
            string2 = nlpResult.intentNamespace;
        }
        if ((n & 4) != 0) {
            locale = nlpResult.language;
        }
        if ((n & 8) != 0) {
            list = nlpResult.entities;
        }
        if ((n & 0x10) != 0) {
            list2 = nlpResult.notRetainedEntities;
        }
        if ((n & 0x20) != 0) {
            d = nlpResult.intentProbability;
        }
        if ((n & 0x40) != 0) {
            d2 = nlpResult.entitiesProbability;
        }
        if ((n & 0x80) != 0) {
            string3 = nlpResult.retainedQuery;
        }
        if ((n & 0x100) != 0) {
            map = nlpResult.otherIntentsProbabilities;
        }
        if ((n & 0x200) != 0) {
            string4 = nlpResult.staticResponse;
        }
        return nlpResult.copy(string, string2, locale, list, list2, d, d2, string3, map, string4);
    }

    @NotNull
    public String toString() {
        return "NlpResult(intent=" + this.intent + ", intentNamespace=" + this.intentNamespace + ", language=" + this.language + ", entities=" + this.entities + ", notRetainedEntities=" + this.notRetainedEntities + ", intentProbability=" + this.intentProbability + ", entitiesProbability=" + this.entitiesProbability + ", retainedQuery=" + this.retainedQuery + ", otherIntentsProbabilities=" + this.otherIntentsProbabilities + ", staticResponse=" + this.staticResponse + ")";
    }

    public int hashCode() {
        int result = this.intent.hashCode();
        result = result * 31 + this.intentNamespace.hashCode();
        result = result * 31 + this.language.hashCode();
        result = result * 31 + ((Object)this.entities).hashCode();
        result = result * 31 + ((Object)this.notRetainedEntities).hashCode();
        result = result * 31 + Double.hashCode(this.intentProbability);
        result = result * 31 + Double.hashCode(this.entitiesProbability);
        result = result * 31 + this.retainedQuery.hashCode();
        result = result * 31 + ((Object)this.otherIntentsProbabilities).hashCode();
        result = result * 31 + (this.staticResponse == null ? 0 : this.staticResponse.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NlpResult)) {
            return false;
        }
        NlpResult nlpResult = (NlpResult)other;
        if (!Intrinsics.areEqual((Object)this.intent, (Object)nlpResult.intent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.intentNamespace, (Object)nlpResult.intentNamespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.language, (Object)nlpResult.language)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.entities, nlpResult.entities)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.notRetainedEntities, nlpResult.notRetainedEntities)) {
            return false;
        }
        if (Double.compare(this.intentProbability, nlpResult.intentProbability) != 0) {
            return false;
        }
        if (Double.compare(this.entitiesProbability, nlpResult.entitiesProbability) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.retainedQuery, (Object)nlpResult.retainedQuery)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.otherIntentsProbabilities, nlpResult.otherIntentsProbabilities)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.staticResponse, (Object)nlpResult.staticResponse);
    }
}

