/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.api.client;

import ai.tock.nlp.api.client.BooleanResponse;
import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.NlpService;
import ai.tock.nlp.api.client.TockNlpClient;
import ai.tock.nlp.api.client.model.NlpLogCount;
import ai.tock.nlp.api.client.model.NlpLogCountQuery;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDefinition;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.CreateApplicationQuery;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationQuery;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationResult;
import ai.tock.nlp.api.client.model.merge.ValuesMergeQuery;
import ai.tock.nlp.api.client.model.merge.ValuesMergeResult;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.shared.RetrofitsKt;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010'\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0013\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0013\u001a\u000200H\u0016J\u001f\u00101\u001a\u0004\u0018\u0001H2\"\u0004\b\u0000\u00102*\b\u0012\u0004\u0012\u0002H203H\u0002\u00a2\u0006\u0002\u00104R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lai/tock/nlp/api/client/TockNlpClient;", "Lai/tock/nlp/api/client/NlpClient;", "baseUrl", "", "(Ljava/lang/String;)V", "nlpService", "Lai/tock/nlp/api/client/NlpService;", "createApplication", "Lai/tock/nlp/api/client/model/dump/ApplicationDefinition;", "namespace", "name", "locale", "Ljava/util/Locale;", "createMultipart", "Lokhttp3/MultipartBody$Part;", "stream", "Ljava/io/InputStream;", "evaluateEntities", "Lai/tock/nlp/api/client/model/evaluation/EntityEvaluationResult;", "query", "Lai/tock/nlp/api/client/model/evaluation/EntityEvaluationQuery;", "getApplicationByNamespaceAndName", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "healthcheck", "", "importNlpDump", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "logsCount", "Lai/tock/nlp/api/client/model/NlpLogCount;", "Lai/tock/nlp/api/client/model/NlpLogCountQuery;", "longProperty", "", "defaultValue", "markAsUnknown", "", "Lai/tock/nlp/api/client/model/monitoring/MarkAsUnknownQuery;", "mergeValues", "Lai/tock/nlp/api/client/model/merge/ValuesMergeResult;", "Lai/tock/nlp/api/client/model/merge/ValuesMergeQuery;", "parse", "Lai/tock/nlp/api/client/model/NlpResult;", "Lai/tock/nlp/api/client/model/NlpQuery;", "parseAndReturns", "T", "Lretrofit2/Response;", "(Lretrofit2/Response;)Ljava/lang/Object;", "Companion", "nlp-api-client"})
public final class TockNlpClient
implements NlpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NlpService nlpService;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    public TockNlpClient(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        mapper.findAndRegisterModules();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        long timeout = this.longProperty("tock_nlp_client_request_timeout_ms", 20000L);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl + "/rest/nlp/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(new OkHttpClient.Builder().readTimeout(timeout, TimeUnit.MILLISECONDS).connectTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new HttpLoggingInterceptor(null, 1, null).setLevel(HttpLoggingInterceptor.Level.valueOf((String)RetrofitsKt.retrofitLogLevel((String)RetrofitsKt.getRetrofitDefaultLogLevel()).toString()))).build()).build();
        Object object = retrofit.create(NlpService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.nlpService = (NlpService)object;
    }

    public /* synthetic */ TockNlpClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = System.getenv("tock_nlp_service_url");
            if (string2 == null) {
                string2 = "http://localhost:8888";
            }
            string = string2;
        }
        this(string);
    }

    private final long longProperty(String name, long defaultValue) {
        String string = System.getenv(name);
        return string != null ? Long.parseLong(string) : defaultValue;
    }

    private final <T> T parseAndReturns(Response<T> $this$parseAndReturns) {
        Object object = $this$parseAndReturns.body();
        if (object == null) {
            Response<T> $this$parseAndReturns_u24lambda_u240 = $this$parseAndReturns;
            boolean bl = false;
            logger.error((Function0)new Function0<Object>($this$parseAndReturns_u24lambda_u240){
                final /* synthetic */ Response<T> $this_run;
                {
                    this.$this_run = $receiver;
                    super(0);
                }

                public final Object invoke() {
                    ResponseBody responseBody = this.$this_run.errorBody();
                    return "nlp error : " + (responseBody != null ? responseBody.string() : null);
                }
            });
            object = null;
        }
        return (T)object;
    }

    @Override
    @Nullable
    public NlpResult parse(@NotNull NlpQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Response response = this.nlpService.parse(query).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return (NlpResult)this.parseAndReturns(response);
    }

    @Override
    @Nullable
    public EntityEvaluationResult evaluateEntities(@NotNull EntityEvaluationQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Response response = this.nlpService.evaluateEntities(query).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return (EntityEvaluationResult)this.parseAndReturns(response);
    }

    @Override
    @Nullable
    public ValuesMergeResult mergeValues(@NotNull ValuesMergeQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Response response = this.nlpService.mergeValues(query).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return (ValuesMergeResult)this.parseAndReturns(response);
    }

    @Override
    public void markAsUnknown(@NotNull MarkAsUnknownQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.nlpService.markAsUnknown(query).execute();
    }

    @Override
    @Nullable
    public ApplicationDefinition createApplication(@NotNull String namespace, @NotNull String name, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (ApplicationDefinition)this.nlpService.createApplication(new CreateApplicationQuery(name, null, namespace, locale, 2, null)).execute().body();
    }

    private final MultipartBody.Part createMultipart(InputStream stream) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream $this$createMultipart_u24lambda_u241 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int nRead = 0;
        byte[] data = new byte[2048];
        while (nRead != -1) {
            nRead = stream.read(data, 0, data.length);
            if (nRead == -1) continue;
            $this$createMultipart_u24lambda_u241.write(data, 0, Math.min(nRead, data.length));
        }
        $this$createMultipart_u24lambda_u241.flush();
        ByteArrayOutputStream dump = byteArrayOutputStream;
        byte[] byArray = dump.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return MultipartBody.Part.Companion.createFormData("dump", "dump", RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)MultipartBody.FORM, (byte[])byArray, (int)0, (int)0, (int)12, null));
    }

    @Override
    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Response response = this.nlpService.getIntentsByNamespaceAndName(namespace, name).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return (List)this.parseAndReturns(response);
    }

    @Override
    @Nullable
    public ApplicationDefinition getApplicationByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Response response = this.nlpService.getApplicationByNamespaceAndName(namespace, name).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return (ApplicationDefinition)this.parseAndReturns(response);
    }

    @Override
    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BooleanResponse booleanResponse = (BooleanResponse)this.nlpService.importNlpDump(this.createMultipart(stream)).execute().body();
        return booleanResponse != null ? booleanResponse.getSuccess() : false;
    }

    @Override
    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        BooleanResponse booleanResponse = (BooleanResponse)this.nlpService.importNlpPlainDump(dump).execute().body();
        return booleanResponse != null ? booleanResponse.getSuccess() : false;
    }

    @Override
    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BooleanResponse booleanResponse = (BooleanResponse)this.nlpService.importNlpSentencesDump(this.createMultipart(stream)).execute().body();
        return booleanResponse != null ? booleanResponse.getSuccess() : false;
    }

    @Override
    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        BooleanResponse booleanResponse = (BooleanResponse)this.nlpService.importNlpPlainSentencesDump(dump).execute().body();
        return booleanResponse != null ? booleanResponse.getSuccess() : false;
    }

    @Override
    @Nullable
    public List<NlpLogCount> logsCount(@NotNull NlpLogCountQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Response response = this.nlpService.logsCount(query).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return (List)this.parseAndReturns(response);
    }

    @Override
    public boolean healthcheck() {
        boolean bl;
        try {
            bl = this.nlpService.healthcheck().execute().isSuccessful();
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    public TockNlpClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/nlp/api/client/TockNlpClient$Companion;", "", "()V", "logger", "Lmu/KLogger;", "nlp-api-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

