/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.analytics.chatbase;

import ai.tock.analytics.chatbase.ChatBaseClient;
import ai.tock.analytics.chatbase.model.Message;
import ai.tock.analytics.chatbase.model.Response;
import ai.tock.analytics.chatbase.model.Status;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.POST;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/tock/analytics/chatbase/ChatBaseClient;", "", "()V", "BASE_URL", "", "genericMessageApi", "Lai/tock/analytics/chatbase/ChatBaseClient$GenericMessageApi;", "logger", "Lmu/KLogger;", "message", "", "Lai/tock/analytics/chatbase/model/Message;", "logError", "", "Lretrofit2/Response;", "GenericMessageApi", "tock-analytics-chatbase"})
@SourceDebugExtension(value={"SMAP\nChatBaseClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatBaseClient.kt\nai/tock/analytics/chatbase/ChatBaseClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,81:1\n71#2:82\n*S KotlinDebug\n*F\n+ 1 ChatBaseClient.kt\nai/tock/analytics/chatbase/ChatBaseClient\n*L\n54#1:82\n*E\n"})
public final class ChatBaseClient {
    @NotNull
    private final String BASE_URL;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final GenericMessageApi genericMessageApi;

    public ChatBaseClient() {
        this.BASE_URL = "https://www.chatbase.com/";
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_chatbase_request_timeout_ms", (long)3000L), (KLogger)this.logger, null, null, (boolean)false, (boolean)false, null, (int)124, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"baseUrl(...)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(GenericMessageApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.genericMessageApi = (GenericMessageApi)object;
    }

    private final void logError(retrofit2.Response<?> $this$logError) {
        String error = $this$logError.message();
        int errorCode = $this$logError.code();
        this.logger.error((Function0)new Function0<Object>(errorCode, error){
            final /* synthetic */ int $errorCode;
            final /* synthetic */ String $error;
            {
                this.$errorCode = $errorCode;
                this.$error = $error;
                super(0);
            }

            public final Object invoke() {
                return "Chatbase Error : " + this.$errorCode + " " + this.$error;
            }
        });
        ResponseBody responseBody = $this$logError.errorBody();
        String errorBody = responseBody != null ? responseBody.string() : null;
        this.logger.error((Function0)new Function0<Object>(errorBody){
            final /* synthetic */ String $errorBody;
            {
                this.$errorBody = $errorBody;
                super(0);
            }

            public final Object invoke() {
                return "Chatbase Error body : " + this.$errorBody;
            }
        });
    }

    public final boolean message(@NotNull Message message) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            boolean bl2;
            retrofit2.Response response = this.genericMessageApi.message(message).execute();
            if (response.isSuccessful()) {
                Response response2 = (Response)response.body();
                bl2 = (response2 != null ? response2.getStatus() : null) == Status.OK;
            } else {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0002\u001a\u00020\u0005H'\u00a8\u0006\u0006"}, d2={"Lai/tock/analytics/chatbase/ChatBaseClient$GenericMessageApi;", "", "message", "Lretrofit2/Call;", "Lai/tock/analytics/chatbase/model/Response;", "Lai/tock/analytics/chatbase/model/Message;", "tock-analytics-chatbase"})
    public static interface GenericMessageApi {
        @POST(value="/api/message")
        @NotNull
        public Call<Response> message(@Body @NotNull Message var1);
    }
}

