/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.aws.secretmanager.dao;

import ai.tock.aws.EnvConfig;
import ai.tock.aws.secretmanager.dao.SecretAWSDAO;
import ai.tock.aws.secretmanager.dao.SecretDAO;
import ai.tock.aws.utils.UtilsKt;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.AWSSecretsManagerException;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/tock/aws/secretmanager/dao/SecretAWSDAO;", "Lai/tock/aws/secretmanager/dao/SecretDAO;", "()V", "lockOnSecretCache", "Ljava/util/concurrent/locks/Lock;", "logger", "Lmu/KLogger;", "secretsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "secretsManagerClient", "Lcom/amazonaws/services/secretsmanager/AWSSecretsManager;", "stsClient", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "kotlin.jvm.PlatformType", "getSecret", "secretId", "getTemporaryCredentials", "Lcom/amazonaws/services/securitytoken/model/Credentials;", "initSecretsManagerWithNewCredentials", "tock-aws-tools"})
public final class SecretAWSDAO
implements SecretDAO {
    private AWSSecurityTokenService stsClient = (AWSSecurityTokenService)AWSSecurityTokenServiceClientBuilder.standard().build();
    @NotNull
    private AWSSecretsManager secretsManagerClient;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final Lock lockOnSecretCache = new ReentrantLock();
    @NotNull
    private Cache<String, String> secretsCache;

    public SecretAWSDAO() {
        Cache cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.secretsCache = cache;
        this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getSecret(@NotNull String secretId) {
        Intrinsics.checkNotNullParameter((Object)secretId, (String)"secretId");
        Lock lock = this.lockOnSecretCache;
        lock.lock();
        try {
            boolean bl = false;
            String storedSecretValue = (String)this.secretsCache.getIfPresent((Object)secretId);
            if (storedSecretValue != null) {
                String string = storedSecretValue;
                return string;
            }
            GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretId).withVersionStage(UtilsKt.property("aws_secret_manager_secret_version", "AWSCURRENT"));
            GetSecretValueResult response = null;
            try {
                GetSecretValueResult getSecretValueResult = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
                Intrinsics.checkNotNullExpressionValue((Object)getSecretValueResult, (String)"getSecretValue(...)");
                response = getSecretValueResult;
            }
            catch (AWSSecretsManagerException e) {
                if (Intrinsics.areEqual((Object)e.getErrorCode(), (Object)"ExpiredTokenException")) {
                    this.logger.debug((Function0)getSecret.1.1.INSTANCE);
                    this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
                    GetSecretValueResult getSecretValueResult = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
                    Intrinsics.checkNotNullExpressionValue((Object)getSecretValueResult, (String)"getSecretValue(...)");
                    response = getSecretValueResult;
                }
                throw e;
            }
            String it = response.getSecretString();
            boolean bl2 = false;
            this.secretsCache.put((Object)secretId, (Object)it);
            Intrinsics.checkNotNull((Object)it);
            String string = it;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private final AWSSecretsManager initSecretsManagerWithNewCredentials() {
        if (UtilsKt.booleanProperty$default("aws_secret_manager_assumed_role_arn", false, 2, null)) {
            Credentials it = this.getTemporaryCredentials();
            boolean bl = false;
            BasicSessionCredentials awsSessionCredentials = new BasicSessionCredentials(it.getAccessKeyId(), it.getSecretAccessKey(), it.getSessionToken());
            Object object = ((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsSessionCredentials))).build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
            return (AWSSecretsManager)object;
        }
        Object object = AWSSecretsManagerClientBuilder.standard().build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AWSSecretsManager)object;
    }

    private final Credentials getTemporaryCredentials() {
        AssumeRoleRequest request = new AssumeRoleRequest().withRoleArn(EnvConfig.INSTANCE.getAwsSecretManagerAssumedRole()).withRoleSessionName(EnvConfig.INSTANCE.getAwsAssumedRoleSessionName()).withDurationSeconds(Integer.valueOf(900));
        Credentials credentials = this.stsClient.assumeRole(request).getCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)credentials, (String)"getCredentials(...)");
        return credentials;
    }
}

