/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.aws.secretmanager.dao;

import ai.tock.aws.EnvConfig;
import ai.tock.aws.secretmanager.dao.SecretDAO;
import ai.tock.aws.utils.UtilsKt;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.AWSSecretsManagerException;
import com.amazonaws.services.secretsmanager.model.CreateSecretRequest;
import com.amazonaws.services.secretsmanager.model.CreateSecretResult;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.ResourceNotFoundException;
import com.amazonaws.services.secretsmanager.model.UpdateSecretRequest;
import com.amazonaws.services.secretsmanager.model.UpdateSecretResult;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/aws/secretmanager/dao/SecretAWSDAO;", "Lai/tock/aws/secretmanager/dao/SecretDAO;", "<init>", "()V", "stsClient", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "kotlin.jvm.PlatformType", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "secretsManagerClient", "Lcom/amazonaws/services/secretsmanager/AWSSecretsManager;", "logger", "Lmu/KLogger;", "lockOnSecretCache", "Ljava/util/concurrent/locks/Lock;", "secretsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "getSecret", "secretId", "initSecretsManagerWithNewCredentials", "getTemporaryCredentials", "Lcom/amazonaws/services/securitytoken/model/Credentials;", "createOrUpdateSecret", "secretName", "secretObject", "", "tock-aws-tools"})
public final class SecretAWSDAO
implements SecretDAO {
    private AWSSecurityTokenService stsClient = (AWSSecurityTokenService)AWSSecurityTokenServiceClientBuilder.standard().build();
    @NotNull
    private AWSSecretsManager secretsManagerClient;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(SecretAWSDAO::logger$lambda$0);
    @NotNull
    private final Lock lockOnSecretCache = new ReentrantLock();
    @NotNull
    private Cache<String, String> secretsCache;

    public SecretAWSDAO() {
        Cache cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.secretsCache = cache;
        this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getSecret(@NotNull String secretId) {
        Intrinsics.checkNotNullParameter((Object)secretId, (String)"secretId");
        Lock lock = this.lockOnSecretCache;
        lock.lock();
        try {
            boolean bl = false;
            String storedSecretValue = (String)this.secretsCache.getIfPresent((Object)secretId);
            if (storedSecretValue != null) {
                String string = storedSecretValue;
                return string;
            }
            GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretId).withVersionStage(UtilsKt.property("aws_secret_manager_secret_version", "AWSCURRENT"));
            GetSecretValueResult response = null;
            try {
                response = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
            }
            catch (AWSSecretsManagerException e) {
                if (Intrinsics.areEqual((Object)e.getErrorCode(), (Object)"ExpiredTokenException")) {
                    this.logger.debug(SecretAWSDAO::getSecret$lambda$3$lambda$1);
                    this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
                    response = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
                }
                throw e;
            }
            String it = response.getSecretString();
            boolean bl2 = false;
            this.secretsCache.put((Object)secretId, (Object)it);
            Intrinsics.checkNotNull((Object)it);
            String string = it;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private final AWSSecretsManager initSecretsManagerWithNewCredentials() {
        if (UtilsKt.booleanProperty$default("aws_secret_manager_assumed_role_arn", false, 2, null)) {
            Credentials it = this.getTemporaryCredentials();
            boolean bl = false;
            BasicSessionCredentials awsSessionCredentials = new BasicSessionCredentials(it.getAccessKeyId(), it.getSecretAccessKey(), it.getSessionToken());
            Object object = ((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsSessionCredentials))).build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
            return (AWSSecretsManager)object;
        }
        Object object = AWSSecretsManagerClientBuilder.standard().build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AWSSecretsManager)object;
    }

    private final Credentials getTemporaryCredentials() {
        AssumeRoleRequest request = new AssumeRoleRequest().withRoleArn(EnvConfig.INSTANCE.getAwsSecretManagerAssumedRole()).withRoleSessionName(EnvConfig.INSTANCE.getAwsAssumedRoleSessionName()).withDurationSeconds(Integer.valueOf(900));
        Credentials credentials = this.stsClient.assumeRole(request).getCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)credentials, (String)"getCredentials(...)");
        return credentials;
    }

    @Override
    @NotNull
    public String createOrUpdateSecret(@NotNull String secretName, @NotNull Object secretObject) {
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Intrinsics.checkNotNullParameter((Object)secretObject, (String)"secretObject");
        String secretValue = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).writeValueAsString(secretObject);
        try {
            UpdateSecretRequest updateRequest = new UpdateSecretRequest().withSecretId(secretName).withSecretString(secretValue);
            UpdateSecretResult updateSecretResult = this.secretsManagerClient.updateSecret(updateRequest);
            Intrinsics.checkNotNullExpressionValue((Object)updateSecretResult, (String)"updateSecret(...)");
            UpdateSecretResult updateResult = updateSecretResult;
            this.logger.info(() -> SecretAWSDAO.createOrUpdateSecret$lambda$5(secretName));
            String string = updateResult.getARN();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getARN(...)");
            return string;
        }
        catch (ResourceNotFoundException exc) {
            this.logger.info(() -> SecretAWSDAO.createOrUpdateSecret$lambda$6(secretName));
            CreateSecretRequest createRequest = new CreateSecretRequest().withName(secretName).withSecretString(secretValue).withDescription("Created from Tock.");
            CreateSecretResult createSecretResult = this.secretsManagerClient.createSecret(createRequest);
            Intrinsics.checkNotNullExpressionValue((Object)createSecretResult, (String)"createSecret(...)");
            CreateSecretResult createResult = createSecretResult;
            this.logger.info(() -> SecretAWSDAO.createOrUpdateSecret$lambda$7(secretName));
            String string = createResult.getARN();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getARN(...)");
            return string;
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object getSecret$lambda$3$lambda$1() {
        return "Refresh secret cache with new temporary credentials";
    }

    private static final Object createOrUpdateSecret$lambda$5(String $secretName) {
        Intrinsics.checkNotNullParameter((Object)$secretName, (String)"$secretName");
        return "The secret '" + $secretName + "' already exists, so it has been updated with a new value.";
    }

    private static final Object createOrUpdateSecret$lambda$6(String $secretName) {
        Intrinsics.checkNotNullParameter((Object)$secretName, (String)"$secretName");
        return "The secret '" + $secretName + "' does not yet exist.";
    }

    private static final Object createOrUpdateSecret$lambda$7(String $secretName) {
        Intrinsics.checkNotNullParameter((Object)$secretName, (String)"$secretName");
        return "The secret '" + $secretName + "' has been created with the value.";
    }
}

