/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.aws.secretmanager;

import ai.tock.aws.EnvConfig;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.SecretManagerProviderType;
import ai.tock.shared.security.SecretManagerService;
import ai.tock.shared.security.SecretManagerServiceKt;
import ai.tock.shared.security.credentials.AIProviderSecret;
import ai.tock.shared.security.credentials.Credentials;
import ai.tock.shared.security.key.AwsSecretKey;
import ai.tock.shared.security.key.SecretKey;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.AWSSecretsManagerException;
import com.amazonaws.services.secretsmanager.model.CreateSecretRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.ResourceNotFoundException;
import com.amazonaws.services.secretsmanager.model.UpdateSecretRequest;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\"H\u0016J \u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lai/tock/aws/secretmanager/AwsSecretManagerService;", "Lai/tock/shared/security/SecretManagerService;", "<init>", "()V", "type", "Lai/tock/shared/security/SecretManagerProviderType;", "getType", "()Lai/tock/shared/security/SecretManagerProviderType;", "stsClient", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "kotlin.jvm.PlatformType", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "secretsManagerClient", "Lcom/amazonaws/services/secretsmanager/AWSSecretsManager;", "logger", "Lmu/KLogger;", "lockOnSecretCache", "Ljava/util/concurrent/locks/Lock;", "secretsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "getAWSSecret", "secretId", "initSecretsManagerWithNewCredentials", "getTemporaryCredentials", "Lcom/amazonaws/services/securitytoken/model/Credentials;", "createOrUpdateAWSSecret", "", "secretName", "secretObject", "", "getCredentials", "Lai/tock/shared/security/credentials/Credentials;", "getAIProviderSecret", "Lai/tock/shared/security/credentials/AIProviderSecret;", "createOrUpdateAIProviderSecret", "secretValue", "generateSecretName", "namespace", "botId", "feature", "createSecretKeyInstance", "Lai/tock/shared/security/key/AwsSecretKey;", "isSecretTypeSupported", "", "secret", "Lai/tock/shared/security/key/SecretKey;", "tock-aws-tools"})
@SourceDebugExtension(value={"SMAP\nAwsSecretManagerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsSecretManagerService.kt\nai/tock/aws/secretmanager/AwsSecretManagerService\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,197:1\n96#2:198\n96#2:199\n434#3:200\n507#3,5:201\n*S KotlinDebug\n*F\n+ 1 AwsSecretManagerService.kt\nai/tock/aws/secretmanager/AwsSecretManagerService\n*L\n154#1:198\n157#1:199\n172#1:200\n172#1:201,5\n*E\n"})
public final class AwsSecretManagerService
implements SecretManagerService {
    private AWSSecurityTokenService stsClient = (AWSSecurityTokenService)AWSSecurityTokenServiceClientBuilder.standard().build();
    @NotNull
    private AWSSecretsManager secretsManagerClient;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(AwsSecretManagerService::logger$lambda$0);
    @NotNull
    private final Lock lockOnSecretCache = new ReentrantLock();
    @NotNull
    private Cache<String, String> secretsCache;

    public AwsSecretManagerService() {
        Cache cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.secretsCache = cache;
        this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
    }

    @NotNull
    public SecretManagerProviderType getType() {
        return SecretManagerProviderType.AWS_SECRETS_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getAWSSecret(String secretId) {
        Lock lock = this.lockOnSecretCache;
        lock.lock();
        try {
            boolean bl = false;
            String storedSecretValue = (String)this.secretsCache.getIfPresent((Object)secretId);
            if (storedSecretValue != null) {
                String string = storedSecretValue;
                return string;
            }
            GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretId).withVersionStage(PropertiesKt.property((String)"aws_secret_manager_secret_version", (String)"AWSCURRENT"));
            GetSecretValueResult response = null;
            try {
                response = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
            }
            catch (AWSSecretsManagerException e) {
                if (Intrinsics.areEqual((Object)e.getErrorCode(), (Object)"ExpiredTokenException")) {
                    this.logger.debug(AwsSecretManagerService::getAWSSecret$lambda$3$lambda$1);
                    this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
                    response = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
                }
                throw e;
            }
            String it = response.getSecretString();
            boolean bl2 = false;
            this.secretsCache.put((Object)secretId, (Object)it);
            Intrinsics.checkNotNull((Object)it);
            String string = it;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private final AWSSecretsManager initSecretsManagerWithNewCredentials() {
        if (PropertiesKt.booleanProperty((String)"aws_secret_manager_assumed_role_arn", (boolean)false)) {
            com.amazonaws.services.securitytoken.model.Credentials it = this.getTemporaryCredentials();
            boolean bl = false;
            BasicSessionCredentials awsSessionCredentials = new BasicSessionCredentials(it.getAccessKeyId(), it.getSecretAccessKey(), it.getSessionToken());
            Object object = ((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsSessionCredentials))).build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
            return (AWSSecretsManager)object;
        }
        Object object = AWSSecretsManagerClientBuilder.standard().build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AWSSecretsManager)object;
    }

    private final com.amazonaws.services.securitytoken.model.Credentials getTemporaryCredentials() {
        AssumeRoleRequest request = new AssumeRoleRequest().withRoleArn(EnvConfig.INSTANCE.getAwsSecretManagerAssumedRole()).withRoleSessionName(EnvConfig.INSTANCE.getAwsAssumedRoleSessionName()).withDurationSeconds(Integer.valueOf(900));
        com.amazonaws.services.securitytoken.model.Credentials credentials = this.stsClient.assumeRole(request).getCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)credentials, (String)"getCredentials(...)");
        return credentials;
    }

    private final void createOrUpdateAWSSecret(String secretName, Object secretObject) {
        String secretValue = ExtensionsKt.jacksonObjectMapper().writeValueAsString(secretObject);
        try {
            UpdateSecretRequest updateRequest = new UpdateSecretRequest().withSecretId(secretName).withSecretString(secretValue);
            this.secretsManagerClient.updateSecret(updateRequest);
            this.logger.info(() -> AwsSecretManagerService.createOrUpdateAWSSecret$lambda$5(secretName));
        }
        catch (ResourceNotFoundException exc) {
            this.logger.info(() -> AwsSecretManagerService.createOrUpdateAWSSecret$lambda$6(secretName));
            CreateSecretRequest createRequest = new CreateSecretRequest().withName(secretName).withSecretString(secretValue).withDescription("Created from Tock.");
            this.secretsManagerClient.createSecret(createRequest);
            this.logger.info(() -> AwsSecretManagerService.createOrUpdateAWSSecret$lambda$7(secretName));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Credentials getCredentials(@NotNull String secretName) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Json json = (Json)Json.Default;
        String string$iv = this.getAWSSecret(secretName);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (Credentials)this_$iv.decodeFromString((DeserializationStrategy)Credentials.Companion.serializer(), string$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AIProviderSecret getAIProviderSecret(@NotNull String secretName) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Json json = (Json)Json.Default;
        String string$iv = this.getAWSSecret(secretName);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (AIProviderSecret)this_$iv.decodeFromString((DeserializationStrategy)AIProviderSecret.Companion.serializer(), string$iv);
    }

    public void createOrUpdateAIProviderSecret(@NotNull String secretName, @NotNull AIProviderSecret secretValue) {
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Intrinsics.checkNotNullParameter((Object)secretValue, (String)"secretValue");
        this.createOrUpdateAWSSecret(secretName, secretValue);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String generateSecretName(@NotNull String namespace, @NotNull String botId, @NotNull String feature) {
        void $this$filterTo$iv$iv;
        String normalized;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789/_+=.@-";
        String secretPath = "/" + SecretManagerServiceKt.getGenAISecretPrefix() + "/" + namespace + "/" + botId + "/" + feature;
        String $this$filter$iv = normalized = StringsKt.replace$default((String)StringsKt.replace$default((String)secretPath, (char)'_', (char)'-', (boolean)false, (int)4, null), (char)' ', (char)'-', (boolean)false, (int)4, null);
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)allowedChars, (char)it, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        normalized = string;
        if (normalized.length() > 512) {
            String string2 = normalized.substring(0, 512);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            normalized = string2;
        }
        Regex hyphenSixPattern = new Regex("-.{6}$");
        if (normalized.length() > 7 && hyphenSixPattern.containsMatchIn((CharSequence)normalized)) {
            String string3 = normalized.substring(0, normalized.length() - 7);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            normalized = string3;
        }
        if (((CharSequence)normalized).length() == 0) {
            throw new IllegalArgumentException("Normalized AWS secret name must be at least one character long.");
        }
        return normalized;
    }

    @NotNull
    public AwsSecretKey createSecretKeyInstance(@NotNull String secretName) {
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        return new AwsSecretKey(secretName);
    }

    public boolean isSecretTypeSupported(@NotNull SecretKey secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        return secret instanceof AwsSecretKey;
    }

    @NotNull
    public SecretKey createOrUpdateSecretKey(@NotNull String namespace, @NotNull String botId, @NotNull String feature, @NotNull String secretValue) {
        return SecretManagerService.DefaultImpls.createOrUpdateSecretKey((SecretManagerService)this, (String)namespace, (String)botId, (String)feature, (String)secretValue);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object getAWSSecret$lambda$3$lambda$1() {
        return "Refresh secret cache with new temporary credentials";
    }

    private static final Object createOrUpdateAWSSecret$lambda$5(String $secretName) {
        return "The secret '" + $secretName + "' already exists, so it has been updated with a new value.";
    }

    private static final Object createOrUpdateAWSSecret$lambda$6(String $secretName) {
        return "The secret '" + $secretName + "' does not yet exist.";
    }

    private static final Object createOrUpdateAWSSecret$lambda$7(String $secretName) {
        return "The secret '" + $secretName + "' has been created with the value.";
    }
}

