/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.aws.secretmanager;

import ai.tock.aws.EnvConfig;
import ai.tock.aws.secretmanager.AwsSecretManagerService;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.SecretManagerProviderType;
import ai.tock.shared.security.SecretManagerService;
import ai.tock.shared.security.SecretManagerServiceKt;
import ai.tock.shared.security.credentials.AIProviderSecret;
import ai.tock.shared.security.credentials.Credentials;
import ai.tock.shared.security.key.AwsSecretKey;
import ai.tock.shared.security.key.SecretKey;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.AWSSecretsManagerException;
import com.amazonaws.services.secretsmanager.model.CreateSecretRequest;
import com.amazonaws.services.secretsmanager.model.DeleteSecretRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.ResourceNotFoundException;
import com.amazonaws.services.secretsmanager.model.UpdateSecretRequest;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lai/tock/aws/secretmanager/AwsSecretManagerService;", "Lai/tock/shared/security/SecretManagerService;", "()V", "lockOnSecretCache", "Ljava/util/concurrent/locks/Lock;", "logger", "Lmu/KLogger;", "secretsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "secretsManagerClient", "Lcom/amazonaws/services/secretsmanager/AWSSecretsManager;", "stsClient", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "kotlin.jvm.PlatformType", "type", "Lai/tock/shared/security/SecretManagerProviderType;", "getType", "()Lai/tock/shared/security/SecretManagerProviderType;", "createOrUpdateAIProviderSecret", "", "secretName", "secretValue", "Lai/tock/shared/security/credentials/AIProviderSecret;", "createOrUpdateAWSSecret", "secretObject", "", "createSecretKeyInstance", "Lai/tock/shared/security/key/AwsSecretKey;", "deleteSecret", "generateSecretName", "namespace", "botId", "feature", "getAIProviderSecret", "getAWSSecret", "secretId", "getCredentials", "Lai/tock/shared/security/credentials/Credentials;", "getTemporaryCredentials", "Lcom/amazonaws/services/securitytoken/model/Credentials;", "initSecretsManagerWithNewCredentials", "isSecretTypeSupported", "", "secret", "Lai/tock/shared/security/key/SecretKey;", "tock-aws-tools"})
@SourceDebugExtension(value={"SMAP\nAwsSecretManagerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsSecretManagerService.kt\nai/tock/aws/secretmanager/AwsSecretManagerService\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,210:1\n96#2:211\n96#2:212\n434#3:213\n507#3,5:214\n*S KotlinDebug\n*F\n+ 1 AwsSecretManagerService.kt\nai/tock/aws/secretmanager/AwsSecretManagerService\n*L\n154#1:211\n157#1:212\n172#1:213\n172#1:214,5\n*E\n"})
public final class AwsSecretManagerService
implements SecretManagerService {
    private AWSSecurityTokenService stsClient = (AWSSecurityTokenService)AWSSecurityTokenServiceClientBuilder.standard().build();
    @NotNull
    private AWSSecretsManager secretsManagerClient;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final Lock lockOnSecretCache = new ReentrantLock();
    @NotNull
    private Cache<String, String> secretsCache;

    public AwsSecretManagerService() {
        Cache cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.secretsCache = cache;
        this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
    }

    @NotNull
    public SecretManagerProviderType getType() {
        return SecretManagerProviderType.AWS_SECRETS_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getAWSSecret(String secretId) {
        Lock lock = this.lockOnSecretCache;
        lock.lock();
        try {
            boolean bl = false;
            String storedSecretValue = (String)this.secretsCache.getIfPresent((Object)secretId);
            if (storedSecretValue != null) {
                String string = storedSecretValue;
                return string;
            }
            GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretId).withVersionStage(PropertiesKt.property((String)"aws_secret_manager_secret_version", (String)"AWSCURRENT"));
            GetSecretValueResult response = null;
            try {
                GetSecretValueResult getSecretValueResult = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
                Intrinsics.checkNotNullExpressionValue((Object)getSecretValueResult, (String)"getSecretValue(...)");
                response = getSecretValueResult;
            }
            catch (AWSSecretsManagerException e) {
                if (Intrinsics.areEqual((Object)e.getErrorCode(), (Object)"ExpiredTokenException")) {
                    this.logger.debug((Function0)getAWSSecret.1.1.INSTANCE);
                    this.secretsManagerClient = this.initSecretsManagerWithNewCredentials();
                    GetSecretValueResult getSecretValueResult = this.secretsManagerClient.getSecretValue(getSecretValueRequest);
                    Intrinsics.checkNotNullExpressionValue((Object)getSecretValueResult, (String)"getSecretValue(...)");
                    response = getSecretValueResult;
                }
                throw e;
            }
            String it = response.getSecretString();
            boolean bl2 = false;
            this.secretsCache.put((Object)secretId, (Object)it);
            Intrinsics.checkNotNull((Object)it);
            String string = it;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private final AWSSecretsManager initSecretsManagerWithNewCredentials() {
        if (PropertiesKt.booleanProperty((String)"aws_secret_manager_assumed_role_arn", (boolean)false)) {
            com.amazonaws.services.securitytoken.model.Credentials it = this.getTemporaryCredentials();
            boolean bl = false;
            BasicSessionCredentials awsSessionCredentials = new BasicSessionCredentials(it.getAccessKeyId(), it.getSecretAccessKey(), it.getSessionToken());
            Object object = ((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsSessionCredentials))).build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
            return (AWSSecretsManager)object;
        }
        Object object = AWSSecretsManagerClientBuilder.standard().build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AWSSecretsManager)object;
    }

    private final com.amazonaws.services.securitytoken.model.Credentials getTemporaryCredentials() {
        AssumeRoleRequest request = new AssumeRoleRequest().withRoleArn(EnvConfig.INSTANCE.getAwsSecretManagerAssumedRole()).withRoleSessionName(EnvConfig.INSTANCE.getAwsAssumedRoleSessionName()).withDurationSeconds(Integer.valueOf(900));
        com.amazonaws.services.securitytoken.model.Credentials credentials = this.stsClient.assumeRole(request).getCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)credentials, (String)"getCredentials(...)");
        return credentials;
    }

    private final void createOrUpdateAWSSecret(String secretName, Object secretObject) {
        String secretValue = ExtensionsKt.jacksonObjectMapper().writeValueAsString(secretObject);
        try {
            UpdateSecretRequest updateRequest = new UpdateSecretRequest().withSecretId(secretName).withSecretString(secretValue);
            this.secretsManagerClient.updateSecret(updateRequest);
            this.logger.info((Function0)new Function0<Object>(secretName){
                final /* synthetic */ String $secretName;
                {
                    this.$secretName = $secretName;
                    super(0);
                }

                public final Object invoke() {
                    return "The secret '" + this.$secretName + "' already exists, so it has been updated with a new value.";
                }
            });
        }
        catch (ResourceNotFoundException exc) {
            this.logger.info((Function0)new Function0<Object>(secretName){
                final /* synthetic */ String $secretName;
                {
                    this.$secretName = $secretName;
                    super(0);
                }

                public final Object invoke() {
                    return "The secret '" + this.$secretName + "' does not yet exist.";
                }
            });
            CreateSecretRequest createRequest = new CreateSecretRequest().withName(secretName).withSecretString(secretValue).withDescription("Created from Tock.");
            this.secretsManagerClient.createSecret(createRequest);
            this.logger.info((Function0)new Function0<Object>(secretName){
                final /* synthetic */ String $secretName;
                {
                    this.$secretName = $secretName;
                    super(0);
                }

                public final Object invoke() {
                    return "The secret '" + this.$secretName + "' has been created with the value.";
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Credentials getCredentials(@NotNull String secretName) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Json json = (Json)Json.Default;
        String string$iv = this.getAWSSecret(secretName);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (Credentials)this_$iv.decodeFromString((DeserializationStrategy)Credentials.Companion.serializer(), string$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AIProviderSecret getAIProviderSecret(@NotNull String secretName) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Json json = (Json)Json.Default;
        String string$iv = this.getAWSSecret(secretName);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (AIProviderSecret)this_$iv.decodeFromString((DeserializationStrategy)AIProviderSecret.Companion.serializer(), string$iv);
    }

    public void createOrUpdateAIProviderSecret(@NotNull String secretName, @NotNull AIProviderSecret secretValue) {
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Intrinsics.checkNotNullParameter((Object)secretValue, (String)"secretValue");
        this.createOrUpdateAWSSecret(secretName, secretValue);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String generateSecretName(@NotNull String namespace, @NotNull String botId, @NotNull String feature) {
        void $this$filterTo$iv$iv;
        String normalized;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789/_+=.@-";
        String secretPath = "/" + SecretManagerServiceKt.getGenAISecretPrefix() + "/" + namespace + "/" + botId + "/" + feature;
        String $this$filter$iv = normalized = StringsKt.replace$default((String)StringsKt.replace$default((String)secretPath, (char)'_', (char)'-', (boolean)false, (int)4, null), (char)' ', (char)'-', (boolean)false, (int)4, null);
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)allowedChars, (char)it, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        normalized = ((StringBuilder)destination$iv$iv).toString();
        if (normalized.length() > 512) {
            String string = normalized.substring(0, 512);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            normalized = string;
        }
        Regex hyphenSixPattern = new Regex("-.{6}$");
        if (normalized.length() > 7 && hyphenSixPattern.containsMatchIn((CharSequence)normalized)) {
            String string = normalized.substring(0, normalized.length() - 7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            normalized = string;
        }
        if (((CharSequence)normalized).length() == 0) {
            throw new IllegalArgumentException("Normalized AWS secret name must be at least one character long.");
        }
        return normalized;
    }

    @NotNull
    public AwsSecretKey createSecretKeyInstance(@NotNull String secretName) {
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        return new AwsSecretKey(secretName);
    }

    public boolean isSecretTypeSupported(@NotNull SecretKey secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        return secret instanceof AwsSecretKey;
    }

    public void deleteSecret(@NotNull String secretName) {
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        try {
            DeleteSecretRequest deleteRequest = new DeleteSecretRequest().withSecretId(secretName).withForceDeleteWithoutRecovery(Boolean.valueOf(true));
            this.secretsManagerClient.deleteSecret(deleteRequest);
            this.logger.info((Function0)new Function0<Object>(secretName){
                final /* synthetic */ String $secretName;
                {
                    this.$secretName = $secretName;
                    super(0);
                }

                public final Object invoke() {
                    return "The secret '" + this.$secretName + "' has been successfully deleted.";
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, (Function0)new Function0<Object>(secretName){
                final /* synthetic */ String $secretName;
                {
                    this.$secretName = $secretName;
                    super(0);
                }

                public final Object invoke() {
                    return "Failed to delete the secret '" + this.$secretName + "'.";
                }
            });
            throw e;
        }
    }

    @NotNull
    public SecretKey createOrUpdateSecretKey(@NotNull String namespace, @NotNull String botId, @NotNull String feature, @NotNull String secretValue) {
        return SecretManagerService.DefaultImpls.createOrUpdateSecretKey((SecretManagerService)this, (String)namespace, (String)botId, (String)feature, (String)secretValue);
    }
}

