/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.indicators.Indicator;
import ai.tock.bot.admin.indicators.IndicatorDAO;
import ai.tock.bot.admin.indicators.IndicatorError;
import ai.tock.bot.admin.indicators.IndicatorValue;
import ai.tock.bot.admin.model.Valid;
import ai.tock.bot.admin.model.indicator.IndicatorResponse;
import ai.tock.bot.admin.model.indicator.IndicatorValueRequest;
import ai.tock.bot.admin.model.indicator.MappersKt;
import ai.tock.bot.admin.model.indicator.SaveIndicatorRequest;
import ai.tock.bot.admin.model.indicator.UpdateIndicatorRequest;
import ai.tock.bot.admin.service.IndicatorService;
import ai.tock.shared.IOCsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fJ7\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00160\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ$\u0010 \u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020!0\u001eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lai/tock/bot/admin/service/IndicatorService;", "", "()V", "dao", "Lai/tock/bot/admin/indicators/IndicatorDAO;", "getDao", "()Lai/tock/bot/admin/indicators/IndicatorDAO;", "dao$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "deleteByNameAndApplicationName", "", "name", "", "applicationName", "findAll", "", "Lai/tock/bot/admin/model/indicator/IndicatorResponse;", "findAllByBotId", "botId", "findByNameAndBotId", "indicatorName", "findIndicatorAndMap", "T", "mapper", "Lkotlin/Function1;", "Lai/tock/bot/admin/indicators/Indicator;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "save", "", "request", "Lai/tock/bot/admin/model/Valid;", "Lai/tock/bot/admin/model/indicator/SaveIndicatorRequest;", "update", "Lai/tock/bot/admin/model/indicator/UpdateIndicatorRequest;", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nIndicatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndicatorService.kt\nai/tock/bot/admin/service/IndicatorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 5 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,123:1\n1549#2:124\n1620#2,3:125\n1549#2:128\n1620#2,3:129\n1549#2:132\n1620#2,3:133\n1#3:136\n80#4:137\n277#5:138\n*S KotlinDebug\n*F\n+ 1 IndicatorService.kt\nai/tock/bot/admin/service/IndicatorService\n*L\n63#1:124\n63#1:125,3\n86#1:128\n86#1:129,3\n94#1:132\n94#1:133,3\n34#1:137\n34#1:138\n*E\n"})
public final class IndicatorService {
    @NotNull
    public static final IndicatorService INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final InjectedProperty dao$delegate;

    private IndicatorService() {
    }

    private final IndicatorDAO getDao() {
        return (IndicatorDAO)dao$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void save(@NotNull String botId, @NotNull Valid<SaveIndicatorRequest> request) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        SaveIndicatorRequest it = request.getData();
        boolean bl = false;
        if (INSTANCE.getDao().existByNameAndBotId(it.getName(), botId)) {
            throw new IndicatorError.IndicatorAlreadyExists(it.getName(), it.getLabel(), botId);
        }
        INSTANCE.getDao().save(MappersKt.toIndicator(botId, it));
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull String botId, @NotNull String indicatorName, @NotNull Valid<UpdateIndicatorRequest> request) {
        Collection<IndicatorValue> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)indicatorName, (String)"indicatorName");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        UpdateIndicatorRequest it = request.getData();
        boolean bl = false;
        Indicator indicator = (Indicator)INSTANCE.findIndicatorAndMap(indicatorName, botId, update.1.1.INSTANCE);
        boolean bl2 = false;
        Iterable iterable = it.getValues();
        Set<String> set = it.getDimensions();
        String string = null;
        String string2 = it.getDescription();
        String string3 = it.getLabel();
        String string4 = null;
        Id id = null;
        Indicator indicator2 = indicator;
        IndicatorDAO indicatorDAO = INSTANCE.getDao();
        boolean $i$f$map = false;
        void var18_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value;
            IndicatorValueRequest indicatorValueRequest = (IndicatorValueRequest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new IndicatorValue(value.getName(), value.getLabel()));
        }
        collection = (List)destination$iv$iv;
        indicatorDAO.save(Indicator.copy$default((Indicator)indicator2, id, string4, (String)string3, (String)string2, string, set, (Set)CollectionsKt.toSet((Iterable)collection), (int)19, null));
    }

    @NotNull
    public final IndicatorResponse findByNameAndBotId(@NotNull String indicatorName, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)indicatorName, (String)"indicatorName");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        return (IndicatorResponse)this.findIndicatorAndMap(indicatorName, botId, findByNameAndBotId.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndicatorResponse> findAllByBotId(@NotNull String botId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Iterable $this$map$iv = this.getDao().findAllByBotId(botId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Indicator indicator = (Indicator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MappersKt.toResponse((Indicator)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndicatorResponse> findAll() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getDao().findAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Indicator indicator = (Indicator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MappersKt.toResponse((Indicator)it));
        }
        return (List)destination$iv$iv;
    }

    public final boolean deleteByNameAndApplicationName(@NotNull String name, @NotNull String applicationName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        boolean it = bl = this.getDao().deleteByNameAndApplicationName(name, applicationName);
        boolean bl2 = false;
        if (!it) {
            throw new IndicatorError.IndicatorDeletionFailed(name, applicationName);
        }
        return bl;
    }

    private final <T> T findIndicatorAndMap(String name, String botId, Function1<? super Indicator, ? extends T> mapper) {
        Object object;
        block3: {
            block2: {
                object = this.getDao().findByNameAndBotId(name, botId);
                if (object == null) break block2;
                Indicator it = object;
                boolean bl = false;
                Object object2 = mapper.invoke((Object)it);
                object = object2;
                if (object2 != null) break block3;
            }
            throw new IndicatorError.IndicatorNotFound(name, botId);
        }
        return (T)object;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(IndicatorService.class, "dao", "getDao()Lai/tock/bot/admin/indicators/IndicatorDAO;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new IndicatorService();
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        dao$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<IndicatorDAO>(){}, tag$iv);
    }
}

