/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin;

import ai.tock.bot.admin.BotAdminService;
import ai.tock.bot.admin.answer.AnswerConfigurationType;
import ai.tock.bot.admin.answer.SimpleAnswer;
import ai.tock.bot.admin.answer.SimpleAnswerConfiguration;
import ai.tock.bot.admin.model.BotStoryDefinitionConfiguration;
import ai.tock.bot.admin.model.CreateI18nLabelRequest;
import ai.tock.bot.admin.model.FaqDefinitionRequest;
import ai.tock.bot.admin.model.FaqDefinitionSearchResult;
import ai.tock.bot.admin.model.FaqSearchRequest;
import ai.tock.bot.admin.story.StoryDefinitionConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationDAO;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationFeature;
import ai.tock.bot.definition.IntentWithoutNamespace;
import ai.tock.nlp.admin.AdminService;
import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.service.ApplicationConfigurationServiceKt;
import ai.tock.nlp.front.service.storage.ClassifiedSentenceDAO;
import ai.tock.nlp.front.service.storage.FaqSettingsDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.Classification;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.FaqDefinition;
import ai.tock.nlp.front.shared.config.FaqDefinitionDetailed;
import ai.tock.nlp.front.shared.config.FaqQueryResult;
import ai.tock.nlp.front.shared.config.FaqSettings;
import ai.tock.nlp.front.shared.config.FaqSettingsQuery;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.SentencesQuery;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.vertx.WebVerticle;
import ai.tock.translator.I18nDAO;
import ai.tock.translator.I18nLabel;
import ai.tock.translator.I18nLabelFilter;
import ai.tock.translator.I18nLabelStateFilter;
import ai.tock.translator.I18nLabelValue;
import ai.tock.translator.I18nLocalizedLabel;
import ai.tock.translator.UserInterfaceType;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\n\u0010#\u001a\u00060\u0019j\u0002`$2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J2\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010*H\u0002J>\u0010/\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010+\u001a\u00020(2\n\u0010#\u001a\u00060\u0019j\u0002`$2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020&2\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u0016\u00103\u001a\u00020\u001f2\u0006\u00100\u001a\u00020&2\u0006\u00104\u001a\u000205J\u001e\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u000205H\u0002J<\u0010;\u001a\u00020:2\u0006\u0010\"\u001a\u00020!2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u00010:2\b\u00101\u001a\u0004\u0018\u000102H\u0002J \u0010<\u001a\b\u0012\u0004\u0012\u0002080=2\u0006\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u000102H\u0002J2\u0010@\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010A\u001a\u00020&2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020(0C2\n\u0010#\u001a\u00060\u0019j\u0002`$H\u0002JR\u0010D\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001907\u0012\n\u0012\b\u0012\u0004\u0012\u00020F070E2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u0019072\u0006\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020&0C2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020(0CH\u0002J\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0019072\u0006\u0010J\u001a\u00020\u0019J\u0016\u0010L\u001a\u00020M2\u0006\u0010\"\u001a\u00020N2\u0006\u00100\u001a\u00020&J$\u0010O\u001a\b\u0012\u0004\u0012\u00020!0P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020!0P2\u0006\u00100\u001a\u00020&H\u0002J$\u0010V\u001a\b\u0012\u0004\u0012\u00020!0P2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X072\u0006\u00100\u001a\u00020&H\u0002J$\u0010Y\u001a\b\u0012\u0004\u0012\u00020!0P2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020X072\u0006\u00100\u001a\u00020&H\u0002J2\u0010[\u001a\b\u0012\u0004\u0012\u00020F072\u0006\u00100\u001a\u00020&2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020(0C2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020F07H\u0002J\u0010\u0010\\\u001a\u00020-2\u0006\u00100\u001a\u00020&H\u0002J\u001e\u0010]\u001a\u00020F2\u0006\u00100\u001a\u00020&2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020(0CH\u0002J&\u0010^\u001a\u00020M2\u0006\u0010_\u001a\u00020`2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020!0P2\u0006\u0010b\u001a\u00020`H\u0002J$\u0010c\u001a\b\u0012\u0004\u0012\u00020!0P2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020e0P2\u0006\u00100\u001a\u00020&H\u0002J\u001e\u0010f\u001a\b\u0012\u0004\u0012\u00020-072\u0006\u00100\u001a\u00020&2\u0006\u0010g\u001a\u00020\u0019H\u0002J\u001a\u0010h\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020!2\u0006\u00100\u001a\u00020&H\u0002J\u0012\u0010i\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020!H\u0002J\u0018\u0010j\u001a\u0004\u0018\u00010(2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020*0CH\u0002J\"\u0010l\u001a\u00020-2\u0006\u0010\"\u001a\u00020!2\u0006\u0010m\u001a\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010*H\u0002J\u0016\u0010n\u001a\u00020?2\u0006\u0010m\u001a\u00020\u00192\u0006\u0010o\u001a\u00020\u0019J(\u0010p\u001a\u00020?2\u0006\u0010%\u001a\u00020&2\u0006\u0010q\u001a\u00020*2\u0006\u0010m\u001a\u00020\u00192\u0006\u0010r\u001a\u00020\u0019H\u0002J\u0010\u0010s\u001a\u0004\u0018\u0001022\u0006\u00100\u001a\u00020&J\u0016\u0010t\u001a\u0002022\u0006\u00100\u001a\u00020&2\u0006\u0010u\u001a\u000202R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R1\u0010R\u001a%\u0012\u0004\u0012\u00020!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020:0T\u0012\u0004\u0012\u00020!0S\u00a2\u0006\u0002\bUX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lai/tock/bot/admin/FaqAdminService;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "i18nDao", "Lai/tock/translator/I18nDAO;", "getI18nDao", "()Lai/tock/translator/I18nDAO;", "classifiedSentenceDAO", "Lai/tock/nlp/front/service/storage/ClassifiedSentenceDAO;", "getClassifiedSentenceDAO", "()Lai/tock/nlp/front/service/storage/ClassifiedSentenceDAO;", "storyDefinitionDAO", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "getStoryDefinitionDAO", "()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "faqSettingsDAO", "Lai/tock/nlp/front/service/storage/FaqSettingsDAO;", "getFaqSettingsDAO", "()Lai/tock/nlp/front/service/storage/FaqSettingsDAO;", "front", "Lai/tock/nlp/front/client/FrontClient;", "FAQ_CATEGORY", "", "UNKNOWN_ANSWER", "MISSING_UTTERANCE", "WARN_CANNOT_FIND_LABEL", "WARN_CANNOT_FIND_UTTERANCE", "makeMigration", "", "saveFAQ", "Lai/tock/bot/admin/model/FaqDefinitionRequest;", "query", "userLogin", "Lai/tock/shared/security/UserLogin;", "application", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "createOrUpdateFaqIntent", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "prepareCreationOrUpdatingFaqDefinition", "Lai/tock/nlp/front/shared/config/FaqDefinition;", "intent", "i18nLabel", "Lai/tock/translator/I18nLabel;", "existingFaq", "createOrUpdateStory", "applicationDefinition", "faqFaqSettingsQuery", "Lai/tock/nlp/front/shared/config/FaqSettingsQuery;", "updateAllFaqStoryWithSettings", "faqSettings", "Lai/tock/nlp/front/shared/config/FaqSettings;", "prepareEndingFeatures", "", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationFeature;", "existingStory", "Lai/tock/bot/admin/story/StoryDefinitionConfiguration;", "prepareStoryCreationOrUpdate", "prepareStoryFeatures", "", "enabled", "", "createOrUpdateUtterances", "app", "intentId", "Lorg/litote/kmongo/Id;", "checkSentencesToAddOrDelete", "Lkotlin/Pair;", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "utterances", "locale", "Ljava/util/Locale;", "applicationId", "searchTags", "searchFAQ", "Lai/tock/bot/admin/model/FaqDefinitionSearchResult;", "Lai/tock/bot/admin/model/FaqSearchRequest;", "feedFaqDataStory", "", "faqs", "updatedFaqSearchWithStoryNameAndDescription", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "mapI18LabelFaqAndConvertToFaqDefinitionRequest", "faqQueryResults", "Lai/tock/nlp/front/shared/config/FaqQueryResult;", "searchLabelsFromTockFrontDb", "faqQuery", "checkAndInformAnyMissingUtterances", "unknownI18n", "fakeMissingUtterance", "toFaqDefinitionSearchResult", "start", "", "faqSet", "count", "convertFaqDefinitionDetailedToFaqDefinitionRequest", "detailedFaqs", "Lai/tock/nlp/front/shared/config/FaqDefinitionDetailed;", "findPredicatesFrom18nLabels", "search", "createIntent", "getIntentName", "findFaqDefinitionIntent", "faqId", "manageI18nLabelUpdate", "namespace", "deleteFaqDefinition", "faqDefinitionId", "deleteOneFaqDefinition", "faqDefinition", "intentName", "getSettings", "saveSettings", "faqSettingsQuery", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nFaqAdminService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaqAdminService.kt\nai/tock/bot/admin/FaqAdminService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,806:1\n48#2,2:807\n48#2,2:811\n48#2,2:815\n48#2,2:819\n51#3:809\n51#3:813\n51#3:817\n51#3:821\n277#4:810\n277#4:814\n277#4:818\n277#4:822\n1863#5,2:823\n1863#5:825\n1864#5:827\n774#5:828\n865#5,2:829\n1863#5:831\n295#5,2:832\n1864#5:834\n774#5:835\n865#5,2:836\n1557#5:838\n1628#5,3:839\n1557#5:842\n1628#5,3:843\n1202#5,2:846\n1230#5,4:848\n774#5:852\n865#5,2:853\n1557#5:855\n1628#5,3:856\n827#5:859\n855#5,2:860\n1557#5:862\n1628#5,3:863\n1557#5:866\n1628#5,3:867\n1557#5:870\n1628#5,2:871\n1557#5:873\n1628#5,3:874\n1557#5:877\n1628#5,3:878\n1557#5:881\n1628#5,3:882\n1557#5:885\n1628#5,3:886\n1630#5:889\n1#6:826\n*S KotlinDebug\n*F\n+ 1 FaqAdminService.kt\nai/tock/bot/admin/FaqAdminService\n*L\n72#1:807,2\n73#1:811,2\n74#1:815,2\n75#1:819,2\n72#1:809\n73#1:813\n74#1:817\n75#1:821\n72#1:810\n73#1:814\n74#1:818\n75#1:822\n247#1:823,2\n380#1:825\n380#1:827\n388#1:828\n388#1:829,2\n423#1:831\n424#1:832,2\n423#1:834\n435#1:835\n435#1:836,2\n451#1:838\n451#1:839,3\n487#1:842\n487#1:843,3\n494#1:846,2\n494#1:848,4\n502#1:852\n502#1:853,2\n503#1:855\n503#1:856,3\n505#1:859\n505#1:860,2\n532#1:862\n532#1:863,3\n553#1:866\n553#1:867,3\n639#1:870\n639#1:871,2\n643#1:873\n643#1:874,3\n653#1:877\n653#1:878,3\n656#1:881\n656#1:882,3\n657#1:885\n657#1:886,3\n639#1:889\n*E\n"})
public final class FaqAdminService {
    @NotNull
    public static final FaqAdminService INSTANCE = new FaqAdminService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(FaqAdminService::logger$lambda$0);
    @NotNull
    private static final FrontClient front = FrontClient.INSTANCE;
    @NotNull
    public static final String FAQ_CATEGORY = "faq";
    @NotNull
    private static final String UNKNOWN_ANSWER = "UNKNOWN ANSWER";
    @NotNull
    public static final String MISSING_UTTERANCE = "MISSING_UTTERANCE";
    @NotNull
    private static final String WARN_CANNOT_FIND_LABEL = "Could not found an associated i18nLabel";
    @NotNull
    private static final String WARN_CANNOT_FIND_UTTERANCE = "Could not found an associated ClassifiedSentence";
    @NotNull
    private static final Function2<FaqDefinitionRequest, Map<String, StoryDefinitionConfiguration>, FaqDefinitionRequest> updatedFaqSearchWithStoryNameAndDescription = FaqAdminService::updatedFaqSearchWithStoryNameAndDescription$lambda$32;

    private FaqAdminService() {
    }

    private final I18nDAO getI18nDao() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (I18nDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<I18nDAO>(){}, tag$iv).getValue()).invoke();
    }

    private final ClassifiedSentenceDAO getClassifiedSentenceDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (ClassifiedSentenceDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ClassifiedSentenceDAO>(){}, tag$iv).getValue()).invoke();
    }

    private final StoryDefinitionConfigurationDAO getStoryDefinitionDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (StoryDefinitionConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<StoryDefinitionConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    private final FaqSettingsDAO getFaqSettingsDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (FaqSettingsDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<FaqSettingsDAO>(){}, tag$iv).getValue()).invoke();
    }

    public final void makeMigration() {
        ApplicationConfigurationServiceKt.getFaqDefinitionDAO().makeMigration(FaqAdminService::makeMigration$lambda$1);
    }

    @NotNull
    public final FaqDefinitionRequest saveFAQ(@NotNull FaqDefinitionRequest query, @NotNull String userLogin, @NotNull ApplicationDefinition application) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)userLogin, (String)"userLogin");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        FaqSettings faqSettings = this.getFaqSettingsDAO().getFaqSettingsByApplicationId(application.get_id());
        FaqSettingsQuery faqSettings2 = faqSettings != null ? faqSettings.toFaqSettingsQuery() : null;
        IntentDefinition intent = this.createOrUpdateFaqIntent(query, application);
        this.createOrUpdateUtterances(query, application, (Id<IntentDefinition>)intent.get_id(), userLogin);
        FaqDefinition existingFaqInCurrentApplication = ApplicationConfigurationServiceKt.getFaqDefinitionDAO().getFaqDefinitionByIntentIdAndBotId(intent.get_id(), query.getApplicationName());
        I18nLabel i18nLabel = this.manageI18nLabelUpdate(query, application.getNamespace(), existingFaqInCurrentApplication);
        FaqDefinition faqDefinition = this.prepareCreationOrUpdatingFaqDefinition(query, application, intent, i18nLabel, existingFaqInCurrentApplication);
        ApplicationConfigurationServiceKt.getFaqDefinitionDAO().save(faqDefinition);
        this.createOrUpdateStory(query, intent, userLogin, i18nLabel, application, faqSettings2);
        return new FaqDefinitionRequest(faqDefinition.get_id().toString(), faqDefinition.getIntentId().toString(), query.getLanguage(), query.getApplicationName(), faqDefinition.getCreationDate(), faqDefinition.getUpdateDate(), String.valueOf(intent.getLabel()), String.valueOf(intent.getDescription()), query.getUtterances(), query.getTags(), ((I18nLocalizedLabel)CollectionsKt.first((Iterable)i18nLabel.getI18n())).getLabel(), query.getEnabled(), intent.getName());
    }

    private final IntentDefinition createOrUpdateFaqIntent(FaqDefinitionRequest query, ApplicationDefinition application) {
        IntentDefinition intentDefinition;
        if (query.getId() != null) {
            IntentDefinition intent = this.findFaqDefinitionIntent((Id<FaqDefinition>)IdsKt.toId((String)query.getId()));
            if (intent == null) {
                WebVerticle.Companion.badRequest("Faq (id:" + query.getId() + ") intent not found !");
                throw new KotlinNothingValueException();
            }
            IntentDefinition intentUpdated = AdminService.INSTANCE.createOrUpdateIntent(application.getNamespace(), IntentDefinition.copy$default((IntentDefinition)intent, null, null, null, null, null, null, null, (String)query.getTitle(), (String)query.getDescription(), null, null, (int)1663, null));
            intentDefinition = intentUpdated;
            if (intentDefinition == null) {
                WebVerticle.Companion.badRequest("Trouble when updating intent : " + query.getIntentName());
                throw new KotlinNothingValueException();
            }
        } else {
            intentDefinition = this.createIntent(query, application);
            if (intentDefinition == null) {
                WebVerticle.Companion.badRequest("Trouble when creating intent : " + query.getIntentName());
                throw new KotlinNothingValueException();
            }
        }
        return intentDefinition;
    }

    private final FaqDefinition prepareCreationOrUpdatingFaqDefinition(FaqDefinitionRequest query, ApplicationDefinition application, IntentDefinition intent, I18nLabel i18nLabel, FaqDefinition existingFaq) {
        FaqDefinition faqDefinition;
        if (existingFaq != null) {
            logger.info(() -> FaqAdminService.prepareCreationOrUpdatingFaqDefinition$lambda$2(intent));
            Id id = existingFaq.get_id();
            String string = existingFaq.getBotId();
            String string2 = existingFaq.getNamespace();
            Id id2 = existingFaq.getIntentId();
            Id id3 = existingFaq.getI18nId();
            List<String> list = query.getTags();
            boolean bl = query.getEnabled();
            Instant instant = existingFaq.getCreationDate();
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            faqDefinition = new FaqDefinition(id, string, string2, id2, id3, list, bl, instant, instant2);
        } else {
            logger.info(() -> FaqAdminService.prepareCreationOrUpdatingFaqDefinition$lambda$3(intent));
            String string = application.getName();
            Id id = intent.get_id();
            String string3 = application.getNamespace();
            Id id4 = i18nLabel.get_id();
            List<String> list = query.getTags();
            boolean bl = query.getEnabled();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant3 = instant;
            Instant instant4 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"now(...)");
            Instant instant5 = instant4;
            faqDefinition = new FaqDefinition(null, string, string3, id, id4, list, bl, instant3, instant5, 1, null);
        }
        return faqDefinition;
    }

    private final void createOrUpdateStory(FaqDefinitionRequest query, IntentDefinition intent, String userLogin, I18nLabel i18nLabel, ApplicationDefinition applicationDefinition, FaqSettingsQuery faqFaqSettingsQuery) {
        BotStoryDefinitionConfiguration botStoryDefinitionConfiguration;
        StoryDefinitionConfiguration existingStory = this.getStoryDefinitionDAO().getConfiguredStoryDefinitionByNamespaceAndBotIdAndIntent(applicationDefinition.getNamespace(), applicationDefinition.getName(), intent.getName());
        StoryDefinitionConfiguration storyDefinitionConfiguration = this.prepareStoryCreationOrUpdate(query, intent, i18nLabel, applicationDefinition, existingStory, faqFaqSettingsQuery);
        BotStoryDefinitionConfiguration it = botStoryDefinitionConfiguration = BotAdminService.INSTANCE.saveStory(applicationDefinition.getNamespace(), new BotStoryDefinitionConfiguration(storyDefinitionConfiguration, i18nLabel.getDefaultLocale(), false), userLogin, intent);
        boolean bl = false;
        String enabledLog = query.getEnabled() ? "enabled" : "disabled";
        logger.info(() -> FaqAdminService.createOrUpdateStory$lambda$5$lambda$4(it, enabledLog));
    }

    public final void updateAllFaqStoryWithSettings(@NotNull ApplicationDefinition applicationDefinition, @NotNull FaqSettings faqSettings) {
        Intrinsics.checkNotNullParameter((Object)applicationDefinition, (String)"applicationDefinition");
        Intrinsics.checkNotNullParameter((Object)faqSettings, (String)"faqSettings");
        List listFaq = ApplicationConfigurationServiceKt.getFaqDefinitionDAO().getFaqDefinitionByBotId(applicationDefinition.getName());
        Iterable $this$forEach$iv = listFaq;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StoryDefinitionConfiguration existingStory;
            StoryDefinitionConfiguration storyDefinitionConfiguration;
            FaqDefinition it = (FaqDefinition)element$iv;
            boolean bl = false;
            Id it2 = it.getIntentId();
            boolean bl2 = false;
            IntentDefinition currentIntent = AdminService.INSTANCE.getFront().getIntentById(it2);
            if (currentIntent != null) {
                boolean bl3 = false;
                storyDefinitionConfiguration = INSTANCE.getStoryDefinitionDAO().getConfiguredStoryDefinitionByNamespaceAndBotIdAndIntent(applicationDefinition.getNamespace(), applicationDefinition.getName(), currentIntent.getName());
            } else {
                storyDefinitionConfiguration = existingStory = null;
            }
            if (existingStory == null) continue;
            boolean bl4 = false;
            INSTANCE.getStoryDefinitionDAO().save(StoryDefinitionConfiguration.copy$default((StoryDefinitionConfiguration)existingStory, null, null, null, null, null, (int)0, null, null, null, null, null, null, null, null, null, INSTANCE.prepareEndingFeatures(existingStory, faqSettings), null, null, null, null, null, (boolean)false, (int)0x3F7FFF, null));
        }
    }

    private final List<StoryDefinitionConfigurationFeature> prepareEndingFeatures(StoryDefinitionConfiguration existingStory, FaqSettings faqSettings) {
        List features = new ArrayList();
        features.addAll(existingStory.getFeatures());
        features.removeIf(arg_0 -> FaqAdminService.prepareEndingFeatures$lambda$11(FaqAdminService::prepareEndingFeatures$lambda$10, arg_0));
        logger.info(() -> FaqAdminService.prepareEndingFeatures$lambda$12(existingStory));
        if (faqSettings.getSatisfactionEnabled()) {
            features.add(new StoryDefinitionConfigurationFeature(null, true, null, faqSettings.getSatisfactionStoryId()));
            logger.info(() -> FaqAdminService.prepareEndingFeatures$lambda$13(faqSettings, existingStory));
        }
        return features;
    }

    private final StoryDefinitionConfiguration prepareStoryCreationOrUpdate(FaqDefinitionRequest query, IntentDefinition intent, I18nLabel i18nLabel, ApplicationDefinition applicationDefinition, StoryDefinitionConfiguration existingStory, FaqSettingsQuery faqFaqSettingsQuery) {
        StoryDefinitionConfiguration storyDefinitionConfiguration;
        List<StoryDefinitionConfigurationFeature> features = this.prepareStoryFeatures(query.getEnabled(), faqFaqSettingsQuery);
        if (existingStory != null) {
            storyDefinitionConfiguration = new StoryDefinitionConfiguration(existingStory.getStoryId(), applicationDefinition.getName(), existingStory.getIntent(), AnswerConfigurationType.simple, CollectionsKt.listOf((Object)new SimpleAnswerConfiguration(CollectionsKt.listOf((Object)new SimpleAnswer(new I18nLabelValue(i18nLabel), -1L, null)))), 1, applicationDefinition.getNamespace(), existingStory.getMandatoryEntities(), existingStory.getSteps(), ((Object)StringsKt.trim((CharSequence)query.getTitle())).toString(), FAQ_CATEGORY, ((Object)StringsKt.trim((CharSequence)query.getDescription())).toString(), (String)CollectionsKt.first(query.getUtterances()), i18nLabel.getDefaultLocale(), existingStory.getConfigurationName(), features, existingStory.get_id(), existingStory.getTags(), existingStory.getConfiguredAnswers(), existingStory.getConfiguredSteps(), null, false, 0x300000, null);
        } else {
            String string = intent.getName();
            String string2 = applicationDefinition.getName();
            IntentWithoutNamespace intentWithoutNamespace = new IntentWithoutNamespace(intent.getName());
            List list = CollectionsKt.listOf((Object)new SimpleAnswerConfiguration(CollectionsKt.listOf((Object)new SimpleAnswer(new I18nLabelValue(i18nLabel), -1L, null))));
            String string3 = applicationDefinition.getNamespace();
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            String string4 = intent.getLabel();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = intent.getDescription();
            Intrinsics.checkNotNull((Object)string5);
            storyDefinitionConfiguration = new StoryDefinitionConfiguration(string, string2, intentWithoutNamespace, AnswerConfigurationType.simple, list, 1, string3, list2, list3, string4, FAQ_CATEGORY, string5, (String)CollectionsKt.first(query.getUtterances()), i18nLabel.getDefaultLocale(), null, features, null, null, null, null, null, false, 4145152, null);
        }
        return storyDefinitionConfiguration;
    }

    private final List<StoryDefinitionConfigurationFeature> prepareStoryFeatures(boolean enabled, FaqSettingsQuery faqFaqSettingsQuery) {
        List features;
        block0: {
            features = new ArrayList();
            features.add(new StoryDefinitionConfigurationFeature(null, enabled, null, null));
            FaqSettingsQuery faqSettingsQuery = faqFaqSettingsQuery;
            if (faqSettingsQuery == null) break block0;
            FaqSettingsQuery it = faqSettingsQuery;
            boolean bl = false;
            features.add(new StoryDefinitionConfigurationFeature(null, true, null, it.getSatisfactionStoryId()));
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private final void createOrUpdateUtterances(FaqDefinitionRequest query, ApplicationDefinition app, Id<IntentDefinition> intentId, String userLogin) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Pair<List<String>, List<ClassifiedSentence>> sentences = this.checkSentencesToAddOrDelete(query.getUtterances(), query.getLanguage(), (Id<ApplicationDefinition>)app.get_id(), intentId);
        List notYetPresentSentences = (List)sentences.getFirst();
        Iterable $this$forEach$iv = notYetPresentSentences;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String utterance = (String)element$iv2;
            boolean bl = false;
            BotAdminService.INSTANCE.saveSentence(utterance, query.getLanguage(), (Id<ApplicationDefinition>)app.get_id(), intentId, userLogin);
            Unit unit = Unit.INSTANCE;
            Unit it = unit;
            boolean bl2 = false;
            logger.info(FaqAdminService::createOrUpdateUtterances$lambda$17$lambda$16$lambda$15);
        }
        logger.info(() -> FaqAdminService.createOrUpdateUtterances$lambda$18(notYetPresentSentences));
        Iterable $this$filter$iv = (Iterable)sentences.getSecond();
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getApplicationId(), (Object)app.get_id())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List noMorePresentSentences = (List)destination$iv$iv;
        this.getClassifiedSentenceDAO().switchSentencesStatus(noMorePresentSentences, ClassifiedSentenceStatus.deleted);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, List<ClassifiedSentence>> checkSentencesToAddOrDelete(List<String> utterances, Locale locale, Id<ApplicationDefinition> applicationId, Id<IntentDefinition> intentId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv2;
        Object[] objectArray = new ClassifiedSentenceStatus[]{ClassifiedSentenceStatus.validated, ClassifiedSentenceStatus.model};
        Set set = SetsKt.setOf((Object[])objectArray);
        List allSentences = this.getClassifiedSentenceDAO().search(new SentencesQuery(applicationId, locale, 0L, null, null, intentId, set, null, true, null, null, null, null, null, null, false, null, false, false, null, null, 0.0f, 0.0f, false, null, 33554068, null)).getSentences();
        Set existingSentences = null;
        existingSentences = new HashSet();
        Set notYetPresentSentences = null;
        notYetPresentSentences = new HashSet();
        Iterable $this$forEach$iv = utterances;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Object v0;
            String utterance;
            block4: {
                utterance = (String)element$iv2;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = allSentences;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    ClassifiedSentence it = (ClassifiedSentence)element$iv3;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)utterance)) continue;
                    v0 = element$iv3;
                    break block4;
                }
                v0 = null;
            }
            ClassifiedSentence existing = v0;
            if (existing != null) {
                existingSentences = SetsKt.plus((Set)existingSentences, (Object)existing);
                continue;
            }
            notYetPresentSentences = SetsKt.plus((Set)notYetPresentSentences, (Object)utterance);
        }
        Iterable $i$f$forEach22 = CollectionsKt.subtract((Iterable)CollectionsKt.toSet((Iterable)allSentences), (Iterable)existingSentences);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getApplicationId(), applicationId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set noMorePresentSentences = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new Pair((Object)CollectionsKt.toList((Iterable)notYetPresentSentences), (Object)CollectionsKt.toList((Iterable)noMorePresentSentences));
    }

    @NotNull
    public final List<String> searchTags(@NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        return ApplicationConfigurationServiceKt.getFaqDefinitionDAO().getTags(applicationId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FaqDefinitionSearchResult searchFAQ(@NotNull FaqSearchRequest query, @NotNull ApplicationDefinition applicationDefinition) {
        Set<FaqDefinitionRequest> set;
        List list;
        Set<FaqDefinitionRequest> destination$iv$iv;
        List<I18nLabel> i18nLabels;
        List<I18nLabel> list2;
        Intrinsics.checkNotNullParameter((Object)((Object)query), (String)"query");
        Intrinsics.checkNotNullParameter((Object)applicationDefinition, (String)"applicationDefinition");
        String string = query.getSearch();
        if (string != null) {
            String it = string;
            boolean bl = false;
            list2 = INSTANCE.findPredicatesFrom18nLabels(applicationDefinition, query.getSearch());
        } else {
            list2 = null;
        }
        List<I18nLabel> list3 = i18nLabels = list2;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = (Set<FaqDefinitionRequest>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                I18nLabel i18nLabel = (I18nLabel)item$iv$iv;
                Set<FaqDefinitionRequest> set2 = destination$iv$iv;
                boolean bl = false;
                set2.add((FaqDefinitionRequest)it.get_id());
            }
            list = CollectionsKt.toList((Iterable)((List)((Object)destination$iv$iv)));
        } else {
            list = null;
        }
        List i18nIds = list;
        Pair faqDetailsWithCount = ApplicationConfigurationServiceKt.getFaqDefinitionDAO().getFaqDetailsWithCount(query.toFaqQuery(), applicationDefinition, i18nIds);
        Set<FaqDefinitionRequest> fromTockBotDb = this.mapI18LabelFaqAndConvertToFaqDefinitionRequest((List)faqDetailsWithCount.getFirst(), applicationDefinition);
        Set<FaqDefinitionRequest> fromTockFrontDb = fromTockBotDb.isEmpty() ? this.searchLabelsFromTockFrontDb((List)faqDetailsWithCount.getFirst(), applicationDefinition) : SetsKt.emptySet();
        destination$iv$iv = fromTockBotDb;
        if (destination$iv$iv.isEmpty()) {
            boolean bl = false;
            set = fromTockFrontDb;
        } else {
            set = destination$iv$iv;
        }
        Set faqResultsTmp = set;
        Set<FaqDefinitionRequest> faqResults = this.feedFaqDataStory(faqResultsTmp, applicationDefinition);
        logger.debug(() -> FaqAdminService.searchFAQ$lambda$26(faqResults));
        return this.toFaqDefinitionSearchResult(query.getStart(), faqResults, ((Number)faqDetailsWithCount.getSecond()).longValue());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FaqDefinitionRequest> feedFaqDataStory(Set<FaqDefinitionRequest> faqs, ApplicationDefinition applicationDefinition) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        FaqDefinitionRequest it;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = faqs;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            Iterator iterator = (FaqDefinitionRequest)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it2.getIntentName());
        }
        List intentNames = (List)destination$iv$iv;
        Iterable $i$f$map22 = BotAdminService.INSTANCE.findConfiguredStoriesByBotIdAndIntent(applicationDefinition.getNamespace(), applicationDefinition.getName(), intentNames);
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void $i$f$mapTo22 = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            StoryDefinitionConfiguration storyDefinitionConfiguration = (StoryDefinitionConfiguration)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(it.getIntent().getName(), element$iv$iv);
        }
        Map faqStoriesByIntentName = destination$iv$iv2;
        Function1 faqWithStoryIntentName = arg_0 -> FaqAdminService.feedFaqDataStory$lambda$29(faqStoriesByIntentName, arg_0);
        Iterable $i$f$associateBy22 = faqs;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)faqWithStoryIntentName.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void faq;
            it = (FaqDefinitionRequest)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add((FaqDefinitionRequest)updatedFaqSearchWithStoryNameAndDescription.invoke((Object)faq, (Object)faqStoriesByIntentName));
        }
        $this$map$iv = faqs;
        object = (List)destination$iv$iv2;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)faqWithStoryIntentName.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return CollectionsKt.union((Iterable)object, (Iterable)((List)destination$iv$iv2));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FaqDefinitionRequest> mapI18LabelFaqAndConvertToFaqDefinitionRequest(List<FaqQueryResult> faqQueryResults, ApplicationDefinition applicationDefinition) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = faqQueryResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void faqQueryResult;
            FaqQueryResult faqQueryResult2 = (FaqQueryResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = faqQueryResult;
            void v1 = faqQueryResult;
            I18nLabel i18nLabel = INSTANCE.getI18nDao().getLabelById(faqQueryResult.getI18nId());
            if (i18nLabel == null) {
                I18nLabel i18nLabel2;
                I18nLabel i18nLabel3 = i18nLabel2 = INSTANCE.unknownI18n(applicationDefinition);
                void var15_14 = v1;
                void var16_15 = v0;
                boolean bl2 = false;
                logger.warn(FaqAdminService::mapI18LabelFaqAndConvertToFaqDefinitionRequest$lambda$35$lambda$34$lambda$33);
                Unit unit = Unit.INSTANCE;
                v0 = var16_15;
                v1 = var15_14;
                i18nLabel = i18nLabel2;
            }
            collection.add(v0.toFaqDefinitionDetailed((FaqQueryResult)v1, i18nLabel));
        }
        Set fromTockBotDb = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return this.convertFaqDefinitionDetailedToFaqDefinitionRequest(fromTockBotDb, applicationDefinition);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FaqDefinitionRequest> searchLabelsFromTockFrontDb(List<FaqQueryResult> faqQuery, ApplicationDefinition applicationDefinition) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = faqQuery;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FaqQueryResult faqQueryResult = (FaqQueryResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            I18nLabel i18nLabel = INSTANCE.getI18nDao().getLabelById(it.getI18nId());
            boolean bl2 = false;
            void v0 = it;
            void v1 = it;
            I18nLabel i18nLabel2 = i18nLabel;
            if (i18nLabel2 == null) {
                I18nLabel i18nLabel3;
                I18nLabel i18nLabel4 = i18nLabel3 = INSTANCE.unknownI18n(applicationDefinition);
                void var17_16 = v1;
                void var18_17 = v0;
                boolean bl3 = false;
                logger.warn(FaqAdminService::searchLabelsFromTockFrontDb$lambda$39$lambda$38$lambda$37$lambda$36);
                Unit unit = Unit.INSTANCE;
                v0 = var18_17;
                v1 = var17_16;
                i18nLabel2 = i18nLabel3;
            }
            collection.add(v0.toFaqDefinitionDetailed((FaqQueryResult)v1, i18nLabel2));
        }
        Set fromTockFrontDbOnly = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new LinkedHashSet(this.convertFaqDefinitionDetailedToFaqDefinitionRequest(fromTockFrontDbOnly, applicationDefinition));
    }

    private final List<ClassifiedSentence> checkAndInformAnyMissingUtterances(ApplicationDefinition applicationDefinition, Id<IntentDefinition> intentId, List<ClassifiedSentence> utterances) {
        Collection collection;
        Collection collection2 = utterances;
        if (collection2.isEmpty()) {
            List list;
            boolean bl = false;
            List it = list = CollectionsKt.listOf((Object)INSTANCE.fakeMissingUtterance(applicationDefinition, intentId));
            boolean bl2 = false;
            logger.warn(FaqAdminService::checkAndInformAnyMissingUtterances$lambda$42$lambda$41$lambda$40);
            collection = list;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final I18nLabel unknownI18n(ApplicationDefinition applicationDefinition) {
        Locale supportedLocale = (Locale)CollectionsKt.first((Iterable)applicationDefinition.getSupportedLocales());
        LinkedHashSet<I18nLocalizedLabel> fakeLocalizedLabel = new LinkedHashSet<I18nLocalizedLabel>();
        fakeLocalizedLabel.add(new I18nLocalizedLabel(supportedLocale, UserInterfaceType.textChat, UNKNOWN_ANSWER));
        return new I18nLabel(IdsKt.newId(), applicationDefinition.getNamespace(), FAQ_CATEGORY, fakeLocalizedLabel, UNKNOWN_ANSWER, supportedLocale, null, 0, 192, null);
    }

    private final ClassifiedSentence fakeMissingUtterance(ApplicationDefinition applicationDefinition, Id<IntentDefinition> intentId) {
        Locale supportedLocale = (Locale)CollectionsKt.first((Iterable)applicationDefinition.getSupportedLocales());
        Id id = applicationDefinition.get_id();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Instant instant2 = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        return new ClassifiedSentence(MISSING_UTTERANCE, supportedLocale, id, instant, instant2, ClassifiedSentenceStatus.inbox, new Classification(intentId, CollectionsKt.emptyList()), Double.valueOf(1.0), Double.valueOf(1.0), null, 0L, 0L, false, null, "-", null, null, 114176, null);
    }

    private final FaqDefinitionSearchResult toFaqDefinitionSearchResult(long start, Set<FaqDefinitionRequest> faqSet, long count) {
        logger.debug(() -> FaqAdminService.toFaqDefinitionSearchResult$lambda$43(faqSet));
        return new FaqDefinitionSearchResult(count, start, start + (long)CollectionsKt.toList((Iterable)faqSet).size(), CollectionsKt.toList((Iterable)faqSet));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FaqDefinitionRequest> convertFaqDefinitionDetailedToFaqDefinitionRequest(Set<FaqDefinitionDetailed> detailedFaqs, ApplicationDefinition applicationDefinition) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = detailedFaqs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            CharSequence charSequence;
            Object object2;
            Collection<String> collection;
            String string;
            ClassifiedSentence it;
            Iterable $this$mapTo$iv$iv2;
            void faqDefinition;
            FaqDefinitionDetailed faqDefinitionDetailed = (FaqDefinitionDetailed)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List<ClassifiedSentence> currentUtterance = INSTANCE.checkAndInformAnyMissingUtterances(applicationDefinition, (Id<IntentDefinition>)faqDefinition.getIntentId(), faqDefinition.getUtterances());
            Iterable $this$map$iv2 = currentUtterance;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                collection3.add(it.getLanguage());
            }
            Locale currentLanguage = (Locale)CollectionsKt.first((List)((List)destination$iv$iv2));
            String string2 = String.valueOf(faqDefinition.get_id());
            String string3 = faqDefinition.getIntentId().toString();
            String string4 = applicationDefinition.getName();
            Instant instant = faqDefinition.getCreationDate();
            Instant instant2 = faqDefinition.getUpdateDate();
            String string5 = faqDefinition.getFaq().getLabel();
            if (string5 == null) {
                string5 = "";
            }
            if ((string = faqDefinition.getFaq().getDescription()) == null) {
                string = "";
            }
            $this$map$iv2 = currentUtterance;
            String string6 = string;
            String string7 = string5;
            Instant instant3 = instant2;
            Instant instant4 = instant;
            String string8 = string4;
            Locale locale = currentLanguage;
            String string9 = string3;
            String string10 = string2;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (ClassifiedSentence)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getText());
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv2 = faqDefinition.getI18nLabel().getI18n();
            List list = faqDefinition.getTags();
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (I18nLocalizedLabel)item$iv$iv2;
                object2 = destination$iv$iv2;
                boolean bl4 = false;
                object2.add(it.getLabel());
            }
            object2 = (List)destination$iv$iv2;
            String string11 = string10;
            String string12 = string9;
            Locale locale2 = locale;
            String string13 = string8;
            Instant instant5 = instant4;
            Instant instant6 = instant3;
            String string14 = string7;
            String string15 = string6;
            Collection<String> collection4 = collection;
            List list2 = list;
            String string16 = (String)CollectionsKt.firstOrNull(object2);
            if (string16 == null) {
                string16 = "";
            }
            if ((charSequence = (CharSequence)string16).length() == 0) {
                void $this$mapTo$iv$iv3;
                list = list2;
                collection = collection4;
                string6 = string15;
                string7 = string14;
                instant3 = instant6;
                instant4 = instant5;
                string8 = string13;
                locale = locale2;
                string9 = string12;
                string10 = string11;
                boolean bl5 = false;
                Iterable $this$map$iv3 = INSTANCE.unknownI18n(applicationDefinition).getI18n();
                boolean $i$f$map3 = false;
                Iterable $i$f$mapTo3 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    void it2;
                    I18nLocalizedLabel i18nLocalizedLabel = (I18nLocalizedLabel)item$iv$iv3;
                    Collection collection5 = destination$iv$iv3;
                    boolean bl6 = false;
                    collection5.add(it2.getLabel());
                }
                object2 = (String)CollectionsKt.first((List)((List)destination$iv$iv3));
                string11 = string10;
                string12 = string9;
                locale2 = locale;
                string13 = string8;
                instant5 = instant4;
                instant6 = instant3;
                string14 = string7;
                string15 = string6;
                collection4 = collection;
                list2 = list;
                object = object2;
            } else {
                object = charSequence;
            }
            String string17 = faqDefinition.getFaq().getName();
            boolean bl7 = faqDefinition.getEnabled();
            String string18 = (String)object;
            List list3 = list2;
            Collection<String> collection6 = collection4;
            String string19 = string15;
            String string20 = string14;
            Instant instant7 = instant6;
            Instant instant8 = instant5;
            String string21 = string13;
            Locale locale3 = locale2;
            String string22 = string12;
            String string23 = string11;
            collection2.add(new FaqDefinitionRequest(string23, string22, locale3, string21, instant8, instant7, string20, string19, (List<String>)collection6, list3, string18, bl7, string17));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final List<I18nLabel> findPredicatesFrom18nLabels(ApplicationDefinition applicationDefinition, String search) {
        return this.getI18nDao().getLabels(applicationDefinition.getNamespace(), new I18nLabelFilter(search, FAQ_CATEGORY, I18nLabelStateFilter.VALIDATED, null, 8, null));
    }

    private final IntentDefinition createIntent(FaqDefinitionRequest query, ApplicationDefinition applicationDefinition) {
        String string = this.getIntentName(query);
        if (string == null) {
            WebVerticle.Companion.badRequest("Trouble when creating/updating intent : Intent name is missing");
            throw new KotlinNothingValueException();
        }
        String name = string;
        IntentDefinition intent = new IntentDefinition(name, applicationDefinition.getNamespace(), SetsKt.setOf((Object)applicationDefinition.get_id()), SetsKt.emptySet(), null, null, null, ((Object)StringsKt.trim((CharSequence)query.getTitle())).toString(), ((Object)StringsKt.trim((CharSequence)query.getDescription())).toString(), FAQ_CATEGORY, null, 1136, null);
        logger.debug(() -> FaqAdminService.createIntent$lambda$50(intent));
        return AdminService.INSTANCE.createOrUpdateIntent(applicationDefinition.getNamespace(), intent);
    }

    private final String getIntentName(FaqDefinitionRequest query) {
        String string;
        if (query.getId() != null) {
            IntentDefinition intentDefinition = this.findFaqDefinitionIntent((Id<FaqDefinition>)IdsKt.toId((String)query.getId()));
            string = intentDefinition != null ? intentDefinition.getName() : null;
        } else {
            string = query.getIntentName();
        }
        return string;
    }

    private final IntentDefinition findFaqDefinitionIntent(Id<FaqDefinition> faqId) {
        IntentDefinition intentDefinition;
        FaqDefinition faqDefinition = ApplicationConfigurationServiceKt.getFaqDefinitionDAO().getFaqDefinitionById(faqId);
        if (faqDefinition != null) {
            FaqDefinition it = faqDefinition;
            boolean bl = false;
            intentDefinition = ApplicationConfigurationServiceKt.getIntentDAO().getIntentById(it.getIntentId());
        } else {
            intentDefinition = null;
        }
        return intentDefinition;
    }

    /*
     * WARNING - void declaration
     */
    private final I18nLabel manageI18nLabelUpdate(FaqDefinitionRequest query, String namespace, FaqDefinition existingFaq) {
        I18nLabel i18nLabel;
        if (existingFaq != null && !StringsKt.isBlank((CharSequence)existingFaq.getI18nId().toString())) {
            I18nLocalizedLabel[] i18nLocalizedLabelArray = new I18nLocalizedLabel[]{new I18nLocalizedLabel(query.getLanguage(), UserInterfaceType.textChat, ((Object)StringsKt.trim((CharSequence)query.getAnswer())).toString())};
            I18nLabel i18nLabel2 = new I18nLabel(existingFaq.getI18nId(), namespace, FAQ_CATEGORY, SetsKt.linkedSetOf((Object[])i18nLocalizedLabelArray), ((Object)StringsKt.trim((CharSequence)query.getAnswer())).toString(), query.getLanguage(), null, 0, 192, null);
            this.getI18nDao().save(CollectionsKt.listOf((Object)i18nLabel2));
            I18nLocalizedLabel[] it = i18nLocalizedLabelArray = Unit.INSTANCE;
            boolean bl = false;
            logger.info(() -> FaqAdminService.manageI18nLabelUpdate$lambda$53$lambda$52(i18nLabel2));
            i18nLabel = i18nLabel2;
        } else {
            void it;
            CreateI18nLabelRequest createI18nLabelRequest;
            CreateI18nLabelRequest createI18nLabelRequest2 = createI18nLabelRequest = new CreateI18nLabelRequest(((Object)StringsKt.trim((CharSequence)query.getAnswer())).toString(), query.getLanguage(), FAQ_CATEGORY);
            String string = namespace;
            BotAdminService botAdminService = BotAdminService.INSTANCE;
            boolean bl = false;
            logger.info(() -> FaqAdminService.manageI18nLabelUpdate$lambda$55$lambda$54((CreateI18nLabelRequest)it));
            Unit unit = Unit.INSTANCE;
            i18nLabel = botAdminService.createI18nRequest(string, createI18nLabelRequest);
        }
        return i18nLabel;
    }

    public final boolean deleteFaqDefinition(@NotNull String namespace, @NotNull String faqDefinitionId) {
        IntentDefinition intent;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)faqDefinitionId, (String)"faqDefinitionId");
        FaqDefinition faqDefinition = ApplicationConfigurationServiceKt.getFaqDefinitionDAO().getFaqDefinitionById(IdsKt.toId((String)faqDefinitionId));
        if (faqDefinition != null && (intent = ApplicationConfigurationServiceKt.getIntentDAO().getIntentById(faqDefinition.getIntentId())) != null) {
            logger.info(() -> FaqAdminService.deleteFaqDefinition$lambda$56(intent));
            ApplicationDefinition applicationDefinition = ApplicationConfigurationServiceKt.getApplicationDAO().getApplicationByNamespaceAndName(namespace, faqDefinition.getBotId());
            if (applicationDefinition == null) {
                WebVerticle.Companion.badRequest("Application not found for namespace " + namespace + " and name " + faqDefinition.getBotId());
                throw new KotlinNothingValueException();
            }
            ApplicationDefinition application = applicationDefinition;
            return this.deleteOneFaqDefinition(application, faqDefinition, namespace, intent.getName());
        }
        return false;
    }

    private final boolean deleteOneFaqDefinition(ApplicationDefinition application, FaqDefinition faqDefinition, String namespace, String intentName) {
        block0: {
            front.removeIntentFromApplication(application, faqDefinition.getIntentId());
            ApplicationConfigurationServiceKt.getFaqDefinitionDAO().deleteFaqDefinitionById(faqDefinition.get_id());
            this.getI18nDao().deleteByNamespaceAndId(namespace, faqDefinition.getI18nId());
            StoryDefinitionConfiguration storyDefinitionConfiguration = this.getStoryDefinitionDAO().getConfiguredStoryDefinitionByNamespaceAndBotIdAndIntent(application.getNamespace(), application.getName(), intentName);
            if (storyDefinitionConfiguration == null) break block0;
            StoryDefinitionConfiguration it = storyDefinitionConfiguration;
            boolean bl = false;
            BotAdminService.INSTANCE.deleteStory(it.getNamespace(), it.get_id().toString());
        }
        return true;
    }

    @Nullable
    public final FaqSettingsQuery getSettings(@NotNull ApplicationDefinition applicationDefinition) {
        Intrinsics.checkNotNullParameter((Object)applicationDefinition, (String)"applicationDefinition");
        FaqSettings faqSettings = this.getFaqSettingsDAO().getFaqSettingsByApplicationId(applicationDefinition.get_id());
        return faqSettings != null ? faqSettings.toFaqSettingsQuery() : null;
    }

    @NotNull
    public final FaqSettingsQuery saveSettings(@NotNull ApplicationDefinition applicationDefinition, @NotNull FaqSettingsQuery faqSettingsQuery) {
        Intrinsics.checkNotNullParameter((Object)applicationDefinition, (String)"applicationDefinition");
        Intrinsics.checkNotNullParameter((Object)faqSettingsQuery, (String)"faqSettingsQuery");
        FaqSettings faqSettings = this.getFaqSettingsDAO().getFaqSettingsByApplicationId(applicationDefinition.get_id());
        FaqSettings faqSettings2 = faqSettings;
        if (faqSettings2 == null) {
            Id id = applicationDefinition.get_id();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            faqSettings2 = new FaqSettings(null, id, false, null, instant, instant2, 13, null);
        }
        boolean bl = faqSettingsQuery.getSatisfactionEnabled();
        String string = faqSettingsQuery.getSatisfactionStoryId();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        FaqSettings faqSettingsUpdated = FaqSettings.copy$default((FaqSettings)faqSettings2, null, null, (boolean)bl, (String)string, null, (Instant)instant, (int)19, null);
        this.getFaqSettingsDAO().save(faqSettingsUpdated);
        this.updateAllFaqStoryWithSettings(applicationDefinition, faqSettingsUpdated);
        return faqSettingsUpdated.toFaqSettingsQuery();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final String makeMigration$lambda$1(Id it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IntentDefinition intentDefinition = ApplicationConfigurationServiceKt.getIntentDAO().getIntentById(it);
        return intentDefinition != null ? intentDefinition.getNamespace() : null;
    }

    private static final Object prepareCreationOrUpdatingFaqDefinition$lambda$2(IntentDefinition $intent) {
        return "Updating FAQ \"" + $intent.getLabel() + "\"";
    }

    private static final Object prepareCreationOrUpdatingFaqDefinition$lambda$3(IntentDefinition $intent) {
        return "Creating FAQ \"" + $intent.getLabel() + "\"";
    }

    private static final Object createOrUpdateStory$lambda$5$lambda$4(BotStoryDefinitionConfiguration $it, String $enabledLog) {
        BotStoryDefinitionConfiguration botStoryDefinitionConfiguration = $it;
        return "Saved FAQ with story \"" + (botStoryDefinitionConfiguration != null && (botStoryDefinitionConfiguration = botStoryDefinitionConfiguration.getIntent()) != null ? botStoryDefinitionConfiguration.getName() : null) + "\" " + $enabledLog;
    }

    private static final boolean prepareEndingFeatures$lambda$10(StoryDefinitionConfigurationFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return feature.getEndWithStoryId() != null;
    }

    private static final boolean prepareEndingFeatures$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object prepareEndingFeatures$lambda$12(StoryDefinitionConfiguration $existingStory) {
        return "Remove all features ending from FAQ Story '" + $existingStory.getStoryId() + "'";
    }

    private static final Object prepareEndingFeatures$lambda$13(FaqSettings $faqSettings, StoryDefinitionConfiguration $existingStory) {
        return "Add the feature ending '" + $faqSettings.getSatisfactionStoryId() + "' to FAQ Story '" + $existingStory.getStoryId() + "'";
    }

    private static final Object createOrUpdateUtterances$lambda$17$lambda$16$lambda$15() {
        return "Saving classified sentence";
    }

    private static final Object createOrUpdateUtterances$lambda$18(List $notYetPresentSentences) {
        return "Create " + $notYetPresentSentences.size() + " new utterances for FAQ";
    }

    private static final Object searchFAQ$lambda$26(Set $faqResults) {
        return "faqResults " + $faqResults;
    }

    private static final boolean feedFaqDataStory$lambda$29(Map $faqStoriesByIntentName, FaqDefinitionRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $faqStoriesByIntentName.keySet().contains(it.getIntentName());
    }

    private static final FaqDefinitionRequest updatedFaqSearchWithStoryNameAndDescription$lambda$32(FaqDefinitionRequest faqDefinitionRequest, Map it) {
        Intrinsics.checkNotNullParameter((Object)faqDefinitionRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = it.get(faqDefinitionRequest.getIntentName());
        Intrinsics.checkNotNull(v);
        StoryDefinitionConfiguration story = (StoryDefinitionConfiguration)v;
        boolean bl = false;
        return FaqDefinitionRequest.copy$default(faqDefinitionRequest, null, null, null, null, null, null, story.getName(), story.getDescription(), null, null, null, false, null, 7999, null);
    }

    private static final Object mapI18LabelFaqAndConvertToFaqDefinitionRequest$lambda$35$lambda$34$lambda$33() {
        return WARN_CANNOT_FIND_LABEL;
    }

    private static final Object searchLabelsFromTockFrontDb$lambda$39$lambda$38$lambda$37$lambda$36() {
        return WARN_CANNOT_FIND_LABEL;
    }

    private static final Object checkAndInformAnyMissingUtterances$lambda$42$lambda$41$lambda$40() {
        return WARN_CANNOT_FIND_UTTERANCE;
    }

    private static final Object toFaqDefinitionSearchResult$lambda$43(Set $faqSet) {
        return "FaqSet " + $faqSet;
    }

    private static final Object createIntent$lambda$50(IntentDefinition $intent) {
        return "Saved intent " + $intent + " for FAQ";
    }

    private static final Object manageI18nLabelUpdate$lambda$53$lambda$52(I18nLabel $i18nLabel) {
        return "Updating I18n label : " + $i18nLabel.getDefaultLabel();
    }

    private static final Object manageI18nLabelUpdate$lambda$55$lambda$54(CreateI18nLabelRequest $it) {
        return "Creating I18n label : " + $it.getLabel();
    }

    private static final Object deleteFaqDefinition$lambda$56(IntentDefinition $intent) {
        return "Deleting FAQ Definition \"" + $intent.getLabel() + "\"";
    }
}

