/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.bot.observability.BotObservabilityConfiguration;
import ai.tock.bot.admin.bot.sentencegeneration.BotSentenceGenerationConfiguration;
import ai.tock.bot.admin.bot.sentencegeneration.BotSentenceGenerationConfigurationDAO;
import ai.tock.bot.admin.model.SentenceGenerationRequest;
import ai.tock.bot.admin.service.ObservabilityService;
import ai.tock.genai.orchestratorclient.requests.Formatter;
import ai.tock.genai.orchestratorclient.requests.PromptTemplate;
import ai.tock.genai.orchestratorclient.requests.SentenceGenerationQuery;
import ai.tock.genai.orchestratorclient.responses.SentenceGenerationResponse;
import ai.tock.genai.orchestratorcore.models.llm.LLMSettingBase;
import ai.tock.genai.orchestratorcore.models.observability.ObservabilitySettingBase;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.vertx.WebVerticle;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lai/tock/bot/admin/service/CompletionService;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "completionService", "Lai/tock/genai/orchestratorclient/services/CompletionService;", "getCompletionService", "()Lai/tock/genai/orchestratorclient/services/CompletionService;", "sentenceGenerationConfigurationDAO", "Lai/tock/bot/admin/bot/sentencegeneration/BotSentenceGenerationConfigurationDAO;", "getSentenceGenerationConfigurationDAO", "()Lai/tock/bot/admin/bot/sentencegeneration/BotSentenceGenerationConfigurationDAO;", "generateSentences", "Lai/tock/genai/orchestratorclient/responses/SentenceGenerationResponse;", "request", "Lai/tock/bot/admin/model/SentenceGenerationRequest;", "namespace", "", "botId", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nCompletionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionService.kt\nai/tock/bot/admin/service/CompletionService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,95:1\n48#2,2:96\n48#2,2:100\n51#3:98\n51#3:102\n277#4:99\n277#4:103\n*S KotlinDebug\n*F\n+ 1 CompletionService.kt\nai/tock/bot/admin/service/CompletionService\n*L\n37#1:96,2\n38#1:100,2\n37#1:98\n38#1:102\n37#1:99\n38#1:103\n*E\n"})
public final class CompletionService {
    @NotNull
    public static final CompletionService INSTANCE = new CompletionService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(CompletionService::logger$lambda$0);

    private CompletionService() {
    }

    private final ai.tock.genai.orchestratorclient.services.CompletionService getCompletionService() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (ai.tock.genai.orchestratorclient.services.CompletionService)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ai.tock.genai.orchestratorclient.services.CompletionService>(){}, tag$iv).getValue()).invoke();
    }

    private final BotSentenceGenerationConfigurationDAO getSentenceGenerationConfigurationDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (BotSentenceGenerationConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<BotSentenceGenerationConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    @Nullable
    public final SentenceGenerationResponse generateSentences(@NotNull SentenceGenerationRequest request, @NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        BotSentenceGenerationConfiguration botSentenceGenerationConfiguration = this.getSentenceGenerationConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
        if (botSentenceGenerationConfiguration == null) {
            WebVerticle.Companion.badRequest("No configuration of sentence generation feature is defined yet [namespace: " + namespace + ", botId = " + botId + "]");
            throw new KotlinNothingValueException();
        }
        BotSentenceGenerationConfiguration sentenceGenerationConfig = botSentenceGenerationConfiguration;
        if (!sentenceGenerationConfig.getEnabled()) {
            WebVerticle.Companion.badRequest("The sentence generation feature is disabled [namespace: " + namespace + ", botId = " + botId + "]");
            throw new KotlinNothingValueException();
        }
        LLMSettingBase llmSetting = sentenceGenerationConfig.getLlmSetting().copyWithTemperature(request.getLlmTemperature());
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"locale", (Object)request.getLocale());
        pairArray[1] = TuplesKt.to((Object)"nb_sentences", (Object)sentenceGenerationConfig.getNbSentences());
        pairArray[2] = TuplesKt.to((Object)"sentences", request.getSentences());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"spelling_mistakes", (Object)request.getOptions().getSpellingMistakes()), TuplesKt.to((Object)"sms_language", (Object)request.getOptions().getSmsLanguage()), TuplesKt.to((Object)"abbreviated_language", (Object)request.getOptions().getAbbreviatedLanguage())};
        pairArray[3] = TuplesKt.to((Object)"options", (Object)MapsKt.mapOf((Pair[])pairArray2));
        Map inputs = MapsKt.mapOf((Pair[])pairArray);
        PromptTemplate prompt = new PromptTemplate(Formatter.JINJA2.getId(), llmSetting.getPrompt(), inputs);
        BotObservabilityConfiguration botObservabilityConfiguration = ObservabilityService.INSTANCE.getObservabilityConfiguration(namespace, botId, true);
        return this.getCompletionService().generateSentences(new SentenceGenerationQuery(llmSetting, prompt, (ObservabilitySettingBase)(botObservabilityConfiguration != null ? botObservabilityConfiguration.getSetting() : null)));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }
}

