/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.BotAdminService;
import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.admin.bot.observability.BotObservabilityConfiguration;
import ai.tock.bot.admin.bot.observability.BotObservabilityConfigurationDAO;
import ai.tock.bot.admin.model.BotObservabilityConfigurationDTO;
import ai.tock.bot.admin.service.ObservabilityValidationService;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.exception.error.ErrorMessage;
import ai.tock.shared.exception.rest.BadRequestException;
import ai.tock.shared.vertx.WebVerticle;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.mongodb.MongoWriteException;
import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lai/tock/bot/admin/service/ObservabilityService;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "observabilityConfigurationDAO", "Lai/tock/bot/admin/bot/observability/BotObservabilityConfigurationDAO;", "getObservabilityConfigurationDAO", "()Lai/tock/bot/admin/bot/observability/BotObservabilityConfigurationDAO;", "getObservabilityConfiguration", "Lai/tock/bot/admin/bot/observability/BotObservabilityConfiguration;", "namespace", "", "botId", "deleteConfig", "", "enabled", "", "saveObservability", "observabilityConfig", "Lai/tock/bot/admin/model/BotObservabilityConfigurationDTO;", "saveObservabilityConfiguration", "observabilityConfiguration", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nObservabilityService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservabilityService.kt\nai/tock/bot/admin/service/ObservabilityService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,111:1\n48#2,2:112\n51#3:114\n277#4:115\n*S KotlinDebug\n*F\n+ 1 ObservabilityService.kt\nai/tock/bot/admin/service/ObservabilityService\n*L\n37#1:112,2\n37#1:114\n37#1:115\n*E\n"})
public final class ObservabilityService {
    @NotNull
    public static final ObservabilityService INSTANCE = new ObservabilityService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ObservabilityService::logger$lambda$0);

    private ObservabilityService() {
    }

    private final BotObservabilityConfigurationDAO getObservabilityConfigurationDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (BotObservabilityConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<BotObservabilityConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    @Nullable
    public final BotObservabilityConfiguration getObservabilityConfiguration(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        return this.getObservabilityConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
    }

    public final void deleteConfig(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        BotObservabilityConfiguration botObservabilityConfiguration = this.getObservabilityConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
        if (botObservabilityConfiguration == null) {
            WebVerticle.Companion.badRequest("No Observability configuration is defined yet [namespace: " + namespace + ", botId: " + botId + "]");
            throw new KotlinNothingValueException();
        }
        BotObservabilityConfiguration observabilityConfig = botObservabilityConfiguration;
        logger.info(() -> ObservabilityService.deleteConfig$lambda$1(namespace, botId));
        this.getObservabilityConfigurationDAO().delete(observabilityConfig.get_id());
    }

    @Nullable
    public final BotObservabilityConfiguration getObservabilityConfiguration(@NotNull String namespace, @NotNull String botId, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        return this.getObservabilityConfigurationDAO().findByNamespaceAndBotIdAndEnabled(namespace, botId, enabled);
    }

    @NotNull
    public final BotObservabilityConfiguration saveObservability(@NotNull BotObservabilityConfigurationDTO observabilityConfig) {
        Intrinsics.checkNotNullParameter((Object)observabilityConfig, (String)"observabilityConfig");
        if ((BotApplicationConfiguration)CollectionsKt.firstOrNull(BotAdminService.INSTANCE.getBotConfigurationsByNamespaceAndBotId(observabilityConfig.getNamespace(), observabilityConfig.getBotId())) == null) {
            WebVerticle.Companion.badRequest("No bot configuration is defined yet [namespace: " + observabilityConfig.getNamespace() + ", botId = " + observabilityConfig.getBotId() + "]");
            throw new KotlinNothingValueException();
        }
        return this.saveObservabilityConfiguration(observabilityConfig);
    }

    private final BotObservabilityConfiguration saveObservabilityConfiguration(BotObservabilityConfigurationDTO observabilityConfiguration) {
        BotObservabilityConfiguration botObservabilityConfiguration;
        BotObservabilityConfiguration observabilityConfig = observabilityConfiguration.toBotObservabilityConfiguration();
        if (observabilityConfig.getEnabled()) {
            Set<ErrorMessage> errors = ObservabilityValidationService.INSTANCE.validate(observabilityConfig);
            boolean bl = false;
            if (!((Collection)errors).isEmpty()) {
                throw new BadRequestException(errors);
            }
        }
        try {
            botObservabilityConfiguration = this.getObservabilityConfigurationDAO().save(observabilityConfig);
        }
        catch (MongoWriteException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Observability Configuration: registration failed on mongo ";
            }
            throw new BadRequestException(string);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Observability Configuration: registration failed ";
            }
            throw new BadRequestException(string);
        }
        return botObservabilityConfiguration;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object deleteConfig$lambda$1(String $namespace, String $botId) {
        return "Deleting the Observability Configuration [namespace: " + $namespace + ", botId: " + $botId + "]";
    }
}

