/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.BotAdminService;
import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.admin.bot.rag.BotRAGConfiguration;
import ai.tock.bot.admin.bot.rag.BotRAGConfigurationDAO;
import ai.tock.bot.admin.model.BotRAGConfigurationDTO;
import ai.tock.bot.admin.service.RAGValidationService;
import ai.tock.bot.admin.story.StoryDefinitionConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationDAO;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationFeature;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.StringsKt;
import ai.tock.shared.exception.error.ErrorMessage;
import ai.tock.shared.exception.rest.BadRequestException;
import ai.tock.shared.vertx.WebVerticle;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.mongodb.MongoWriteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lai/tock/bot/admin/service/RAGService;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "storyDefinitionDAO", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "getStoryDefinitionDAO", "()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "ragConfigurationDAO", "Lai/tock/bot/admin/bot/rag/BotRAGConfigurationDAO;", "getRagConfigurationDAO", "()Lai/tock/bot/admin/bot/rag/BotRAGConfigurationDAO;", "getRAGConfiguration", "Lai/tock/bot/admin/bot/rag/BotRAGConfiguration;", "namespace", "", "botId", "deleteConfig", "", "saveRag", "ragConfig", "Lai/tock/bot/admin/model/BotRAGConfigurationDTO;", "saveRagConfiguration", "ragConfiguration", "prepareEndingFeatures", "", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationFeature;", "story", "Lai/tock/bot/admin/story/StoryDefinitionConfiguration;", "ragEnabled", "", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nRAGService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RAGService.kt\nai/tock/bot/admin/service/RAGService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,134:1\n48#2,2:135\n48#2,2:139\n51#3:137\n51#3:141\n277#4:138\n277#4:142\n*S KotlinDebug\n*F\n+ 1 RAGService.kt\nai/tock/bot/admin/service/RAGService\n*L\n42#1:135,2\n43#1:139,2\n42#1:137\n43#1:141\n42#1:138\n43#1:142\n*E\n"})
public final class RAGService {
    @NotNull
    public static final RAGService INSTANCE = new RAGService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(RAGService::logger$lambda$0);

    private RAGService() {
    }

    private final StoryDefinitionConfigurationDAO getStoryDefinitionDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (StoryDefinitionConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<StoryDefinitionConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    private final BotRAGConfigurationDAO getRagConfigurationDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (BotRAGConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<BotRAGConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    @Nullable
    public final BotRAGConfiguration getRAGConfiguration(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        return this.getRagConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
    }

    public final void deleteConfig(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        BotRAGConfiguration botRAGConfiguration = this.getRagConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
        if (botRAGConfiguration == null) {
            WebVerticle.Companion.badRequest("No RAG configuration is defined yet [namespace: " + namespace + ", botId: " + botId + "]");
            throw new KotlinNothingValueException();
        }
        BotRAGConfiguration ragConfig = botRAGConfiguration;
        logger.info(() -> RAGService.deleteConfig$lambda$1(namespace, botId));
        this.getRagConfigurationDAO().delete(ragConfig.get_id());
    }

    @NotNull
    public final BotRAGConfiguration saveRag(@NotNull BotRAGConfigurationDTO ragConfig) {
        Intrinsics.checkNotNullParameter((Object)ragConfig, (String)"ragConfig");
        if ((BotApplicationConfiguration)CollectionsKt.firstOrNull(BotAdminService.INSTANCE.getBotConfigurationsByNamespaceAndBotId(ragConfig.getNamespace(), ragConfig.getBotId())) == null) {
            WebVerticle.Companion.badRequest("No RAG configuration is defined yet [namespace: " + ragConfig.getNamespace() + ", botId: " + ragConfig.getBotId() + "]");
            throw new KotlinNothingValueException();
        }
        logger.info(() -> RAGService.saveRag$lambda$2(ragConfig));
        return this.saveRagConfiguration(ragConfig);
    }

    private final BotRAGConfiguration saveRagConfiguration(BotRAGConfigurationDTO ragConfiguration) {
        StoryDefinitionConfiguration storyDefinitionConfiguration;
        BotRAGConfiguration ragConfig = ragConfiguration.toBotRAGConfiguration();
        if (ragConfig.getEnabled()) {
            Set<ErrorMessage> errors = RAGValidationService.INSTANCE.validate(ragConfig);
            boolean bl = false;
            if (!((Collection)errors).isEmpty()) {
                throw new BadRequestException(errors);
            }
        }
        try {
            storyDefinitionConfiguration = this.getStoryDefinitionDAO().getStoryDefinitionByNamespaceAndBotIdAndIntent(ragConfiguration.getNamespace(), ragConfiguration.getBotId(), StringsKt.withoutNamespace$default((String)"tock:unknown", null, (int)1, null));
            if (storyDefinitionConfiguration != null) {
                StoryDefinitionConfiguration it = storyDefinitionConfiguration;
                boolean bl = false;
                INSTANCE.getStoryDefinitionDAO().save(StoryDefinitionConfiguration.copy$default((StoryDefinitionConfiguration)it, null, null, null, null, null, (int)0, null, null, null, null, null, null, null, null, null, INSTANCE.prepareEndingFeatures(it, !ragConfiguration.getEnabled()), null, null, null, null, null, (boolean)false, (int)0x3F7FFF, null));
            }
            storyDefinitionConfiguration = this.getRagConfigurationDAO().save(ragConfig);
        }
        catch (MongoWriteException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Rag Configuration: registration failed on mongo ";
            }
            throw new BadRequestException(string);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Rag Configuration: registration failed ";
            }
            throw new BadRequestException(string);
        }
        return storyDefinitionConfiguration;
    }

    private final List<StoryDefinitionConfigurationFeature> prepareEndingFeatures(StoryDefinitionConfiguration story, boolean ragEnabled) {
        List features = new ArrayList();
        features.addAll(story.getFeatures());
        features.removeIf(arg_0 -> RAGService.prepareEndingFeatures$lambda$6(RAGService::prepareEndingFeatures$lambda$5, arg_0));
        features.add(new StoryDefinitionConfigurationFeature(null, ragEnabled, null, null));
        return features;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object deleteConfig$lambda$1(String $namespace, String $botId) {
        return "Deleting the RAG Configuration [namespace: " + $namespace + ", botId: " + $botId + "]";
    }

    private static final Object saveRag$lambda$2(BotRAGConfigurationDTO $ragConfig) {
        return "Saving the RAG Configuration [namespace: " + $ragConfig.getNamespace() + ", botId: " + $ragConfig.getBotId() + "]";
    }

    private static final boolean prepareEndingFeatures$lambda$5(StoryDefinitionConfigurationFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        feature.getEnabled();
        return true;
    }

    private static final boolean prepareEndingFeatures$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

