/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.bot.observability.BotObservabilityConfiguration;
import ai.tock.bot.admin.bot.rag.BotRAGConfiguration;
import ai.tock.bot.admin.service.ObservabilityService;
import ai.tock.genai.orchestratorclient.requests.EMProviderSettingStatusQuery;
import ai.tock.genai.orchestratorclient.requests.LLMProviderSettingStatusQuery;
import ai.tock.genai.orchestratorclient.responses.ErrorResponse;
import ai.tock.genai.orchestratorclient.responses.ProviderSettingStatusResponse;
import ai.tock.genai.orchestratorclient.services.EMProviderService;
import ai.tock.genai.orchestratorclient.services.LLMProviderService;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.exception.error.ErrorMessage;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lai/tock/bot/admin/service/RAGValidationService;", "", "<init>", "()V", "llmProviderService", "Lai/tock/genai/orchestratorclient/services/LLMProviderService;", "getLlmProviderService", "()Lai/tock/genai/orchestratorclient/services/LLMProviderService;", "emProviderService", "Lai/tock/genai/orchestratorclient/services/EMProviderService;", "getEmProviderService", "()Lai/tock/genai/orchestratorclient/services/EMProviderService;", "validate", "", "Lai/tock/shared/exception/error/ErrorMessage;", "ragConfig", "Lai/tock/bot/admin/bot/rag/BotRAGConfiguration;", "validateIndexSessionId", "getErrors", "Lai/tock/genai/orchestratorclient/responses/ProviderSettingStatusResponse;", "message", "", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nRAGValidationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RAGValidationService.kt\nai/tock/bot/admin/service/RAGValidationService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n48#2,2:76\n48#2,2:80\n51#3:78\n51#3:82\n277#4:79\n277#4:83\n1557#5:84\n1628#5,3:85\n*S KotlinDebug\n*F\n+ 1 RAGValidationService.kt\nai/tock/bot/admin/service/RAGValidationService\n*L\n32#1:76,2\n33#1:80,2\n32#1:78\n33#1:82\n32#1:79\n33#1:83\n73#1:84\n73#1:85,3\n*E\n"})
public final class RAGValidationService {
    @NotNull
    public static final RAGValidationService INSTANCE = new RAGValidationService();

    private RAGValidationService() {
    }

    private final LLMProviderService getLlmProviderService() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (LLMProviderService)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<LLMProviderService>(){}, tag$iv).getValue()).invoke();
    }

    private final EMProviderService getEmProviderService() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (EMProviderService)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<EMProviderService>(){}, tag$iv).getValue()).invoke();
    }

    @NotNull
    public final Set<ErrorMessage> validate(@NotNull BotRAGConfiguration ragConfig) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)ragConfig, (String)"ragConfig");
        Set $this$validate_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        BotObservabilityConfiguration botObservabilityConfiguration = ObservabilityService.INSTANCE.getObservabilityConfiguration(ragConfig.getNamespace(), ragConfig.getBotId(), true);
        $this$validate_u24lambda_u240.addAll((Collection)INSTANCE.getErrors(INSTANCE.getLlmProviderService().checkSetting(new LLMProviderSettingStatusQuery(ragConfig.getLlmSetting(), botObservabilityConfiguration != null ? botObservabilityConfiguration.getSetting() : null)), "LLM setting check failed"));
        $this$validate_u24lambda_u240.addAll((Collection)INSTANCE.getErrors(INSTANCE.getEmProviderService().checkSetting(new EMProviderSettingStatusQuery(ragConfig.getEmSetting())), "Embedding Model setting check failed"));
        $this$validate_u24lambda_u240.addAll((Collection)INSTANCE.validateIndexSessionId(ragConfig));
        return set;
    }

    private final Set<ErrorMessage> validateIndexSessionId(BotRAGConfiguration ragConfig) {
        CharSequence charSequence;
        Set errors = new LinkedHashSet();
        if (ragConfig.getEnabled() && ((charSequence = (CharSequence)ragConfig.getIndexSessionId()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            errors.add(new ErrorMessage(null, "The index session ID is required to enable the RAG feature", null, 5, null));
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ErrorMessage> getErrors(ProviderSettingStatusResponse $this$getErrors, String message) {
        Object object;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                object = $this$getErrors;
                if (object == null || (object = object.getErrors()) == null) break block3;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ErrorResponse errorResponse = (ErrorResponse)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ErrorMessage(null, message, (Object)$this$getErrors.getErrors(), 1, null));
                }
                object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (object != null) break block4;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }
}

