/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.BotAdminService;
import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.admin.bot.BotApplicationConfigurationDAO;
import ai.tock.bot.admin.bot.BotConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationDAO;
import ai.tock.bot.admin.story.dump.StoryDefinitionConfigurationDump;
import ai.tock.bot.admin.story.dump.StoryDefinitionConfigurationDumpImport;
import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.shared.codec.ApplicationDump;
import ai.tock.nlp.front.shared.codec.ApplicationImportConfiguration;
import ai.tock.nlp.front.shared.codec.DumpType;
import ai.tock.nlp.front.shared.codec.ImportReport;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.user.UserNamespace;
import ai.tock.shared.IOCsKt;
import ai.tock.translator.I18nDAO;
import chat.rocket.common.util.CommonExtensionsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015J>\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J4\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J4\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$H\u0002J$\u0010+\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0,2\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%H\u0002J\u0018\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/tock/bot/admin/service/SynchronizationService;", "", "<init>", "()V", "front", "Lai/tock/nlp/front/client/FrontClient;", "i18n", "Lai/tock/translator/I18nDAO;", "getI18n", "()Lai/tock/translator/I18nDAO;", "i18n$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "storyDefinitionDAO", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "getStoryDefinitionDAO", "()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "botConfigurationDAO", "Lai/tock/bot/admin/bot/BotApplicationConfigurationDAO;", "getBotConfigurationDAO", "()Lai/tock/bot/admin/bot/BotApplicationConfigurationDAO;", "tempPostfix", "", "synchronize", "Lai/tock/nlp/front/shared/codec/ImportReport;", "srcNamespace", "srcAppName", "srcAppId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "targetNamespace", "targetAppName", "withInboxMessages", "", "userLogin", "migrateData", "prepareTempApplication", "", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "cleanTempNamespaceAndApplication", "", "tempNamespace", "tempAppName", "botAppConfMap", "exchangePaths", "Lkotlin/Pair;", "first", "second", "deleteStories", "namespace", "applicationName", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nSynchronizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynchronizationService.kt\nai/tock/bot/admin/service/SynchronizationService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,260:1\n48#2,2:261\n48#2,2:265\n51#3:263\n51#3:267\n80#3:291\n277#4:264\n277#4:268\n277#4:292\n1485#5:269\n1510#5,3:270\n1513#5,3:280\n295#5,2:285\n1863#5,2:287\n1863#5,2:289\n381#6,7:273\n216#7,2:283\n*S KotlinDebug\n*F\n+ 1 SynchronizationService.kt\nai/tock/bot/admin/service/SynchronizationService\n*L\n44#1:261,2\n45#1:265,2\n44#1:263\n45#1:267\n43#1:291\n44#1:264\n45#1:268\n43#1:292\n87#1:269\n87#1:270,3\n87#1:280,3\n139#1:285,2\n206#1:287,2\n220#1:289,2\n87#1:273,7\n88#1:283,2\n*E\n"})
public final class SynchronizationService {
    @NotNull
    public static final SynchronizationService INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final FrontClient front;
    @NotNull
    private static final InjectedProperty i18n$delegate;
    @NotNull
    private static final String tempPostfix = "-temp";

    private SynchronizationService() {
    }

    private final I18nDAO getI18n() {
        return (I18nDAO)i18n$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final StoryDefinitionConfigurationDAO getStoryDefinitionDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (StoryDefinitionConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<StoryDefinitionConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    private final BotApplicationConfigurationDAO getBotConfigurationDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (BotApplicationConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<BotApplicationConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    @NotNull
    public final ImportReport synchronize(@NotNull String srcNamespace, @NotNull String srcAppName, @NotNull Id<ApplicationDefinition> srcAppId, @NotNull String targetNamespace, @NotNull String targetAppName, boolean withInboxMessages, @NotNull String userLogin) {
        Intrinsics.checkNotNullParameter((Object)srcNamespace, (String)"srcNamespace");
        Intrinsics.checkNotNullParameter((Object)srcAppName, (String)"srcAppName");
        Intrinsics.checkNotNullParameter(srcAppId, (String)"srcAppId");
        Intrinsics.checkNotNullParameter((Object)targetNamespace, (String)"targetNamespace");
        Intrinsics.checkNotNullParameter((Object)targetAppName, (String)"targetAppName");
        Intrinsics.checkNotNullParameter((Object)userLogin, (String)"userLogin");
        Map<BotApplicationConfiguration, BotApplicationConfiguration> configMap = this.prepareTempApplication(targetNamespace, targetAppName, userLogin, withInboxMessages);
        ImportReport report = this.migrateData(srcNamespace, srcAppName, srcAppId, targetNamespace, targetAppName, withInboxMessages);
        this.cleanTempNamespaceAndApplication(targetNamespace + tempPostfix, targetAppName + tempPostfix, userLogin, configMap);
        return report;
    }

    /*
     * WARNING - void declaration
     */
    private final ImportReport migrateData(String srcNamespace, String srcAppName, Id<ApplicationDefinition> srcAppId, String targetNamespace, String targetAppName, boolean withInboxMessages) {
        void $this$forEach$iv;
        Iterator $this$groupByTo$iv$iv;
        List<StoryDefinitionConfigurationDump> sourceStories = BotAdminService.INSTANCE.exportStories(srcNamespace, srcAppName);
        this.deleteStories(targetNamespace, targetAppName);
        Object $this$groupBy$iv = sourceStories;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            StoryDefinitionConfigurationDump it = (StoryDefinitionConfigurationDump)element$iv$iv;
            boolean bl = false;
            Locale key$iv$iv = it.getUserSentenceLocale();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry group = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            Locale locale = (Locale)group.getKey();
            if (locale == null) {
                locale = Locale.ENGLISH;
            }
            Locale locale2 = locale;
            Intrinsics.checkNotNull((Object)locale2);
            BotAdminService.INSTANCE.importStories(targetNamespace, targetAppName, locale2, new StoryDefinitionConfigurationDumpImport((List)group.getValue(), null, 2, null), "botUser");
        }
        ApplicationDump originalAppDump = front.export(srcAppId, DumpType.full);
        ApplicationDump appDumpToImport = withInboxMessages ? originalAppDump : ApplicationDump.copy$default((ApplicationDump)originalAppDump, null, null, null, (List)CollectionsKt.emptyList(), null, null, null, (int)119, null);
        ApplicationDump updatedAppDump = ApplicationDump.copy$default((ApplicationDump)appDumpToImport, (ApplicationDefinition)ApplicationDefinition.copy$default((ApplicationDefinition)appDumpToImport.getApplication(), (String)targetAppName, null, (String)targetNamespace, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, null, (int)8186, null), null, null, null, null, null, null, (int)126, null);
        ImportReport importReport = front.import(targetNamespace, updatedAppDump, new ApplicationImportConfiguration(targetAppName, false, 2, null));
        List sourceLabels = I18nDAO.DefaultImpls.getLabels$default((I18nDAO)this.getI18n(), (String)srcNamespace, null, (int)2, null);
        BotAdminService.INSTANCE.importLabels(sourceLabels, targetNamespace);
        return importReport;
    }

    private final Map<BotApplicationConfiguration, BotApplicationConfiguration> prepareTempApplication(String targetNamespace, String targetAppName, String userLogin, boolean withInboxMessages) {
        Object v0;
        Object it;
        Map botApplicationConfigurationFitMap;
        String tempAppName;
        String tempNamespaceName;
        block8: {
            tempNamespaceName = targetNamespace + tempPostfix;
            tempAppName = targetAppName + tempPostfix;
            botApplicationConfigurationFitMap = new LinkedHashMap();
            Iterable $this$firstOrNull$iv = front.getNamespaces(userLogin);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (UserNamespace)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNamespace(), (Object)tempNamespaceName)) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        UserNamespace tempNamespace = v0;
        if (tempNamespace == null) {
            front.saveNamespace(new UserNamespace(userLogin, tempNamespaceName, false, false, 12, null));
        }
        List<BotConfiguration> targetBotConfigurationsList = BotAdminService.INSTANCE.getBots(targetNamespace, targetAppName);
        for (BotConfiguration botConfiguration : targetBotConfigurationsList) {
            BotAdminService.INSTANCE.save(BotConfiguration.copy$default((BotConfiguration)botConfiguration, (String)tempAppName, (String)tempAppName, (String)tempNamespaceName, null, null, null, null, (int)120, null));
        }
        ApplicationDefinition targetNlpAppDef = front.getApplicationByNamespaceAndName(targetNamespace, targetAppName);
        if (targetNlpAppDef != null) {
            Object element$iv;
            element$iv = IdsKt.newId();
            it = targetNlpAppDef.getLabel() + tempPostfix;
            Set bl = SetsKt.emptySet();
            ApplicationDefinition tempNlpAppDef = ApplicationDefinition.copy$default((ApplicationDefinition)targetNlpAppDef, (String)tempAppName, (String)it, (String)tempNamespaceName, (Set)bl, null, null, null, (boolean)false, (boolean)false, (boolean)false, (double)0.0, (boolean)false, (Id)element$iv, (int)4080, null);
            ApplicationDefinition applicationDefinition = front.getApplicationByNamespaceAndName(tempNamespaceName, tempAppName);
            if (applicationDefinition != null) {
                ApplicationDefinition it2 = applicationDefinition;
                boolean bl2 = false;
                front.deleteApplicationById(it2.get_id());
            }
            front.save(tempNlpAppDef);
        }
        List<BotApplicationConfiguration> targetBotApplicationConfigurationList = BotAdminService.INSTANCE.getBotConfigurationsByNamespaceAndBotId(targetNamespace, targetAppName);
        for (BotApplicationConfiguration targetBotAppConfig : targetBotApplicationConfigurationList) {
            String tempApplicationId = targetBotAppConfig.getApplicationId() + tempPostfix;
            String string = targetBotAppConfig.getPath();
            Intrinsics.checkNotNull((Object)string);
            String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"/") + "-temp/";
            Id id = IdsKt.newId();
            BotApplicationConfiguration tempBotAppConfig = BotApplicationConfiguration.copy$default((BotApplicationConfiguration)targetBotAppConfig, (String)tempApplicationId, (String)tempAppName, (String)tempNamespaceName, (String)tempAppName, null, null, null, null, null, (String)string2, (Id)id, null, (int)2544, null);
            string2 = BotAdminService.INSTANCE.getBotConfigurationByApplicationIdAndBotId(tempNamespaceName, tempApplicationId, tempAppName);
            if (string2 != null) {
                String it3 = string2;
                boolean bl = false;
                BotAdminService.INSTANCE.deleteApplicationConfiguration((BotApplicationConfiguration)it3);
            }
            BotAdminService.INSTANCE.saveApplicationConfiguration(tempBotAppConfig);
            botApplicationConfigurationFitMap.put(targetBotAppConfig, tempBotAppConfig);
        }
        ApplicationDefinition applicationDefinition = targetNlpAppDef;
        Intrinsics.checkNotNull((Object)applicationDefinition);
        this.migrateData(targetNamespace, targetAppName, (Id<ApplicationDefinition>)applicationDefinition.get_id(), tempNamespaceName, tempAppName, withInboxMessages);
        Map updatedBotConfigsMap = new LinkedHashMap();
        Iterable $this$forEach$iv = botApplicationConfigurationFitMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BotApplicationConfiguration it4 = (BotApplicationConfiguration)element$iv;
            boolean bl = false;
            Object v = botApplicationConfigurationFitMap.get(it4);
            Intrinsics.checkNotNull(v);
            Pair<BotApplicationConfiguration, BotApplicationConfiguration> result = INSTANCE.exchangePaths(it4, (BotApplicationConfiguration)v);
            updatedBotConfigsMap.put(result.getFirst(), result.getSecond());
        }
        return updatedBotConfigsMap;
    }

    private final void cleanTempNamespaceAndApplication(String tempNamespace, String tempAppName, String userLogin, Map<BotApplicationConfiguration, BotApplicationConfiguration> botAppConfMap) {
        Iterable $this$forEach$iv = botAppConfMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BotApplicationConfiguration it = (BotApplicationConfiguration)element$iv;
            boolean bl = false;
            BotApplicationConfiguration botApplicationConfiguration = botAppConfMap.get(it);
            Intrinsics.checkNotNull((Object)botApplicationConfiguration);
            INSTANCE.exchangePaths(botApplicationConfiguration, it);
        }
        ApplicationDefinition tempAppDef = front.getApplicationByNamespaceAndName(tempNamespace, tempAppName);
        if (tempAppDef != null) {
            front.deleteApplicationById(tempAppDef.get_id());
            BotAdminService.INSTANCE.deleteApplication(tempAppDef);
        }
        front.deleteNamespace(userLogin, tempNamespace);
    }

    private final Pair<BotApplicationConfiguration, BotApplicationConfiguration> exchangePaths(BotApplicationConfiguration first, BotApplicationConfiguration second) {
        String string = first.getPath();
        Intrinsics.checkNotNull((Object)string);
        String firstPath = string;
        String string2 = first.getPath();
        Intrinsics.checkNotNull((Object)string2);
        String nonConflictingFirstPath = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string2, (CharSequence)tempPostfix), (CharSequence)"/") + "_";
        String string3 = second.getPath();
        Intrinsics.checkNotNull((Object)string3);
        String secondPath = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string3, (CharSequence)"/"), (CharSequence)"_");
        CommonExtensionsKt.ifNull((Object)this.getBotConfigurationDAO().getConfigurationByPath(nonConflictingFirstPath), () -> SynchronizationService.exchangePaths$lambda$7(first, nonConflictingFirstPath));
        CommonExtensionsKt.ifNull((Object)this.getBotConfigurationDAO().getConfigurationByPath(firstPath), () -> SynchronizationService.exchangePaths$lambda$8(second, firstPath));
        CommonExtensionsKt.ifNull((Object)this.getBotConfigurationDAO().getConfigurationByPath(secondPath), () -> SynchronizationService.exchangePaths$lambda$9(first, secondPath));
        BotApplicationConfiguration firstUpdated = BotAdminService.INSTANCE.getBotConfigurationById((Id<BotApplicationConfiguration>)first.get_id());
        BotApplicationConfiguration secondUpdated = BotAdminService.INSTANCE.getBotConfigurationById((Id<BotApplicationConfiguration>)second.get_id());
        BotApplicationConfiguration botApplicationConfiguration = firstUpdated;
        Intrinsics.checkNotNull((Object)botApplicationConfiguration);
        BotApplicationConfiguration botApplicationConfiguration2 = secondUpdated;
        Intrinsics.checkNotNull((Object)botApplicationConfiguration2);
        return TuplesKt.to((Object)botApplicationConfiguration, (Object)botApplicationConfiguration2);
    }

    private final void deleteStories(String namespace, String applicationName) {
        this.getStoryDefinitionDAO().deleteByNamespaceAndBotId(namespace, applicationName);
    }

    private static final Unit exchangePaths$lambda$7(BotApplicationConfiguration $first, String $nonConflictingFirstPath) {
        BotAdminService.INSTANCE.saveApplicationConfiguration(BotApplicationConfiguration.copy$default((BotApplicationConfiguration)$first, null, null, null, null, null, null, null, null, null, (String)$nonConflictingFirstPath, null, null, (int)3583, null));
        return Unit.INSTANCE;
    }

    private static final Unit exchangePaths$lambda$8(BotApplicationConfiguration $second, String $firstPath) {
        BotAdminService.INSTANCE.saveApplicationConfiguration(BotApplicationConfiguration.copy$default((BotApplicationConfiguration)$second, null, null, null, null, null, null, null, null, null, (String)$firstPath, null, null, (int)3583, null));
        return Unit.INSTANCE;
    }

    private static final Unit exchangePaths$lambda$9(BotApplicationConfiguration $first, String $secondPath) {
        BotAdminService.INSTANCE.saveApplicationConfiguration(BotApplicationConfiguration.copy$default((BotApplicationConfiguration)$first, null, null, null, null, null, null, null, null, null, (String)$secondPath, null, null, (int)3583, null));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SynchronizationService.class, "i18n", "getI18n()Lai/tock/translator/I18nDAO;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SynchronizationService();
        front = FrontClient.INSTANCE;
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        i18n$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<I18nDAO>(){}, tag$iv);
    }
}

