/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.service;

import ai.tock.bot.admin.BotAdminService;
import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.admin.bot.vectorstore.BotVectorStoreConfiguration;
import ai.tock.bot.admin.bot.vectorstore.BotVectorStoreConfigurationDAO;
import ai.tock.bot.admin.model.BotVectorStoreConfigurationDTO;
import ai.tock.bot.admin.service.VectorStoreValidationService;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.exception.error.ErrorMessage;
import ai.tock.shared.exception.rest.BadRequestException;
import ai.tock.shared.vertx.WebVerticle;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.mongodb.MongoWriteException;
import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lai/tock/bot/admin/service/VectorStoreService;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "vectorStoreConfigurationDAO", "Lai/tock/bot/admin/bot/vectorstore/BotVectorStoreConfigurationDAO;", "getVectorStoreConfigurationDAO", "()Lai/tock/bot/admin/bot/vectorstore/BotVectorStoreConfigurationDAO;", "getVectorStoreConfiguration", "Lai/tock/bot/admin/bot/vectorstore/BotVectorStoreConfiguration;", "namespace", "", "botId", "deleteConfig", "", "saveVectorStore", "vectorStoreConfig", "Lai/tock/bot/admin/model/BotVectorStoreConfigurationDTO;", "saveVectorStoreConfiguration", "vectorStoreConfiguration", "tock-bot-admin-server"})
@SourceDebugExtension(value={"SMAP\nVectorStoreService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorStoreService.kt\nai/tock/bot/admin/service/VectorStoreService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,99:1\n48#2,2:100\n51#3:102\n277#4:103\n*S KotlinDebug\n*F\n+ 1 VectorStoreService.kt\nai/tock/bot/admin/service/VectorStoreService\n*L\n37#1:100,2\n37#1:102\n37#1:103\n*E\n"})
public final class VectorStoreService {
    @NotNull
    public static final VectorStoreService INSTANCE = new VectorStoreService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(VectorStoreService::logger$lambda$0);

    private VectorStoreService() {
    }

    private final BotVectorStoreConfigurationDAO getVectorStoreConfigurationDAO() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (BotVectorStoreConfigurationDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<BotVectorStoreConfigurationDAO>(){}, tag$iv).getValue()).invoke();
    }

    @Nullable
    public final BotVectorStoreConfiguration getVectorStoreConfiguration(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        return this.getVectorStoreConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
    }

    public final void deleteConfig(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        BotVectorStoreConfiguration botVectorStoreConfiguration = this.getVectorStoreConfigurationDAO().findByNamespaceAndBotId(namespace, botId);
        if (botVectorStoreConfiguration == null) {
            WebVerticle.Companion.badRequest("No Vector Store configuration is defined yet [namespace: " + namespace + ", botId: " + botId + "]");
            throw new KotlinNothingValueException();
        }
        BotVectorStoreConfiguration vectorStoreConfig = botVectorStoreConfiguration;
        logger.info(() -> VectorStoreService.deleteConfig$lambda$1(namespace, botId));
        this.getVectorStoreConfigurationDAO().delete(vectorStoreConfig.get_id());
    }

    @NotNull
    public final BotVectorStoreConfiguration saveVectorStore(@NotNull BotVectorStoreConfigurationDTO vectorStoreConfig) {
        Intrinsics.checkNotNullParameter((Object)vectorStoreConfig, (String)"vectorStoreConfig");
        if ((BotApplicationConfiguration)CollectionsKt.firstOrNull(BotAdminService.INSTANCE.getBotConfigurationsByNamespaceAndBotId(vectorStoreConfig.getNamespace(), vectorStoreConfig.getBotId())) == null) {
            WebVerticle.Companion.badRequest("No Vector Store configuration is defined yet [namespace: " + vectorStoreConfig.getNamespace() + ", botId = " + vectorStoreConfig.getBotId() + "]");
            throw new KotlinNothingValueException();
        }
        return this.saveVectorStoreConfiguration(vectorStoreConfig);
    }

    private final BotVectorStoreConfiguration saveVectorStoreConfiguration(BotVectorStoreConfigurationDTO vectorStoreConfiguration) {
        BotVectorStoreConfiguration botVectorStoreConfiguration;
        BotVectorStoreConfiguration vectorStoreConfig = vectorStoreConfiguration.toBotVectorStoreConfiguration();
        if (vectorStoreConfig.getEnabled()) {
            Set<ErrorMessage> errors = VectorStoreValidationService.INSTANCE.validate(vectorStoreConfig);
            boolean bl = false;
            if (!((Collection)errors).isEmpty()) {
                throw new BadRequestException(errors);
            }
        }
        try {
            botVectorStoreConfiguration = this.getVectorStoreConfigurationDAO().save(vectorStoreConfig);
        }
        catch (MongoWriteException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Vector Store Configuration: registration failed on mongo ";
            }
            throw new BadRequestException(string);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Vector Store Configuration: registration failed ";
            }
            throw new BadRequestException(string);
        }
        return botVectorStoreConfiguration;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object deleteConfig$lambda$1(String $namespace, String $botId) {
        return "Deleting the Vector Store Configuration [namespace: " + $namespace + ", botId: " + $botId + "]";
    }
}

