/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.service;

import ai.tock.bot.admin.bot.BotConfiguration;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.configuration.ClientConfiguration;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.service.BotApiClient;
import ai.tock.bot.api.service.BotApiClientControllerKt;
import ai.tock.bot.api.service.BotApiDefinitionProvider;
import ai.tock.bot.api.service.WSHolder;
import ai.tock.bot.engine.WebSocketController;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0004\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/tock/bot/api/service/BotApiClientController;", "", "provider", "Lai/tock/bot/api/service/BotApiDefinitionProvider;", "configuration", "Lai/tock/bot/admin/bot/BotConfiguration;", "<init>", "(Lai/tock/bot/api/service/BotApiDefinitionProvider;Lai/tock/bot/admin/bot/BotConfiguration;)V", "logger", "Lmu/KLogger;", "apiKey", "", "webhookUrl", "client", "Lai/tock/bot/api/service/BotApiClient;", "Lai/tock/bot/api/model/configuration/ClientConfiguration;", "send", "Lai/tock/bot/api/model/websocket/ResponseData;", "userRequest", "Lai/tock/bot/api/model/UserRequest;", "sendWithWebSocket", "request", "Lai/tock/bot/api/model/websocket/RequestData;", "tock-bot-api-service"})
@SourceDebugExtension(value={"SMAP\nBotApiClientController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiClientController.kt\nai/tock/bot/api/service/BotApiClientController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,130:1\n1#2:131\n56#3:132\n49#3:133\n*S KotlinDebug\n*F\n+ 1 BotApiClientController.kt\nai/tock/bot/api/service/BotApiClientController\n*L\n82#1:132\n82#1:133\n*E\n"})
public final class BotApiClientController {
    @NotNull
    private final BotApiDefinitionProvider provider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String apiKey;
    @Nullable
    private final String webhookUrl;
    @Nullable
    private final BotApiClient client;

    /*
     * Unable to fully structure code
     */
    public BotApiClientController(@NotNull BotApiDefinitionProvider provider, @NotNull BotConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super();
        this.provider = provider;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, logger$lambda$0(), ()Lkotlin/Unit;)());
        this.apiKey = configuration.getApiKey();
        this.webhookUrl = configuration.getWebhookUrl();
        v0 = this;
        v1 = this.webhookUrl;
        if (v1 == null) ** GOTO lbl-1000
        var4_4 = var3_3 = v1;
        var8_5 = v0;
        $i$a$-takeUnless-BotApiClientController$client$1 = false;
        var9_7 = StringsKt.isBlank((CharSequence)it);
        v0 = var8_5;
        v1 = var9_7 == false ? var3_3 : null;
        if (v1 != null) {
            it = v1;
            var8_5 = v0;
            $i$a$-let-BotApiClientController$client$2 = false;
            try {
                var6_8 = new BotApiClient(it);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
                var6_8 = null;
            }
            v2 = var6_8;
            v0 = var8_5;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v0.client = v2;
        if (WebSocketController.INSTANCE.getWebsocketEnabled()) {
            this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, _init_$lambda$3(ai.tock.bot.api.service.BotApiClientController ), ()Ljava/lang/Object;)((BotApiClientController)this));
            WebSocketController.INSTANCE.registerAuthorizedKey(this.apiKey);
            WebSocketController.INSTANCE.setReceiveHandler(this.apiKey, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, _init_$lambda$6(ai.tock.bot.api.service.BotApiClientController java.lang.String ), (Ljava/lang/String;)Lkotlin/Unit;)((BotApiClientController)this));
        }
    }

    @Nullable
    public final ClientConfiguration configuration() {
        BotApiClient botApiClient = this.client;
        if (botApiClient == null || (botApiClient = botApiClient.send(new RequestData(null, Boolean.valueOf(true), null, 5, null))) == null || (botApiClient = botApiClient.getBotConfiguration()) == null) {
            ResponseData responseData = this.sendWithWebSocket(new RequestData(null, Boolean.valueOf(true), null, 5, null));
            botApiClient = responseData != null ? responseData.getBotConfiguration() : null;
        }
        return botApiClient;
    }

    @Nullable
    public final ResponseData send(@NotNull UserRequest userRequest) {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)userRequest, (String)"userRequest");
        RequestData request = new RequestData(userRequest, null, null, 6, null);
        if (this.client != null) {
            responseData = this.client.send(request);
        } else {
            responseData = this.sendWithWebSocket(request);
            if (responseData == null) {
                throw new IllegalStateException("no webhook set and no response from websocket".toString());
            }
        }
        return responseData;
    }

    private final ResponseData sendWithWebSocket(RequestData request) {
        ResponseData responseData;
        Function1 pushHandler = WebSocketController.INSTANCE.getPushHandler(this.apiKey);
        if (pushHandler != null) {
            WSHolder holder = new WSHolder(null, null, 3, null);
            BotApiClientControllerKt.access$getWsRepository$p().put((Object)request.getRequestId(), (Object)holder);
            this.logger.debug(() -> BotApiClientController.sendWithWebSocket$lambda$7(request));
            String string = JacksonKt.getMapper().writeValueAsString((Object)request);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            pushHandler.invoke((Object)string);
            responseData = holder.wait();
        } else {
            responseData = null;
        }
        return responseData;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object _init_$lambda$3(BotApiClientController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "register " + this$0.apiKey;
    }

    private static final Object lambda$6$lambda$4(ResponseData $response) {
        return "unknown request " + $response.getRequestId();
    }

    private static final Object lambda$6$lambda$5(String $content) {
        Intrinsics.checkNotNullParameter((Object)$content, (String)"$content");
        return "null response: " + $content;
    }

    private static final Unit _init_$lambda$6(BotApiClientController this$0, String content) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            ResponseData response = (ResponseData)$this$readValue$iv.readValue(content, (TypeReference)new TypeReference<ResponseData>(){});
            if (response != null) {
                ClientConfiguration conf = response.getBotConfiguration();
                if (conf == null) {
                    WSHolder holder = (WSHolder)BotApiClientControllerKt.access$getWsRepository$p().getIfPresent((Object)response.getRequestId());
                    if (holder == null) {
                        this$0.logger.warn(() -> BotApiClientController.lambda$6$lambda$4(response));
                    }
                    WSHolder wSHolder = holder;
                    if (wSHolder != null) {
                        wSHolder.receive(response);
                    }
                } else {
                    this$0.provider.updateIfConfigurationChange(conf);
                }
            } else {
                this$0.logger.warn(() -> BotApiClientController.lambda$6$lambda$5(content));
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this$0.logger, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Object sendWithWebSocket$lambda$7(RequestData $request) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return "send request " + $request.getRequestId();
    }
}

