/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.service;

import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.service.BotApiService;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/tock/bot/api/service/BotApiClient;", "", "baseUrl", "", "<init>", "(Ljava/lang/String;)V", "timeoutInSeconds", "", "logger", "Lmu/KLogger;", "service", "Lai/tock/bot/api/service/BotApiService;", "send", "Lai/tock/bot/api/model/websocket/ResponseData;", "request", "Lai/tock/bot/api/model/websocket/RequestData;", "tock-bot-api-service"})
@SourceDebugExtension(value={"SMAP\nBotApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiClient.kt\nai/tock/bot/api/service/BotApiClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,51:1\n71#2:52\n*S KotlinDebug\n*F\n+ 1 BotApiClient.kt\nai/tock/bot/api/service/BotApiClient\n*L\n40#1:52\n*E\n"})
public final class BotApiClient {
    private final long timeoutInSeconds;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final BotApiService service;

    public BotApiClient(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.timeoutInSeconds = PropertiesKt.longProperty((String)"tock_bot_api_timeout_in_ms", (long)5000L);
        this.logger = KotlinLogging.INSTANCE.logger(BotApiClient::logger$lambda$0);
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)this.timeoutInSeconds, (KLogger)this.logger, null, null, (boolean)false, (boolean)false, null, (int)124, null), null, (int)1, null).baseUrl((String)(StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null) ? baseUrl : baseUrl + "/")).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(BotApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.service = (BotApiService)object;
    }

    @Nullable
    public final ResponseData send(@NotNull RequestData request) {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            responseData = (ResponseData)this.service.send(request).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            responseData = null;
        }
        return responseData;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }
}

