/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.service;

import ai.tock.bot.api.model.BotResponse;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.service.BotApiClient;
import ai.tock.bot.api.service.BotApiService;
import ai.tock.bot.api.service.CloseListener;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.background.BackgroundEventHandler;
import com.launchdarkly.eventsource.background.BackgroundEventSource;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00120\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/tock/bot/api/service/BotApiClient;", "", "baseUrl", "", "(Ljava/lang/String;)V", "connectionTimeoutInMs", "", "formattedBaseUrl", "logger", "Lmu/KLogger;", "service", "Lai/tock/bot/api/service/BotApiService;", "timeoutInMs", "send", "Lai/tock/bot/api/model/websocket/ResponseData;", "request", "Lai/tock/bot/api/model/websocket/RequestData;", "sendWithSse", "", "sendResponse", "Lkotlin/Function1;", "tock-bot-api-service"})
@SourceDebugExtension(value={"SMAP\nBotApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiClient.kt\nai/tock/bot/api/service/BotApiClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,129:1\n71#2:130\n*S KotlinDebug\n*F\n+ 1 BotApiClient.kt\nai/tock/bot/api/service/BotApiClient\n*L\n53#1:130\n*E\n"})
public final class BotApiClient {
    private final long connectionTimeoutInMs;
    private final long timeoutInMs;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String formattedBaseUrl;
    @NotNull
    private final BotApiService service;

    public BotApiClient(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.connectionTimeoutInMs = PropertiesKt.longProperty((String)"tock_bot_api_connection_timeout_in_ms", (long)3000L);
        this.timeoutInMs = PropertiesKt.longProperty((String)"tock_bot_api_timeout_in_ms", (long)60000L);
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.formattedBaseUrl = StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null) ? baseUrl : baseUrl + "/";
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)this.timeoutInMs, (KLogger)this.logger, null, null, (boolean)false, (boolean)false, null, (int)124, null), null, (int)1, null).baseUrl(this.formattedBaseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(BotApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.service = (BotApiService)object;
    }

    @Nullable
    public final ResponseData send(@NotNull RequestData request) {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            responseData = (ResponseData)this.service.send(request).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            responseData = null;
        }
        return responseData;
    }

    public final void sendWithSse(@NotNull RequestData request, @NotNull Function1<? super ResponseData, Unit> sendResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(sendResponse, (String)"sendResponse");
        try {
            BackgroundEventSource backgroundEventSource;
            CloseListener closeListener = new CloseListener(null, 1, null);
            BackgroundEventSource $this$sendWithSse_u24lambda_u240 = backgroundEventSource = new BackgroundEventSource.Builder(new BackgroundEventHandler(this, sendResponse, closeListener){
                final /* synthetic */ BotApiClient this$0;
                final /* synthetic */ Function1<ResponseData, Unit> $sendResponse;
                final /* synthetic */ CloseListener $closeListener;
                {
                    this.this$0 = $receiver;
                    this.$sendResponse = $sendResponse;
                    this.$closeListener = $closeListener;
                }

                public void onOpen() {
                    BotApiClient.access$getLogger$p(this.this$0).debug("open sse connection");
                }

                public void onClosed() {
                    BotApiClient.access$getLogger$p(this.this$0).debug("close sse connection");
                }

                /*
                 * WARNING - void declaration
                 */
                public void onMessage(String event, MessageEvent messageEvent) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)messageEvent, (String)"messageEvent");
                    BotApiClient.access$getLogger$p(this.this$0).debug((Function0)new Function0<Object>(event){
                        final /* synthetic */ String $event;
                        {
                            this.$event = $event;
                            super(0);
                        }

                        public final Object invoke() {
                            return "Event: " + this.$event;
                        }
                    });
                    BotApiClient.access$getLogger$p(this.this$0).debug((Function0)new Function0<Object>(messageEvent){
                        final /* synthetic */ MessageEvent $messageEvent;
                        {
                            this.$messageEvent = $messageEvent;
                            super(0);
                        }

                        public final Object invoke() {
                            return "Message: " + this.$messageEvent.getData();
                        }
                    });
                    if (Intrinsics.areEqual((Object)event, (Object)"message")) {
                        void $this$readValue$iv;
                        ObjectMapper objectMapper = JacksonKt.getMapper();
                        String string = messageEvent.getData();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getData(...)");
                        String content$iv = string;
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        ResponseData message = (ResponseData)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<ResponseData>(){});
                        this.$sendResponse.invoke((Object)message);
                        BotResponse botResponse = message.getBotResponse();
                        boolean bl = botResponse != null && (botResponse = botResponse.getContext()) != null ? botResponse.getLastResponse() : false;
                        if (bl) {
                            BotApiClient.access$getLogger$p(this.this$0).debug((Function0)sendWithSse.eventSource.onMessage.3.INSTANCE);
                            this.$closeListener.close();
                        }
                    }
                }

                public void onComment(String comment) {
                    Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                    BotApiClient.access$getLogger$p(this.this$0).debug((Function0)new Function0<Object>(comment){
                        final /* synthetic */ String $comment;
                        {
                            this.$comment = $comment;
                            super(0);
                        }

                        public final Object invoke() {
                            return "sse comment: " + this.$comment;
                        }
                    });
                }

                public void onError(Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    LoggersKt.error((KLogger)BotApiClient.access$getLogger$p(this.this$0), (Throwable)t);
                }
            }, new EventSource.Builder((ConnectStrategy)ConnectStrategy.http((URL)URI.create(this.formattedBaseUrl + "webhook/sse").toURL()).header("message", JacksonKt.getMapper().writeValueAsString((Object)request)).connectTimeout(this.connectionTimeoutInMs, TimeUnit.MILLISECONDS).readTimeout(this.timeoutInMs, TimeUnit.MILLISECONDS))).threadPriority(Integer.valueOf(10)).build();
            boolean bl = false;
            closeListener.setSource($this$sendWithSse_u24lambda_u240);
            $this$sendWithSse_u24lambda_u240.start();
            BackgroundEventSource backgroundEventSource2 = backgroundEventSource;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
        }
    }

    public static final /* synthetic */ KLogger access$getLogger$p(BotApiClient $this) {
        return $this.logger;
    }
}

