/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.service;

import ai.tock.bot.admin.bot.BotConfiguration;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.configuration.ClientConfiguration;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.service.BotApiClient;
import ai.tock.bot.api.service.BotApiClientController;
import ai.tock.bot.api.service.BotApiClientControllerKt;
import ai.tock.bot.api.service.BotApiDefinitionProvider;
import ai.tock.bot.api.service.WSHolder;
import ai.tock.bot.engine.WebSocketController;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0004\u001a\u0004\u0018\u00010\u000eJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00100\u0014J*\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/bot/api/service/BotApiClientController;", "", "provider", "Lai/tock/bot/api/service/BotApiDefinitionProvider;", "configuration", "Lai/tock/bot/admin/bot/BotConfiguration;", "(Lai/tock/bot/api/service/BotApiDefinitionProvider;Lai/tock/bot/admin/bot/BotConfiguration;)V", "apiKey", "", "client", "Lai/tock/bot/api/service/BotApiClient;", "logger", "Lmu/KLogger;", "webhookUrl", "Lai/tock/bot/api/model/configuration/ClientConfiguration;", "send", "", "userRequest", "Lai/tock/bot/api/model/UserRequest;", "sendResponse", "Lkotlin/Function1;", "Lai/tock/bot/api/model/websocket/ResponseData;", "sendWithWebSocket", "request", "Lai/tock/bot/api/model/websocket/RequestData;", "sendWithWebhook", "tock-bot-api-service"})
@SourceDebugExtension(value={"SMAP\nBotApiClientController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiClientController.kt\nai/tock/bot/api/service/BotApiClientController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1#2:179\n1863#3,2:180\n*S KotlinDebug\n*F\n+ 1 BotApiClientController.kt\nai/tock/bot/api/service/BotApiClientController\n*L\n167#1:180,2\n*E\n"})
public final class BotApiClientController {
    @NotNull
    private final BotApiDefinitionProvider provider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String apiKey;
    @Nullable
    private final String webhookUrl;
    @Nullable
    private final BotApiClient client;

    /*
     * Unable to fully structure code
     */
    public BotApiClientController(@NotNull BotApiDefinitionProvider provider, @NotNull BotConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super();
        this.provider = provider;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.apiKey = configuration.getApiKey();
        this.webhookUrl = configuration.getWebhookUrl();
        v0 = this;
        v1 = this.webhookUrl;
        if (v1 == null) ** GOTO lbl-1000
        var4_4 = var3_3 = v1;
        var8_5 = v0;
        $i$a$-takeUnless-BotApiClientController$client$1 = false;
        var9_7 = StringsKt.isBlank((CharSequence)it);
        v0 = var8_5;
        v1 = var9_7 == false ? var3_3 : null;
        if (v1 != null) {
            it = v1;
            var8_5 = v0;
            $i$a$-let-BotApiClientController$client$2 = false;
            try {
                var6_8 = new BotApiClient(it);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
                var6_8 = null;
            }
            v2 = var6_8;
            v0 = var8_5;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v0.client = v2;
        if (WebSocketController.INSTANCE.getWebsocketEnabled()) {
            this.logger.debug((Function0)new Function0<Object>(){

                public final Object invoke() {
                    return "register " + apiKey;
                }
            });
            WebSocketController.INSTANCE.registerAuthorizedKey(this.apiKey);
            WebSocketController.INSTANCE.setReceiveHandler(this.apiKey, (Function1)new Function1<String, Unit>(){

                public final void invoke(final String content) {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    try {
                        ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        final ResponseData response = (ResponseData)$this$readValue$iv.readValue(content, (TypeReference)new TypeReference<ResponseData>(){});
                        if (response != null) {
                            ClientConfiguration conf = response.getBotConfiguration();
                            if (conf == null) {
                                WSHolder holder = (WSHolder)BotApiClientControllerKt.access$getWsRepository$p().getIfPresent((Object)response.getRequestId());
                                if (holder == null) {
                                    logger.warn((Function0)new Function0<Object>(){

                                        public final Object invoke() {
                                            return "unknown request " + response.getRequestId();
                                        }
                                    });
                                }
                                WSHolder wSHolder = holder;
                                if (wSHolder != null) {
                                    wSHolder.receive(response);
                                }
                            } else {
                                provider.updateIfConfigurationChange(conf);
                            }
                        } else {
                            logger.warn((Function0)new Function0<Object>(){

                                public final Object invoke() {
                                    return "null response: " + content;
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)logger, (Throwable)e);
                    }
                }
            });
        }
    }

    @Nullable
    public final ClientConfiguration configuration() {
        BotApiClient botApiClient = this.client;
        if (botApiClient == null || (botApiClient = botApiClient.send(new RequestData(null, Boolean.valueOf(true), null, 5, null))) == null || (botApiClient = botApiClient.getBotConfiguration()) == null) {
            ResponseData responseData = BotApiClientController.sendWithWebSocket$default(this, new RequestData(null, Boolean.valueOf(true), null, 5, null), null, 2, null);
            botApiClient = responseData != null ? responseData.getBotConfiguration() : null;
        }
        return botApiClient;
    }

    public final void send(@NotNull UserRequest userRequest, @NotNull Function1<? super ResponseData, Unit> sendResponse) {
        Intrinsics.checkNotNullParameter((Object)userRequest, (String)"userRequest");
        Intrinsics.checkNotNullParameter(sendResponse, (String)"sendResponse");
        RequestData request = new RequestData(userRequest, null, null, 6, null);
        if (this.client != null) {
            this.sendWithWebhook(request, sendResponse);
        } else if (this.sendWithWebSocket(request, sendResponse) == null) {
            throw new IllegalStateException("no webhook set and no response from websocket".toString());
        }
    }

    private final void sendWithWebhook(RequestData request, Function1<? super ResponseData, Unit> sendResponse) {
        block2: {
            BotApiClient botApiClient;
            BotApiClient botApiClient2 = this.client;
            if (botApiClient2 == null) break block2;
            BotApiClient $this$sendWithWebhook_u24lambda_u243 = botApiClient = botApiClient2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)request.getConfiguration(), (Object)true) || BotApiClientControllerKt.access$getOldWebhookBehaviour$p()) {
                ResponseData responseData;
                ResponseData $this$sendWithWebhook_u24lambda_u243_u24lambda_u242 = responseData = $this$sendWithWebhook_u24lambda_u243.send(request);
                boolean bl2 = false;
                sendResponse.invoke((Object)$this$sendWithWebhook_u24lambda_u243_u24lambda_u242);
            } else {
                $this$sendWithWebhook_u24lambda_u243.sendWithSse(request, sendResponse);
            }
        }
    }

    private final ResponseData sendWithWebSocket(RequestData request, Function1<? super ResponseData, Unit> sendResponse) {
        ResponseData responseData;
        Function1 pushHandler = WebSocketController.INSTANCE.getPushHandler(this.apiKey);
        if (pushHandler != null) {
            boolean bl;
            WSHolder holder = new WSHolder();
            BotApiClientControllerKt.access$getWsRepository$p().put((Object)request.getRequestId(), (Object)holder);
            this.logger.debug((Function0)new Function0<Object>(request){
                final /* synthetic */ RequestData $request;
                {
                    this.$request = $request;
                    super(0);
                }

                public final Object invoke() {
                    return "send request " + this.$request.getRequestId();
                }
            });
            String string = JacksonKt.getMapper().writeValueAsString((Object)request);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            pushHandler.invoke((Object)string);
            ResponseData response = null;
            do {
                List<ResponseData> responses = holder.wait();
                response = (ResponseData)CollectionsKt.lastOrNull(responses);
                Iterable $this$forEach$iv = responses;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResponseData it = (ResponseData)element$iv;
                    boolean bl2 = false;
                    sendResponse.invoke((Object)it);
                }
                ResponseData responseData2 = response;
                if (responseData2 != null && (responseData2 = responseData2.getBotResponse()) != null && (responseData2 = responseData2.getContext()) != null) {
                    if (!responseData2.getLastResponse()) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (bl);
            responseData = response;
        } else {
            responseData = null;
        }
        return responseData;
    }

    static /* synthetic */ ResponseData sendWithWebSocket$default(BotApiClientController botApiClientController, RequestData requestData, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = sendWithWebSocket.1.INSTANCE;
        }
        return botApiClientController.sendWithWebSocket(requestData, (Function1<? super ResponseData, Unit>)function1);
    }
}

