/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.websocket;

import ai.tock.bot.api.client.ClientBotDefinition;
import ai.tock.bot.api.client.ConfigurationsKt;
import ai.tock.bot.api.client.TockClientBus;
import ai.tock.bot.api.model.BotResponse;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.websocket.BotApiWebSocketClientKt;
import ai.tock.shared.Dice;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\t\u001a\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lmu/KLogger;", "start", "", "botDefinition", "Lai/tock/bot/api/client/ClientBotDefinition;", "serverPort", "", "serverHost", "", "ssl", "", "url", "startWithDemo", "tock-bot-api-websocket-base"})
public final class BotApiWebSocketClientKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    public static final void startWithDemo(@NotNull ClientBotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        BotApiWebSocketClientKt.start(botDefinition, "https://demo-bot.tock.ai");
    }

    /*
     * WARNING - void declaration
     */
    public static final void start(@NotNull ClientBotDefinition botDefinition, @NotNull String url) {
        void it;
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL u = new URL(url);
        Integer n = u.getPort();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = ((Number)n).intValue();
        ClientBotDefinition clientBotDefinition = botDefinition;
        boolean bl3 = false;
        boolean bl4 = it == -1;
        Integer n3 = !bl4 ? n : null;
        int n4 = n3 != null ? n3.intValue() : u.getDefaultPort();
        String string = u.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"u.host");
        BotApiWebSocketClientKt.start(clientBotDefinition, n4, string, Intrinsics.areEqual((Object)u.getProtocol(), (Object)"https"));
    }

    public static final void start(@NotNull ClientBotDefinition botDefinition, int serverPort, @NotNull String serverHost, boolean ssl) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)serverHost, (String)"serverHost");
        Function2<HttpClient, Long, Unit> $fun$restart$2 = new Function2<HttpClient, Long, Unit>(botDefinition, serverPort, serverHost, ssl){
            final /* synthetic */ ClientBotDefinition $botDefinition;
            final /* synthetic */ int $serverPort;
            final /* synthetic */ String $serverHost;
            final /* synthetic */ boolean $ssl;

            public final void invoke(@NotNull HttpClient client, long delay) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                BotApiWebSocketClientKt.access$getLogger$p().info("restart...");
                try {
                    client.close();
                }
                catch (Exception e) {
                    LoggersKt.error((KLogger)BotApiWebSocketClientKt.access$getLogger$p(), (Throwable)e);
                }
                VertXsKt.getVertx().setTimer(TimeUnit.SECONDS.toMillis(delay), (Handler)new Handler<Long>(this, client, delay){
                    final /* synthetic */ start.2 this$0;
                    final /* synthetic */ HttpClient $client;
                    final /* synthetic */ long $delay;

                    public final void handle(Long it) {
                        try {
                            BotApiWebSocketClientKt.start(this.this$0.$botDefinition, this.this$0.$serverPort, this.this$0.$serverHost, this.this$0.$ssl);
                        }
                        catch (Exception e) {
                            LoggersKt.error((KLogger)BotApiWebSocketClientKt.access$getLogger$p(), (Throwable)e);
                            this.this$0.invoke(this.$client, this.$delay);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$client = httpClient;
                        this.$delay = l;
                    }
                });
            }
            {
                this.$botDefinition = clientBotDefinition;
                this.$serverPort = n;
                this.$serverHost = string;
                this.$ssl = bl;
                super(2);
            }
        };
        WebSocketConnectOptions options = new WebSocketConnectOptions().setSsl(Boolean.valueOf(ssl)).setHost(serverHost).setPort(serverPort).setURI('/' + botDefinition.getApiKey());
        logger.info((Function0)new Function0<Object>(options){
            final /* synthetic */ WebSocketConnectOptions $options;

            @Nullable
            public final Object invoke() {
                return "start web socket client: " + this.$options.toJson();
            }
            {
                this.$options = webSocketConnectOptions;
                super(0);
            }
        });
        HttpClient client = VertXsKt.getVertx().createHttpClient();
        client.webSocket(options, (Handler)new Handler<AsyncResult<WebSocket>>(botDefinition, $fun$restart$2, client){
            final /* synthetic */ ClientBotDefinition $botDefinition;
            final /* synthetic */ start.2 $restart$2;
            final /* synthetic */ HttpClient $client;

            public final void handle(AsyncResult<WebSocket> context) {
                try {
                    WebSocket webSocket;
                    WebSocket socket = (WebSocket)context.result();
                    String conf = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(Dice.INSTANCE.newId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)this.$botDefinition), 2, null));
                    BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)new Function0<Object>(conf){
                        final /* synthetic */ String $conf;

                        @Nullable
                        public final Object invoke() {
                            return "send bot conf: " + this.$conf;
                        }
                        {
                            this.$conf = string;
                            super(0);
                        }
                    });
                    WebSocket webSocket2 = socket;
                    if (webSocket2 != null) {
                        webSocket2.writeTextMessage(conf);
                    }
                    if ((webSocket = socket) == null || (webSocket = webSocket.textMessageHandler((Handler)new Handler<String>(this, socket){
                        final /* synthetic */ start.4 this$0;
                        final /* synthetic */ WebSocket $socket;

                        public final void handle(String json) {
                            VertXsKt.blocking((Vertx)VertXsKt.getVertx(), (Function1)((Function1)new Function1<Promise<String>, Unit>(this, json){
                                final /* synthetic */ start.2 this$0;
                                final /* synthetic */ String $json;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull Promise<String> it) {
                                    void $this$readValue$iv;
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)new Function0<Object>(this){
                                        final /* synthetic */ start.1 this$0;

                                        @Nullable
                                        public final Object invoke() {
                                            return "json: " + this.this$0.$json;
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    });
                                    ObjectMapper objectMapper = JacksonKt.getMapper();
                                    String string = this.$json;
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json");
                                    String content$iv = string;
                                    boolean $i$f$readValue = false;
                                    String string2 = content$iv;
                                    void var7_6 = $this$readValue$iv;
                                    boolean $i$f$jacksonTypeRef = false;
                                    TypeReference typeReference = (TypeReference)new TypeReference<RequestData>(){};
                                    RequestData data = (RequestData)var7_6.readValue(string2, typeReference);
                                    UserRequest request = data.getBotRequest();
                                    if (request != null) {
                                        BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)start.2.INSTANCE);
                                        TockClientBus bus2 = new TockClientBus(this.this$0.this$0.$botDefinition, data, (Function1)new Function1<BotResponse, Unit>(data, it){
                                            final /* synthetic */ RequestData $data;
                                            final /* synthetic */ Promise $it;

                                            public final void invoke(@NotNull BotResponse r) {
                                                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                                                BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)start.bus.1.INSTANCE);
                                                String response = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(this.$data.getRequestId(), r, null, 4, null));
                                                BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)new Function0<Object>(response){
                                                    final /* synthetic */ String $response;

                                                    @Nullable
                                                    public final Object invoke() {
                                                        return this.$response;
                                                    }
                                                    {
                                                        this.$response = string;
                                                        super(0);
                                                    }
                                                });
                                                this.$it.complete((Object)response);
                                            }
                                            {
                                                this.$data = requestData;
                                                this.$it = promise;
                                                super(1);
                                            }
                                        });
                                        bus2.handle();
                                    } else if (Intrinsics.areEqual((Object)data.getConfiguration(), (Object)true)) {
                                        BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)start.3.INSTANCE);
                                        it.complete((Object)JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(data.getRequestId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)this.this$0.this$0.$botDefinition), 2, null)));
                                    } else {
                                        it.fail("invalid request: " + this.$json);
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$json = string;
                                    super(1);
                                }
                            }), (Function1)((Function1)new Function1<AsyncResult<String>, Unit>(this, json){
                                final /* synthetic */ start.2 this$0;
                                final /* synthetic */ String $json;

                                public final void invoke(@NotNull AsyncResult<String> it) {
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    if (it.succeeded()) {
                                        if (it.result() != null) {
                                            this.this$0.$socket.writeTextMessage((String)it.result());
                                        } else {
                                            BotApiWebSocketClientKt.access$getLogger$p().error((Function0)new Function0<Object>(this){
                                                final /* synthetic */ start.2 this$0;

                                                @Nullable
                                                public final Object invoke() {
                                                    return "empty response for " + this.this$0.$json;
                                                }
                                                {
                                                    this.this$0 = var1_1;
                                                    super(0);
                                                }
                                            });
                                        }
                                    } else {
                                        Throwable c = it.cause();
                                        if (c == null) {
                                            BotApiWebSocketClientKt.access$getLogger$p().error("unknown error for " + this.$json + " : " + (String)it.result());
                                        } else {
                                            LoggersKt.error((KLogger)BotApiWebSocketClientKt.access$getLogger$p(), (Throwable)c);
                                        }
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$json = string;
                                    super(1);
                                }
                            }));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$socket = webSocket;
                        }
                    })) == null || (webSocket = webSocket.exceptionHandler((Handler)new Handler<Throwable>(this){
                        final /* synthetic */ start.4 this$0;

                        public final void handle(Throwable it) {
                            BotApiWebSocketClientKt.access$getLogger$p().info("Exception, restarting in 1s");
                            start.2 v0 = this.this$0.$restart$2;
                            HttpClient httpClient = this.this$0.$client;
                            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client");
                            v0.invoke(httpClient, 1L);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    })) == null || (webSocket = webSocket.closeHandler((Handler)new Handler<Void>(this){
                        final /* synthetic */ start.4 this$0;

                        public final void handle(Void it) {
                            BotApiWebSocketClientKt.access$getLogger$p().info("Closed, restarting in 1s");
                            start.2 v0 = this.this$0.$restart$2;
                            HttpClient httpClient = this.this$0.$client;
                            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client");
                            v0.invoke(httpClient, 1L);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    })) == null) {
                        HttpClient httpClient = this.$client;
                        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client");
                        this.$restart$2.invoke(httpClient, 10L);
                        Unit unit = Unit.INSTANCE;
                        boolean bl = false;
                        boolean bl2 = false;
                        Unit $this$apply = unit;
                        boolean bl3 = false;
                        BotApiWebSocketClientKt.access$getLogger$p().warn((Function0)start.5.1.INSTANCE);
                        webSocket = unit;
                    }
                }
                catch (Exception e) {
                    LoggersKt.error((KLogger)BotApiWebSocketClientKt.access$getLogger$p(), (Throwable)e);
                }
            }
            {
                this.$botDefinition = clientBotDefinition;
                this.$restart$2 = var2_2;
                this.$client = httpClient;
            }
        });
    }

    public static /* synthetic */ void start$default(ClientBotDefinition clientBotDefinition, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = PropertiesKt.intProperty((String)"tock_websocket_port", (int)8080);
        }
        if ((n2 & 4) != 0) {
            string = PropertiesKt.property((String)"tock_websocket_host", (String)"localhost");
        }
        if ((n2 & 8) != 0) {
            bl = PropertiesKt.booleanProperty((String)"tock_websocket_ssl", (boolean)false);
        }
        BotApiWebSocketClientKt.start(clientBotDefinition, n, string, bl);
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

