/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.websocket;

import ai.tock.bot.api.client.ClientBotDefinition;
import ai.tock.bot.api.client.ConfigurationsKt;
import ai.tock.bot.api.client.TockClientBus;
import ai.tock.bot.api.model.BotResponse;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.shared.Dice;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketConnectOptions;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a,\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lmu/KLogger;", "startWithDemo", "", "botDefinition", "Lai/tock/bot/api/client/ClientBotDefinition;", "start", "url", "", "serverPort", "", "serverHost", "ssl", "", "tock-bot-api-websocket-base"})
@SourceDebugExtension(value={"SMAP\nBotApiWebSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiWebSocketClient.kt\nai/tock/bot/api/websocket/BotApiWebSocketClientKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,174:1\n1#2:175\n56#3:176\n49#3:177\n*S KotlinDebug\n*F\n+ 1 BotApiWebSocketClient.kt\nai/tock/bot/api/websocket/BotApiWebSocketClientKt\n*L\n123#1:176\n123#1:177\n*E\n"})
public final class BotApiWebSocketClientKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(BotApiWebSocketClientKt::logger$lambda$0);

    public static final void startWithDemo(@NotNull ClientBotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        BotApiWebSocketClientKt.start(botDefinition, "https://demo-bot.tock.ai");
    }

    /*
     * WARNING - void declaration
     */
    public static final void start(@NotNull ClientBotDefinition botDefinition, @NotNull String url) {
        void it;
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL u = new URL(url);
        Integer n = u.getPort();
        int n2 = ((Number)n).intValue();
        ClientBotDefinition clientBotDefinition = botDefinition;
        boolean bl = false;
        boolean bl2 = it == -1;
        Integer n3 = !bl2 ? n : null;
        int n4 = n3 != null ? n3.intValue() : u.getDefaultPort();
        String string = u.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        BotApiWebSocketClientKt.start(clientBotDefinition, n4, string, Intrinsics.areEqual((Object)u.getProtocol(), (Object)"https"));
    }

    public static final void start(@NotNull ClientBotDefinition botDefinition, int serverPort, @NotNull String serverHost, boolean ssl) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)serverHost, (String)"serverHost");
        Ref.BooleanRef websocketIsRestarting = new Ref.BooleanRef();
        WebSocketConnectOptions options = new WebSocketConnectOptions().setSsl(Boolean.valueOf(ssl)).setHost(serverHost).setPort(Integer.valueOf(serverPort)).setURI("/" + botDefinition.getApiKey());
        logger.info(() -> BotApiWebSocketClientKt.start$lambda$4(options));
        HttpClient client = VertXsKt.getVertx().createHttpClient();
        client.webSocket(options, arg_0 -> BotApiWebSocketClientKt.start$lambda$20(botDefinition, client, websocketIsRestarting, serverPort, serverHost, ssl, arg_0));
    }

    public static /* synthetic */ void start$default(ClientBotDefinition clientBotDefinition, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = PropertiesKt.intProperty((String)"tock_websocket_port", (int)8080);
        }
        if ((n2 & 4) != 0) {
            string = PropertiesKt.property((String)"tock_websocket_host", (String)"localhost");
        }
        if ((n2 & 8) != 0) {
            bl = PropertiesKt.booleanProperty((String)"tock_websocket_ssl", (boolean)false);
        }
        BotApiWebSocketClientKt.start(clientBotDefinition, n, string, bl);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object start$restart$lambda$2(long $delay) {
        return "restart in " + $delay + " seconds...";
    }

    private static final void start$restart$lambda$3(ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, HttpClient $client, long $delay, Ref.BooleanRef $websocketIsRestarting, Long it) {
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        Intrinsics.checkNotNullParameter((Object)$serverHost, (String)"$serverHost");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$websocketIsRestarting, (String)"$websocketIsRestarting");
        try {
            BotApiWebSocketClientKt.start($botDefinition, $serverPort, $serverHost, $ssl);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, $delay);
        }
    }

    private static final void start$restart(Ref.BooleanRef websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, HttpClient client, long delay) {
        if (websocketIsRestarting.element) {
            return;
        }
        websocketIsRestarting.element = true;
        logger.info(() -> BotApiWebSocketClientKt.start$restart$lambda$2(delay));
        try {
            client.close();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        VertXsKt.getVertx().setTimer(TimeUnit.SECONDS.toMillis(delay), arg_0 -> BotApiWebSocketClientKt.start$restart$lambda$3($botDefinition, $serverPort, $serverHost, $ssl, client, delay, websocketIsRestarting, arg_0));
    }

    private static final Object start$lambda$4(WebSocketConnectOptions $options) {
        return "start web socket client: " + $options.toJson();
    }

    private static final Object start$lambda$20$lambda$5(String $conf) {
        return "send bot conf: " + $conf;
    }

    private static final Object start$lambda$20$lambda$15$lambda$12$lambda$6(String $json) {
        return "json: " + $json;
    }

    private static final Object start$lambda$20$lambda$15$lambda$12$lambda$7() {
        return "handle request by bus";
    }

    private static final Object start$lambda$20$lambda$15$lambda$12$lambda$10$lambda$8() {
        return "send bus response";
    }

    private static final Object start$lambda$20$lambda$15$lambda$12$lambda$10$lambda$9(String $response) {
        return $response;
    }

    private static final Unit start$lambda$20$lambda$15$lambda$12$lambda$10(RequestData $data, Promise $it, BotResponse r) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        logger.debug(BotApiWebSocketClientKt::start$lambda$20$lambda$15$lambda$12$lambda$10$lambda$8);
        String response = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData($data.getRequestId(), r, null, 4, null));
        logger.debug(() -> BotApiWebSocketClientKt.start$lambda$20$lambda$15$lambda$12$lambda$10$lambda$9(response));
        $it.complete((Object)response);
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$20$lambda$15$lambda$12$lambda$11() {
        return "send configuration ";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit start$lambda$20$lambda$15$lambda$12(String $json, ClientBotDefinition $botDefinition, Promise it) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.debug(() -> BotApiWebSocketClientKt.start$lambda$20$lambda$15$lambda$12$lambda$6($json));
        ObjectMapper objectMapper = JacksonKt.getMapper();
        Intrinsics.checkNotNull((Object)$json);
        String content$iv = $json;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        RequestData data = (RequestData)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<RequestData>(){});
        UserRequest request = data.getBotRequest();
        if (request != null) {
            logger.debug(BotApiWebSocketClientKt::start$lambda$20$lambda$15$lambda$12$lambda$7);
            TockClientBus bus = new TockClientBus($botDefinition, data, arg_0 -> BotApiWebSocketClientKt.start$lambda$20$lambda$15$lambda$12$lambda$10(data, it, arg_0));
            bus.handle();
        } else if (Intrinsics.areEqual((Object)data.getConfiguration(), (Object)true)) {
            logger.debug(BotApiWebSocketClientKt::start$lambda$20$lambda$15$lambda$12$lambda$11);
            it.complete((Object)JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(data.getRequestId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)$botDefinition), 2, null)));
        } else {
            it.fail("invalid request: " + $json);
        }
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$20$lambda$15$lambda$14$lambda$13(String $json) {
        return "empty response for " + $json;
    }

    private static final Unit start$lambda$20$lambda$15$lambda$14(WebSocket $socket, String $json, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.succeeded()) {
            if (it.result() != null) {
                $socket.writeTextMessage((String)it.result());
            } else {
                logger.error(() -> BotApiWebSocketClientKt.start$lambda$20$lambda$15$lambda$14$lambda$13($json));
            }
        } else {
            Throwable c = it.cause();
            if (c == null) {
                logger.error("unknown error for " + $json + " : " + it.result());
            } else {
                LoggersKt.error((KLogger)logger, (Throwable)c);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void start$lambda$20$lambda$15(ClientBotDefinition $botDefinition, WebSocket $socket, String json) {
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        VertXsKt.blocking((Vertx)VertXsKt.getVertx(), arg_0 -> BotApiWebSocketClientKt.start$lambda$20$lambda$15$lambda$12(json, $botDefinition, arg_0), arg_0 -> BotApiWebSocketClientKt.start$lambda$20$lambda$15$lambda$14($socket, json, arg_0));
    }

    private static final void start$lambda$20$lambda$16(HttpClient $client, Ref.BooleanRef $websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$websocketIsRestarting, (String)"$websocketIsRestarting");
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        Intrinsics.checkNotNullParameter((Object)$serverHost, (String)"$serverHost");
        logger.info("Exception");
        Intrinsics.checkNotNull((Object)$client);
        BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 1L);
    }

    private static final void start$lambda$20$lambda$17(HttpClient $client, Ref.BooleanRef $websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, Void it) {
        Intrinsics.checkNotNullParameter((Object)$websocketIsRestarting, (String)"$websocketIsRestarting");
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        Intrinsics.checkNotNullParameter((Object)$serverHost, (String)"$serverHost");
        logger.info("Closed");
        Intrinsics.checkNotNull((Object)$client);
        BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 1L);
    }

    private static final Object start$lambda$20$lambda$19$lambda$18() {
        return "websocket server not found or unknown key - retry in 10s";
    }

    private static final void start$lambda$20(ClientBotDefinition $botDefinition, HttpClient $client, Ref.BooleanRef $websocketIsRestarting, int $serverPort, String $serverHost, boolean $ssl, AsyncResult context) {
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        Intrinsics.checkNotNullParameter((Object)$websocketIsRestarting, (String)"$websocketIsRestarting");
        Intrinsics.checkNotNullParameter((Object)$serverHost, (String)"$serverHost");
        try {
            WebSocketBase webSocketBase;
            WebSocketBase webSocketBase2;
            WebSocketBase webSocketBase3;
            WebSocket socket = (WebSocket)context.result();
            String conf = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(Dice.INSTANCE.newId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)$botDefinition), 2, null));
            logger.debug(() -> BotApiWebSocketClientKt.start$lambda$20$lambda$5(conf));
            WebSocket webSocket = socket;
            if (webSocket != null) {
                webSocket.writeTextMessage(conf);
            }
            if (socket == null || (webSocketBase3 = socket.textMessageHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$20$lambda$15($botDefinition, socket, arg_0))) == null || (webSocketBase2 = webSocketBase3.exceptionHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$20$lambda$16($client, $websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, arg_0))) == null || (webSocketBase = webSocketBase2.closeHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$20$lambda$17($client, $websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, arg_0))) == null) {
                Unit unit;
                Intrinsics.checkNotNull((Object)$client);
                BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 10L);
                Unit $this$start_u24lambda_u2420_u24lambda_u2419 = unit = Unit.INSTANCE;
                boolean bl = false;
                logger.warn(BotApiWebSocketClientKt::start$lambda$20$lambda$19$lambda$18);
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }
}

