/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.alcmeon;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/tock/bot/connector/alcmeon/AlcmeonAuthorisationHandler;", "Lio/vertx/core/Handler;", "Lio/vertx/ext/web/RoutingContext;", "secret", "", "(Ljava/lang/String;)V", "mac", "Ljavax/crypto/Mac;", "kotlin.jvm.PlatformType", "signingKey", "Ljavax/crypto/spec/SecretKeySpec;", "calculateSignature", "payload", "handle", "", "routingContext", "tock-bot-connector-alcmeon"})
public final class AlcmeonAuthorisationHandler
implements Handler<RoutingContext> {
    @NotNull
    private final SecretKeySpec signingKey;
    private final Mac mac;

    public AlcmeonAuthorisationHandler(@NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        String string = secret;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.signingKey = new SecretKeySpec(byArray, "HmacSHA256");
        this.mac = Mac.getInstance("HmacSHA256");
        this.mac.init(this.signingKey);
    }

    public void handle(@NotNull RoutingContext routingContext) {
        Intrinsics.checkNotNullParameter((Object)routingContext, (String)"routingContext");
        String alcmeonWebhookSignature = routingContext.request().getHeader("X-Alcmeon-Webhook-Signature");
        String normalisedPath = routingContext.normalizedPath();
        String requestPayload = routingContext.body().asString();
        String signature = this.calculateSignature(normalisedPath + " " + requestPayload);
        if (Intrinsics.areEqual((Object)alcmeonWebhookSignature, (Object)signature)) {
            routingContext.next();
        } else {
            routingContext.response().setStatusCode(403).end("Invalid Alcmeon webhook signature");
        }
    }

    private final String calculateSignature(String payload) {
        Hex hex = new Hex();
        String string = payload;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = hex.encode(this.mac.doFinal(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        return new String(byArray3, Charsets.UTF_8);
    }
}

