/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.alcmeon;

import ai.tock.bot.connector.ConnectorCallbackBase;
import ai.tock.bot.connector.alcmeon.AlcmeonBackend;
import ai.tock.bot.connector.alcmeon.AlcmeonConnectorCallback;
import ai.tock.bot.connector.alcmeon.AlcmeonConnectorMessageResponse;
import ai.tock.bot.connector.alcmeon.AlcmeonConnectorProviderKt;
import ai.tock.bot.connector.alcmeon.AlcmeonMessageConverter;
import ai.tock.bot.connector.alcmeon.DelayedAction;
import ai.tock.bot.engine.action.Action;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u001e\u0010$\u001a\u00020\u00152\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010&\u001a\u00020\u0019H\u0002J\u0016\u0010'\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0019J\u0006\u0010(\u001a\u00020\u0015J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lai/tock/bot/connector/alcmeon/AlcmeonConnectorCallback;", "Lai/tock/bot/connector/ConnectorCallbackBase;", "applicationId", "", "backend", "Lai/tock/bot/connector/alcmeon/AlcmeonBackend;", "context", "Lio/vertx/ext/web/RoutingContext;", "(Ljava/lang/String;Lai/tock/bot/connector/alcmeon/AlcmeonBackend;Lio/vertx/ext/web/RoutingContext;)V", "actions", "", "Lai/tock/bot/connector/alcmeon/DelayedAction;", "getApplicationId", "()Ljava/lang/String;", "getBackend", "()Lai/tock/bot/connector/alcmeon/AlcmeonBackend;", "getContext", "()Lio/vertx/ext/web/RoutingContext;", "logger", "Lmu/KLogger;", "addAction", "", "action", "Lai/tock/bot/engine/action/Action;", "delay", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "sendResponse", "exitReason", "delayInMs", "sendResponseWithExit", "sendResponseWithoutExit", "toString", "tock-bot-connector-alcmeon"})
public final class AlcmeonConnectorCallback
extends ConnectorCallbackBase {
    @NotNull
    private final String applicationId;
    @NotNull
    private final AlcmeonBackend backend;
    @NotNull
    private final RoutingContext context;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final List<DelayedAction> actions;

    public AlcmeonConnectorCallback(@NotNull String applicationId, @NotNull AlcmeonBackend backend, @NotNull RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(applicationId, AlcmeonConnectorProviderKt.getAlcmeonConnectorType());
        this.applicationId = applicationId;
        this.backend = backend;
        this.context = context;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.actions = new ArrayList();
    }

    @NotNull
    public String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final AlcmeonBackend getBackend() {
        return this.backend;
    }

    @NotNull
    public final RoutingContext getContext() {
        return this.context;
    }

    public final void addAction(@NotNull Action action, long delay) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.actions.add(new DelayedAction(action, delay));
    }

    public final void sendResponseWithoutExit() {
        AlcmeonConnectorCallback.sendResponse$default(this, null, 0L, 3, null);
    }

    public final void sendResponseWithExit(@NotNull String exitReason, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)exitReason, (String)"exitReason");
        this.sendResponse(exitReason, delayInMs);
    }

    private final void sendResponse(String exitReason, long delayInMs) {
        AlcmeonConnectorMessageResponse response = AlcmeonMessageConverter.INSTANCE.toMessageOut(this.actions, this.backend, exitReason, delayInMs);
        String serializedResponse = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)response);
        this.logger.info((Function0)new Function0<Object>(serializedResponse){
            final /* synthetic */ String $serializedResponse;
            {
                this.$serializedResponse = $serializedResponse;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Alcmeon connector callback response : " + this.$serializedResponse;
            }
        });
        this.context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(serializedResponse);
    }

    static /* synthetic */ void sendResponse$default(AlcmeonConnectorCallback alcmeonConnectorCallback, String string, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        alcmeonConnectorCallback.sendResponse(string, l);
    }

    @NotNull
    public final String component1() {
        return this.applicationId;
    }

    @NotNull
    public final AlcmeonBackend component2() {
        return this.backend;
    }

    @NotNull
    public final RoutingContext component3() {
        return this.context;
    }

    @NotNull
    public final AlcmeonConnectorCallback copy(@NotNull String applicationId, @NotNull AlcmeonBackend backend, @NotNull RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new AlcmeonConnectorCallback(applicationId, backend, context);
    }

    public static /* synthetic */ AlcmeonConnectorCallback copy$default(AlcmeonConnectorCallback alcmeonConnectorCallback, String string, AlcmeonBackend alcmeonBackend, RoutingContext routingContext, int n, Object object) {
        if ((n & 1) != 0) {
            string = alcmeonConnectorCallback.applicationId;
        }
        if ((n & 2) != 0) {
            alcmeonBackend = alcmeonConnectorCallback.backend;
        }
        if ((n & 4) != 0) {
            routingContext = alcmeonConnectorCallback.context;
        }
        return alcmeonConnectorCallback.copy(string, alcmeonBackend, routingContext);
    }

    @NotNull
    public String toString() {
        return "AlcmeonConnectorCallback(applicationId=" + this.applicationId + ", backend=" + this.backend + ", context=" + this.context + ")";
    }

    public int hashCode() {
        int result = this.applicationId.hashCode();
        result = result * 31 + this.backend.hashCode();
        result = result * 31 + this.context.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlcmeonConnectorCallback)) {
            return false;
        }
        AlcmeonConnectorCallback alcmeonConnectorCallback = (AlcmeonConnectorCallback)((Object)other);
        if (!Intrinsics.areEqual((Object)this.applicationId, (Object)alcmeonConnectorCallback.applicationId)) {
            return false;
        }
        if (this.backend != alcmeonConnectorCallback.backend) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.context, (Object)alcmeonConnectorCallback.context);
    }
}

