/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.alexa;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.alexa.AlexaBuildersKt;
import ai.tock.bot.connector.alexa.AlexaConnectorCallback;
import ai.tock.bot.connector.alexa.AlexaConnectorProvider;
import ai.tock.bot.connector.alexa.AlexaTockMapper;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaFile;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.I18nTranslator;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.vertx.VertXsKt;
import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.SpeechletRequestHandler;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletV2;
import com.amazon.speech.speechlet.authentication.SpeechletRequestSignatureVerifier;
import com.amazon.speech.speechlet.verifier.ApplicationIdSpeechletRequestEnvelopeVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestEnvelopeVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifierWrapper;
import com.amazon.speech.speechlet.verifier.TimestampSpeechletRequestVerifier;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u001d\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J'\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0#\u00a2\u0006\u0002\b'2\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lai/tock/bot/connector/alexa/AlexaConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "alexaTockMapper", "Lai/tock/bot/connector/alexa/AlexaTockMapper;", "supportedAlexaApplicationIds", "", "timestampInMs", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lai/tock/bot/connector/alexa/AlexaTockMapper;Ljava/util/Set;J)V", "getApplicationId", "()Ljava/lang/String;", "getPath", "getAlexaTockMapper", "()Lai/tock/bot/connector/alexa/AlexaTockMapper;", "requestHandler", "Lcom/amazon/speech/speechlet/SpeechletRequestHandler;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "handleRequest", "context", "Lio/vertx/ext/web/RoutingContext;", "handleRequest$tock_bot_connector_alexa", "toConnectorMessage", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "message", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-alexa"})
public final class AlexaConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    @NotNull
    private final AlexaTockMapper alexaTockMapper;
    @NotNull
    private final SpeechletRequestHandler requestHandler;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(AlexaConnector::logger$lambda$4);
    private static final boolean disableRequestSignatureCheck = PropertiesKt.booleanProperty((String)"tock_alexa_disable_request_signature_check", (boolean)false);

    public AlexaConnector(@NotNull String applicationId, @NotNull String path, @NotNull AlexaTockMapper alexaTockMapper, @NotNull Set<String> supportedAlexaApplicationIds, long timestampInMs) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)alexaTockMapper, (String)"alexaTockMapper");
        Intrinsics.checkNotNullParameter(supportedAlexaApplicationIds, (String)"supportedAlexaApplicationIds");
        super(AlexaConnectorProvider.INSTANCE.getConnectorType(), null, 2, null);
        this.applicationId = applicationId;
        this.path = path;
        this.alexaTockMapper = alexaTockMapper;
        Object[] objectArray = new SpeechletRequestEnvelopeVerifier[]{new ApplicationIdSpeechletRequestEnvelopeVerifier(supportedAlexaApplicationIds), new SpeechletRequestVerifierWrapper((SpeechletRequestVerifier)new TimestampSpeechletRequestVerifier(timestampInMs, TimeUnit.MILLISECONDS))};
        this.requestHandler = new SpeechletRequestHandler(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final AlexaTockMapper getAlexaTockMapper() {
        return this.alexaTockMapper;
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        controller.registerServices(this.path, arg_0 -> AlexaConnector.register$lambda$1(this, controller, arg_0));
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        AlexaConnectorCallback cfr_ignored_0 = (AlexaConnectorCallback)callback;
        ((AlexaConnectorCallback)callback).addAction$tock_bot_connector_alexa(event, delayInMs);
        if (event instanceof Action) {
            if (((Action)event).getMetadata().getLastAnswer()) {
                ((AlexaConnectorCallback)callback).sendResponse$tock_bot_connector_alexa();
            }
        } else {
            logger.trace(() -> AlexaConnector.send$lambda$2(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleRequest$tock_bot_connector_alexa(@NotNull ConnectorController controller, @NotNull RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("alexa_webhook");
        try {
            byte[] bytes = context.body().buffer().getBytes();
            if (!disableRequestSignatureCheck) {
                SpeechletRequestSignatureVerifier.checkRequestSignature((byte[])bytes, (String)context.request().getHeader("Signature"), (String)context.request().getHeader("SignatureCertChainUrl"));
            }
            context.response().putHeader("Content-Type", "application/json").end(Buffer.buffer((byte[])this.requestHandler.handleSpeechletCall((SpeechletV2)new AlexaConnectorCallback(this.applicationId, controller, this.alexaTockMapper, context, null, 16, null), bytes)));
        }
        catch (Throwable ex) {
            BotRepository.INSTANCE.getRequestTimer().throwable(ex, timerData);
            ai.tock.bot.connector.alexa.AlexaConnector$Companion.sendTechnicalError$tock_bot_connector_alexa$default(Companion, context, ex, null, 4, null);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return arg_0 -> AlexaConnector.toConnectorMessage$lambda$3(message, arg_0);
    }

    private static final Unit register$lambda$1$lambda$0(AlexaConnector this$0, ConnectorController $controller, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            this$0.handleRequest$tock_bot_connector_alexa($controller, context);
        }
        catch (Throwable e) {
            context.fail(e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$1(AlexaConnector this$0, ConnectorController $controller, Router router) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        logger.info("deploy rest alexa services for root path " + this$0.path + " ");
        Route route = router.post(this$0.path);
        Intrinsics.checkNotNullExpressionValue((Object)route, (String)"post(...)");
        VertXsKt.blocking((Route)route, arg_0 -> AlexaConnector.register$lambda$1$lambda$0(this$0, $controller, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object send$lambda$2(Event $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        return "unsupported event: " + $event;
    }

    private static final List toConnectorMessage$lambda$3(MediaMessage $message, BotBus botBus) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        if ($message instanceof MediaCard) {
            CharSequence title = ((MediaCard)$message).getTitle();
            CharSequence subTitle = ((MediaCard)$message).getSubTitle();
            MediaFile file = ((MediaCard)$message).getFile();
            list = title != null && subTitle != null && file != null && file.getType() == SendAttachment.AttachmentType.image ? CollectionsKt.listOf((Object)AlexaBuildersKt.alexaStandardCard$default((I18nTranslator)botBus, title, subTitle, file.getUrl(), null, 8, null)) : CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit logger$lambda$4() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/alexa/AlexaConnector$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "disableRequestSignatureCheck", "", "sendTechnicalError", "", "context", "Lio/vertx/ext/web/RoutingContext;", "throwable", "", "request", "Lcom/amazon/speech/speechlet/IntentRequest;", "sendTechnicalError$tock_bot_connector_alexa", "tock-bot-connector-alexa"})
    public static final class Companion {
        private Companion() {
        }

        public final void sendTechnicalError$tock_bot_connector_alexa(@NotNull RoutingContext context, @NotNull Throwable throwable, @Nullable IntentRequest request) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            try {
                logger.error("request: " + request, throwable);
                if (throwable instanceof SpeechletRequestHandlerException || throwable instanceof SecurityException) {
                    context.fail(400);
                } else {
                    context.fail(throwable);
                }
            }
            catch (Throwable t) {
                LoggersKt.error((KLogger)logger, (Throwable)t);
                context.fail(t);
            }
        }

        public static /* synthetic */ void sendTechnicalError$tock_bot_connector_alexa$default(Companion companion, RoutingContext routingContext, Throwable throwable, IntentRequest intentRequest, int n, Object object) {
            if ((n & 4) != 0) {
                intentRequest = null;
            }
            companion.sendTechnicalError$tock_bot_connector_alexa(routingContext, throwable, intentRequest);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

