/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.ga;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorCallbackBase;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorFeature;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.connector.ga.GAAccountLinking;
import ai.tock.bot.connector.ga.GABasicCardsBuilderKt;
import ai.tock.bot.connector.ga.GABuildersKt;
import ai.tock.bot.connector.ga.GACarouselBuildersKt;
import ai.tock.bot.connector.ga.GAConnector;
import ai.tock.bot.connector.ga.GAConnectorCallback;
import ai.tock.bot.connector.ga.GAConnectorProvider;
import ai.tock.bot.connector.ga.GAResponseConnectorMessage;
import ai.tock.bot.connector.ga.GARichResponseBuildersKt;
import ai.tock.bot.connector.ga.WebhookActionConverter;
import ai.tock.bot.connector.ga.model.request.GARequest;
import ai.tock.bot.connector.ga.model.request.GAUser;
import ai.tock.bot.connector.ga.model.request.GAUserProfile;
import ai.tock.bot.connector.ga.model.response.GABasicCard;
import ai.tock.bot.connector.ga.model.response.GACarouselItem;
import ai.tock.bot.connector.ga.model.response.GAExpectedInput;
import ai.tock.bot.connector.ga.model.response.GAExpectedIntent;
import ai.tock.bot.connector.ga.model.response.GAInputPrompt;
import ai.tock.bot.connector.ga.model.response.GAItem;
import ai.tock.bot.connector.ga.model.response.GAOptionInfo;
import ai.tock.bot.connector.ga.model.response.GARichResponse;
import ai.tock.bot.connector.ga.model.response.GASimpleResponse;
import ai.tock.bot.connector.ga.model.response.GASuggestion;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaCarousel;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.I18nTranslator;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendChoice;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.LoginEvent;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J1\u0010\u0017\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0018\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J1\u0010\u0017\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0018\u00a2\u0006\u0002\b\u001b2\u0006\u0010 \u001a\u00020\u001f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u00102\u001a\u00020\"2\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0016J'\u00107\u001a\u0019\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u001e0\u0018\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u000208H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006:"}, d2={"Lai/tock/bot/connector/ga/GAConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "allowedProjectIds", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getAllowedProjectIds", "()Ljava/util/Set;", "getApplicationId", "()Ljava/lang/String;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "getPath", "verifier", "Lcom/google/api/client/auth/openidconnect/IdTokenVerifier;", "getVerifier", "()Lcom/google/api/client/auth/openidconnect/IdTokenVerifier;", "verifier$delegate", "Lkotlin/Lazy;", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "message", "suggestions", "", "", "text", "handleRequest", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "context", "Lio/vertx/ext/web/RoutingContext;", "body", "handleRequest$tock_bot_connector_ga", "isValidToken", "", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "userId", "Lai/tock/bot/engine/user/PlayerId;", "register", "send", "event", "Lai/tock/bot/engine/event/Event;", "delayInMs", "", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-ga"})
@SourceDebugExtension(value={"SMAP\nGAConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GAConnector.kt\nai/tock/bot/connector/ga/GAConnector\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n53#2,2:307\n51#3:309\n277#4:310\n50#5:311\n43#5:312\n1747#6,3:313\n*S KotlinDebug\n*F\n+ 1 GAConnector.kt\nai/tock/bot/connector/ga/GAConnector\n*L\n72#1:307,2\n72#1:309\n72#1:310\n105#1:311\n105#1:312\n161#1:313,3\n*E\n"})
public final class GAConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    @NotNull
    private final Set<String> allowedProjectIds;
    @NotNull
    private final Lazy verifier$delegate;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    public GAConnector(@NotNull String applicationId, @NotNull String path, @NotNull Set<String> allowedProjectIds) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(allowedProjectIds, (String)"allowedProjectIds");
        super(GAConnectorProvider.INSTANCE.getConnectorType(), SetsKt.setOf((Object)ConnectorFeature.CAROUSEL));
        this.applicationId = applicationId;
        this.path = path;
        this.allowedProjectIds = allowedProjectIds;
        this.verifier$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)verifier.2.INSTANCE);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Set<String> getAllowedProjectIds() {
        return this.allowedProjectIds;
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    private final IdTokenVerifier getVerifier() {
        Lazy lazy = this.verifier$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-verifier>(...)");
        return (IdTokenVerifier)object;
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ GAConnector this$0;
            final /* synthetic */ ConnectorController $controller;
            {
                this.this$0 = $receiver;
                this.$controller = $controller;
                super(1);
            }

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                GAConnector.access$getLogger$cp().info("deploy rest google assistant services for root path " + this.this$0.getPath() + " ");
                router.post(this.this$0.getPath()).handler(arg_0 -> register.1.invoke$lambda$0(this.this$0, this.$controller, arg_0));
            }

            private static final void invoke$lambda$0(GAConnector this$0, ConnectorController $controller, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    if (GAConnector.access$isValidToken(this$0, context)) {
                        GAConnector.access$getExecutor(this$0).executeBlocking((Function0)new Function0<Unit>(this$0, $controller, context){
                            final /* synthetic */ GAConnector this$0;
                            final /* synthetic */ ConnectorController $controller;
                            final /* synthetic */ RoutingContext $context;
                            {
                                this.this$0 = $receiver;
                                this.$controller = $controller;
                                this.$context = $context;
                                super(0);
                            }

                            public final void invoke() {
                                RoutingContext routingContext = this.$context;
                                Intrinsics.checkNotNullExpressionValue((Object)routingContext, (String)"context");
                                String string = this.$context.body().asString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.body().asString()");
                                this.this$0.handleRequest$tock_bot_connector_ga(this.$controller, routingContext, string);
                            }
                        });
                    } else {
                        context.fail(400);
                    }
                }
                catch (Throwable e) {
                    context.fail(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleRequest$tock_bot_connector_ga(@NotNull ConnectorController controller, @NotNull RoutingContext context, @NotNull String body) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("ga_webhook");
            try {
                logger.debug((Function0)new Function0<Object>(body){
                    final /* synthetic */ String $body;
                    {
                        this.$body = $body;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Google Assistant request input : " + this.$body;
                    }
                });
                ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                GARequest request = (GARequest)$this$readValue$iv.readValue(body, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<GARequest>(){});
                GAConnectorCallback callback = new GAConnectorCallback(this.applicationId, controller, context, request, null, 16, null);
                try {
                    Event event = WebhookActionConverter.INSTANCE.toEvent(request, this.applicationId);
                    if (event instanceof LoginEvent) {
                        GAAccountLinking.Companion.switchTimeLine$tock_bot_connector_ga(this.applicationId, ((LoginEvent)event).getUserId(), ((LoginEvent)event).getPreviousUserId(), controller);
                        GAConnector.handleRequest$sendRequest(controller, event, callback, request);
                        break block10;
                    }
                    if (GAAccountLinking.Companion.isUserAuthenticated$tock_bot_connector_ga(request)) {
                        logger.debug((Function0)handleRequest.2.INSTANCE);
                        String string = request.getUser().getAccessToken();
                        if (string == null) {
                            throw new IllegalStateException("Access token can't be null".toString());
                        }
                        String string2 = this.applicationId;
                        ConnectorType connectorType = GABuildersKt.getGaConnectorType();
                        controller.handle((Event)new LoginEvent(new PlayerId(GAAccountLinking.Companion.getUserId$tock_bot_connector_ga(request), PlayerType.user, null, 4, null), new PlayerId(this.applicationId, PlayerType.bot, null, 4, null), string, this.applicationId, null, true, 16, null), new ConnectorData((ConnectorCallback)new ConnectorCallbackBase(context, controller, event, callback, request, string2, connectorType){
                            final /* synthetic */ RoutingContext $context;
                            final /* synthetic */ ConnectorController $controller;
                            final /* synthetic */ Event $event;
                            final /* synthetic */ GAConnectorCallback $callback;
                            final /* synthetic */ GARequest $request;
                            {
                                this.$context = $context;
                                this.$controller = $controller;
                                this.$event = $event;
                                this.$callback = $callback;
                                this.$request = $request;
                                super($super_call_param$1, $super_call_param$2);
                            }

                            public void eventSkipped(@NotNull Event event) {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                this.$context.fail(401);
                            }

                            public void eventAnswered(@NotNull Event event) {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                GAConnector.access$handleRequest$sendRequest(this.$controller, this.$event, this.$callback, this.$request);
                            }
                        }, null, false, null, null, null, 62, null));
                        break block10;
                    }
                    GAConnector.handleRequest$sendRequest(controller, event, callback, request);
                }
                catch (Throwable t) {
                    BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
                    callback.sendTechnicalError(t, body, request);
                }
            }
            catch (Throwable t) {
                BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
                context.fail(t);
            }
            finally {
                BotRepository.INSTANCE.getRequestTimer().end(timerData);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidToken(RoutingContext context) {
        if (((Collection)this.allowedProjectIds).isEmpty()) return true;
        boolean bl = true;
        if (!bl) return true;
        try {
            String it;
            String jwt = context.request().getHeader("authorization");
            IdToken token = IdToken.parse((JsonFactory)((JsonFactory)JacksonFactory.getDefaultInstance()), (String)jwt);
            boolean bl2 = false;
            if (!this.getVerifier().verify(token)) return false;
            Iterable $this$any$iv = this.allowedProjectIds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl3 = false;
            } while (!token.verifyAudience((Collection)CollectionsKt.listOf((Object)it)));
            return true;
        }
        catch (Exception e) {
            logger.warn((Function0)isValidToken.2.INSTANCE);
            return false;
        }
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        GAConnectorCallback c;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        GAConnectorCallback gAConnectorCallback = c = callback instanceof GAConnectorCallback ? (GAConnectorCallback)callback : null;
        if (gAConnectorCallback != null) {
            gAConnectorCallback.addAction(event, delayInMs);
        }
        if (event instanceof Action) {
            if (((Action)event).getMetadata().getLastAnswer()) {
                GAConnectorCallback gAConnectorCallback2 = c;
                if (gAConnectorCallback2 != null) {
                    gAConnectorCallback2.sendResponse();
                }
            }
        } else {
            logger.trace((Function0)new Function0<Object>(event){
                final /* synthetic */ Event $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "unsupported event: " + this.$event;
                }
            });
        }
    }

    @Nullable
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        UserPreferences userPreferences;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        GAConnectorCallback c = callback instanceof GAConnectorCallback ? (GAConnectorCallback)callback : null;
        Object object = c;
        if (object != null && (object = object.getRequest()) != null && (object = ((GARequest)object).getUser()) != null && (object = ((GAUser)object).getProfile()) != null) {
            GAConnectorCallback $this$loadProfile_u24lambda_u242 = object;
            boolean bl = false;
            userPreferences = ((GAUserProfile)((Object)$this$loadProfile_u24lambda_u242)).getGivenName() != null ? new UserPreferences(((GAUserProfile)((Object)$this$loadProfile_u24lambda_u242)).getGivenName(), ((GAUserProfile)((Object)$this$loadProfile_u24lambda_u242)).getFamilyName(), null, null, null, null, null, false, null, 508, null) : null;
        } else {
            userPreferences = null;
        }
        return userPreferences;
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, GAResponseConnectorMessage>(text, suggestions){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ List<CharSequence> $suggestions;
            {
                this.$text = $text;
                this.$suggestions = $suggestions;
                super(1);
            }

            @NotNull
            public final GAResponseConnectorMessage invoke(@NotNull BotBus $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                return GABuildersKt.gaMessage((I18nTranslator)$this$null, GARichResponseBuildersKt.richResponse((I18nTranslator)$this$null, this.$text, this.$suggestions));
            }
        };
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, ConnectorMessage>(message, suggestions){
            final /* synthetic */ ConnectorMessage $message;
            final /* synthetic */ List<CharSequence> $suggestions;
            {
                this.$message = $message;
                this.$suggestions = $suggestions;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ConnectorMessage invoke(@NotNull BotBus $this$null) {
                ConnectorMessage connectorMessage;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                if (this.$message instanceof GAResponseConnectorMessage) {
                    GAResponseConnectorMessage gAResponseConnectorMessage;
                    GARichResponse m;
                    Object object = (GAExpectedInput)CollectionsKt.lastOrNull(((GAResponseConnectorMessage)this.$message).getExpectedInputs());
                    GARichResponse gARichResponse = object != null && (object = ((GAExpectedInput)object).getInputPrompt()) != null ? ((GAInputPrompt)object).getRichInitialPrompt() : (m = null);
                    if (m != null && m.getSuggestions().isEmpty()) {
                        Collection<GASuggestion> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$suggestions;
                        List list = null;
                        GARichResponse gARichResponse2 = m;
                        GAInputPrompt gAInputPrompt = ((GAExpectedInput)CollectionsKt.last(((GAResponseConnectorMessage)this.$message).getExpectedInputs())).getInputPrompt();
                        GAExpectedInput gAExpectedInput = (GAExpectedInput)CollectionsKt.last(((GAResponseConnectorMessage)this.$message).getExpectedInputs());
                        Collection collection2 = CollectionsKt.take((Iterable)((GAResponseConnectorMessage)this.$message).getExpectedInputs(), (int)(((GAResponseConnectorMessage)this.$message).getExpectedInputs().size() - 1));
                        boolean bl = false;
                        GAResponseConnectorMessage gAResponseConnectorMessage2 = (GAResponseConnectorMessage)this.$message;
                        boolean $i$f$map = false;
                        void var5_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CharSequence charSequence = (CharSequence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(GARichResponseBuildersKt.suggestion((I18nTranslator)$this$null, (CharSequence)it));
                        }
                        collection = (List)destination$iv$iv;
                        gAResponseConnectorMessage = GAResponseConnectorMessage.copy$default(gAResponseConnectorMessage2, bl, CollectionsKt.plus((Collection)collection2, (Object)GAExpectedInput.copy$default(gAExpectedInput, GAInputPrompt.copy$default(gAInputPrompt, GARichResponse.copy$default(gARichResponse2, list, (List)collection, null, 5, null), null, 2, null), null, null, 6, null)), null, false, 13, null);
                    } else {
                        gAResponseConnectorMessage = null;
                    }
                    connectorMessage = gAResponseConnectorMessage;
                } else {
                    connectorMessage = null;
                }
                return connectorMessage;
            }
        };
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (Function1)new Function1<BotBus, List<? extends ConnectorMessage>>(message, this){
            final /* synthetic */ MediaMessage $message;
            final /* synthetic */ GAConnector this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @NotNull
            public final List<ConnectorMessage> invoke(@NotNull BotBus $this$null) {
                block17: {
                    block18: {
                        block19: {
                            block16: {
                                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                                if (!(this.$message instanceof MediaCard)) break block16;
                                title = ((MediaCard)this.$message).getTitle();
                                subTitle = ((MediaCard)this.$message).getSubTitle();
                                v0 = ((MediaCard)this.$message).getFile();
                                if (v0 != null) {
                                    it = var6_6 = v0;
                                    $i$a$-takeIf-GAConnector$toConnectorMessage$1$image$1 = false;
                                    v1 /* !! */  = it.getType() == SendAttachment.AttachmentType.image ? var6_6 : null;
                                } else {
                                    v1 /* !! */  = image = null;
                                }
                                v2 = image != null ? GABasicCardsBuilderKt.basicCard$default((I18nTranslator)$this$null, title, null, subTitle, GABuildersKt.gaImage$default((I18nTranslator)$this$null, image.getUrl(), image.getName(), null, null, 12, null), null, 16, null) : (title != null ? (subTitle == null ? GABasicCardsBuilderKt.basicCard$default((I18nTranslator)$this$null, null, null, title, null, null, 27, null) : GABasicCardsBuilderKt.basicCard$default((I18nTranslator)$this$null, title, null, subTitle, null, null, 26, null)) : (card = subTitle != null ? GABasicCardsBuilderKt.basicCard$default((I18nTranslator)$this$null, null, null, subTitle, null, null, 27, null) : null));
                                v3 = title;
                                if (v3 == null && (v3 = subTitle) == null) {
                                    v3 = requiredTextToSpeech = (CharSequence)"default_ga_card_title";
                                }
                                if (card != null) {
                                    block15: {
                                        actions = ((MediaCard)this.$message).getActions();
                                        $this$filter$iv = actions;
                                        $i$f$filter = false;
                                        var11_22 = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (MediaAction)element$iv$iv;
                                            $i$a$-filter-GAConnector$toConnectorMessage$1$suggestions$1 = false;
                                            if (!(it.getUrl() == null)) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        $this$filter$iv = (List)destination$iv$iv;
                                        $i$f$map = false;
                                        $this$filterTo$iv$iv = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            it = (MediaAction)item$iv$iv;
                                            var30_41 = destination$iv$iv;
                                            $i$a$-map-GAConnector$toConnectorMessage$1$suggestions$2 = false;
                                            var30_41.add(it.getTitle());
                                        }
                                        suggestions = (List)destination$iv$iv;
                                        $this$firstOrNull$iv = actions;
                                        $i$f$firstOrNull = false;
                                        for (T element$iv : $this$firstOrNull$iv) {
                                            it = (MediaAction)element$iv;
                                            $i$a$-firstOrNull-GAConnector$toConnectorMessage$1$redirect$1 = false;
                                            if (!(it.getUrl() != null)) continue;
                                            v4 = element$iv;
                                            break block15;
                                        }
                                        v4 = null;
                                    }
                                    v5 = v4;
                                    if (v5 != null) {
                                        it = v5;
                                        $i$a$-let-GAConnector$toConnectorMessage$1$redirect$2 = false;
                                        v6 = (I18nTranslator)$this$null;
                                        v7 = it.getTitle();
                                        v8 = it.getUrl();
                                        Intrinsics.checkNotNull((Object)v8);
                                        v9 = GABuildersKt.gaButton(v6, v7, v8);
                                    } else {
                                        v9 = null;
                                    }
                                    redirect = v9;
                                    v10 = CollectionsKt.listOf((Object)GABuildersKt.gaMessage((I18nTranslator)$this$null, GARichResponseBuildersKt.richResponse((I18nTranslator)$this$null, (CharSequence)$this$null.i18nKey("default_ga_card_title", requiredTextToSpeech, new Object[0]), GABasicCard.copy$default(card, null, null, null, null, CollectionsKt.listOfNotNull((Object)redirect), 15, null), (List<? extends CharSequence>)suggestions)));
                                } else {
                                    v10 = CollectionsKt.emptyList();
                                }
                                break block17;
                            }
                            if (!(this.$message instanceof MediaCarousel)) break block18;
                            if (((MediaCarousel)this.$message).getCards().size() <= 1) break block19;
                            suggestions = new ArrayList<E>();
                            $this$map$iv = ((MediaCarousel)this.$message).getCards();
                            $i$f$map = false;
                            requiredTextToSpeech = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                $this$firstOrNull$iv = (MediaCard)item$iv$iv;
                                var30_42 = destination$iv$iv;
                                $i$a$-map-GAConnector$toConnectorMessage$1$items$1 = false;
                                title = $this$null.translate(card.getTitle(), new Object[0]);
                                subTitle = $this$null.translate(card.getSubTitle(), new Object[0]);
                                it = card.getActions();
                                var16_38 = suggestions;
                                $i$f$filter = false;
                                var18_43 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (MediaAction)element$iv$iv;
                                    $i$a$-filter-GAConnector$toConnectorMessage$1$items$1$1 = false;
                                    if (!(it.getUrl() == null)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                $i$f$map = false;
                                $this$filterTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (MediaAction)item$iv$iv;
                                    var25_50 = destination$iv$iv;
                                    $i$a$-map-GAConnector$toConnectorMessage$1$items$1$2 = false;
                                    var25_50.add(it.getTitle().toString());
                                }
                                var16_38.addAll((List)destination$iv$iv);
                                v11 = new GAOptionInfo(SendChoice.Companion.encodeNlpChoiceId(title.toString()), CollectionsKt.emptyList());
                                v12 = title.toString();
                                v13 = subTitle.toString();
                                v14 /* !! */  = card.getFile();
                                if (v14 /* !! */  == null) ** GOTO lbl-1000
                                var18_43 = v14 /* !! */ ;
                                destination$iv$iv = var18_43;
                                var26_51 = v13;
                                var27_52 = v12;
                                var28_53 = v11;
                                $i$a$-takeIf-GAConnector$toConnectorMessage$1$items$1$3 = false;
                                var29_54 = it.getType() == SendAttachment.AttachmentType.image;
                                v11 = var28_53;
                                v12 = var27_52;
                                v13 = var26_51;
                                v14 /* !! */  = var29_54 != false ? var18_43 : null;
                                if (v14 /* !! */  != null) {
                                    it = v14 /* !! */ ;
                                    var26_51 = v13;
                                    var27_52 = v12;
                                    var28_53 = v11;
                                    $i$a$-let-GAConnector$toConnectorMessage$1$items$1$4 = false;
                                    var29_55 = GABuildersKt.gaImage$default((I18nTranslator)$this$null, it.getUrl(), it.getName(), null, null, 12, null);
                                    v11 = var28_53;
                                    v12 = var27_52;
                                    v13 = var26_51;
                                    v15 = var29_55;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v15 = null;
                                }
                                var31_56 = v15;
                                var32_57 = v13;
                                var33_58 = v12;
                                var34_59 = v11;
                                var30_42.add(new GACarouselItem(var34_59, var33_58, var32_57, var31_56));
                            }
                            items = (List)destination$iv$iv;
                            var5_17 = new GAExpectedIntent[]{GABuildersKt.expectedTextIntent(), GACarouselBuildersKt.expectedIntentForCarousel((I18nTranslator)$this$null, items)};
                            carouselMessage = GABuildersKt.gaMessage$default((I18nTranslator)$this$null, GABuildersKt.inputPrompt$default((I18nTranslator)$this$null, GARichResponseBuildersKt.richResponse((I18nTranslator)$this$null, (List<GAItem>)CollectionsKt.listOf((Object)new GAItem(new GASimpleResponse($this$null.translate((CharSequence)"default_ga_carousel_title", new Object[0]).toString(), null, null, 6, null), null, null, null, 14, null)), (List<? extends CharSequence>)suggestions), null, 2, null), CollectionsKt.listOf((Object[])var5_17), null, 4, null);
                            v10 = CollectionsKt.listOf((Object)carouselMessage);
                            break block17;
                        }
                        v10 = ((MediaCarousel)this.$message).getCards().size() == 1 ? (List)this.this$0.toConnectorMessage((MediaMessage)CollectionsKt.first((List)((MediaCarousel)this.$message).getCards())).invoke((Object)$this$null) : CollectionsKt.emptyList();
                        break block17;
                    }
                    v10 = CollectionsKt.emptyList();
                }
                return v10;
            }
        };
    }

    private static final void handleRequest$sendRequest(ConnectorController $controller, Event event, GAConnectorCallback callback, GARequest request) {
        $controller.handle(event, new ConnectorData((ConnectorCallback)callback, null, !request.getHealthcheck(), null, null, null, 58, null));
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ boolean access$isValidToken(GAConnector $this, RoutingContext context) {
        return $this.isValidToken(context);
    }

    public static final /* synthetic */ Executor access$getExecutor(GAConnector $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ void access$handleRequest$sendRequest(ConnectorController $controller, Event event, GAConnectorCallback callback, GARequest request) {
        GAConnector.handleRequest$sendRequest($controller, event, callback, request);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/ga/GAConnector$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-bot-connector-ga"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

