/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.ga;

import ai.tock.bot.connector.ga.GaNotificationClient;
import ai.tock.bot.connector.ga.model.notification.GANotification;
import ai.tock.bot.connector.ga.model.notification.GAPushNotification;
import ai.tock.bot.connector.ga.model.notification.GATarget;
import ai.tock.bot.connector.ga.model.notification.GaPushMessage;
import ai.tock.shared.IOsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.POST;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/tock/bot/connector/ga/GaNotificationClient;", "", "()V", "baseUrl", "", "gaNotificationApi", "Lai/tock/bot/connector/ga/GaNotificationClient$GaNotificationApi;", "logger", "Lmu/KLogger;", "version", "getAccessToken", "loadCredentials", "Lcom/google/auth/oauth2/ServiceAccountCredentials;", "push", "", "title", "userId", "intent", "locale", "GaNotificationApi", "tock-bot-connector-ga"})
@SourceDebugExtension(value={"SMAP\nGaNotificationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GaNotificationClient.kt\nai/tock/bot/connector/ga/GaNotificationClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,101:1\n71#2:102\n*S KotlinDebug\n*F\n+ 1 GaNotificationClient.kt\nai/tock/bot/connector/ga/GaNotificationClient\n*L\n63#1:102\n*E\n"})
public final class GaNotificationClient {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final GaNotificationApi gaNotificationApi;
    @NotNull
    private final String version = PropertiesKt.property((String)"tock_ga_notification_api_version", (String)"2");
    @NotNull
    private final String baseUrl = PropertiesKt.property((String)"tock_ga_notification_api_url", (String)"https://actions.googleapis.com");

    public GaNotificationClient() {
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_ga_notification_api_timeout", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)RetrofitsKt.tokenAuthenticationInterceptor((String)this.getAccessToken())), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.baseUrl + "/v" + this.version + "/");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026rl(\"$baseUrl/v$version/\")");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(GaNotificationApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.gaNotificationApi = (GaNotificationApi)object;
    }

    public final boolean push(@NotNull String title, @NotNull String userId, @NotNull String intent, @NotNull String locale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        try {
            bl = this.gaNotificationApi.push(new GAPushNotification(new GaPushMessage(new GANotification(title), new GATarget(userId, intent, locale)))).execute().isSuccessful();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final String getAccessToken() {
        AccessToken token = this.loadCredentials().refreshAccessToken();
        String string = token.getTokenValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"token.tokenValue");
        return string;
    }

    private final ServiceAccountCredentials loadCredentials() {
        InputStream actionsApiServiceAccountFile = IOsKt.resourceAsStream((String)"/service-account.json");
        ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)actionsApiServiceAccountFile);
        GoogleCredentials googleCredentials = serviceAccountCredentials.createScoped((Collection)Collections.singleton("https://www.googleapis.com/auth/actions.fulfillment.conversation"));
        Intrinsics.checkNotNull((Object)googleCredentials, (String)"null cannot be cast to non-null type com.google.auth.oauth2.ServiceAccountCredentials");
        return (ServiceAccountCredentials)googleCredentials;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lai/tock/bot/connector/ga/GaNotificationClient$GaNotificationApi;", "", "push", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "notification", "Lai/tock/bot/connector/ga/model/notification/GAPushNotification;", "tock-bot-connector-ga"})
    public static interface GaNotificationApi {
        @POST(value="./conversations:send")
        @NotNull
        public Call<ResponseBody> push(@Body @NotNull GAPushNotification var1);
    }
}

