/*
 * Copyright (C) 2017/2021 e-voyageurs technologies
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ai.tock.bot.connector.ga.model.response.transaction.v3

/**
 * @see https://developers.google.com/actions/transactions/reference/physical/rest/v3/Order#PurchaseItemExtension
 */
data class GAPurchaseItemExtension(
    val status: GAPurchaseStatus = GAPurchaseStatus.PURCHASE_STATUS_UNSPECIFIED,
    val userVisibleStatusLabel: String,
    val type: GAPurchaseType = GAPurchaseType.PURCHASE_TYPE_UNSPECIFIED,
    val quantity: Int? = null,
    val itemOptions: List<GaItemOption>? = emptyList()
)

enum class GAPurchaseStatus {
    CONFIRMED,
    CREATED,
    DELIVERED,
    CANCELLED,
    PURCHASE_STATUS_UNSPECIFIED
}

enum class GAPurchaseType {
    PURCHASE_TYPE_UNSPECIFIED,
}
