/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.messenger;

import ai.tock.bot.connector.ConnectorException;
import ai.tock.bot.connector.messenger.MessengerClient;
import ai.tock.bot.connector.messenger.model.Recipient;
import ai.tock.bot.connector.messenger.model.UserProfile;
import ai.tock.bot.connector.messenger.model.attachment.AttachmentRequest;
import ai.tock.bot.connector.messenger.model.handover.PassThreadControlRequest;
import ai.tock.bot.connector.messenger.model.handover.RequestThreadControlRequest;
import ai.tock.bot.connector.messenger.model.handover.SecondaryReceiverData;
import ai.tock.bot.connector.messenger.model.handover.SecondaryReceiverResponse;
import ai.tock.bot.connector.messenger.model.handover.TakeThreadControlRequest;
import ai.tock.bot.connector.messenger.model.handover.ThreadOwner;
import ai.tock.bot.connector.messenger.model.handover.ThreadOwnerData;
import ai.tock.bot.connector.messenger.model.handover.ThreadOwnerResponse;
import ai.tock.bot.connector.messenger.model.send.ActionRequest;
import ai.tock.bot.connector.messenger.model.send.CustomEventRequest;
import ai.tock.bot.connector.messenger.model.send.MessageRequest;
import ai.tock.bot.connector.messenger.model.send.SendResponse;
import ai.tock.bot.connector.messenger.model.send.SendResponseError;
import ai.tock.bot.connector.messenger.model.send.SendResponseErrorContainer;
import ai.tock.bot.connector.messenger.model.subscription.SubscriptionsResponse;
import ai.tock.bot.connector.messenger.model.subscription.SuccessResponse;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.monitoring.RequestTimer;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.monitoring.RequestTimerKt;
import ai.tock.shared.Level;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002RSB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0003J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0016\u0010$\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010+\u001a\u00020.J9\u0010/\u001a\u00020*\"\b\b\u0000\u00100*\u00020\u00012\u0006\u0010+\u001a\u0002H02\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u0002H0\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0302H\u0002\u00a2\u0006\u0002\u00104JA\u0010/\u001a\u00020*\"\b\b\u0000\u00100*\u00020\u00012\u0006\u0010+\u001a\u0002H02\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u0002H0\u0012\n\u0012\b\u0012\u0004\u0012\u00020*03022\u0006\u00105\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u00106J\u0018\u00107\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u0018\u0010:\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010+\u001a\u00020;J\u0016\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010A\u001a\u00020BJ \u0010C\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J0\u0010D\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u0018\u0010G\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010+\u001a\u00020HJ#\u0010I\u001a\u00020J\"\u0004\b\u0000\u001002\u0006\u0010+\u001a\u0002H02\u0006\u0010K\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010LJ+\u0010M\u001a\u00020N\"\u0004\b\u0000\u001002\u0006\u0010+\u001a\u0002H02\u000e\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010PH\u0002\u00a2\u0006\u0002\u0010QR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lai/tock/bot/connector/messenger/MessengerClient;", "", "secretKey", "", "(Ljava/lang/String;)V", "extendedProfileFields", "graphApi", "Lai/tock/bot/connector/messenger/MessengerClient$GraphApi;", "logger", "Lmu/KLogger;", "nbRetriesLimit", "", "nbRetriesWaitInMs", "", "getSecretKey", "()Ljava/lang/String;", "statusApi", "Lai/tock/bot/connector/messenger/MessengerClient$StatusApi;", "defaultUserProfile", "Lai/tock/bot/connector/messenger/model/UserProfile;", "deleteSubscribedApps", "Lai/tock/bot/connector/messenger/model/subscription/SuccessResponse;", "pageId", "fields", "token", "getProfileFields", "extendedFields", "getSecondaryReceivers", "", "Lai/tock/bot/connector/messenger/model/handover/SecondaryReceiverData;", "getSubscriptions", "Lai/tock/bot/connector/messenger/model/subscription/SubscriptionsResponse;", "appId", "appToken", "getThreadOwnerId", "userId", "getUserProfile", "recipient", "Lai/tock/bot/connector/messenger/model/Recipient;", "healthcheck", "", "passThreadControl", "Lai/tock/bot/connector/messenger/model/send/SendResponse;", "request", "Lai/tock/bot/connector/messenger/model/handover/PassThreadControlRequest;", "requestThreadControl", "Lai/tock/bot/connector/messenger/model/handover/RequestThreadControlRequest;", "send", "T", "call", "Lkotlin/Function1;", "Lretrofit2/Response;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lai/tock/bot/connector/messenger/model/send/SendResponse;", "nbTries", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;I)Lai/tock/bot/connector/messenger/model/send/SendResponse;", "sendAction", "actionRequest", "Lai/tock/bot/connector/messenger/model/send/ActionRequest;", "sendAttachment", "Lai/tock/bot/connector/messenger/model/attachment/AttachmentRequest;", "sendCustomEvent", "applicationId", "customEventRequest", "Lai/tock/bot/connector/messenger/model/send/CustomEventRequest;", "sendMessage", "messageRequest", "Lai/tock/bot/connector/messenger/model/send/MessageRequest;", "subscribedApps", "subscriptions", "callbackUrl", "verifyToken", "takeThreadControl", "Lai/tock/bot/connector/messenger/model/handover/TakeThreadControlRequest;", "throwError", "", "errorMessage", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Void;", "warnRequest", "", "msg", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "GraphApi", "StatusApi", "tock-bot-connector-messenger"})
public final class MessengerClient {
    private final KLogger logger;
    private final GraphApi graphApi;
    private final StatusApi statusApi;
    private final int nbRetriesLimit;
    private final long nbRetriesWaitInMs;
    private final String extendedProfileFields;
    @NotNull
    private final String secretKey;

    public final boolean healthcheck() {
        boolean bl;
        try {
            Response response = this.statusApi.status().execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"statusApi.status().execute()");
            bl = response.isSuccessful();
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)this.logger, (Throwable)t);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final SendResponse sendMessage(@NotNull String token, @NotNull MessageRequest messageRequest) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)messageRequest, (String)"messageRequest");
        return this.send(messageRequest, (Function1)new Function1<MessageRequest, Response<SendResponse>>(this, token, messageRequest){
            final /* synthetic */ MessengerClient this$0;
            final /* synthetic */ String $token;
            final /* synthetic */ MessageRequest $messageRequest;

            public final Response<SendResponse> invoke(@NotNull MessageRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Response response = MessengerClient.access$getGraphApi$p(this.this$0).sendMessage(this.$token, this.$messageRequest).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.sendMessage(tok\u2026messageRequest).execute()");
                return response;
            }
            {
                this.this$0 = messengerClient;
                this.$token = string;
                this.$messageRequest = messageRequest;
                super(1);
            }
        });
    }

    @Nullable
    public final SendResponse sendAttachment(@NotNull String token, @NotNull AttachmentRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (SendResponse)this.graphApi.sendAttachment(token, request).execute().body();
    }

    @Nullable
    public final SendResponse sendAction(@NotNull String token, @NotNull ActionRequest actionRequest) {
        SendResponse sendResponse;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)actionRequest, (String)"actionRequest");
        try {
            sendResponse = this.send(actionRequest, (Function1)new Function1<ActionRequest, Response<SendResponse>>(this, token, actionRequest){
                final /* synthetic */ MessengerClient this$0;
                final /* synthetic */ String $token;
                final /* synthetic */ ActionRequest $actionRequest;

                public final Response<SendResponse> invoke(@NotNull ActionRequest it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Response response = MessengerClient.access$getGraphApi$p(this.this$0).sendAction(this.$token, this.$actionRequest).execute();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.sendAction(toke\u2026 actionRequest).execute()");
                    return response;
                }
                {
                    this.this$0 = messengerClient;
                    this.$token = string;
                    this.$actionRequest = actionRequest;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            LoggersKt.info((KLogger)this.logger, (Throwable)e);
            sendResponse = null;
        }
        return sendResponse;
    }

    @NotNull
    public final SendResponse sendCustomEvent(@NotNull String applicationId, @NotNull CustomEventRequest customEventRequest) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)customEventRequest, (String)"customEventRequest");
        return this.send(customEventRequest, (Function1)new Function1<CustomEventRequest, Response<SendResponse>>(this, applicationId, customEventRequest){
            final /* synthetic */ MessengerClient this$0;
            final /* synthetic */ String $applicationId;
            final /* synthetic */ CustomEventRequest $customEventRequest;

            public final Response<SendResponse> invoke(@NotNull CustomEventRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Response response = MessengerClient.access$getGraphApi$p(this.this$0).sendCustomEvent(this.$applicationId, this.$customEventRequest).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.sendCustomEvent\u2026omEventRequest).execute()");
                return response;
            }
            {
                this.this$0 = messengerClient;
                this.$applicationId = string;
                this.$customEventRequest = customEventRequest;
                super(1);
            }
        });
    }

    @Nullable
    public final SendResponse requestThreadControl(@NotNull String token, @NotNull RequestThreadControlRequest request) {
        SendResponse sendResponse;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            sendResponse = this.send(request, (Function1)new Function1<RequestThreadControlRequest, Response<SendResponse>>(this, token, request){
                final /* synthetic */ MessengerClient this$0;
                final /* synthetic */ String $token;
                final /* synthetic */ RequestThreadControlRequest $request;

                public final Response<SendResponse> invoke(@NotNull RequestThreadControlRequest it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Response response = MessengerClient.access$getGraphApi$p(this.this$0).requestThreadControl(this.$token, this.$request).execute();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.requestThreadCo\u2026token, request).execute()");
                    return response;
                }
                {
                    this.this$0 = messengerClient;
                    this.$token = string;
                    this.$request = requestThreadControlRequest;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            sendResponse = null;
        }
        return sendResponse;
    }

    @Nullable
    public final SendResponse takeThreadControl(@NotNull String token, @NotNull TakeThreadControlRequest request) {
        SendResponse sendResponse;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            sendResponse = this.send(request, (Function1)new Function1<TakeThreadControlRequest, Response<SendResponse>>(this, token, request){
                final /* synthetic */ MessengerClient this$0;
                final /* synthetic */ String $token;
                final /* synthetic */ TakeThreadControlRequest $request;

                public final Response<SendResponse> invoke(@NotNull TakeThreadControlRequest it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Response response = MessengerClient.access$getGraphApi$p(this.this$0).takeThreadControl(this.$token, this.$request).execute();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.takeThreadContr\u2026token, request).execute()");
                    return response;
                }
                {
                    this.this$0 = messengerClient;
                    this.$token = string;
                    this.$request = takeThreadControlRequest;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            sendResponse = null;
        }
        return sendResponse;
    }

    @Nullable
    public final SendResponse passThreadControl(@NotNull String token, @NotNull PassThreadControlRequest request) {
        SendResponse sendResponse;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            sendResponse = this.send(request, (Function1)new Function1<PassThreadControlRequest, Response<SendResponse>>(this, token, request){
                final /* synthetic */ MessengerClient this$0;
                final /* synthetic */ String $token;
                final /* synthetic */ PassThreadControlRequest $request;

                public final Response<SendResponse> invoke(@NotNull PassThreadControlRequest it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Response response = MessengerClient.access$getGraphApi$p(this.this$0).passThreadControl(this.$token, this.$request).execute();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"graphApi.passThreadContr\u2026token, request).execute()");
                    return response;
                }
                {
                    this.this$0 = messengerClient;
                    this.$token = string;
                    this.$request = passThreadControlRequest;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            sendResponse = null;
        }
        return sendResponse;
    }

    @Nullable
    public final String getThreadOwnerId(@NotNull String token, @NotNull String userId) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        try {
            Object object = (ThreadOwnerResponse)this.graphApi.threadOwner(token, userId).execute().body();
            string = object != null && (object = ((ThreadOwnerResponse)object).getData()) != null && (object = (ThreadOwnerData)CollectionsKt.firstOrNull((List)object)) != null && (object = ((ThreadOwnerData)object).getThreadOwner()) != null ? ((ThreadOwner)object).getAppId() : null;
        }
        catch (Exception e) {
            LoggersKt.warn((KLogger)this.logger, (Throwable)e);
            string = null;
        }
        return string;
    }

    @Nullable
    public final List<SecondaryReceiverData> getSecondaryReceivers(@NotNull String token) {
        List<SecondaryReceiverData> list;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        try {
            SecondaryReceiverResponse secondaryReceiverResponse = (SecondaryReceiverResponse)GraphApi.DefaultImpls.secondaryReceivers$default(this.graphApi, token, null, 2, null).execute().body();
            list = secondaryReceiverResponse != null ? secondaryReceiverResponse.getData() : null;
        }
        catch (Exception e) {
            LoggersKt.warn((KLogger)this.logger, (Throwable)e);
            list = null;
        }
        return list;
    }

    private final UserProfile defaultUserProfile() {
        return new UserProfile("", "", null, null, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UserProfile getUserProfile(@NotNull String token, @NotNull Recipient recipient) {
        UserProfile userProfile;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("messenger_user_profile");
        try {
            UserProfile userProfile2;
            String string = recipient.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((userProfile2 = (UserProfile)this.graphApi.getUserProfile(string, token, this.getProfileFields(this.extendedProfileFields)).execute().body()) == null) {
                userProfile2 = this.defaultUserProfile();
            }
            userProfile = userProfile2;
        }
        catch (Exception e) {
            this.logger.warn((Function0)new Function0<Recipient>(recipient){
                final /* synthetic */ Recipient $recipient;

                @NotNull
                public final Recipient invoke() {
                    return this.$recipient;
                }
                {
                    this.$recipient = recipient;
                    super(0);
                }
            });
            RequestTimerKt.logError((KLogger)this.logger, (Throwable)e, (RequestTimerData)requestTimerData);
            userProfile = this.defaultUserProfile();
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
        }
        return userProfile;
    }

    private final String getProfileFields(String extendedFields) {
        List standardFields = CollectionsKt.listOf((Object[])new String[]{"first_name", "last_name", "profile_pic"});
        CharSequence charSequence = extendedFields;
        boolean bl = false;
        return charSequence.length() > 0 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)standardFields, (Object)extendedFields), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : CollectionsKt.joinToString$default((Iterable)standardFields, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private final <T> SendResponse send(T request, Function1<? super T, Response<SendResponse>> call) {
        return this.send(request, call, 0);
    }

    private final <T> void warnRequest(T request, Function0<? extends Object> msg) {
        if (request instanceof ActionRequest) {
            this.logger.debug(msg);
        } else {
            this.logger.warn(msg);
        }
    }

    private final <T> Void throwError(T request, String errorMessage) {
        this.warnRequest(request, (Function0<? extends Object>)((Function0)new Function0<String>(request){
            final /* synthetic */ Object $request;

            public final String invoke() {
                return JacksonKt.getMapper().writeValueAsString(this.$request);
            }
            {
                this.$request = object;
                super(0);
            }
        }));
        throw (Throwable)new ConnectorException(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> SendResponse send(T request, Function1<? super T, Response<SendResponse>> call, int nbTries) {
        String string;
        RequestTimer requestTimer = BotRepository.INSTANCE.getRequestTimer();
        StringBuilder stringBuilder = new StringBuilder().append("messenger_send_");
        String string2 = request.getClass().getSimpleName();
        if (string2 != null) {
            String string3 = string2;
            StringBuilder stringBuilder2 = stringBuilder;
            RequestTimer requestTimer2 = requestTimer;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            String string6 = string5;
            requestTimer = requestTimer2;
            stringBuilder = stringBuilder2;
            string = string6;
        } else {
            string = null;
        }
        RequestTimerData requestTimerData = requestTimer.start(stringBuilder.append(string).toString());
        try {
            Response response;
            block15: {
                block16: {
                    block17: {
                        response = (Response)call.invoke(request);
                        if (response.isSuccessful()) break block15;
                        String error = response.message();
                        int errorCode = response.code();
                        this.warnRequest(request, (Function0<? extends Object>)((Function0)new Function0<String>(errorCode, error){
                            final /* synthetic */ int $errorCode;
                            final /* synthetic */ String $error;

                            @NotNull
                            public final String invoke() {
                                return "Messenger Error : " + this.$errorCode + ' ' + this.$error;
                            }
                            {
                                this.$errorCode = n;
                                this.$error = string;
                                super(0);
                            }
                        }));
                        ResponseBody responseBody = response.errorBody();
                        String errorBody = responseBody != null ? responseBody.string() : null;
                        this.warnRequest(request, (Function0<? extends Object>)((Function0)new Function0<String>(errorBody){
                            final /* synthetic */ String $errorBody;

                            @NotNull
                            public final String invoke() {
                                return "Messenger Error body : " + this.$errorBody;
                            }
                            {
                                this.$errorBody = string;
                                super(0);
                            }
                        }));
                        if (!(request instanceof MessageRequest) || nbTries > this.nbRetriesLimit || errorBody == null) break block16;
                        ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
                        boolean $i$f$readValue = false;
                        String string7 = errorBody;
                        ObjectMapper objectMapper = $this$readValue$iv;
                        boolean $i$f$jacksonTypeRef = false;
                        TypeReference typeReference = (TypeReference)new TypeReference<SendResponseErrorContainer>(){};
                        SendResponseErrorContainer errorContainer = (SendResponseErrorContainer)objectMapper.readValue(string7, typeReference);
                        if (errorContainer.getError() == null) break block16;
                        SendResponseError sendResponseError = errorContainer.getError();
                        boolean bl = false;
                        boolean bl2 = false;
                        SendResponseError $this$with = sendResponseError;
                        boolean bl3 = false;
                        Integer n = $this$with.getCode();
                        if (n != null && n == 1200) break block17;
                        Integer n2 = $this$with.getCode();
                        if (n2 != null && n2 == 613) break block17;
                        Integer n3 = $this$with.getCode();
                        if (n3 == null || n3 != 200) break block16;
                        Integer n4 = $this$with.getErrorSubcode();
                        if (n4 == null || n4 != 1545041) break block16;
                    }
                    this.logger.info((Function0)new Function0<String>(this, request, call, nbTries){
                        final /* synthetic */ MessengerClient this$0;
                        final /* synthetic */ Object $request$inlined;
                        final /* synthetic */ Function1 $call$inlined;
                        final /* synthetic */ int $nbTries$inlined;
                        {
                            this.this$0 = messengerClient;
                            this.$request$inlined = object;
                            this.$call$inlined = function1;
                            this.$nbTries$inlined = n;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Try to send again in " + MessengerClient.access$getNbRetriesWaitInMs$p(this.this$0) + " ms " + this.$request$inlined;
                        }
                    });
                    Thread.sleep(this.nbRetriesWaitInMs);
                    SendResponse sendResponse = this.send(request, call, nbTries + 1);
                    return sendResponse;
                }
                String string8 = response.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"response.message()");
                Void void_ = this.throwError(request, string8);
                throw null;
            }
            SendResponse sendResponse = (SendResponse)response.body();
            if (sendResponse == null) {
                Void void_ = this.throwError(request, "null body");
                throw null;
            }
            SendResponse sendResponse2 = sendResponse;
            return sendResponse2;
        }
        catch (Throwable e) {
            BotRepository.INSTANCE.getRequestTimer().throwable(e, requestTimerData);
            if (e instanceof ConnectorException) {
                throw e;
            }
            String string9 = e.getMessage();
            if (string9 == null) {
                string9 = "";
            }
            Void void_ = this.throwError(request, string9);
            throw null;
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
        }
    }

    @Nullable
    public final SubscriptionsResponse getSubscriptions(@NotNull String appId, @NotNull String appToken) {
        SubscriptionsResponse subscriptionsResponse;
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)appToken, (String)"appToken");
        try {
            subscriptionsResponse = (SubscriptionsResponse)this.graphApi.getSubscriptions(appId, appToken).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            subscriptionsResponse = null;
        }
        return subscriptionsResponse;
    }

    @Nullable
    public final SuccessResponse subscriptions(@NotNull String appId, @NotNull String callbackUrl, @NotNull String fields, @NotNull String verifyToken, @NotNull String appToken) {
        SuccessResponse successResponse;
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)callbackUrl, (String)"callbackUrl");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        Intrinsics.checkParameterIsNotNull((Object)verifyToken, (String)"verifyToken");
        Intrinsics.checkParameterIsNotNull((Object)appToken, (String)"appToken");
        try {
            if (Intrinsics.areEqual((Object)callbackUrl, (Object)"")) {
                throw (Throwable)new ConnectorException("No callback URL found to subscribe webhook");
            }
            successResponse = (SuccessResponse)this.graphApi.subscriptions(appId, "page", callbackUrl, fields, verifyToken, appToken).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            successResponse = null;
        }
        return successResponse;
    }

    @Nullable
    public final SuccessResponse deleteSubscribedApps(@NotNull String pageId, @NotNull String fields, @NotNull String token) {
        SuccessResponse successResponse;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        try {
            successResponse = (SuccessResponse)this.graphApi.deleteSubscribedApps(pageId, fields, token).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            successResponse = null;
        }
        return successResponse;
    }

    @Nullable
    public final SuccessResponse subscribedApps(@NotNull String pageId, @NotNull String fields, @NotNull String token) {
        SuccessResponse successResponse;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        try {
            successResponse = (SuccessResponse)this.graphApi.subscribedApps(pageId, fields, token).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            successResponse = null;
        }
        return successResponse;
    }

    @NotNull
    public final String getSecretKey() {
        return this.secretKey;
    }

    public MessengerClient(@NotNull String secretKey) {
        Retrofit $this$create$iv;
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        this.secretKey = secretKey;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.nbRetriesLimit = PropertiesKt.intProperty((String)"messenger_retries_on_error_limit", (int)1);
        this.nbRetriesWaitInMs = PropertiesKt.longProperty((String)"messenger_retries_on_error_wait_in_ms", (long)5000L);
        this.extendedProfileFields = PropertiesKt.property((String)"tock_messenger_extended_profile_fields", (String)"");
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_messenger_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, null, (boolean)PropertiesKt.booleanProperty((String)"tock_messenger_request_gzip", (boolean)true), (boolean)false, null, (int)108, null).baseUrl("https://graph.facebook.com");
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"retrofitBuilderWithTimeo\u2026ps://graph.facebook.com\")");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder, null, (int)1, null).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        Retrofit retrofit2 = retrofit;
        MessengerClient messengerClient = this;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(GraphApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"create(T::class.java)");
        Object object2 = object;
        messengerClient.graphApi = (GraphApi)object2;
        Retrofit retrofit3 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_messenger_request_timeout_ms", (long)5000L), (KLogger)this.logger, (Level)Level.BASIC, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl("https://www.facebook.com").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit3, (String)"retrofitBuilderWithTimeo\u2026om\")\n            .build()");
        $this$create$iv = retrofit3;
        messengerClient = this;
        $i$f$create = false;
        Object object3 = $this$create$iv.create(StatusApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"create(T::class.java)");
        object2 = object3;
        messengerClient.statusApi = (StatusApi)object2;
    }

    public static final /* synthetic */ GraphApi access$getGraphApi$p(MessengerClient $this) {
        return $this.graphApi;
    }

    public static final /* synthetic */ long access$getNbRetriesWaitInMs$p(MessengerClient $this) {
        return $this.nbRetriesWaitInMs;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H'J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\b\b\u0001\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H'J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0006H'J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u0014H'J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u0016H'J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0003\u0010\u0019\u001a\u00020\u0006H'J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u001b\u001a\u00020\u001cH'J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u001e\u001a\u00020\u001fH'J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010!\u001a\u00020\"H'J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010$\u001a\u00020%H'J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H'JJ\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010(\u001a\u00020\u00062\b\b\u0001\u0010)\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u00062\b\b\u0001\u0010*\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H'J\"\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020,H'J\"\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00032\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u0019\u001a\u00020\u0006H'\u00a8\u0006/"}, d2={"Lai/tock/bot/connector/messenger/MessengerClient$GraphApi;", "", "deleteSubscribedApps", "Lretrofit2/Call;", "Lai/tock/bot/connector/messenger/model/subscription/SuccessResponse;", "pageId", "", "subscribedFields", "accessToken", "getSubscriptions", "Lai/tock/bot/connector/messenger/model/subscription/SubscriptionsResponse;", "appId", "appAccessToken", "getUserProfile", "Lai/tock/bot/connector/messenger/model/UserProfile;", "userId", "fields", "passThreadControl", "Lai/tock/bot/connector/messenger/model/send/SendResponse;", "request", "Lai/tock/bot/connector/messenger/model/handover/PassThreadControlRequest;", "requestThreadControl", "Lai/tock/bot/connector/messenger/model/handover/RequestThreadControlRequest;", "secondaryReceivers", "Lai/tock/bot/connector/messenger/model/handover/SecondaryReceiverResponse;", "recipient", "sendAction", "actionRequest", "Lai/tock/bot/connector/messenger/model/send/ActionRequest;", "sendAttachment", "attachmentRequest", "Lai/tock/bot/connector/messenger/model/attachment/AttachmentRequest;", "sendCustomEvent", "customEventRequest", "Lai/tock/bot/connector/messenger/model/send/CustomEventRequest;", "sendMessage", "messageRequest", "Lai/tock/bot/connector/messenger/model/send/MessageRequest;", "subscribedApps", "subscriptions", "obj", "callbackUrl", "verifyToken", "takeThreadControl", "Lai/tock/bot/connector/messenger/model/handover/TakeThreadControlRequest;", "threadOwner", "Lai/tock/bot/connector/messenger/model/handover/ThreadOwnerResponse;", "tock-bot-connector-messenger"})
    public static interface GraphApi {
        @POST(value="/v5.0/me/messages")
        @NotNull
        public Call<SendResponse> sendMessage(@Query(value="access_token") @NotNull String var1, @Body @NotNull MessageRequest var2);

        @POST(value="/v5.0/me/messages")
        @NotNull
        public Call<SendResponse> sendAction(@Query(value="access_token") @NotNull String var1, @Body @NotNull ActionRequest var2);

        @GET(value="/v5.0/{userId}/")
        @NotNull
        public Call<UserProfile> getUserProfile(@Path(value="userId") @NotNull String var1, @Query(value="access_token") @NotNull String var2, @Query(value="fields") @NotNull String var3);

        @POST(value="/v5.0/me/message_attachments")
        @NotNull
        public Call<SendResponse> sendAttachment(@Query(value="access_token") @NotNull String var1, @Body @NotNull AttachmentRequest var2);

        @POST(value="/v5.0/me/pass_thread_control")
        @NotNull
        public Call<SendResponse> passThreadControl(@Query(value="access_token") @NotNull String var1, @Body @NotNull PassThreadControlRequest var2);

        @POST(value="/v5.0/me/take_thread_control")
        @NotNull
        public Call<SendResponse> takeThreadControl(@Query(value="access_token") @NotNull String var1, @Body @NotNull TakeThreadControlRequest var2);

        @POST(value="/v5.0/me/request_thread_control")
        @NotNull
        public Call<SendResponse> requestThreadControl(@Query(value="access_token") @NotNull String var1, @Body @NotNull RequestThreadControlRequest var2);

        @GET(value="/v5.0/me/secondary_receivers")
        @NotNull
        public Call<SecondaryReceiverResponse> secondaryReceivers(@Query(value="access_token") @NotNull String var1, @Query(value="fields") @NotNull String var2);

        @GET(value="/v5.0/me/thread_owner")
        @NotNull
        public Call<ThreadOwnerResponse> threadOwner(@Query(value="access_token") @NotNull String var1, @Query(value="recipient") @NotNull String var2);

        @POST(value="/{appId}/activities")
        @NotNull
        public Call<SendResponse> sendCustomEvent(@Path(value="appId") @NotNull String var1, @Body @NotNull CustomEventRequest var2);

        @GET(value="/v5.0/{appId}/subscriptions")
        @NotNull
        public Call<SubscriptionsResponse> getSubscriptions(@Path(value="appId") @NotNull String var1, @Query(value="access_token") @NotNull String var2);

        @POST(value="/v5.0/{appId}/subscriptions")
        @NotNull
        public Call<SuccessResponse> subscriptions(@Path(value="appId") @NotNull String var1, @Query(value="object") @NotNull String var2, @Query(value="callback_url") @NotNull String var3, @Query(value="fields") @NotNull String var4, @Query(value="verify_token") @NotNull String var5, @Query(value="access_token") @NotNull String var6);

        @DELETE(value="/v5.0/{pageId}/subscribed_apps")
        @NotNull
        public Call<SuccessResponse> deleteSubscribedApps(@Path(value="pageId") @NotNull String var1, @Query(value="subscribed_fields") @NotNull String var2, @Query(value="access_token") @NotNull String var3);

        @POST(value="/v5.0/{pageId}/subscribed_apps")
        @NotNull
        public Call<SuccessResponse> subscribedApps(@Path(value="pageId") @NotNull String var1, @Query(value="subscribed_fields") @NotNull String var2, @Query(value="access_token") @NotNull String var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ Call secondaryReceivers$default(GraphApi graphApi, String string, String string2, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: secondaryReceivers");
                }
                if ((n & 2) != 0) {
                    string2 = "id,name";
                }
                return graphApi.secondaryReceivers(string, string2);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/messenger/MessengerClient$StatusApi;", "", "status", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "tock-bot-connector-messenger"})
    public static interface StatusApi {
        @GET(value="/platform/api-status")
        @NotNull
        public Call<ResponseBody> status();
    }
}

