/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.messenger;

import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.messenger.WebhookActionConverter;
import ai.tock.bot.connector.messenger.model.handover.AppRolesWebhook;
import ai.tock.bot.connector.messenger.model.handover.PassThreadControlWebhook;
import ai.tock.bot.connector.messenger.model.handover.RequestThreadControlWebhook;
import ai.tock.bot.connector.messenger.model.handover.TakeThreadControlWebhook;
import ai.tock.bot.connector.messenger.model.webhook.AccountLinkingStatus;
import ai.tock.bot.connector.messenger.model.webhook.AccountLinkingWebhook;
import ai.tock.bot.connector.messenger.model.webhook.Attachment;
import ai.tock.bot.connector.messenger.model.webhook.AttachmentType;
import ai.tock.bot.connector.messenger.model.webhook.LocationPayload;
import ai.tock.bot.connector.messenger.model.webhook.Message;
import ai.tock.bot.connector.messenger.model.webhook.MessageWebhook;
import ai.tock.bot.connector.messenger.model.webhook.OptinWebhook;
import ai.tock.bot.connector.messenger.model.webhook.PostbackWebhook;
import ai.tock.bot.connector.messenger.model.webhook.Referral;
import ai.tock.bot.connector.messenger.model.webhook.ReferralParametersWebhook;
import ai.tock.bot.connector.messenger.model.webhook.UrlPayload;
import ai.tock.bot.connector.messenger.model.webhook.UserActionPayload;
import ai.tock.bot.connector.messenger.model.webhook.Webhook;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendChoice;
import ai.tock.bot.engine.action.SendLocation;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.AppRole;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.GetAppRolesEvent;
import ai.tock.bot.engine.event.LoginEvent;
import ai.tock.bot.engine.event.LogoutEvent;
import ai.tock.bot.engine.event.OneToOneEvent;
import ai.tock.bot.engine.event.PassThreadControlEvent;
import ai.tock.bot.engine.event.ReferralParametersEvent;
import ai.tock.bot.engine.event.RequestThreadControlEvent;
import ai.tock.bot.engine.event.SubscribingEvent;
import ai.tock.bot.engine.event.TakeThreadControlEvent;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.IdsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/tock/bot/connector/messenger/WebhookActionConverter;", "", "()V", "logger", "Lmu/KLogger;", "readAttachment", "Lai/tock/bot/engine/action/SendAttachment;", "message", "Lai/tock/bot/connector/messenger/model/webhook/MessageWebhook;", "attachment", "Lai/tock/bot/connector/messenger/model/webhook/Attachment;", "applicationId", "", "attachmentType", "Lai/tock/bot/engine/action/SendAttachment$AttachmentType;", "readLocation", "Lai/tock/bot/engine/action/SendLocation;", "readSentence", "Lai/tock/bot/engine/action/SendSentence;", "toEvent", "Lai/tock/bot/engine/event/Event;", "Lai/tock/bot/connector/messenger/model/webhook/Webhook;", "tock-bot-connector-messenger"})
public final class WebhookActionConverter {
    @NotNull
    public static final WebhookActionConverter INSTANCE = new WebhookActionConverter();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    private WebhookActionConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Event toEvent(@NotNull Webhook message, @NotNull String applicationId) {
        Event event;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Webhook webhook = message;
        if (webhook instanceof MessageWebhook) {
            Action action;
            Message message2 = ((MessageWebhook)message).getMessage();
            boolean bl = false;
            boolean bl2 = false;
            Message $this$toEvent_u24lambda_u2d1 = message2;
            boolean bl3 = false;
            if ($this$toEvent_u24lambda_u2d1.getQuickReply() != null) {
                UserActionPayload userActionPayload = $this$toEvent_u24lambda_u2d1.getQuickReply();
                Intrinsics.checkNotNull((Object)userActionPayload);
                if (userActionPayload.hasEmailPayloadFromMessenger()) {
                    action = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                } else {
                    UserActionPayload userActionPayload2 = $this$toEvent_u24lambda_u2d1.getQuickReply();
                    if (userActionPayload2 == null) {
                        action = null;
                    } else {
                        String string = userActionPayload2.getPayload();
                        if (string == null) {
                            action = null;
                        } else {
                            String string2 = string;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String payload = string2;
                            boolean bl6 = false;
                            action = SendChoice.Companion.decodeChoice$default((SendChoice.Companion)SendChoice.Companion, (String)payload, (PlayerId)message.playerId(PlayerType.user), (String)applicationId, (PlayerId)message.recipientId(PlayerType.bot), null, (int)16, null);
                        }
                    }
                }
            } else {
                List<Attachment> a = $this$toEvent_u24lambda_u2d1.getAttachments();
                Collection collection = a;
                boolean bl7 = false;
                if (!collection.isEmpty()) {
                    Attachment first = (Attachment)CollectionsKt.first(a);
                    AttachmentType attachmentType = first.getType();
                    int n = WhenMappings.$EnumSwitchMapping$0[attachmentType.ordinal()];
                    switch (n) {
                        case 1: {
                            action = (Action)INSTANCE.readLocation((MessageWebhook)message, first, applicationId);
                            break;
                        }
                        case 2: {
                            action = (Action)INSTANCE.readAttachment((MessageWebhook)message, first, applicationId, SendAttachment.AttachmentType.image);
                            break;
                        }
                        case 3: {
                            action = (Action)INSTANCE.readAttachment((MessageWebhook)message, first, applicationId, SendAttachment.AttachmentType.audio);
                            break;
                        }
                        default: {
                            action = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                            break;
                        }
                    }
                } else {
                    action = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                }
            }
            event = (Event)action;
        } else if (webhook instanceof PostbackWebhook) {
            Action action;
            String string = ((PostbackWebhook)message).getPostback().getPayload();
            if (string == null) {
                action = null;
            } else {
                Referral first;
                String string3 = string;
                boolean bl = false;
                boolean $this$toEvent_u24lambda_u2d1 = false;
                String payload = string3;
                boolean bl8 = false;
                action = SendChoice.Companion.decodeChoice(payload, message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), (first = ((PostbackWebhook)message).getPostback().getReferral()) == null ? null : first.getRef());
            }
            event = (Event)action;
        } else if (webhook instanceof OptinWebhook) {
            event = (Event)new SubscribingEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), ((OptinWebhook)message).getOptin().getRef(), applicationId);
        } else if (webhook instanceof AccountLinkingWebhook) {
            OneToOneEvent oneToOneEvent;
            AccountLinkingStatus accountLinkingStatus = ((AccountLinkingWebhook)message).getAccountLinking().getStatus();
            int n = WhenMappings.$EnumSwitchMapping$1[accountLinkingStatus.ordinal()];
            switch (n) {
                case 1: {
                    PlayerId playerId = message.playerId(PlayerType.user);
                    PlayerId playerId2 = message.recipientId(PlayerType.bot);
                    String string = ((AccountLinkingWebhook)message).getAccountLinking().getAuthorizationCode();
                    Intrinsics.checkNotNull((Object)string);
                    oneToOneEvent = (OneToOneEvent)new LoginEvent(playerId, playerId2, string, applicationId, null, false, 48, null);
                    break;
                }
                case 2: {
                    oneToOneEvent = (OneToOneEvent)new LogoutEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            event = (Event)oneToOneEvent;
        } else if (webhook instanceof AppRolesWebhook) {
            Map map;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<String, List<String>> map2 = ((AppRolesWebhook)message).getAppRoles();
            String string = applicationId;
            PlayerId playerId = message.recipientId(PlayerType.bot);
            boolean $i$f$mapValues = false;
            void var6_14 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map = map3;
                boolean bl9 = false;
                Iterable $this$mapNotNull$iv = (Iterable)it.getValue();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    AppRole appRole;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = iterator.next();
                    boolean bl10 = false;
                    String it2 = (String)element$iv$iv;
                    boolean bl11 = false;
                    String string4 = it2;
                    if (Intrinsics.areEqual((Object)string4, (Object)"primary_receiver")) {
                        appRole = AppRole.primaryReceiver;
                    } else if (Intrinsics.areEqual((Object)string4, (Object)"secondary_receiver")) {
                        appRole = AppRole.secondaryReceiver;
                    } else {
                        logger.warn((Function0)new Function0<Object>(it2){
                            final /* synthetic */ String $it;
                            {
                                this.$it = $it;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return Intrinsics.stringPlus((String)"unknown role ", (Object)this.$it);
                            }
                        });
                        appRole = null;
                    }
                    if (appRole == null) continue;
                    AppRole appRole2 = appRole;
                    boolean bl12 = false;
                    boolean bl13 = false;
                    AppRole it$iv$iv2 = appRole2;
                    boolean bl14 = false;
                    destination$iv$iv2.add(it$iv$iv2);
                }
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                map.put(k2, set);
            }
            Map map4 = map = destination$iv$iv;
            String string5 = string;
            PlayerId playerId3 = playerId;
            event = (Event)new GetAppRolesEvent(playerId3, string5, map4);
        } else if (webhook instanceof RequestThreadControlWebhook) {
            event = (Event)new RequestThreadControlEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((RequestThreadControlWebhook)message).getRequestThreadControl().getRequestOwnerAppId(), ((RequestThreadControlWebhook)message).getRequestThreadControl().getMetadata());
        } else if (webhook instanceof PassThreadControlWebhook) {
            event = (Event)new PassThreadControlEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((PassThreadControlWebhook)message).getPassThreadControl().getNewOwnerAppId(), ((PassThreadControlWebhook)message).getPassThreadControl().getMetadata());
        } else if (webhook instanceof TakeThreadControlWebhook) {
            event = (Event)new TakeThreadControlEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((TakeThreadControlWebhook)message).getTakeThreadControl().getPreviousOwnerAppId(), ((TakeThreadControlWebhook)message).getTakeThreadControl().getMetadata());
        } else if (webhook instanceof ReferralParametersWebhook) {
            event = (Event)new ReferralParametersEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((ReferralParametersWebhook)message).getReferral().getRef());
        } else {
            logger.error((Function0)new Function0<Object>(message){
                final /* synthetic */ Webhook $message;
                {
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"unknown message ", (Object)this.$message);
                }
            });
            event = null;
        }
        return event;
    }

    private final SendSentence readSentence(MessageWebhook message, String applicationId) {
        Object[] objectArray = message.getMessage().getText();
        Object object = objectArray == null ? "" : objectArray;
        objectArray = new ConnectorMessage[]{message};
        return new SendSentence(message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), (CharSequence)object, CollectionsKt.mutableListOf((Object[])objectArray), IdsKt.toId((String)message.getMessageId()), null, null, null, null, null, 1984, null);
    }

    private final SendLocation readLocation(MessageWebhook message, Attachment attachment2, String applicationId) {
        logger.debug((Function0)new Function0<Object>(attachment2){
            final /* synthetic */ Attachment $attachment;
            {
                this.$attachment = $attachment;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"read location attachment : ", (Object)this.$attachment);
            }
        });
        return new SendLocation(message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), ((LocationPayload)attachment2.getPayload()).getCoordinates().toUserLocation(), IdsKt.toId((String)message.getMessageId()), null, null, null, 224, null);
    }

    private final SendAttachment readAttachment(MessageWebhook message, Attachment attachment2, String applicationId, SendAttachment.AttachmentType attachmentType) {
        logger.debug((Function0)new Function0<Object>(attachment2){
            final /* synthetic */ Attachment $attachment;
            {
                this.$attachment = $attachment;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"read attachment : ", (Object)this.$attachment);
            }
        });
        return new SendAttachment(message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), ((UrlPayload)attachment2.getPayload()).getUrl(), attachmentType, IdsKt.toId((String)message.getMessageId()), null, null, null, 448, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AttachmentType.values().length];
            nArray[AttachmentType.location.ordinal()] = 1;
            nArray[AttachmentType.image.ordinal()] = 2;
            nArray[AttachmentType.audio.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AccountLinkingStatus.values().length];
            nArray[AccountLinkingStatus.linked.ordinal()] = 1;
            nArray[AccountLinkingStatus.unlinked.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

