/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.messenger;

import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.messenger.MessengerConnectorProvider;
import ai.tock.bot.connector.messenger.model.Recipient;
import ai.tock.bot.connector.messenger.model.send.Attachment;
import ai.tock.bot.connector.messenger.model.send.AttachmentMessage;
import ai.tock.bot.connector.messenger.model.send.AttachmentType;
import ai.tock.bot.connector.messenger.model.send.Message;
import ai.tock.bot.connector.messenger.model.send.MessageRequest;
import ai.tock.bot.connector.messenger.model.send.MessageTag;
import ai.tock.bot.connector.messenger.model.send.MessagingType;
import ai.tock.bot.connector.messenger.model.send.NotificationType;
import ai.tock.bot.connector.messenger.model.send.TextMessage;
import ai.tock.bot.connector.messenger.model.send.UrlPayload;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendSentence;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/tock/bot/connector/messenger/SendActionConverter;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "toMessageRequest", "Lai/tock/bot/connector/messenger/model/send/MessageRequest;", "action", "Lai/tock/bot/engine/action/Action;", "personaId", "", "tock-bot-connector-messenger"})
public final class SendActionConverter {
    @NotNull
    public static final SendActionConverter INSTANCE = new SendActionConverter();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(SendActionConverter::logger$lambda$0);

    private SendActionConverter() {
    }

    @Nullable
    public final MessageRequest toMessageRequest(@NotNull Action action, @Nullable String personaId) {
        MessageRequest messageRequest;
        Message message;
        Message message2;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Action action2 = action;
        if (action2 instanceof SendSentence) {
            if (((SendSentence)action).hasMessage(MessengerConnectorProvider.INSTANCE.getConnectorType())) {
                ConnectorMessage connectorMessage = ((SendSentence)action).message(MessengerConnectorProvider.INSTANCE.getConnectorType());
                Intrinsics.checkNotNull((Object)connectorMessage, (String)"null cannot be cast to non-null type ai.tock.bot.connector.messenger.model.send.Message");
                message2 = (Message)connectorMessage;
            } else {
                String string = ((SendSentence)action).getStringText();
                if (string == null) {
                    string = "";
                }
                message2 = new TextMessage(string, null, 2, null);
            }
        } else if (action2 instanceof SendAttachment) {
            message2 = new AttachmentMessage(new Attachment(AttachmentType.Companion.fromTockAttachmentType(((SendAttachment)action).getType()), UrlPayload.Companion.getUrlPayload((SendAttachment)action)), null, 2, null);
        } else {
            logger.warn(() -> SendActionConverter.toMessageRequest$lambda$1(action));
            message2 = message = null;
        }
        if (message != null) {
            Message it = message;
            boolean bl = false;
            MessageTag messageTag = MessageTag.Companion.toMessageTag(action);
            messageRequest = new MessageRequest(new Recipient(action.getRecipientId().getId(), null, 2, null), it, messageTag == null ? MessagingType.RESPONSE : MessagingType.MESSAGE_TAG, NotificationType.Companion.toNotificationType(action), messageTag, personaId);
        } else {
            messageRequest = null;
        }
        return messageRequest;
    }

    public static /* synthetic */ MessageRequest toMessageRequest$default(SendActionConverter sendActionConverter, Action action, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sendActionConverter.toMessageRequest(action, string);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object toMessageRequest$lambda$1(Action $action) {
        return "action not supported : " + $action + " ";
    }
}

