/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.messenger;

import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.messenger.model.handover.AppRolesWebhook;
import ai.tock.bot.connector.messenger.model.handover.PassThreadControlWebhook;
import ai.tock.bot.connector.messenger.model.handover.RequestThreadControlWebhook;
import ai.tock.bot.connector.messenger.model.handover.TakeThreadControlWebhook;
import ai.tock.bot.connector.messenger.model.webhook.AccountLinkingStatus;
import ai.tock.bot.connector.messenger.model.webhook.AccountLinkingWebhook;
import ai.tock.bot.connector.messenger.model.webhook.Attachment;
import ai.tock.bot.connector.messenger.model.webhook.AttachmentType;
import ai.tock.bot.connector.messenger.model.webhook.LocationPayload;
import ai.tock.bot.connector.messenger.model.webhook.Message;
import ai.tock.bot.connector.messenger.model.webhook.MessageWebhook;
import ai.tock.bot.connector.messenger.model.webhook.OptinWebhook;
import ai.tock.bot.connector.messenger.model.webhook.Payload;
import ai.tock.bot.connector.messenger.model.webhook.PostbackWebhook;
import ai.tock.bot.connector.messenger.model.webhook.Referral;
import ai.tock.bot.connector.messenger.model.webhook.ReferralParametersWebhook;
import ai.tock.bot.connector.messenger.model.webhook.UrlPayload;
import ai.tock.bot.connector.messenger.model.webhook.UserActionPayload;
import ai.tock.bot.connector.messenger.model.webhook.Webhook;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendChoice;
import ai.tock.bot.engine.action.SendLocation;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.AppRole;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.GetAppRolesEvent;
import ai.tock.bot.engine.event.LoginEvent;
import ai.tock.bot.engine.event.LogoutEvent;
import ai.tock.bot.engine.event.OneToOneEvent;
import ai.tock.bot.engine.event.PassThreadControlEvent;
import ai.tock.bot.engine.event.ReferralParametersEvent;
import ai.tock.bot.engine.event.RequestThreadControlEvent;
import ai.tock.bot.engine.event.SubscribingEvent;
import ai.tock.bot.engine.event.TakeThreadControlEvent;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.IdsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/tock/bot/connector/messenger/WebhookActionConverter;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "toEvent", "Lai/tock/bot/engine/event/Event;", "message", "Lai/tock/bot/connector/messenger/model/webhook/Webhook;", "applicationId", "", "readSentence", "Lai/tock/bot/engine/action/SendSentence;", "Lai/tock/bot/connector/messenger/model/webhook/MessageWebhook;", "readLocation", "Lai/tock/bot/engine/action/SendLocation;", "attachment", "Lai/tock/bot/connector/messenger/model/webhook/Attachment;", "readAttachment", "Lai/tock/bot/engine/action/SendAttachment;", "attachmentType", "Lai/tock/bot/engine/action/SendAttachment$AttachmentType;", "tock-bot-connector-messenger"})
@SourceDebugExtension(value={"SMAP\nWebhookActionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookActionConverter.kt\nai/tock/bot/connector/messenger/WebhookActionConverter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n462#2:233\n412#2:234\n1246#3,2:235\n1611#3,9:237\n1863#3:246\n1864#3:248\n1620#3:249\n1249#3:250\n1#4:247\n*S KotlinDebug\n*F\n+ 1 WebhookActionConverter.kt\nai/tock/bot/connector/messenger/WebhookActionConverter\n*L\n136#1:233\n136#1:234\n136#1:235,2\n137#1:237,9\n137#1:246\n137#1:248\n137#1:249\n136#1:250\n137#1:247\n*E\n"})
public final class WebhookActionConverter {
    @NotNull
    public static final WebhookActionConverter INSTANCE = new WebhookActionConverter();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(WebhookActionConverter::logger$lambda$0);

    private WebhookActionConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Event toEvent(@NotNull Webhook message, @NotNull String applicationId) {
        Event event;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Webhook webhook = message;
        if (webhook instanceof MessageWebhook) {
            Action action;
            Message $this$toEvent_u24lambda_u242 = ((MessageWebhook)message).getMessage();
            boolean bl = false;
            if ($this$toEvent_u24lambda_u242.getQuickReply() != null) {
                UserActionPayload userActionPayload = $this$toEvent_u24lambda_u242.getQuickReply();
                Intrinsics.checkNotNull((Object)userActionPayload);
                if (userActionPayload.hasEmailPayloadFromMessenger()) {
                    action = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                } else {
                    String string;
                    UserActionPayload userActionPayload2 = $this$toEvent_u24lambda_u242.getQuickReply();
                    if (userActionPayload2 != null && (string = userActionPayload2.getPayload()) != null) {
                        String payload = string;
                        boolean bl2 = false;
                        action = SendChoice.Companion.decodeChoice$default((SendChoice.Companion)SendChoice.Companion, (String)payload, (PlayerId)message.playerId(PlayerType.user), (String)applicationId, (PlayerId)message.recipientId(PlayerType.bot), null, (int)16, null);
                    } else {
                        action = null;
                    }
                }
            } else {
                List<Attachment> a = $this$toEvent_u24lambda_u242.getAttachments();
                if (!((Collection)a).isEmpty()) {
                    Attachment first = (Attachment)CollectionsKt.first(a);
                    switch (WhenMappings.$EnumSwitchMapping$0[first.getType().ordinal()]) {
                        case 1: {
                            action = (Action)INSTANCE.readLocation((MessageWebhook)message, first, applicationId);
                            break;
                        }
                        case 2: {
                            action = (Action)INSTANCE.readAttachment((MessageWebhook)message, first, applicationId, SendAttachment.AttachmentType.image);
                            break;
                        }
                        case 3: {
                            action = (Action)INSTANCE.readAttachment((MessageWebhook)message, first, applicationId, SendAttachment.AttachmentType.audio);
                            break;
                        }
                        default: {
                            action = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                            break;
                        }
                    }
                } else {
                    action = (Action)INSTANCE.readSentence((MessageWebhook)message, applicationId);
                }
            }
            event = (Event)action;
        } else if (webhook instanceof PostbackWebhook) {
            Action action;
            String string = ((PostbackWebhook)message).getPostback().getPayload();
            if (string != null) {
                String payload = string;
                boolean bl = false;
                Referral referral = ((PostbackWebhook)message).getPostback().getReferral();
                action = SendChoice.Companion.decodeChoice(payload, message.playerId(PlayerType.user), applicationId, message.recipientId(PlayerType.bot), referral != null ? referral.getRef() : null);
            } else {
                action = null;
            }
            event = (Event)action;
        } else if (webhook instanceof OptinWebhook) {
            event = (Event)new SubscribingEvent(((OptinWebhook)message).playerId(PlayerType.user), message.recipientId(PlayerType.bot), ((OptinWebhook)message).getOptin().getRef(), applicationId);
        } else if (webhook instanceof AccountLinkingWebhook) {
            OneToOneEvent oneToOneEvent;
            switch (WhenMappings.$EnumSwitchMapping$1[((AccountLinkingWebhook)message).getAccountLinking().getStatus().ordinal()]) {
                case 1: {
                    PlayerId playerId = message.playerId(PlayerType.user);
                    PlayerId playerId2 = message.recipientId(PlayerType.bot);
                    String string = ((AccountLinkingWebhook)message).getAccountLinking().getAuthorizationCode();
                    Intrinsics.checkNotNull((Object)string);
                    oneToOneEvent = (OneToOneEvent)new LoginEvent(playerId, playerId2, string, applicationId, null, false, 48, null);
                    break;
                }
                case 2: {
                    oneToOneEvent = (OneToOneEvent)new LogoutEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            event = (Event)oneToOneEvent;
        } else if (webhook instanceof AppRolesWebhook) {
            Map map;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<String, List<String>> map2 = ((AppRolesWebhook)message).getAppRoles();
            String string = applicationId;
            PlayerId playerId = message.recipientId(PlayerType.bot);
            boolean $i$f$mapValues = false;
            void payload = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map = map3;
                boolean bl3 = false;
                Iterable $this$mapNotNull$iv = (Iterable)it.getValue();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    AppRole appRole;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = iterator.next();
                    boolean bl4 = false;
                    String it2 = (String)element$iv$iv;
                    boolean bl5 = false;
                    String string2 = it2;
                    if (Intrinsics.areEqual((Object)string2, (Object)"primary_receiver")) {
                        appRole = AppRole.primaryReceiver;
                    } else if (Intrinsics.areEqual((Object)string2, (Object)"secondary_receiver")) {
                        appRole = AppRole.secondaryReceiver;
                    } else {
                        logger.warn(() -> WebhookActionConverter.toEvent$lambda$6$lambda$5$lambda$4(it2));
                        appRole = null;
                    }
                    if (appRole == null) continue;
                    AppRole it$iv$iv2 = appRole;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv2);
                }
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                map.put(k, set);
            }
            Map map4 = map = destination$iv$iv;
            String string3 = string;
            PlayerId playerId3 = playerId;
            event = (Event)new GetAppRolesEvent(playerId3, string3, map4);
        } else if (webhook instanceof RequestThreadControlWebhook) {
            event = (Event)new RequestThreadControlEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((RequestThreadControlWebhook)message).getRequestThreadControl().getRequestOwnerAppId(), ((RequestThreadControlWebhook)message).getRequestThreadControl().getMetadata());
        } else if (webhook instanceof PassThreadControlWebhook) {
            event = (Event)new PassThreadControlEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((PassThreadControlWebhook)message).getPassThreadControl().getNewOwnerAppId(), ((PassThreadControlWebhook)message).getPassThreadControl().getMetadata());
        } else if (webhook instanceof TakeThreadControlWebhook) {
            event = (Event)new TakeThreadControlEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((TakeThreadControlWebhook)message).getTakeThreadControl().getPreviousOwnerAppId(), ((TakeThreadControlWebhook)message).getTakeThreadControl().getMetadata());
        } else if (webhook instanceof ReferralParametersWebhook) {
            event = (Event)new ReferralParametersEvent(message.playerId(PlayerType.user), message.recipientId(PlayerType.bot), applicationId, ((ReferralParametersWebhook)message).getReferral().getRef());
        } else {
            logger.error(() -> WebhookActionConverter.toEvent$lambda$7(message));
            event = null;
        }
        return event;
    }

    private final SendSentence readSentence(MessageWebhook message, String applicationId) {
        PlayerId playerId = message.playerId(PlayerType.user);
        PlayerId playerId2 = message.recipientId(PlayerType.bot);
        String string = message.getMessage().getText();
        if (string == null) {
            string = "";
        }
        Object[] objectArray = new ConnectorMessage[]{message};
        return new SendSentence(playerId, applicationId, playerId2, (CharSequence)string, CollectionsKt.mutableListOf((Object[])objectArray), IdsKt.toId((String)message.getMessageId()), null, null, null, null, null, 1984, null);
    }

    private final SendLocation readLocation(MessageWebhook message, Attachment attachment, String applicationId) {
        logger.debug(() -> WebhookActionConverter.readLocation$lambda$8(attachment));
        PlayerId playerId = message.playerId(PlayerType.user);
        PlayerId playerId2 = message.recipientId(PlayerType.bot);
        Payload payload = attachment.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type ai.tock.bot.connector.messenger.model.webhook.LocationPayload");
        return new SendLocation(playerId, applicationId, playerId2, ((LocationPayload)payload).getCoordinates().toUserLocation(), IdsKt.toId((String)message.getMessageId()), null, null, null, 224, null);
    }

    private final SendAttachment readAttachment(MessageWebhook message, Attachment attachment, String applicationId, SendAttachment.AttachmentType attachmentType) {
        logger.debug(() -> WebhookActionConverter.readAttachment$lambda$9(attachment));
        PlayerId playerId = message.playerId(PlayerType.user);
        PlayerId playerId2 = message.recipientId(PlayerType.bot);
        Payload payload = attachment.getPayload();
        Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type ai.tock.bot.connector.messenger.model.webhook.UrlPayload");
        return new SendAttachment(playerId, applicationId, playerId2, ((UrlPayload)payload).getUrl(), attachmentType, IdsKt.toId((String)message.getMessageId()), null, null, null, 448, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object toEvent$lambda$6$lambda$5$lambda$4(String $it) {
        return "unknown role " + $it;
    }

    private static final Object toEvent$lambda$7(Webhook $message) {
        return "unknown message " + $message;
    }

    private static final Object readLocation$lambda$8(Attachment $attachment) {
        return "read location attachment : " + $attachment;
    }

    private static final Object readAttachment$lambda$9(Attachment $attachment) {
        return "read attachment : " + $attachment;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AttachmentType.values().length];
            try {
                nArray[AttachmentType.location.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttachmentType.image.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttachmentType.audio.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AccountLinkingStatus.values().length];
            try {
                nArray[AccountLinkingStatus.linked.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccountLinkingStatus.unlinked.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

