/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.rest;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.connector.Connector;
import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorFeature;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.rest.RestConnectorCallback;
import ai.tock.bot.connector.rest.model.MessageRequest;
import ai.tock.bot.connector.rest.model.MessageResponse;
import ai.tock.bot.definition.TestBehaviour;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.message.Choice;
import ai.tock.bot.engine.message.GenericMessage;
import ai.tock.bot.engine.message.Message;
import ai.tock.bot.engine.message.Sentence;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.security.RequestFilter;
import ai.tock.shared.vertx.VertXsKt;
import ai.tock.translator.UserInterfaceType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J1\u0010&\u001a\u0015\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010)0'\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.H\u0016J1\u0010&\u001a\u0015\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010)0'\u00a2\u0006\u0002\b*2\u0006\u0010\u0017\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.H\u0016J'\u0010/\u001a\u0019\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0.0'\u00a2\u0006\u0002\b*2\u0006\u0010\u0017\u001a\u000200H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/tock/bot/connector/rest/RestConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "requestFilter", "Lai/tock/shared/security/RequestFilter;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lai/tock/shared/security/RequestFilter;)V", "getApplicationId", "()Ljava/lang/String;", "hasFeature", "", "feature", "Lai/tock/bot/connector/ConnectorFeature;", "targetConnectorType", "Lai/tock/bot/connector/ConnectorType;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "transformMessage", "Lai/tock/bot/engine/action/Action;", "message", "Lai/tock/bot/connector/rest/model/MessageRequest;", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "userId", "Lai/tock/bot/engine/user/PlayerId;", "getTargetConnector", "Lai/tock/bot/connector/Connector;", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "text", "", "suggestions", "", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-rest"})
@SourceDebugExtension(value={"SMAP\nRestConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestConnector.kt\nai/tock/bot/connector/rest/RestConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1#2:195\n58#3:196\n51#3:197\n1557#4:198\n1628#4,3:199\n1557#4:202\n1628#4,3:203\n*S KotlinDebug\n*F\n+ 1 RestConnector.kt\nai/tock/bot/connector/rest/RestConnector\n*L\n78#1:196\n78#1:197\n145#1:198\n145#1:199,3\n167#1:202\n167#1:203,3\n*E\n"})
public final class RestConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    @NotNull
    private final RequestFilter requestFilter;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(RestConnector::logger$lambda$14);
    private static final boolean disabled = PropertiesKt.booleanProperty((String)"tock_rest_connector_disabled", (boolean)false);
    private static final boolean checkNlpStats = PropertiesKt.booleanProperty((String)"tock_rest_connector_check_nlp_stats", (boolean)false);

    public RestConnector(@NotNull String applicationId, @NotNull String path, @NotNull RequestFilter requestFilter) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestFilter, (String)"requestFilter");
        super(ConnectorType.Companion.getRest(), null, 2, null);
        this.applicationId = applicationId;
        this.path = path;
        this.requestFilter = requestFilter;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    public boolean hasFeature(@NotNull ConnectorFeature feature, @NotNull ConnectorType targetConnectorType) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)targetConnectorType, (String)"targetConnectorType");
        Connector connector = this.getTargetConnector(targetConnectorType);
        return connector != null ? connector.hasFeature(feature, targetConnectorType) : false;
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        if (!disabled) {
            logger.info(() -> RestConnector.register$lambda$0(this));
            controller.registerServices(this.path, arg_0 -> RestConnector.register$lambda$2(this, controller, arg_0));
        }
    }

    private final Action transformMessage(MessageRequest message) {
        Message message2;
        Message $this$transformMessage_u24lambda_u244 = message.getMessage();
        boolean bl = false;
        Object object = $this$transformMessage_u24lambda_u244 instanceof Choice ? (Choice)$this$transformMessage_u24lambda_u244 : null;
        String nlp = object != null && (object = object.getParameters()) != null ? (String)object.get("_nlp") : null;
        Message it = message2 = $this$transformMessage_u24lambda_u244;
        boolean bl2 = false;
        Object object2 = !(nlp != null) ? message2 : null;
        if (object2 == null) {
            object2 = (Message)new Sentence(nlp, null, null, null, 14, null);
        }
        Message m = object2;
        return m.toAction(new PlayerId(message.getUserId(), PlayerType.user, null, 4, null), this.applicationId, new PlayerId(message.getRecipientId(), PlayerType.bot, null, 4, null));
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        RestConnectorCallback cfr_ignored_0 = (RestConnectorCallback)callback;
        if (event instanceof Action) {
            ((RestConnectorCallback)callback).getActions().add((Action)event);
        } else {
            logger.trace(() -> RestConnector.send$lambda$5(event));
        }
    }

    @NotNull
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        UserPreferences userPreferences;
        block0: {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            RestConnectorCallback cfr_ignored_0 = (RestConnectorCallback)callback;
            UserPreferences $this$loadProfile_u24lambda_u246 = userPreferences = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
            boolean bl = false;
            $this$loadProfile_u24lambda_u246.setLocale(((RestConnectorCallback)callback).getLocale());
            TestBehaviour testBehaviour = ((RestConnectorCallback)callback).getTestContext();
            if (testBehaviour == null) break block0;
            testBehaviour.setup($this$loadProfile_u24lambda_u246, ((RestConnectorCallback)callback).getConnectorType(), $this$loadProfile_u24lambda_u246.getLocale());
        }
        return userPreferences;
    }

    private final Connector getTargetConnector(ConnectorType targetConnectorType) {
        ConnectorController connectorController = BotRepository.INSTANCE.getController(arg_0 -> RestConnector.getTargetConnector$lambda$7(targetConnectorType, arg_0));
        return connectorController != null ? connectorController.getConnector() : null;
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> RestConnector.addSuggestions$lambda$9(text, suggestions, this, arg_0);
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> RestConnector.addSuggestions$lambda$11(message, suggestions, this, arg_0);
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return arg_0 -> RestConnector.toConnectorMessage$lambda$13(message, this, arg_0);
    }

    private static final Object register$lambda$0(RestConnector this$0) {
        return "deploy rest connector to " + this$0.path;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit register$lambda$2$lambda$1(RestConnector this$0, ConnectorController $controller, RoutingContext context) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RequestFilter requestFilter = this$0.requestFilter;
        HttpServerRequest httpServerRequest = context.request();
        Intrinsics.checkNotNullExpressionValue((Object)httpServerRequest, (String)"request(...)");
        if (!requestFilter.accept(httpServerRequest)) {
            context.response().setStatusCode(403).end();
            return Unit.INSTANCE;
        }
        ObjectMapper objectMapper = JacksonKt.getMapper();
        String string = context.body().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String content$iv = string;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        MessageRequest message = (MessageRequest)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<MessageRequest>(){});
        Action action = this$0.transformMessage(message);
        Locale locale = Locale.forLanguageTag(context.pathParam("locale"));
        action.getState().setSourceConnectorType(message.getConnectorType());
        action.getState().setTargetConnectorType(message.getTargetConnectorType());
        action.getMetadata().setDebugEnabled(message.getDebugEnabled());
        action.getMetadata().setSourceWithContent(message.getSourceWithContent());
        Event event = (Event)action;
        String string2 = this$0.applicationId;
        ConnectorType connectorType = message.getTargetConnectorType();
        TestBehaviour testBehaviour = message.getTest() ? $controller.getBotDefinition().getTestBehaviour() : null;
        Intrinsics.checkNotNull((Object)locale);
        $controller.handle(event, new ConnectorData((ConnectorCallback)new RestConnectorCallback(string2, connectorType, context, testBehaviour, locale, action, null, 64, null), null, false, null, null, null, 62, null));
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$2(RestConnector this$0, ConnectorController $controller, Router router) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Route route = router.post(this$0.path + "/:locale");
        Intrinsics.checkNotNullExpressionValue((Object)route, (String)"post(...)");
        VertXsKt.blocking((Route)route, arg_0 -> RestConnector.register$lambda$2$lambda$1(this$0, $controller, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object send$lambda$5(Event $event) {
        return "unsupported event: " + $event;
    }

    private static final boolean getTargetConnector$lambda$7(ConnectorType $targetConnectorType, BotApplicationConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getConnectorType(), (Object)$targetConnectorType);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConnectorMessage addSuggestions$lambda$9(CharSequence $text, List $suggestions, RestConnector this$0, BotBus botBus) {
        ConnectorMessage connectorMessage;
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        if (Intrinsics.areEqual((Object)botBus.getTargetConnectorType(), (Object)ConnectorType.Companion.getRest())) {
            Collection<Choice> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new GenericMessage[1];
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"text", (Object)((Object)$text).toString()));
            Iterable iterable = $suggestions;
            int n = 0;
            Object[] objectArray2 = objectArray;
            String string = null;
            boolean $i$f$map = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CharSequence charSequence = (CharSequence)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Choice.Companion.fromText$default((Choice.Companion)Choice.Companion, (String)it.toString(), null, null, (int)6, null));
            }
            Collection<Choice> collection2 = collection = (List)destination$iv$iv;
            objectArray2[n] = new GenericMessage(null, null, collection2, map, null, null, null, null, 243, null);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 28;
            Function0 function0 = null;
            long l = 0L;
            UserInterfaceType userInterfaceType = null;
            List list = CollectionsKt.mutableListOf((Object[])objectArray);
            String string2 = string;
            DefaultConstructorMarker defaultConstructorMarker2 = null;
            int n3 = 28;
            boolean bl = false;
            Locale locale = null;
            String string3 = null;
            String string4 = botBus.getApplicationId();
            List list2 = CollectionsKt.listOf((Object)new Sentence(string2, list, userInterfaceType, l, function0, n2, defaultConstructorMarker));
            connectorMessage = new MessageResponse(list2, string4, string3, locale, bl, n3, defaultConstructorMarker2);
        } else {
            Connector connector = this$0.getTargetConnector(botBus.getTargetConnectorType());
            connectorMessage = connector != null && (connector = connector.addSuggestions($text, $suggestions)) != null ? (ConnectorMessage)connector.invoke((Object)botBus) : null;
        }
        return connectorMessage;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConnectorMessage addSuggestions$lambda$11(ConnectorMessage $message, List $suggestions, RestConnector this$0, BotBus botBus) {
        ConnectorMessage connectorMessage;
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        if (Intrinsics.areEqual((Object)botBus.getTargetConnectorType(), (Object)ConnectorType.Companion.getRest())) {
            MessageResponse response = $message instanceof MessageResponse ? (MessageResponse)$message : null;
            Object object = response;
            Message message = object != null && (object = ((MessageResponse)object).getMessages()) != null ? (Message)CollectionsKt.lastOrNull((List)object) : null;
            Sentence sentence = message instanceof Sentence ? (Sentence)message : null;
            Object object2 = sentence;
            GenericMessage lastMessage = object2 != null && (object2 = object2.getMessages()) != null ? (GenericMessage)CollectionsKt.lastOrNull((List)object2) : null;
            Object object3 = lastMessage;
            boolean bl = object3 != null && (object3 = object3.getChoices()) != null ? object3.isEmpty() : false;
            if (bl) {
                Collection<Choice> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = $suggestions;
                List list = null;
                ConnectorType connectorType = null;
                GenericMessage genericMessage = lastMessage;
                int n = sentence.getMessages().size() - 1;
                List list2 = sentence.getMessages();
                boolean $i$f$map = false;
                void var9_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CharSequence charSequence = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(Choice.Companion.fromText$default((Choice.Companion)Choice.Companion, (String)it.toString(), null, null, (int)6, null));
                }
                collection = (List)destination$iv$iv;
                list2.set(n, GenericMessage.copy$default((GenericMessage)genericMessage, connectorType, list, (List)collection, null, null, null, null, null, (int)251, null));
            }
            connectorMessage = $message;
        } else {
            Connector connector = this$0.getTargetConnector(botBus.getTargetConnectorType());
            connectorMessage = connector != null && (connector = connector.addSuggestions($message, $suggestions)) != null ? (ConnectorMessage)connector.invoke((Object)botBus) : null;
        }
        return connectorMessage;
    }

    private static final List toConnectorMessage$lambda$13(MediaMessage $message, RestConnector this$0, BotBus botBus) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        if (Intrinsics.areEqual((Object)botBus.getTargetConnectorType(), (Object)ConnectorType.Companion.getRest())) {
            MessageResponse messageResponse;
            GenericMessage genericMessage = $message.toGenericMessage();
            if (genericMessage != null) {
                GenericMessage it = genericMessage;
                boolean bl = false;
                Object[] objectArray = new GenericMessage[]{it};
                MessageResponse messageResponse2 = new MessageResponse(CollectionsKt.listOf((Object)new Sentence(null, CollectionsKt.mutableListOf((Object[])objectArray), null, 0L, null, 28, null)), botBus.getApplicationId(), null, null, false, 28, null);
                messageResponse = messageResponse2;
            } else {
                messageResponse = null;
            }
            object = CollectionsKt.listOfNotNull(messageResponse);
        } else {
            object = this$0.getTargetConnector(botBus.getTargetConnectorType());
            if (object == null || (object = object.toConnectorMessage($message)) == null || (object = (List)object.invoke((Object)botBus)) == null) {
                object = CollectionsKt.emptyList();
            }
        }
        return object;
    }

    private static final Unit logger$lambda$14() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/tock/bot/connector/rest/RestConnector$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "disabled", "", "checkNlpStats", "getCheckNlpStats$tock_bot_connector_rest", "()Z", "tock-bot-connector-rest"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getCheckNlpStats$tock_bot_connector_rest() {
            return checkNlpStats;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

