/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.rocketchat;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.rocketchat.RocketChatBuildersKt;
import ai.tock.bot.connector.rocketchat.RocketChatClient;
import ai.tock.bot.connector.rocketchat.RocketChatConnector;
import ai.tock.bot.connector.rocketchat.RocketChatConnectorCallback;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.shared.LoggersKt;
import chat.rocket.common.model.SimpleUser;
import chat.rocket.core.model.LastMessage;
import chat.rocket.core.model.Room;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/tock/bot/connector/rocketchat/RocketChatConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "client", "Lai/tock/bot/connector/rocketchat/RocketChatClient;", "roomId", "(Ljava/lang/String;Lai/tock/bot/connector/rocketchat/RocketChatClient;Ljava/lang/String;)V", "lastMessages", "Ljava/util/concurrent/ArrayBlockingQueue;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "unregister", "Companion", "tock-bot-connector-rocketchat"})
public final class RocketChatConnector
extends ConnectorBase {
    private final ArrayBlockingQueue<String> lastMessages;
    private final String applicationId;
    private final RocketChatClient client;
    private final String roomId;
    private static final KLogger logger;
    private static final CopyOnWriteArraySet<String> registeredClientUrls;
    public static final Companion Companion;

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        if (registeredClientUrls.contains(this.client.getTargetUrl())) {
            logger.warn((Function0)new Function0<String>(this){
                final /* synthetic */ RocketChatConnector this$0;

                @NotNull
                public final String invoke() {
                    return "client url already registered - skip: " + RocketChatConnector.access$getClient$p(this.this$0).getTargetUrl();
                }
                {
                    this.this$0 = rocketChatConnector;
                    super(0);
                }
            });
        } else {
            registeredClientUrls.add(this.client.getTargetUrl());
            this.client.join(this.roomId, (Function1<? super Room, Unit>)((Function1)new Function1<Room, Unit>(this, controller){
                final /* synthetic */ RocketChatConnector this$0;
                final /* synthetic */ ConnectorController $controller;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull Room room) {
                    Intrinsics.checkParameterIsNotNull((Object)room, (String)"room");
                    RocketChatConnector.access$getLogger$cp().debug((Function0)new Function0<String>(room){
                        final /* synthetic */ Room $room;

                        @NotNull
                        public final String invoke() {
                            return "listening room event: " + this.$room;
                        }
                        {
                            this.$room = room;
                            super(0);
                        }
                    });
                    LastMessage message = room.getLastMessage();
                    if (Intrinsics.areEqual((Object)room.getType().toString(), (Object)"l") ^ true && (RocketChatConnector.access$getRoomId$p(this.this$0) == null || Intrinsics.areEqual((Object)room.getId(), (Object)RocketChatConnector.access$getRoomId$p(this.this$0)) ^ true)) {
                        RocketChatConnector.access$getLogger$cp().debug((Function0)register.2.INSTANCE);
                    } else {
                        LastMessage lastMessage = message;
                        if ((lastMessage != null ? lastMessage.getSender() : null) == null) {
                            RocketChatConnector.access$getLogger$cp().warn((Function0)new Function0<String>(room){
                                final /* synthetic */ Room $room;

                                @NotNull
                                public final String invoke() {
                                    return "no message for " + this.$room + " - skip";
                                }
                                {
                                    this.$room = room;
                                    super(0);
                                }
                            });
                        } else {
                            SimpleUser simpleUser = message.getSender();
                            if (simpleUser == null) {
                                Intrinsics.throwNpe();
                            }
                            if (Intrinsics.areEqual((Object)simpleUser.getUsername(), (Object)RocketChatConnector.access$getClient$p(this.this$0).getLogin())) {
                                RocketChatConnector.access$getLogger$cp().debug((Function0)new Function0<String>(this, room){
                                    final /* synthetic */ register.2 this$0;
                                    final /* synthetic */ Room $room;

                                    @NotNull
                                    public final String invoke() {
                                        return "do not reply to bot messages " + this.$room + " because client login is the same than sender: " + RocketChatConnector.access$getClient$p(this.this$0.this$0).getLogin();
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$room = room;
                                        super(0);
                                    }
                                });
                            } else if (RocketChatConnector.access$getLastMessages$p(this.this$0).contains(message.getId())) {
                                RocketChatConnector.access$getLogger$cp().debug((Function0)new Function0<String>(message){
                                    final /* synthetic */ LastMessage $message;

                                    @NotNull
                                    public final String invoke() {
                                        return "message " + this.$message + " already seen - skip";
                                    }
                                    {
                                        this.$message = lastMessage;
                                        super(0);
                                    }
                                });
                            } else {
                                RocketChatConnector.access$getLastMessages$p(this.this$0).poll();
                                RocketChatConnector.access$getLastMessages$p(this.this$0).offer(message.getId());
                                RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("rocketchat_webhook");
                                RocketChatConnector.access$getLogger$cp().debug((Function0)new Function0<String>(message){
                                    final /* synthetic */ LastMessage $message;

                                    @NotNull
                                    public final String invoke() {
                                        return "message handled : " + this.$message;
                                    }
                                    {
                                        this.$message = lastMessage;
                                        super(0);
                                    }
                                });
                                try {
                                    SimpleUser simpleUser2 = message.getSender();
                                    if (simpleUser2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    String string = simpleUser2.getId();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    this.$controller.handle((Event)new SendSentence(new PlayerId(string, null, null, 6, null), RocketChatConnector.access$getApplicationId$p(this.this$0), new PlayerId(RocketChatConnector.access$getApplicationId$p(this.this$0), PlayerType.bot, null, 4, null), (CharSequence)message.getMessage(), null, null, null, null, null, null, null, 2032, null), new ConnectorData((ConnectorCallback)new RocketChatConnectorCallback(RocketChatConnector.access$getApplicationId$p(this.this$0), room.getId()), null, false, null, null, 30, null));
                                }
                                catch (Throwable e) {
                                    LoggersKt.error((KLogger)RocketChatConnector.access$getLogger$cp(), (Throwable)e);
                                }
                                finally {
                                    try {
                                        BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                                    }
                                    catch (Throwable e) {
                                        LoggersKt.error((KLogger)RocketChatConnector.access$getLogger$cp(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                }
                {
                    this.this$0 = rocketChatConnector;
                    this.$controller = connectorController;
                    super(1);
                }
            }));
        }
    }

    public void unregister(@NotNull ConnectorController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        super.unregister(controller);
        this.client.unregister();
        registeredClientUrls.remove(this.client.getTargetUrl());
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (event instanceof SendSentence && ((SendSentence)event).getText() != null) {
            String roomId = ((RocketChatConnectorCallback)callback).getRoomId();
            String string = ((SendSentence)event).getStringText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.client.send(roomId, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public RocketChatConnector(@NotNull String applicationId, @NotNull RocketChatClient client2, @Nullable String roomId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
        super(RocketChatBuildersKt.getRocketChatConnectorType());
        this.applicationId = applicationId;
        this.client = client2;
        this.roomId = roomId;
        int n = 0;
        Iterable iterable = (Iterable)new IntRange(n, 9);
        boolean bl = true;
        int n2 = 10;
        RocketChatConnector rocketChatConnector = this;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = "";
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        boolean bl3 = bl;
        int n4 = n2;
        rocketChatConnector.lastMessages = new ArrayBlockingQueue(n4, bl3, collection2);
    }

    public /* synthetic */ RocketChatConnector(String string, RocketChatClient rocketChatClient, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, rocketChatClient, string2);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        registeredClientUrls = new CopyOnWriteArraySet();
    }

    public static final /* synthetic */ RocketChatClient access$getClient$p(RocketChatConnector $this) {
        return $this.client;
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getRoomId$p(RocketChatConnector $this) {
        return $this.roomId;
    }

    public static final /* synthetic */ ArrayBlockingQueue access$getLastMessages$p(RocketChatConnector $this) {
        return $this.lastMessages;
    }

    public static final /* synthetic */ String access$getApplicationId$p(RocketChatConnector $this) {
        return $this.applicationId;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/tock/bot/connector/rocketchat/RocketChatConnector$Companion;", "", "()V", "logger", "Lmu/KLogger;", "registeredClientUrls", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "tock-bot-connector-rocketchat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

