/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.rocketchat;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.rocketchat.RocketChatBuildersKt;
import ai.tock.bot.connector.rocketchat.RocketChatClient;
import ai.tock.bot.connector.rocketchat.RocketChatConnectorCallback;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.shared.LoggersKt;
import chat.rocket.common.model.SimpleUser;
import chat.rocket.core.model.LastMessage;
import chat.rocket.core.model.Room;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/tock/bot/connector/rocketchat/RocketChatConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "client", "Lai/tock/bot/connector/rocketchat/RocketChatClient;", "roomId", "<init>", "(Ljava/lang/String;Lai/tock/bot/connector/rocketchat/RocketChatClient;Ljava/lang/String;)V", "lastMessages", "Ljava/util/concurrent/ArrayBlockingQueue;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "unregister", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "Companion", "tock-bot-connector-rocketchat"})
@SourceDebugExtension(value={"SMAP\nRocketChatConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RocketChatConnector.kt\nai/tock/bot/connector/rocketchat/RocketChatConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1557#2:112\n1628#2,3:113\n*S KotlinDebug\n*F\n+ 1 RocketChatConnector.kt\nai/tock/bot/connector/rocketchat/RocketChatConnector\n*L\n48#1:112\n48#1:113,3\n*E\n"})
public final class RocketChatConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final RocketChatClient client;
    @Nullable
    private final String roomId;
    @NotNull
    private final ArrayBlockingQueue<String> lastMessages;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(RocketChatConnector::logger$lambda$9);
    @NotNull
    private static final CopyOnWriteArraySet<String> registeredClientUrls = new CopyOnWriteArraySet();

    /*
     * WARNING - void declaration
     */
    public RocketChatConnector(@NotNull String applicationId, @NotNull RocketChatClient client2, @Nullable String roomId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        super(RocketChatBuildersKt.getRocketChatConnectorType(), null, 2, null);
        this.applicationId = applicationId;
        this.client = client2;
        this.roomId = roomId;
        Iterable iterable = (Iterable)new IntRange(0, 9);
        boolean bl = true;
        int n = 10;
        RocketChatConnector rocketChatConnector = this;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add("");
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        boolean bl3 = bl;
        int n3 = n;
        rocketChatConnector.lastMessages = new ArrayBlockingQueue(n3, bl3, collection2);
    }

    public /* synthetic */ RocketChatConnector(String string, RocketChatClient rocketChatClient, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, rocketChatClient, string2);
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        if (registeredClientUrls.contains(this.client.getTargetUrl())) {
            logger.warn(() -> RocketChatConnector.register$lambda$1(this));
        } else {
            registeredClientUrls.add(this.client.getTargetUrl());
            this.client.join(this.roomId, (Function1<? super Room, Unit>)((Function1)arg_0 -> RocketChatConnector.register$lambda$8(this, controller, arg_0)));
        }
    }

    public void unregister(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        super.unregister(controller);
        this.client.unregister();
        registeredClientUrls.remove(this.client.getTargetUrl());
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (event instanceof SendSentence && ((SendSentence)event).getText() != null) {
            String roomId = ((RocketChatConnectorCallback)callback).getRoomId();
            String string = ((SendSentence)event).getStringText();
            Intrinsics.checkNotNull((Object)string);
            this.client.send(roomId, string);
        }
    }

    private static final Object register$lambda$1(RocketChatConnector this$0) {
        return "client url already registered - skip: " + this$0.client.getTargetUrl();
    }

    private static final Object register$lambda$8$lambda$2(Room $room) {
        return "listening room event: " + $room;
    }

    private static final Object register$lambda$8$lambda$3() {
        return "Do not reply to messages in non-livechat rooms or dedicated room";
    }

    private static final Object register$lambda$8$lambda$4(Room $room) {
        return "no message for " + $room + " - skip";
    }

    private static final Object register$lambda$8$lambda$5(Room $room, RocketChatConnector this$0) {
        return "do not reply to bot messages " + $room + " because client login is the same than sender: " + this$0.client.getLogin();
    }

    private static final Object register$lambda$8$lambda$6(LastMessage $message) {
        return "message " + $message + " already seen - skip";
    }

    private static final Object register$lambda$8$lambda$7(LastMessage $message) {
        return "message handled : " + $message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit register$lambda$8(RocketChatConnector this$0, ConnectorController $controller, Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        logger.debug(() -> RocketChatConnector.register$lambda$8$lambda$2(room));
        LastMessage message = room.getLastMessage();
        if (!(Intrinsics.areEqual((Object)room.getType().toString(), (Object)"l") || this$0.roomId != null && Intrinsics.areEqual((Object)room.getId(), (Object)this$0.roomId))) {
            logger.debug(RocketChatConnector::register$lambda$8$lambda$3);
        } else {
            LastMessage lastMessage = message;
            if ((lastMessage != null ? lastMessage.getSender() : null) == null) {
                logger.warn(() -> RocketChatConnector.register$lambda$8$lambda$4(room));
            } else {
                SimpleUser simpleUser = message.getSender();
                Intrinsics.checkNotNull((Object)simpleUser);
                if (Intrinsics.areEqual((Object)simpleUser.getUsername(), (Object)this$0.client.getLogin())) {
                    logger.debug(() -> RocketChatConnector.register$lambda$8$lambda$5(room, this$0));
                } else if (this$0.lastMessages.contains(message.getId())) {
                    logger.debug(() -> RocketChatConnector.register$lambda$8$lambda$6(message));
                } else {
                    this$0.lastMessages.poll();
                    this$0.lastMessages.offer(message.getId());
                    RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("rocketchat_webhook");
                    logger.debug(() -> RocketChatConnector.register$lambda$8$lambda$7(message));
                    try {
                        SimpleUser simpleUser2 = message.getSender();
                        Intrinsics.checkNotNull((Object)simpleUser2);
                        String string = simpleUser2.getId();
                        Intrinsics.checkNotNull((Object)string);
                        $controller.handle((Event)new SendSentence(new PlayerId(string, null, null, 6, null), this$0.applicationId, new PlayerId(this$0.applicationId, PlayerType.bot, null, 4, null), (CharSequence)message.getMessage(), null, null, null, null, null, null, null, 2032, null), new ConnectorData((ConnectorCallback)new RocketChatConnectorCallback(this$0.applicationId, room.getId()), null, false, null, null, null, 62, null));
                    }
                    catch (Throwable e) {
                        LoggersKt.error((KLogger)logger, (Throwable)e);
                    }
                    finally {
                        try {
                            BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                        }
                        catch (Throwable e) {
                            LoggersKt.error((KLogger)logger, (Throwable)e);
                        }
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit logger$lambda$9() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/tock/bot/connector/rocketchat/RocketChatConnector$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "registeredClientUrls", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "tock-bot-connector-rocketchat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

