/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.slack;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.slack.SlackBuildersKt;
import ai.tock.bot.connector.slack.SlackClient;
import ai.tock.bot.connector.slack.SlackCodecKt;
import ai.tock.bot.connector.slack.SlackConnector;
import ai.tock.bot.connector.slack.SlackConnectorProvider;
import ai.tock.bot.connector.slack.SlackMessageConverter;
import ai.tock.bot.connector.slack.SlackRequestConverter;
import ai.tock.bot.connector.slack.model.AttachmentField;
import ai.tock.bot.connector.slack.model.Button;
import ai.tock.bot.connector.slack.model.EventApiMessage;
import ai.tock.bot.connector.slack.model.SlackConnectorMessage;
import ai.tock.bot.connector.slack.model.SlackMessageAttachment;
import ai.tock.bot.connector.slack.model.SlackMessageOut;
import ai.tock.bot.connector.slack.model.UrlVerificationEvent;
import ai.tock.bot.connector.slack.model.old.SlackMessageIn;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.I18nTranslator;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.monitoring.RequestTimerKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ1\u0010\u0019\u001a\u0015\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J1\u0010\u0019\u001a\u0015\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a\u00a2\u0006\u0002\b\u001d2\u0006\u0010\"\u001a\u00020!2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J \u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020$2\u0006\u0010\u001e\u001a\u0002012\u0006\u0010.\u001a\u00020/H\u0002J'\u00102\u001a\u0019\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0 0\u001a\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u000203H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u00065"}, d2={"Lai/tock/bot/connector/slack/SlackConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "outToken1", "outToken2", "outToken3", "client", "Lai/tock/bot/connector/slack/SlackClient;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lai/tock/bot/connector/slack/SlackClient;)V", "getApplicationId", "()Ljava/lang/String;", "getClient", "()Lai/tock/bot/connector/slack/SlackClient;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "getOutToken1", "getOutToken2", "getOutToken3", "getPath", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "message", "suggestions", "", "", "text", "eventApi", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "oldApi", "register", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "sendMessage", "Lai/tock/bot/connector/slack/model/SlackConnectorMessage;", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-slack"})
public final class SlackConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    @NotNull
    private final String outToken1;
    @NotNull
    private final String outToken2;
    @NotNull
    private final String outToken3;
    @NotNull
    private final SlackClient client;
    @NotNull
    private final InjectedProperty executor$delegate;
    @NotNull
    private static final KLogger logger;
    private static final boolean OLD_SLACK_API;

    public SlackConnector(@NotNull String applicationId, @NotNull String path, @NotNull String outToken1, @NotNull String outToken2, @NotNull String outToken3, @NotNull SlackClient client) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)outToken1, (String)"outToken1");
        Intrinsics.checkNotNullParameter((Object)outToken2, (String)"outToken2");
        Intrinsics.checkNotNullParameter((Object)outToken3, (String)"outToken3");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(SlackConnectorProvider.INSTANCE.getConnectorType(), null, 2, null);
        this.applicationId = applicationId;
        this.path = path;
        this.outToken1 = outToken1;
        this.outToken2 = outToken2;
        this.outToken3 = outToken3;
        this.client = client;
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getOutToken1() {
        return this.outToken1;
    }

    @NotNull
    public final String getOutToken2() {
        return this.outToken2;
    }

    @NotNull
    public final String getOutToken3() {
        return this.outToken3;
    }

    @NotNull
    public final SlackClient getClient() {
        return this.client;
    }

    private final Executor getExecutor() {
        return (Executor)this.executor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        if (OLD_SLACK_API) {
            this.oldApi(controller);
        } else {
            this.eventApi(controller);
        }
    }

    private final void eventApi(ConnectorController controller) {
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ SlackConnector this$0;
            final /* synthetic */ ConnectorController $controller;
            {
                this.this$0 = $receiver;
                this.$controller = $controller;
                super(1);
            }

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                router.post(this.this$0.getPath()).handler(arg_0 -> eventApi.1.invoke$lambda-1(this.this$0, this.$controller, arg_0));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final void invoke$lambda-1(SlackConnector this$0, ConnectorController $controller, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
                RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("slack_webhook");
                try {
                    void $this$readValue$iv;
                    String string;
                    String it = context.getBodyAsString();
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (StringsKt.startsWith$default((String)it, (String)"payload=", (boolean)false, (int)2, null)) {
                        String string2 = it.substring("payload=".length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                        string = URLDecoder.decode(string2, "UTF-8");
                    } else {
                        string = it;
                    }
                    String body = string;
                    SlackConnector.access$getLogger$cp().info((Function0)new Function0<Object>(body){
                        final /* synthetic */ String $body;
                        {
                            this.$body = $body;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "message received from slack: " + this.$body;
                        }
                    });
                    it = JacksonKt.getMapper();
                    Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                    String content$iv = body;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    EventApiMessage message = (EventApiMessage)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<EventApiMessage>(){});
                    if (message instanceof UrlVerificationEvent) {
                        context.response().putHeader("Content-type", "text/plain").end(((UrlVerificationEvent)message).getChallenge());
                    } else {
                        context.response().end();
                        Event event = SlackRequestConverter.INSTANCE.toEvent(message, this$0.getApplicationId());
                        if (event != null) {
                            SlackConnector.access$getExecutor(this$0).executeBlocking((Function0)new Function0<Unit>($controller, event){
                                final /* synthetic */ ConnectorController $controller;
                                final /* synthetic */ Event $event;
                                {
                                    this.$controller = $controller;
                                    this.$event = $event;
                                    super(0);
                                }

                                public final void invoke() {
                                    ConnectorController.DefaultImpls.handle$default((ConnectorController)this.$controller, (Event)this.$event, null, (int)2, null);
                                }
                            });
                        } else {
                            SlackConnector.access$getLogger$cp().debug((Function0)new Function0<Object>(body){
                                final /* synthetic */ String $body;
                                {
                                    this.$body = $body;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return "skip message: " + this.$body;
                                }
                            });
                        }
                    }
                }
                catch (Throwable e) {
                    RequestTimerKt.logError((KLogger)SlackConnector.access$getLogger$cp(), (Throwable)e, (RequestTimerData)requestTimerData);
                    try {
                        context.response().end();
                    }
                    catch (Exception e2) {
                        LoggersKt.error((KLogger)SlackConnector.access$getLogger$cp(), (Throwable)e2);
                    }
                }
                finally {
                    try {
                        BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                    }
                    catch (Throwable e) {
                        LoggersKt.error((KLogger)SlackConnector.access$getLogger$cp(), (Throwable)e);
                    }
                }
            }
        });
    }

    private final void oldApi(ConnectorController controller) {
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ SlackConnector this$0;
            final /* synthetic */ ConnectorController $controller;
            {
                this.this$0 = $receiver;
                this.$controller = $controller;
                super(1);
            }

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                router.post(this.this$0.getPath()).handler(arg_0 -> oldApi.1.invoke$lambda-2(this.this$0, this.$controller, arg_0));
            }

            private static final void invoke$lambda-2$lambda-0(SlackMessageIn $message, SlackConnector this$0, ConnectorController $controller, RequestTimerData $requestTimerData, Promise it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
                Intrinsics.checkNotNullParameter((Object)$requestTimerData, (String)"$requestTimerData");
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)$message, (String)"message");
                    Event event = SlackRequestConverter.INSTANCE.toEvent($message, this$0.getApplicationId());
                    if (event != null) {
                        ConnectorController.DefaultImpls.handle$default((ConnectorController)$controller, (Event)event, null, (int)2, null);
                    } else {
                        RequestTimerKt.logError((KLogger)SlackConnector.access$getLogger$cp(), (String)("unable to convert " + $message + " to event"), (RequestTimerData)$requestTimerData);
                    }
                }
                catch (Throwable e) {
                    RequestTimerKt.logError((KLogger)SlackConnector.access$getLogger$cp(), (Throwable)e, (RequestTimerData)$requestTimerData);
                }
            }

            private static final void invoke$lambda-2$lambda-1(AsyncResult it) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$lambda-2(SlackConnector this$0, ConnectorController $controller, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
                RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("slack_webhook");
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    String body = SlackCodecKt.convertUrlEncodedStringToJson(context);
                    SlackConnector.access$getLogger$cp().info((Function0)new Function0<Object>(body){
                        final /* synthetic */ String $body;
                        {
                            this.$body = $body;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "message received from slack: " + this.$body;
                        }
                    });
                    SlackMessageIn message = (SlackMessageIn)JacksonKt.getMapper().readValue(body, SlackMessageIn.class);
                    if (!Intrinsics.areEqual((Object)message.getUser_id(), (Object)"USLACKBOT")) {
                        VertXsKt.getVertx().executeBlocking(arg_0 -> oldApi.1.invoke$lambda-2$lambda-0(message, this$0, $controller, requestTimerData, arg_0), false, oldApi.1::invoke$lambda-2$lambda-1);
                    }
                }
                catch (Throwable e) {
                    RequestTimerKt.logError((KLogger)SlackConnector.access$getLogger$cp(), (Throwable)e, (RequestTimerData)requestTimerData);
                }
                finally {
                    try {
                        BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                        context.response().end();
                    }
                    catch (Throwable e) {
                        LoggersKt.error((KLogger)SlackConnector.access$getLogger$cp(), (Throwable)e);
                    }
                }
            }
        });
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        SlackConnectorMessage message;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        logger.debug((Function0)new Function0<Object>(event){
            final /* synthetic */ Event $event;
            {
                this.$event = $event;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "event: " + this.$event;
            }
        });
        if (event instanceof Action && (message = SlackMessageConverter.INSTANCE.toMessageOut((Action)event)) != null) {
            this.sendMessage(message, delayInMs);
        }
    }

    private final void sendMessage(SlackConnectorMessage message, long delayInMs) {
        Executor executor = this.getExecutor();
        Duration duration = Duration.ofMillis(delayInMs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(delayInMs)");
        executor.executeBlocking(duration, (Function0)new Function0<Unit>(this, message){
            final /* synthetic */ SlackConnector this$0;
            final /* synthetic */ SlackConnectorMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                this.this$0.getClient().sendMessage(this.this$0.getOutToken1(), this.this$0.getOutToken2(), this.this$0.getOutToken3(), this.$message);
            }
        });
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, SlackMessageOut>(text, suggestions){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ List<CharSequence> $suggestions;
            {
                this.$text = $text;
                this.$suggestions = $suggestions;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SlackMessageOut invoke(@NotNull BotBus $this$null) {
                Collection<Button> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                SlackMessageAttachment[] slackMessageAttachmentArray = new SlackMessageAttachment[1];
                Iterable iterable = this.$suggestions;
                CharSequence charSequence = null;
                I18nTranslator i18nTranslator = (I18nTranslator)$this$null;
                int n = 0;
                SlackMessageAttachment[] slackMessageAttachmentArray2 = slackMessageAttachmentArray;
                CharSequence charSequence2 = this.$text;
                I18nTranslator i18nTranslator2 = (I18nTranslator)$this$null;
                boolean $i$f$map = false;
                void var5_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CharSequence charSequence3 = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SlackBuildersKt.slackButton$default((Bus)$this$null, (CharSequence)it, null, null, null, 14, null));
                }
                collection = (List)destination$iv$iv;
                slackMessageAttachmentArray2[n] = SlackBuildersKt.slackAttachment$default(i18nTranslator, charSequence, (List)collection, null, null, null, new AttachmentField[0], 28, null);
                return SlackBuildersKt.slackMessage(i18nTranslator2, charSequence2, slackMessageAttachmentArray);
            }
        };
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, ConnectorMessage>(message, suggestions){
            final /* synthetic */ ConnectorMessage $message;
            final /* synthetic */ List<CharSequence> $suggestions;
            {
                this.$message = $message;
                this.$suggestions = $suggestions;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ConnectorMessage invoke(@NotNull BotBus $this$null) {
                ConnectorMessage connectorMessage;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                if (this.$message instanceof SlackMessageOut) {
                    SlackMessageOut slackMessageOut;
                    SlackMessageAttachment attachment = (SlackMessageAttachment)CollectionsKt.lastOrNull(((SlackMessageOut)this.$message).getAttachments());
                    if (attachment == null) {
                        Collection<Button> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$suggestions;
                        CharSequence charSequence = null;
                        I18nTranslator i18nTranslator = (I18nTranslator)$this$null;
                        String string = null;
                        String string2 = null;
                        SlackMessageOut slackMessageOut2 = (SlackMessageOut)this.$message;
                        boolean $i$f$map = false;
                        void var5_17 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CharSequence charSequence2 = (CharSequence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(SlackBuildersKt.slackButton$default((Bus)$this$null, (CharSequence)it, null, null, null, 14, null));
                        }
                        collection = (List)destination$iv$iv;
                        slackMessageOut = SlackMessageOut.copy$default(slackMessageOut2, string2, string, CollectionsKt.listOf((Object)SlackBuildersKt.slackAttachment$default(i18nTranslator, charSequence, (List)collection, null, null, null, new AttachmentField[0], 28, null)), 3, null);
                    } else if (attachment.getActions().isEmpty()) {
                        Collection<Button> collection;
                        Iterable $this$map$iv = this.$suggestions;
                        CharSequence charSequence = null;
                        I18nTranslator i18nTranslator = (I18nTranslator)$this$null;
                        Collection collection2 = CollectionsKt.take((Iterable)((SlackMessageOut)this.$message).getAttachments(), (int)(((SlackMessageOut)this.$message).getAttachments().size() - 1));
                        String string = null;
                        String string3 = null;
                        SlackMessageOut slackMessageOut3 = (SlackMessageOut)this.$message;
                        boolean $i$f$map = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            CharSequence it = (CharSequence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(SlackBuildersKt.slackButton$default((Bus)$this$null, it, null, null, null, 14, null));
                        }
                        collection = (List)destination$iv$iv;
                        slackMessageOut = SlackMessageOut.copy$default(slackMessageOut3, string3, string, CollectionsKt.plus((Collection)collection2, (Object)SlackBuildersKt.slackAttachment$default(i18nTranslator, charSequence, (List)collection, null, null, null, new AttachmentField[0], 28, null)), 3, null);
                    } else {
                        slackMessageOut = null;
                    }
                    connectorMessage = slackMessageOut;
                } else {
                    connectorMessage = null;
                }
                return connectorMessage;
            }
        };
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (Function1)new Function1<BotBus, List<? extends ConnectorMessage>>(message){
            final /* synthetic */ MediaMessage $message;
            {
                this.$message = $message;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ConnectorMessage> invoke(@NotNull BotBus $this$null) {
                List list;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                if (this.$message instanceof MediaCard) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    MediaAction it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    CharSequence title = ((MediaCard)this.$message).getTitle();
                    CharSequence subTitle = ((MediaCard)this.$message).getSubTitle();
                    Object[] objectArray = new SlackMessageOut[2];
                    objectArray[0] = title != null && subTitle != null ? SlackBuildersKt.textMessage((I18nTranslator)$this$null, title) : (SlackMessageOut)null;
                    I18nTranslator i18nTranslator = (I18nTranslator)$this$null;
                    CharSequence charSequence = subTitle;
                    if (charSequence == null && (charSequence = title) == null) {
                        charSequence = "";
                    }
                    SlackMessageAttachment[] slackMessageAttachmentArray = new SlackMessageAttachment[1];
                    Iterable iterable = ((MediaCard)this.$message).getActions();
                    CharSequence charSequence2 = null;
                    I18nTranslator i18nTranslator2 = (I18nTranslator)$this$null;
                    int n = 0;
                    SlackMessageAttachment[] slackMessageAttachmentArray2 = slackMessageAttachmentArray;
                    CharSequence charSequence3 = charSequence;
                    I18nTranslator i18nTranslator3 = i18nTranslator;
                    int n2 = 1;
                    Object[] objectArray2 = objectArray;
                    boolean $i$f$filter = false;
                    void var8_16 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (MediaAction)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getUrl() == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Collection<Button> collection = (List)destination$iv$iv;
                    $this$filter$iv = collection;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (MediaAction)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(SlackBuildersKt.slackButton$default((Bus)$this$null, it.getTitle(), null, null, null, 14, null));
                    }
                    collection = (List)destination$iv$iv;
                    slackMessageAttachmentArray2[n] = SlackBuildersKt.slackAttachment$default(i18nTranslator2, charSequence2, (List)collection, null, null, null, new AttachmentField[0], 28, null);
                    objectArray2[n2] = SlackBuildersKt.slackMessage(i18nTranslator3, charSequence3, slackMessageAttachmentArray);
                    list = CollectionsKt.listOfNotNull((Object[])objectArray);
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        };
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Executor access$getExecutor(SlackConnector $this) {
        return $this.getExecutor();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SlackConnector.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        OLD_SLACK_API = PropertiesKt.booleanProperty((String)"tock_slack_old_api_style", (boolean)false);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/tock/bot/connector/slack/SlackConnector$Companion;", "", "()V", "OLD_SLACK_API", "", "logger", "Lmu/KLogger;", "tock-bot-connector-slack"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

