/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.slack;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.slack.SlackBuildersKt;
import ai.tock.bot.connector.slack.SlackClient;
import ai.tock.bot.connector.slack.SlackCodecKt;
import ai.tock.bot.connector.slack.SlackConnectorProvider;
import ai.tock.bot.connector.slack.SlackMessageConverter;
import ai.tock.bot.connector.slack.SlackRequestConverter;
import ai.tock.bot.connector.slack.model.AttachmentField;
import ai.tock.bot.connector.slack.model.Button;
import ai.tock.bot.connector.slack.model.EventApiMessage;
import ai.tock.bot.connector.slack.model.SlackConnectorMessage;
import ai.tock.bot.connector.slack.model.SlackMessageAttachment;
import ai.tock.bot.connector.slack.model.SlackMessageOut;
import ai.tock.bot.connector.slack.model.UrlVerificationEvent;
import ai.tock.bot.connector.slack.model.old.SlackMessageIn;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.I18nTranslator;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.monitoring.RequestTimerKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0002J1\u0010*\u001a\u0015\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010-0+\u00a2\u0006\u0002\b.2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020002H\u0016J1\u0010*\u001a\u0015\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010-0+\u00a2\u0006\u0002\b.2\u0006\u0010(\u001a\u00020-2\f\u00101\u001a\b\u0012\u0004\u0012\u00020002H\u0016J'\u00103\u001a\u0019\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020-020+\u00a2\u0006\u0002\b.2\u0006\u0010(\u001a\u000204H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Lai/tock/bot/connector/slack/SlackConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "outToken1", "outToken2", "outToken3", "client", "Lai/tock/bot/connector/slack/SlackClient;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lai/tock/bot/connector/slack/SlackClient;)V", "getApplicationId", "()Ljava/lang/String;", "getPath", "getOutToken1", "getOutToken2", "getOutToken3", "getClient", "()Lai/tock/bot/connector/slack/SlackClient;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "eventApi", "oldApi", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "sendMessage", "message", "Lai/tock/bot/connector/slack/model/SlackConnectorMessage;", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "text", "", "suggestions", "", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-slack"})
@SourceDebugExtension(value={"SMAP\nSlackConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlackConnector.kt\nai/tock/bot/connector/slack/SlackConnector\n+ 2 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 3 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n80#2:224\n277#3:225\n56#4:226\n49#4:227\n1557#5:228\n1628#5,3:229\n1557#5:232\n1628#5,3:233\n1557#5:236\n1628#5,3:237\n774#5:240\n865#5,2:241\n1557#5:243\n1628#5,3:244\n*S KotlinDebug\n*F\n+ 1 SlackConnector.kt\nai/tock/bot/connector/slack/SlackConnector\n*L\n62#1:224\n62#1:225\n86#1:226\n86#1:227\n181#1:228\n181#1:229,3\n189#1:232\n189#1:233,3\n193#1:236\n193#1:237,3\n215#1:240\n215#1:241,2\n215#1:243\n215#1:244,3\n*E\n"})
public final class SlackConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    @NotNull
    private final String outToken1;
    @NotNull
    private final String outToken2;
    @NotNull
    private final String outToken3;
    @NotNull
    private final SlackClient client;
    @NotNull
    private final InjectedProperty executor$delegate;
    @NotNull
    private static final KLogger logger;
    private static final boolean OLD_SLACK_API;

    public SlackConnector(@NotNull String applicationId, @NotNull String path, @NotNull String outToken1, @NotNull String outToken2, @NotNull String outToken3, @NotNull SlackClient client) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)outToken1, (String)"outToken1");
        Intrinsics.checkNotNullParameter((Object)outToken2, (String)"outToken2");
        Intrinsics.checkNotNullParameter((Object)outToken3, (String)"outToken3");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(SlackConnectorProvider.INSTANCE.getConnectorType(), null, 2, null);
        this.applicationId = applicationId;
        this.path = path;
        this.outToken1 = outToken1;
        this.outToken2 = outToken2;
        this.outToken3 = outToken3;
        this.client = client;
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getOutToken1() {
        return this.outToken1;
    }

    @NotNull
    public final String getOutToken2() {
        return this.outToken2;
    }

    @NotNull
    public final String getOutToken3() {
        return this.outToken3;
    }

    @NotNull
    public final SlackClient getClient() {
        return this.client;
    }

    private final Executor getExecutor() {
        return (Executor)this.executor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        if (OLD_SLACK_API) {
            this.oldApi(controller);
        } else {
            this.eventApi(controller);
        }
    }

    private final void eventApi(ConnectorController controller) {
        controller.registerServices(this.path, arg_0 -> SlackConnector.eventApi$lambda$5(this, controller, arg_0));
    }

    private final void oldApi(ConnectorController controller) {
        controller.registerServices(this.path, arg_0 -> SlackConnector.oldApi$lambda$10(this, controller, arg_0));
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        SlackConnectorMessage message;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        logger.debug(() -> SlackConnector.send$lambda$11(event));
        if (event instanceof Action && (message = SlackMessageConverter.INSTANCE.toMessageOut((Action)event)) != null) {
            this.sendMessage(message, delayInMs);
        }
    }

    private final void sendMessage(SlackConnectorMessage message, long delayInMs) {
        Executor executor = this.getExecutor();
        Duration duration = Duration.ofMillis(delayInMs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        executor.executeBlocking(duration, () -> SlackConnector.sendMessage$lambda$12(this, message));
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> SlackConnector.addSuggestions$lambda$14(text, suggestions, arg_0);
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> SlackConnector.addSuggestions$lambda$17(message, suggestions, arg_0);
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return arg_0 -> SlackConnector.toConnectorMessage$lambda$20(message, arg_0);
    }

    private static final Object eventApi$lambda$5$lambda$4$lambda$1(String $body) {
        return "message received from slack: " + $body;
    }

    private static final Unit eventApi$lambda$5$lambda$4$lambda$2(ConnectorController $controller, Event $event) {
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        ConnectorController.DefaultImpls.handle$default((ConnectorController)$controller, (Event)$event, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Object eventApi$lambda$5$lambda$4$lambda$3(String $body) {
        return "skip message: " + $body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void eventApi$lambda$5$lambda$4(SlackConnector this$0, ConnectorController $controller, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("slack_webhook");
        try {
            void $this$readValue$iv;
            String string;
            String it = context.body().asString();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (StringsKt.startsWith$default((String)it, (String)"payload=", (boolean)false, (int)2, null)) {
                String string2 = it.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = URLDecoder.decode(string2, "UTF-8");
            } else {
                string = it;
            }
            String body = string;
            logger.info(() -> SlackConnector.eventApi$lambda$5$lambda$4$lambda$1(body));
            it = JacksonKt.getMapper();
            Intrinsics.checkNotNull((Object)body);
            String content$iv = body;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            EventApiMessage message = (EventApiMessage)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<EventApiMessage>(){});
            if (message instanceof UrlVerificationEvent) {
                context.response().putHeader("Content-type", "text/plain").end(((UrlVerificationEvent)message).getChallenge());
            } else {
                context.response().end();
                Event event = SlackRequestConverter.INSTANCE.toEvent(message, this$0.applicationId);
                if (event != null) {
                    this$0.getExecutor().executeBlocking(() -> SlackConnector.eventApi$lambda$5$lambda$4$lambda$2($controller, event));
                } else {
                    logger.debug(() -> SlackConnector.eventApi$lambda$5$lambda$4$lambda$3(body));
                }
            }
        }
        catch (Throwable e) {
            RequestTimerKt.logError((KLogger)logger, (Throwable)e, (RequestTimerData)requestTimerData);
            try {
                Future event = context.response().end();
            }
            catch (Exception e2) {
                LoggersKt.error((KLogger)logger, (Throwable)e2);
                Unit event = Unit.INSTANCE;
            }
        }
        finally {
            try {
                BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
            }
            catch (Throwable e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
        }
    }

    private static final Unit eventApi$lambda$5(SlackConnector this$0, ConnectorController $controller, Router router) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        router.post(this$0.path).handler(arg_0 -> SlackConnector.eventApi$lambda$5$lambda$4(this$0, $controller, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object oldApi$lambda$10$lambda$9$lambda$6(String $body) {
        Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
        return "message received from slack: " + $body;
    }

    private static final void oldApi$lambda$10$lambda$9$lambda$7(SlackMessageIn $message, SlackConnector this$0, ConnectorController $controller, RequestTimerData $requestTimerData, Promise it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)$requestTimerData, (String)"$requestTimerData");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            Intrinsics.checkNotNull((Object)$message);
            Event event = SlackRequestConverter.INSTANCE.toEvent($message, this$0.applicationId);
            if (event != null) {
                ConnectorController.DefaultImpls.handle$default((ConnectorController)$controller, (Event)event, null, (int)2, null);
            } else {
                RequestTimerKt.logError((KLogger)logger, (String)("unable to convert " + $message + " to event"), (RequestTimerData)$requestTimerData);
            }
        }
        catch (Throwable e) {
            RequestTimerKt.logError((KLogger)logger, (Throwable)e, (RequestTimerData)$requestTimerData);
        }
    }

    private static final void oldApi$lambda$10$lambda$9$lambda$8(AsyncResult it) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void oldApi$lambda$10$lambda$9(SlackConnector this$0, ConnectorController $controller, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("slack_webhook");
        try {
            Intrinsics.checkNotNull((Object)context);
            String body = SlackCodecKt.convertUrlEncodedStringToJson(context);
            logger.info(() -> SlackConnector.oldApi$lambda$10$lambda$9$lambda$6(body));
            SlackMessageIn message = (SlackMessageIn)JacksonKt.getMapper().readValue(body, SlackMessageIn.class);
            if (!Intrinsics.areEqual((Object)message.getUser_id(), (Object)"USLACKBOT")) {
                VertXsKt.getVertx().executeBlocking(arg_0 -> SlackConnector.oldApi$lambda$10$lambda$9$lambda$7(message, this$0, $controller, requestTimerData, arg_0), false, SlackConnector::oldApi$lambda$10$lambda$9$lambda$8);
            }
        }
        catch (Throwable e) {
            RequestTimerKt.logError((KLogger)logger, (Throwable)e, (RequestTimerData)requestTimerData);
        }
        finally {
            try {
                BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                context.response().end();
            }
            catch (Throwable e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
        }
    }

    private static final Unit oldApi$lambda$10(SlackConnector this$0, ConnectorController $controller, Router router) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        router.post(this$0.path).handler(arg_0 -> SlackConnector.oldApi$lambda$10$lambda$9(this$0, $controller, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object send$lambda$11(Event $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        return "event: " + $event;
    }

    private static final Unit sendMessage$lambda$12(SlackConnector this$0, SlackConnectorMessage $message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        this$0.client.sendMessage(this$0.outToken1, this$0.outToken2, this$0.outToken3, $message);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final SlackMessageOut addSuggestions$lambda$14(CharSequence $text, List $suggestions, BotBus botBus) {
        Collection<Button> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$suggestions, (String)"$suggestions");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        SlackMessageAttachment[] slackMessageAttachmentArray = new SlackMessageAttachment[1];
        Iterable iterable = $suggestions;
        CharSequence charSequence = null;
        I18nTranslator i18nTranslator = (I18nTranslator)botBus;
        int n = 0;
        SlackMessageAttachment[] slackMessageAttachmentArray2 = slackMessageAttachmentArray;
        CharSequence charSequence2 = $text;
        I18nTranslator i18nTranslator2 = (I18nTranslator)botBus;
        boolean $i$f$map = false;
        void var6_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CharSequence charSequence3 = (CharSequence)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SlackBuildersKt.slackButton$default((Bus)botBus, (CharSequence)it, null, null, null, 14, null));
        }
        collection = (List)destination$iv$iv;
        slackMessageAttachmentArray2[n] = SlackBuildersKt.slackAttachment$default(i18nTranslator, charSequence, (List)collection, null, null, null, new AttachmentField[0], 28, null);
        return SlackBuildersKt.slackMessage(i18nTranslator2, charSequence2, slackMessageAttachmentArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConnectorMessage addSuggestions$lambda$17(ConnectorMessage $message, List $suggestions, BotBus botBus) {
        ConnectorMessage connectorMessage;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$suggestions, (String)"$suggestions");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        if ($message instanceof SlackMessageOut) {
            SlackMessageOut slackMessageOut;
            SlackMessageAttachment attachment = (SlackMessageAttachment)CollectionsKt.lastOrNull(((SlackMessageOut)$message).getAttachments());
            if (attachment == null) {
                Collection<Button> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = $suggestions;
                CharSequence charSequence = null;
                I18nTranslator i18nTranslator = (I18nTranslator)botBus;
                String string = null;
                String string2 = null;
                SlackMessageOut slackMessageOut2 = (SlackMessageOut)$message;
                boolean $i$f$map = false;
                void var6_18 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CharSequence charSequence2 = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SlackBuildersKt.slackButton$default((Bus)botBus, (CharSequence)it, null, null, null, 14, null));
                }
                collection = (List)destination$iv$iv;
                slackMessageOut = SlackMessageOut.copy$default(slackMessageOut2, string2, string, CollectionsKt.listOf((Object)SlackBuildersKt.slackAttachment$default(i18nTranslator, charSequence, (List)collection, null, null, null, new AttachmentField[0], 28, null)), 3, null);
            } else if (attachment.getActions().isEmpty()) {
                Collection<Button> collection;
                Iterable $this$map$iv = $suggestions;
                CharSequence charSequence = null;
                I18nTranslator i18nTranslator = (I18nTranslator)botBus;
                Collection collection2 = CollectionsKt.take((Iterable)((SlackMessageOut)$message).getAttachments(), (int)(((SlackMessageOut)$message).getAttachments().size() - 1));
                String string = null;
                String string3 = null;
                SlackMessageOut slackMessageOut3 = (SlackMessageOut)$message;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    CharSequence it = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SlackBuildersKt.slackButton$default((Bus)botBus, it, null, null, null, 14, null));
                }
                collection = (List)destination$iv$iv;
                slackMessageOut = SlackMessageOut.copy$default(slackMessageOut3, string3, string, CollectionsKt.plus((Collection)collection2, (Object)SlackBuildersKt.slackAttachment$default(i18nTranslator, charSequence, (List)collection, null, null, null, new AttachmentField[0], 28, null)), 3, null);
            } else {
                slackMessageOut = null;
            }
            connectorMessage = slackMessageOut;
        } else {
            connectorMessage = null;
        }
        return connectorMessage;
    }

    /*
     * WARNING - void declaration
     */
    private static final List toConnectorMessage$lambda$20(MediaMessage $message, BotBus botBus) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        if ($message instanceof MediaCard) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            MediaAction it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            CharSequence title = ((MediaCard)$message).getTitle();
            CharSequence subTitle = ((MediaCard)$message).getSubTitle();
            Object[] objectArray = new SlackMessageOut[2];
            objectArray[0] = title != null && subTitle != null ? SlackBuildersKt.textMessage((I18nTranslator)botBus, title) : null;
            I18nTranslator i18nTranslator = (I18nTranslator)botBus;
            CharSequence charSequence = subTitle;
            if (charSequence == null && (charSequence = title) == null) {
                charSequence = "";
            }
            SlackMessageAttachment[] slackMessageAttachmentArray = new SlackMessageAttachment[1];
            Iterable iterable = ((MediaCard)$message).getActions();
            CharSequence charSequence2 = null;
            I18nTranslator i18nTranslator2 = (I18nTranslator)botBus;
            int n = 0;
            SlackMessageAttachment[] slackMessageAttachmentArray2 = slackMessageAttachmentArray;
            CharSequence charSequence3 = charSequence;
            I18nTranslator i18nTranslator3 = i18nTranslator;
            int n2 = 1;
            Object[] objectArray2 = objectArray;
            boolean $i$f$filter = false;
            void var8_16 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MediaAction)element$iv$iv;
                boolean bl = false;
                if (!(it.getUrl() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Button> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MediaAction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SlackBuildersKt.slackButton$default((Bus)botBus, it.getTitle(), null, null, null, 14, null));
            }
            collection = (List)destination$iv$iv;
            slackMessageAttachmentArray2[n] = SlackBuildersKt.slackAttachment$default(i18nTranslator2, charSequence2, (List)collection, null, null, null, new AttachmentField[0], 28, null);
            objectArray2[n2] = SlackBuildersKt.slackMessage(i18nTranslator3, charSequence3, slackMessageAttachmentArray);
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit logger$lambda$21() {
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SlackConnector.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger(SlackConnector::logger$lambda$21);
        OLD_SLACK_API = PropertiesKt.booleanProperty((String)"tock_slack_old_api_style", (boolean)false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/tock/bot/connector/slack/SlackConnector$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "OLD_SLACK_API", "", "tock-bot-connector-slack"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

