/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.teams.token;

import ai.tock.bot.connector.teams.token.LoginMicrosoftOnline;
import ai.tock.bot.connector.teams.token.LoginResponse;
import ai.tock.bot.connector.teams.token.TokenHandler;
import ai.tock.shared.Level;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lai/tock/bot/connector/teams/token/TokenHandler;", "", "appId", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "logLevel", "Lai/tock/shared/Level;", "logger", "Lmu/KLogger;", "loginApi", "Lai/tock/bot/connector/teams/token/LoginMicrosoftOnline;", "getLoginApi", "()Lai/tock/bot/connector/teams/token/LoginMicrosoftOnline;", "setLoginApi", "(Lai/tock/bot/connector/teams/token/LoginMicrosoftOnline;)V", "teamsMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getTeamsMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "token", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "tokenExpiration", "Ljava/time/Instant;", "tokenTimerTask", "Ljava/util/Timer;", "checkToken", "", "fetchToken", "isTokenExpired", "", "launchTokenCollector", "connectorId", "msInterval", "", "stopTokenCollector", "tock-bot-connector-teams"})
public final class TokenHandler {
    private final KLogger logger;
    @Nullable
    private volatile String token;
    private volatile Instant tokenExpiration;
    private final Level logLevel;
    @NotNull
    private final ObjectMapper teamsMapper;
    private volatile Timer tokenTimerTask;
    @NotNull
    private LoginMicrosoftOnline loginApi;
    private final String appId;
    private final String password;

    @Nullable
    public final String getToken() {
        return this.token;
    }

    public final void setToken(@Nullable String string) {
        this.token = string;
    }

    @NotNull
    public final ObjectMapper getTeamsMapper() {
        return this.teamsMapper;
    }

    @NotNull
    public final LoginMicrosoftOnline getLoginApi() {
        return this.loginApi;
    }

    public final void setLoginApi(@NotNull LoginMicrosoftOnline loginMicrosoftOnline) {
        Intrinsics.checkNotNullParameter((Object)loginMicrosoftOnline, (String)"<set-?>");
        this.loginApi = loginMicrosoftOnline;
    }

    public final void checkToken() {
        if (this.token == null || this.isTokenExpired()) {
            this.fetchToken();
        }
    }

    public final boolean isTokenExpired() {
        this.logger.debug((Function0)isTokenExpired.1.INSTANCE);
        Instant instant = this.tokenExpiration;
        return Instant.now().isAfter(instant != null ? instant.minus(10L, ChronoUnit.SECONDS) : null);
    }

    private final void fetchToken() {
        Response response = LoginMicrosoftOnline.DefaultImpls.login$default(this.loginApi, null, this.appId, this.password, null, 9, null).execute();
        Object object = (LoginResponse)response.body();
        if (object == null || (object = ((LoginResponse)object).getAccessToken()) == null) {
            String string = "empty access token";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.token = object;
        Instant instant = Instant.now();
        LoginResponse loginResponse = (LoginResponse)response.body();
        Long l = loginResponse != null ? Long.valueOf(loginResponse.getExpiresIn()) : null;
        Intrinsics.checkNotNull((Object)l);
        this.tokenExpiration = instant.plus((long)l, ChronoUnit.SECONDS);
    }

    public final void launchTokenCollector(@NotNull String connectorId, long msInterval) {
        Timer timer;
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        String string = "microsoft-api-token-handling-" + connectorId;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        Timer timer2 = timer = TimersKt.timer((String)string, (boolean)bl);
        boolean bl3 = false;
        boolean bl4 = false;
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ TokenHandler this$0;
            {
                this.this$0 = tokenHandler;
            }

            public void run() {
                TimerTask $this$fixedRateTimer = this;
                boolean bl = false;
                this.this$0.checkToken();
            }
        };
        timer2.scheduleAtFixedRate(timerTask, l, msInterval);
        this.tokenTimerTask = timer;
    }

    public static /* synthetic */ void launchTokenCollector$default(TokenHandler tokenHandler, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 3600000L;
        }
        tokenHandler.launchTokenCollector(string, l);
    }

    public final void stopTokenCollector() {
        if (this.tokenTimerTask != null) {
            Timer timer = this.tokenTimerTask;
            if (timer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokenTimerTask");
            }
            timer.cancel();
            Timer timer2 = this.tokenTimerTask;
            if (timer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokenTimerTask");
            }
            timer2.purge();
        } else {
            this.logger.error("Trying to stop an uninitialized tokentimertask !");
        }
    }

    public TokenHandler(@NotNull String appId, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.appId = appId;
        this.password = password;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.logLevel = this.logger.isDebugEnabled() ? Level.BODY : Level.BASIC;
        ObjectMapper objectMapper = JacksonKt.getMapper().copy().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"mapper.copy().setPropert\u2026amingStrategy.SNAKE_CASE)");
        this.teamsMapper = objectMapper;
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)30000L), (KLogger)this.logger, (Level)this.logLevel, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl("https://login.microsoftonline.com");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026gin.microsoftonline.com\")");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026sMapper)\n        .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(LoginMicrosoftOnline.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.loginApi = (LoginMicrosoftOnline)object;
    }

    public static final /* synthetic */ Timer access$getTokenTimerTask$p(TokenHandler $this) {
        Timer timer = $this.tokenTimerTask;
        if (timer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokenTimerTask");
        }
        return timer;
    }

    public static final /* synthetic */ void access$setTokenTimerTask$p(TokenHandler $this, Timer timer) {
        $this.tokenTimerTask = timer;
    }
}

