/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.teams;

import ai.tock.bot.connector.teams.TeamsClient;
import ai.tock.bot.connector.teams.messages.MarkdownHelper;
import ai.tock.bot.connector.teams.messages.TeamsBotMessage;
import ai.tock.bot.connector.teams.messages.TeamsCardAction;
import ai.tock.bot.connector.teams.messages.TeamsCarousel;
import ai.tock.bot.connector.teams.messages.TeamsHeroCard;
import ai.tock.bot.connector.teams.token.TokenHandler;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.AttachmentLayoutTypes;
import com.microsoft.bot.schema.HeroCard;
import com.microsoft.bot.schema.TextFormatTypes;
import com.microsoft.bot.schema.ThumbnailCard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Url;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/tock/bot/connector/teams/TeamsClient;", "", "tokenHandler", "Lai/tock/bot/connector/teams/token/TokenHandler;", "(Lai/tock/bot/connector/teams/token/TokenHandler;)V", "connectorApi", "Lai/tock/bot/connector/teams/TeamsClient$ConnectorMicrosoftApi;", "customInterceptor", "Lai/tock/bot/connector/teams/TeamsClient$CustomInterceptor;", "logger", "Lmu/KLogger;", "getAttachment", "", "Lcom/microsoft/bot/schema/Attachment;", "event", "Lai/tock/bot/connector/teams/messages/TeamsBotMessage;", "sendMessage", "", "callbackActivity", "Lcom/microsoft/bot/schema/Activity;", "ConnectorMicrosoftApi", "CustomInterceptor", "MessageResponse", "tock-bot-connector-teams"})
public final class TeamsClient {
    @NotNull
    private final TokenHandler tokenHandler;
    @NotNull
    private final ConnectorMicrosoftApi connectorApi;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final CustomInterceptor customInterceptor;

    public TeamsClient(@NotNull TokenHandler tokenHandler) {
        Intrinsics.checkNotNullParameter((Object)tokenHandler, (String)"tokenHandler");
        this.tokenHandler = tokenHandler;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.customInterceptor = new CustomInterceptor();
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_whatsapp_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)this.customInterceptor), (boolean)false, (boolean)false, null, (int)116, null).baseUrl("https://smba.trafficmanager.net/emea/");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026rafficmanager.net/emea/\")");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.tokenHandler.getTeamsMapper()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(ConnectorMicrosoftApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.connectorApi = (ConnectorMicrosoftApi)object;
    }

    public final void sendMessage(@NotNull Activity callbackActivity, @NotNull TeamsBotMessage event) {
        retrofit2.Response messageResponse;
        Activity activity;
        Intrinsics.checkNotNullParameter((Object)callbackActivity, (String)"callbackActivity");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String url = callbackActivity.getServiceUrl() + "/v3/conversations/" + callbackActivity.getConversation().getId() + "/activities/" + callbackActivity.getId();
        Activity $this$sendMessage_u24lambda_u240 = activity = new Activity("message");
        boolean bl = false;
        $this$sendMessage_u24lambda_u240.setText(MarkdownHelper.INSTANCE.activeLink(event.getText()));
        $this$sendMessage_u24lambda_u240.setTextFormat(TextFormatTypes.MARKDOWN);
        $this$sendMessage_u24lambda_u240.setRecipient(callbackActivity.getFrom());
        $this$sendMessage_u24lambda_u240.setAttachments(this.getAttachment(event));
        $this$sendMessage_u24lambda_u240.setFrom(callbackActivity.getRecipient());
        $this$sendMessage_u24lambda_u240.setConversation(callbackActivity.getConversation());
        $this$sendMessage_u24lambda_u240.setReplyToId(callbackActivity.getId());
        Activity activity2 = activity;
        if (event instanceof TeamsCarousel) {
            activity2.setAttachmentLayout(AttachmentLayoutTypes.CAROUSEL);
        }
        if (!(messageResponse = this.connectorApi.postResponse(url, activity2).execute()).isSuccessful()) {
            this.logger.warn((Function0)new Function0<Object>((retrofit2.Response<MessageResponse>)messageResponse){
                final /* synthetic */ retrofit2.Response<MessageResponse> $messageResponse;
                {
                    this.$messageResponse = $messageResponse;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Microsoft Login Api Error : " + this.$messageResponse.code() + " // " + this.$messageResponse.errorBody();
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> getAttachment(TeamsBotMessage event) {
        List attachments = new ArrayList();
        TeamsBotMessage teamsBotMessage = event;
        if (teamsBotMessage instanceof TeamsCardAction) {
            void $this$getAttachment_u24lambda_u242;
            ThumbnailCard thumbnailCard;
            ThumbnailCard $this$getAttachment_u24lambda_u241 = thumbnailCard = new ThumbnailCard();
            boolean bl = false;
            $this$getAttachment_u24lambda_u241.setTitle(((TeamsCardAction)event).getActionTitle());
            $this$getAttachment_u24lambda_u241.setButtons(((TeamsCardAction)event).getButtons());
            ThumbnailCard card = thumbnailCard;
            $this$getAttachment_u24lambda_u241 = thumbnailCard = new Attachment();
            List list = attachments;
            boolean bl2 = false;
            $this$getAttachment_u24lambda_u242.setContentType("application/vnd.microsoft.card.thumbnail");
            $this$getAttachment_u24lambda_u242.setContent((Object)card);
            list.add(thumbnailCard);
        } else if (teamsBotMessage instanceof TeamsCarousel) {
            List listElement = new ArrayList();
            listElement.addAll((Collection)((TeamsCarousel)event).getListMessage());
            while (!((Collection)listElement).isEmpty()) {
                attachments.addAll((Collection)this.getAttachment((TeamsBotMessage)listElement.remove(0)));
            }
        } else if (teamsBotMessage instanceof TeamsHeroCard) {
            void $this$getAttachment_u24lambda_u244;
            HeroCard heroCard;
            HeroCard $this$getAttachment_u24lambda_u243 = heroCard = new HeroCard();
            boolean bl = false;
            $this$getAttachment_u24lambda_u243.setTitle(((TeamsHeroCard)event).getTitle());
            $this$getAttachment_u24lambda_u243.setSubtitle(((TeamsHeroCard)event).getSubtitle());
            $this$getAttachment_u24lambda_u243.setText(((TeamsHeroCard)event).getAttachmentContent());
            $this$getAttachment_u24lambda_u243.setImages(((TeamsHeroCard)event).getImages());
            $this$getAttachment_u24lambda_u243.setButtons(((TeamsHeroCard)event).getButtons());
            $this$getAttachment_u24lambda_u243.setTap(((TeamsHeroCard)event).getTap());
            HeroCard card = heroCard;
            $this$getAttachment_u24lambda_u243 = heroCard = new Attachment();
            List list = attachments;
            boolean bl3 = false;
            $this$getAttachment_u24lambda_u244.setContentType("application/vnd.microsoft.card.hero");
            $this$getAttachment_u24lambda_u244.setContent((Object)card);
            list.add(heroCard);
        }
        return attachments;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/tock/bot/connector/teams/TeamsClient$MessageResponse;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-bot-connector-teams"})
    private static final class MessageResponse {
        @NotNull
        private final String id;

        public MessageResponse(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final MessageResponse copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new MessageResponse(id);
        }

        public static /* synthetic */ MessageResponse copy$default(MessageResponse messageResponse, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = messageResponse.id;
            }
            return messageResponse.copy(string);
        }

        @NotNull
        public String toString() {
            return "MessageResponse(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageResponse)) {
                return false;
            }
            MessageResponse messageResponse = (MessageResponse)other;
            return Intrinsics.areEqual((Object)this.id, (Object)messageResponse.id);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH'\u00a8\u0006\t"}, d2={"Lai/tock/bot/connector/teams/TeamsClient$ConnectorMicrosoftApi;", "", "postResponse", "Lretrofit2/Call;", "Lai/tock/bot/connector/teams/TeamsClient$MessageResponse;", "url", "", "activity", "Lcom/microsoft/bot/schema/Activity;", "tock-bot-connector-teams"})
    private static interface ConnectorMicrosoftApi {
        @POST
        @Headers(value={"Content-Type: application/json"})
        @NotNull
        public Call<MessageResponse> postResponse(@Url @NotNull String var1, @Body @NotNull Activity var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lai/tock/bot/connector/teams/TeamsClient$CustomInterceptor;", "Lokhttp3/Interceptor;", "(Lai/tock/bot/connector/teams/TeamsClient;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "tock-bot-connector-teams"})
    private final class CustomInterceptor
    implements Interceptor {
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            TeamsClient.this.tokenHandler.checkToken();
            Request request = chain.request();
            request = request.newBuilder().addHeader("Authorization", "Bearer " + TeamsClient.this.tokenHandler.getToken()).build();
            Response response = chain.proceed(request);
            TeamsClient.this.logger.debug((Function0)new Function0<Object>(response){
                final /* synthetic */ Response $response;
                {
                    this.$response = $response;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Response sent to Teams : " + this.$response.code() + " - " + this.$response.message();
                }
            });
            return response;
        }
    }
}

