/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.teams.auth;

import ai.tock.bot.connector.teams.auth.JWKHandler;
import ai.tock.bot.connector.teams.auth.MicrosoftJwksApi;
import ai.tock.bot.connector.teams.auth.MicrosoftOpenIdMetadataApi;
import ai.tock.bot.connector.teams.auth.MicrosoftOpenidMetadata;
import ai.tock.bot.connector.teams.auth.MicrosoftValidSigningKeys;
import ai.tock.shared.Level;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020 J\u0015\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b'J\u0006\u0010(\u001a\u00020\u001bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017j\n\u0012\u0004\u0012\u00020\u0018\u0018\u0001`\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lai/tock/bot/connector/teams/auth/JWKHandler;", "", "()V", "cacheKeys", "Lai/tock/bot/connector/teams/auth/MicrosoftValidSigningKeys;", "getCacheKeys", "()Lai/tock/bot/connector/teams/auth/MicrosoftValidSigningKeys;", "setCacheKeys", "(Lai/tock/bot/connector/teams/auth/MicrosoftValidSigningKeys;)V", "jwkTimerTask", "Ljava/util/Timer;", "logLevel", "Lai/tock/shared/Level;", "logger", "Lmu/KLogger;", "microsoftJwksApi", "Lai/tock/bot/connector/teams/auth/MicrosoftJwksApi;", "microsoftOpenIdMetadataApi", "Lai/tock/bot/connector/teams/auth/MicrosoftOpenIdMetadataApi;", "microsoftOpenIdMetadataApiForBotFwkEmulator", "teamsMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "tokenIds", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "collectJWK", "", "getJWK", "launchJWKCollector", "connectorId", "msInterval", "", "setJKSBaseLocation", "url", "setJKSBaseLocation$tock_bot_connector_teams", "setOpenIdMatadataLocation", "setOpenIdMatadataLocation$tock_bot_connector_teams", "setOpenIdMatadataLocationBotFwkEmulator", "setOpenIdMatadataLocationBotFwkEmulator$tock_bot_connector_teams", "stopJWKCollector", "Companion", "tock-bot-connector-teams"})
public final class JWKHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile ArrayList<String> tokenIds;
    @Nullable
    private volatile MicrosoftValidSigningKeys cacheKeys;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final Level logLevel = this.logger.isDebugEnabled() ? Level.BODY : Level.BASIC;
    @NotNull
    private final ObjectMapper teamsMapper;
    private Timer jwkTimerTask;
    @NotNull
    private MicrosoftOpenIdMetadataApi microsoftOpenIdMetadataApiForBotFwkEmulator;
    @NotNull
    private MicrosoftOpenIdMetadataApi microsoftOpenIdMetadataApi;
    @NotNull
    private MicrosoftJwksApi microsoftJwksApi;
    @NotNull
    private static String OPENID_METADATA_LOCATION = "https://login.botframework.com/v1/";
    @NotNull
    private static String JKS_BASE_LOCATION = "https://login.botframework.com/v1/.well-known/keys/";
    @NotNull
    private static String OPENID_METADATA_LOCATION_BOT_FWK_EMULATOR = "https://login.microsoftonline.com/botframework.com/v2.0/";

    public JWKHandler() {
        ObjectMapper objectMapper = JacksonKt.getMapper().copy().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"mapper.copy().setPropert\u2026amingStrategy.SNAKE_CASE)");
        this.teamsMapper = objectMapper;
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)5000L), (KLogger)this.logger, (Level)this.logLevel, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl(OPENID_METADATA_LOCATION_BOT_FWK_EMULATOR);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026OCATION_BOT_FWK_EMULATOR)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026sMapper)\n        .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(MicrosoftOpenIdMetadataApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.microsoftOpenIdMetadataApiForBotFwkEmulator = (MicrosoftOpenIdMetadataApi)object;
        Retrofit.Builder builder2 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)5000L), (KLogger)this.logger, (Level)this.logLevel, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl(OPENID_METADATA_LOCATION);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"retrofitBuilderWithTimeo\u2026OPENID_METADATA_LOCATION)");
        $this$create$iv = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder2, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"retrofitBuilderWithTimeo\u2026sMapper)\n        .build()");
        $i$f$create = false;
        Object object2 = $this$create$iv.create(MicrosoftOpenIdMetadataApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(T::class.java)");
        this.microsoftOpenIdMetadataApi = (MicrosoftOpenIdMetadataApi)object2;
        Retrofit.Builder builder3 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)5000L), (KLogger)this.logger, (Level)this.logLevel, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl(JKS_BASE_LOCATION);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"retrofitBuilderWithTimeo\u2026aseUrl(JKS_BASE_LOCATION)");
        $this$create$iv = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder3, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"retrofitBuilderWithTimeo\u2026sMapper)\n        .build()");
        $i$f$create = false;
        Object object3 = $this$create$iv.create(MicrosoftJwksApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"create(T::class.java)");
        this.microsoftJwksApi = (MicrosoftJwksApi)object3;
    }

    @Nullable
    public final MicrosoftValidSigningKeys getCacheKeys() {
        return this.cacheKeys;
    }

    public final void setCacheKeys(@Nullable MicrosoftValidSigningKeys microsoftValidSigningKeys) {
        this.cacheKeys = microsoftValidSigningKeys;
    }

    public final void launchJWKCollector(@NotNull String connectorId, long msInterval) {
        Timer timer;
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        String string = "microsoft-jwk-collector-" + connectorId;
        long l = 0L;
        boolean bl = false;
        Timer timer2 = timer = TimersKt.timer((String)string, (boolean)bl);
        timer2.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ JWKHandler this$0;
            {
                this.this$0 = jWKHandler;
            }

            public void run() {
                TimerTask $this$launchJWKCollector_u24lambda_u240 = this;
                boolean bl = false;
                JWKHandler.access$collectJWK(this.this$0);
            }
        }, l, msInterval);
        this.jwkTimerTask = timer;
    }

    public static /* synthetic */ void launchJWKCollector$default(JWKHandler jWKHandler, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 82800000L;
        }
        jWKHandler.launchJWKCollector(string, l);
    }

    public final void stopJWKCollector() {
        if (this.jwkTimerTask != null) {
            Timer timer = this.jwkTimerTask;
            if (timer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"jwkTimerTask");
                timer = null;
            }
            timer.cancel();
            Timer timer2 = this.jwkTimerTask;
            if (timer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"jwkTimerTask");
                timer2 = null;
            }
            timer2.purge();
        }
    }

    private final void collectJWK() {
        this.logger.debug("Getting new jwks");
        Response microsoftOpenidMetadata = this.microsoftOpenIdMetadataApi.getMicrosoftOpenIdMetadata().execute();
        MicrosoftOpenidMetadata response = (MicrosoftOpenidMetadata)microsoftOpenidMetadata.body();
        Object object = response;
        if (object == null || (object = ((MicrosoftOpenidMetadata)object).getIdTokenSigningAlgValuesSupported()) == null) {
            throw new IllegalStateException("Error : Unable to get OpenidMetadata to validate BotConnectorServiceKeys".toString());
        }
        this.tokenIds = object;
        MicrosoftValidSigningKeys microsoftValidSigningKeys = (MicrosoftValidSigningKeys)this.microsoftJwksApi.getJwk(response.getJwksUri()).execute().body();
        if (microsoftValidSigningKeys == null) {
            throw new IllegalStateException("Error : Unable to get JWK signatures to validate BotConnectorServiceKeys".toString());
        }
        MicrosoftValidSigningKeys keysForBotConnectorService = microsoftValidSigningKeys;
        List listOfKeys = CollectionsKt.toMutableList((Collection)keysForBotConnectorService.getKeys());
        if (PropertiesKt.getDevEnvironment()) {
            Response microsoftOpenidMetadataBotFwkEmulator = this.microsoftOpenIdMetadataApiForBotFwkEmulator.getMicrosoftOpenIdMetadataForBotFwkEmulator().execute();
            MicrosoftOpenidMetadata nextResponse = (MicrosoftOpenidMetadata)microsoftOpenidMetadataBotFwkEmulator.body();
            ArrayList<String> arrayList = this.tokenIds;
            if (arrayList != null) {
                Object object2 = nextResponse;
                if (object2 == null || (object2 = ((MicrosoftOpenidMetadata)object2).getIdTokenSigningAlgValuesSupported()) == null) {
                    throw new IllegalStateException("Error : Unable to get OpenidMetadata to validate BotFrameworkEmulatorKeys".toString());
                }
                arrayList.addAll((Collection)object2);
            }
            MicrosoftOpenidMetadata microsoftOpenidMetadata2 = nextResponse;
            Intrinsics.checkNotNull((Object)microsoftOpenidMetadata2);
            MicrosoftValidSigningKeys microsoftValidSigningKeys2 = (MicrosoftValidSigningKeys)this.microsoftJwksApi.getJwk(microsoftOpenidMetadata2.getJwksUri()).execute().body();
            if (microsoftValidSigningKeys2 == null) {
                throw new IllegalStateException("Error : Unable to get JWK signatures to validate BotFrameworkEmulatorKeys".toString());
            }
            MicrosoftValidSigningKeys keysForBotFwkEmulator = microsoftValidSigningKeys2;
            listOfKeys.addAll((Collection)keysForBotFwkEmulator.getKeys());
        }
        this.cacheKeys = new MicrosoftValidSigningKeys(listOfKeys);
    }

    @Nullable
    public final MicrosoftValidSigningKeys getJWK() {
        if (this.cacheKeys == null) {
            this.collectJWK();
        }
        return this.cacheKeys;
    }

    public final void setOpenIdMatadataLocation$tock_bot_connector_teams(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.logger.debug("setOpenIdMatadataLocation : " + url);
        OPENID_METADATA_LOCATION = url;
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)5000L), (KLogger)this.logger, (Level)Level.BASIC, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl(OPENID_METADATA_LOCATION);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026OPENID_METADATA_LOCATION)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(MicrosoftOpenIdMetadataApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.microsoftOpenIdMetadataApi = (MicrosoftOpenIdMetadataApi)object;
    }

    public final void setOpenIdMatadataLocationBotFwkEmulator$tock_bot_connector_teams(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.logger.debug("setOpenIdMatadataLocationBotFwkEmulator : " + url);
        OPENID_METADATA_LOCATION_BOT_FWK_EMULATOR = url;
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)5000L), (KLogger)this.logger, (Level)Level.BASIC, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl(OPENID_METADATA_LOCATION);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026OPENID_METADATA_LOCATION)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(MicrosoftOpenIdMetadataApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.microsoftOpenIdMetadataApiForBotFwkEmulator = (MicrosoftOpenIdMetadataApi)object;
    }

    public final void setJKSBaseLocation$tock_bot_connector_teams(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.logger.debug("setJKSBaseLocation : " + url);
        JKS_BASE_LOCATION = url;
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)5000L), (KLogger)this.logger, (Level)Level.BASIC, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl(JKS_BASE_LOCATION);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026aseUrl(JKS_BASE_LOCATION)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(MicrosoftJwksApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.microsoftJwksApi = (MicrosoftJwksApi)object;
    }

    public static final /* synthetic */ void access$collectJWK(JWKHandler $this) {
        $this.collectJWK();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/tock/bot/connector/teams/auth/JWKHandler$Companion;", "", "()V", "JKS_BASE_LOCATION", "", "OPENID_METADATA_LOCATION", "OPENID_METADATA_LOCATION_BOT_FWK_EMULATOR", "tock-bot-connector-teams"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

