/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.teams;

import ai.tock.bot.connector.teams.messages.MarkdownHelper;
import ai.tock.bot.connector.teams.messages.TeamsBotMessage;
import ai.tock.bot.connector.teams.messages.TeamsCardAction;
import ai.tock.bot.connector.teams.messages.TeamsCarousel;
import ai.tock.bot.connector.teams.messages.TeamsHeroCard;
import ai.tock.bot.connector.teams.token.TokenHandler;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.AttachmentLayoutTypes;
import com.microsoft.bot.schema.HeroCard;
import com.microsoft.bot.schema.TextFormatTypes;
import com.microsoft.bot.schema.ThumbnailCard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Url;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/tock/bot/connector/teams/TeamsClient;", "", "tokenHandler", "Lai/tock/bot/connector/teams/token/TokenHandler;", "<init>", "(Lai/tock/bot/connector/teams/token/TokenHandler;)V", "connectorApi", "Lai/tock/bot/connector/teams/TeamsClient$ConnectorMicrosoftApi;", "logger", "Lmu/KLogger;", "customInterceptor", "Lai/tock/bot/connector/teams/TeamsClient$CustomInterceptor;", "sendMessage", "", "callbackActivity", "Lcom/microsoft/bot/schema/Activity;", "event", "Lai/tock/bot/connector/teams/messages/TeamsBotMessage;", "getAttachment", "", "Lcom/microsoft/bot/schema/Attachment;", "MessageResponse", "ConnectorMicrosoftApi", "CustomInterceptor", "tock-bot-connector-teams"})
@SourceDebugExtension(value={"SMAP\nTeamsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamsClient.kt\nai/tock/bot/connector/teams/TeamsClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,170:1\n71#2:171\n*S KotlinDebug\n*F\n+ 1 TeamsClient.kt\nai/tock/bot/connector/teams/TeamsClient\n*L\n60#1:171\n*E\n"})
public final class TeamsClient {
    @NotNull
    private final TokenHandler tokenHandler;
    @NotNull
    private final ConnectorMicrosoftApi connectorApi;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final CustomInterceptor customInterceptor;

    public TeamsClient(@NotNull TokenHandler tokenHandler) {
        Intrinsics.checkNotNullParameter((Object)tokenHandler, (String)"tokenHandler");
        this.tokenHandler = tokenHandler;
        this.logger = KotlinLogging.INSTANCE.logger(TeamsClient::logger$lambda$0);
        this.customInterceptor = new CustomInterceptor();
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_whatsapp_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)this.customInterceptor), (boolean)false, (boolean)false, null, (int)116, null).baseUrl("https://smba.trafficmanager.net/emea/");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"baseUrl(...)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.tokenHandler.getTeamsMapper()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(ConnectorMicrosoftApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.connectorApi = (ConnectorMicrosoftApi)object;
    }

    public final void sendMessage(@NotNull Activity callbackActivity, @NotNull TeamsBotMessage event) {
        retrofit2.Response messageResponse;
        Activity activity;
        Intrinsics.checkNotNullParameter((Object)callbackActivity, (String)"callbackActivity");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String url = callbackActivity.getServiceUrl() + "/v3/conversations/" + callbackActivity.getConversation().getId() + "/activities/" + callbackActivity.getId();
        Activity $this$sendMessage_u24lambda_u241 = activity = new Activity("message");
        boolean bl = false;
        $this$sendMessage_u24lambda_u241.setText(MarkdownHelper.INSTANCE.activeLink(event.getText()));
        $this$sendMessage_u24lambda_u241.setTextFormat(TextFormatTypes.MARKDOWN);
        $this$sendMessage_u24lambda_u241.setRecipient(callbackActivity.getFrom());
        $this$sendMessage_u24lambda_u241.setAttachments(this.getAttachment(event));
        $this$sendMessage_u24lambda_u241.setFrom(callbackActivity.getRecipient());
        $this$sendMessage_u24lambda_u241.setConversation(callbackActivity.getConversation());
        $this$sendMessage_u24lambda_u241.setReplyToId(callbackActivity.getId());
        Activity activity2 = activity;
        if (event instanceof TeamsCarousel) {
            activity2.setAttachmentLayout(AttachmentLayoutTypes.CAROUSEL);
        }
        if (!(messageResponse = this.connectorApi.postResponse(url, activity2).execute()).isSuccessful()) {
            this.logger.warn(() -> TeamsClient.sendMessage$lambda$2(messageResponse));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> getAttachment(TeamsBotMessage event) {
        List attachments = new ArrayList();
        TeamsBotMessage teamsBotMessage = event;
        if (teamsBotMessage instanceof TeamsCardAction) {
            void $this$getAttachment_u24lambda_u244;
            ThumbnailCard thumbnailCard;
            ThumbnailCard $this$getAttachment_u24lambda_u243 = thumbnailCard = new ThumbnailCard();
            boolean bl = false;
            $this$getAttachment_u24lambda_u243.setTitle(((TeamsCardAction)event).getActionTitle());
            $this$getAttachment_u24lambda_u243.setButtons(((TeamsCardAction)event).getButtons());
            ThumbnailCard card = thumbnailCard;
            $this$getAttachment_u24lambda_u243 = thumbnailCard = new Attachment();
            List list = attachments;
            boolean bl2 = false;
            $this$getAttachment_u24lambda_u244.setContentType("application/vnd.microsoft.card.thumbnail");
            $this$getAttachment_u24lambda_u244.setContent((Object)card);
            list.add(thumbnailCard);
        } else if (teamsBotMessage instanceof TeamsCarousel) {
            List listElement = new ArrayList();
            listElement.addAll((Collection)((TeamsCarousel)event).getListMessage());
            while (!((Collection)listElement).isEmpty()) {
                attachments.addAll((Collection)this.getAttachment((TeamsBotMessage)listElement.remove(0)));
            }
        } else if (teamsBotMessage instanceof TeamsHeroCard) {
            void $this$getAttachment_u24lambda_u246;
            HeroCard heroCard;
            HeroCard $this$getAttachment_u24lambda_u245 = heroCard = new HeroCard();
            boolean bl = false;
            $this$getAttachment_u24lambda_u245.setTitle(((TeamsHeroCard)event).getTitle());
            $this$getAttachment_u24lambda_u245.setSubtitle(((TeamsHeroCard)event).getSubtitle());
            $this$getAttachment_u24lambda_u245.setText(((TeamsHeroCard)event).getAttachmentContent());
            $this$getAttachment_u24lambda_u245.setImages(((TeamsHeroCard)event).getImages());
            $this$getAttachment_u24lambda_u245.setButtons(((TeamsHeroCard)event).getButtons());
            $this$getAttachment_u24lambda_u245.setTap(((TeamsHeroCard)event).getTap());
            HeroCard card = heroCard;
            $this$getAttachment_u24lambda_u245 = heroCard = new Attachment();
            List list = attachments;
            boolean bl3 = false;
            $this$getAttachment_u24lambda_u246.setContentType("application/vnd.microsoft.card.hero");
            $this$getAttachment_u24lambda_u246.setContent((Object)card);
            list.add(heroCard);
        }
        return attachments;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object sendMessage$lambda$2(retrofit2.Response $messageResponse) {
        return "Microsoft Login Api Error : " + $messageResponse.code() + " // " + $messageResponse.errorBody();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH'\u00a8\u0006\t"}, d2={"Lai/tock/bot/connector/teams/TeamsClient$ConnectorMicrosoftApi;", "", "postResponse", "Lretrofit2/Call;", "Lai/tock/bot/connector/teams/TeamsClient$MessageResponse;", "url", "", "activity", "Lcom/microsoft/bot/schema/Activity;", "tock-bot-connector-teams"})
    private static interface ConnectorMicrosoftApi {
        @POST
        @Headers(value={"Content-Type: application/json"})
        @NotNull
        public Call<MessageResponse> postResponse(@Url @NotNull String var1, @Body @NotNull Activity var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lai/tock/bot/connector/teams/TeamsClient$CustomInterceptor;", "Lokhttp3/Interceptor;", "<init>", "(Lai/tock/bot/connector/teams/TeamsClient;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "tock-bot-connector-teams"})
    private final class CustomInterceptor
    implements Interceptor {
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            TeamsClient.this.tokenHandler.checkToken();
            Request request = chain.request();
            request = request.newBuilder().addHeader("Authorization", "Bearer " + TeamsClient.this.tokenHandler.getToken()).build();
            Response response = chain.proceed(request);
            TeamsClient.this.logger.debug(() -> CustomInterceptor.intercept$lambda$0(response));
            return response;
        }

        private static final Object intercept$lambda$0(Response $response) {
            return "Response sent to Teams : " + $response.code() + " - " + $response.message();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lai/tock/bot/connector/teams/TeamsClient$MessageResponse;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-bot-connector-teams"})
    private static final class MessageResponse {
        @NotNull
        private final String id;

        public MessageResponse(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final MessageResponse copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new MessageResponse(id);
        }

        public static /* synthetic */ MessageResponse copy$default(MessageResponse messageResponse, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = messageResponse.id;
            }
            return messageResponse.copy(string);
        }

        @NotNull
        public String toString() {
            return "MessageResponse(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageResponse)) {
                return false;
            }
            MessageResponse messageResponse = (MessageResponse)other;
            return Intrinsics.areEqual((Object)this.id, (Object)messageResponse.id);
        }
    }
}

