/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.teams.auth;

import ai.tock.bot.connector.teams.auth.ForbiddenException;
import ai.tock.bot.connector.teams.auth.JWKHandler;
import ai.tock.bot.connector.teams.auth.MicrosoftValidSigningKey;
import ai.tock.bot.connector.teams.auth.MicrosoftValidSigningKeys;
import ai.tock.shared.PropertiesKt;
import com.microsoft.bot.schema.Activity;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import io.vertx.core.MultiMap;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/tock/bot/connector/teams/auth/AuthenticateBotConnectorService;", "", "appId", "", "<init>", "(Ljava/lang/String;)V", "logger", "Lmu/KLogger;", "checkRequestValidity", "", "jwkHandler", "Lai/tock/bot/connector/teams/auth/JWKHandler;", "headers", "Lio/vertx/core/MultiMap;", "activity", "Lcom/microsoft/bot/schema/Activity;", "checkTokenValidityFromEmulator", "", "checkTokenValidityFromConnectorService", "checkValidity", "signedJWT", "Lcom/nimbusds/jwt/SignedJWT;", "checkSignature", "Companion", "tock-bot-connector-teams"})
@SourceDebugExtension(value={"SMAP\nAuthenticateBotConnectorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticateBotConnectorService.kt\nai/tock/bot/connector/teams/auth/AuthenticateBotConnectorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1863#2,2:180\n*S KotlinDebug\n*F\n+ 1 AuthenticateBotConnectorService.kt\nai/tock/bot/connector/teams/auth/AuthenticateBotConnectorService\n*L\n162#1:180,2\n*E\n"})
public final class AuthenticateBotConnectorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String appId;
    @NotNull
    private final KLogger logger;
    @NotNull
    public static final String AUTHORIZATION_HEADER = "Authorization";
    @NotNull
    public static final String ISSUER_BOT_CONNECTOR_SERVICE = "https://api.botframework.com";
    @NotNull
    private static final List<String> ISSUER_BOT_FWK_EMULATOR;
    @NotNull
    public static final String BEARER_PREFIX = "Bearer ";

    public AuthenticateBotConnectorService(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.appId = appId;
        this.logger = KotlinLogging.INSTANCE.logger(AuthenticateBotConnectorService::logger$lambda$0);
    }

    public final void checkRequestValidity(@NotNull JWKHandler jwkHandler, @NotNull MultiMap headers, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)jwkHandler, (String)"jwkHandler");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Ref.BooleanRef isFromTheBotConnectorService = new Ref.BooleanRef();
        Ref.BooleanRef isFromTheBotFwkEmulator = new Ref.BooleanRef();
        Ref.ObjectRef errorStackTrace = new Ref.ObjectRef();
        errorStackTrace.element = "";
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isFromTheBotConnectorService, this, jwkHandler, headers, activity, (Ref.ObjectRef<String>)errorStackTrace, isFromTheBotFwkEmulator, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ref.BooleanRef $isFromTheBotConnectorService;
            final /* synthetic */ AuthenticateBotConnectorService this$0;
            final /* synthetic */ JWKHandler $jwkHandler;
            final /* synthetic */ MultiMap $headers;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ Ref.ObjectRef<String> $errorStackTrace;
            final /* synthetic */ Ref.BooleanRef $isFromTheBotFwkEmulator;
            {
                this.$isFromTheBotConnectorService = $isFromTheBotConnectorService;
                this.this$0 = $receiver;
                this.$jwkHandler = $jwkHandler;
                this.$headers = $headers;
                this.$activity = $activity;
                this.$errorStackTrace = $errorStackTrace;
                this.$isFromTheBotFwkEmulator = $isFromTheBotFwkEmulator;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block7: {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$runBlocking = (CoroutineScope)this.L$0;
                            jobAuthenticateFromBotConnectorService = BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$isFromTheBotConnectorService, this.this$0, this.$jwkHandler, this.$headers, this.$activity, this.$errorStackTrace, null){
                                int label;
                                final /* synthetic */ Ref.BooleanRef $isFromTheBotConnectorService;
                                final /* synthetic */ AuthenticateBotConnectorService this$0;
                                final /* synthetic */ JWKHandler $jwkHandler;
                                final /* synthetic */ MultiMap $headers;
                                final /* synthetic */ Activity $activity;
                                final /* synthetic */ Ref.ObjectRef<String> $errorStackTrace;
                                {
                                    this.$isFromTheBotConnectorService = $isFromTheBotConnectorService;
                                    this.this$0 = $receiver;
                                    this.$jwkHandler = $jwkHandler;
                                    this.$headers = $headers;
                                    this.$activity = $activity;
                                    this.$errorStackTrace = $errorStackTrace;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            boolean bl;
                                            Ref.BooleanRef booleanRef;
                                            ResultKt.throwOnFailure((Object)object);
                                            Ref.BooleanRef booleanRef2 = this.$isFromTheBotConnectorService;
                                            try {
                                                booleanRef = booleanRef2;
                                                bl = AuthenticateBotConnectorService.access$checkTokenValidityFromConnectorService(this.this$0, this.$jwkHandler, this.$headers, this.$activity);
                                            }
                                            catch (Exception exception) {
                                                void e;
                                                booleanRef = booleanRef2;
                                                this.$errorStackTrace.element = e.getMessage();
                                                bl = false;
                                            }
                                            booleanRef.element = bl;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            jobAuthenticateFromBotFrameworkEmulator = PropertiesKt.getDevEnvironment() != false ? BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$isFromTheBotFwkEmulator, this.this$0, this.$jwkHandler, this.$headers, null){
                                int label;
                                final /* synthetic */ Ref.BooleanRef $isFromTheBotFwkEmulator;
                                final /* synthetic */ AuthenticateBotConnectorService this$0;
                                final /* synthetic */ JWKHandler $jwkHandler;
                                final /* synthetic */ MultiMap $headers;
                                {
                                    this.$isFromTheBotFwkEmulator = $isFromTheBotFwkEmulator;
                                    this.this$0 = $receiver;
                                    this.$jwkHandler = $jwkHandler;
                                    this.$headers = $headers;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.$isFromTheBotFwkEmulator.element = AuthenticateBotConnectorService.access$checkTokenValidityFromEmulator(this.this$0, this.$jwkHandler, this.$headers);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null) : null;
                            this.L$0 = jobAuthenticateFromBotFrameworkEmulator;
                            this.label = 1;
                            v0 = jobAuthenticateFromBotConnectorService.join((Continuation)this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl18
                        }
                        case 1: {
                            jobAuthenticateFromBotFrameworkEmulator = (Deferred)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            v1 = jobAuthenticateFromBotFrameworkEmulator;
                            if (v1 == null) break;
                            this.L$0 = null;
                            this.label = 2;
                            v2 = v1.join((Continuation)this);
                            if (v2 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl29:
                            // 2 sources

                            v3 = Unit.INSTANCE;
                            break block7;
                        }
                    }
                    v3 = null;
                }
                return v3;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!isFromTheBotConnectorService.element && !isFromTheBotFwkEmulator.element) {
            throw new ForbiddenException("Unvalid JWT in Authorization Header : " + errorStackTrace.element);
        }
    }

    private final boolean checkTokenValidityFromEmulator(JWKHandler jwkHandler, MultiMap headers) {
        this.logger.debug("Validating token from incoming request...");
        String authorizationHeader = headers.get(AUTHORIZATION_HEADER);
        try {
            Intrinsics.checkNotNull((Object)authorizationHeader);
            if (!StringsKt.contains$default((CharSequence)authorizationHeader, (CharSequence)BEARER_PREFIX, (boolean)false, (int)2, null)) {
                throw new ForbiddenException("Authorization Header does not contains the Bearer scheme");
            }
            String token = StringsKt.removePrefix((String)authorizationHeader, (CharSequence)BEARER_PREFIX);
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (!ISSUER_BOT_FWK_EMULATOR.contains(signedJWT.getJWTClaimsSet().getIssuer())) {
                this.logger.error("Invalid issuer : " + signedJWT.getJWTClaimsSet().getIssuer());
                throw new ForbiddenException("Issuer is not valid");
            }
            if (!signedJWT.getJWTClaimsSet().getAudience().contains(this.appId)) {
                throw new ForbiddenException("Audience is not valid");
            }
            if (!Intrinsics.areEqual((Object)signedJWT.getJWTClaimsSet().getClaim("azp"), (Object)this.appId)) {
                throw new ForbiddenException("AppId claim is not valid");
            }
            Intrinsics.checkNotNull((Object)signedJWT);
            this.checkValidity(signedJWT);
            this.checkSignature(signedJWT, jwkHandler);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private final boolean checkTokenValidityFromConnectorService(JWKHandler jwkHandler, MultiMap headers, Activity activity) {
        this.logger.debug("Validating token from incoming request...");
        String authorizationHeader = headers.get(AUTHORIZATION_HEADER);
        try {
            Intrinsics.checkNotNull((Object)authorizationHeader);
            if (!StringsKt.contains$default((CharSequence)authorizationHeader, (CharSequence)BEARER_PREFIX, (boolean)false, (int)2, null)) {
                throw new ForbiddenException("Authorization Header does not contains the Bearer scheme");
            }
            String token = StringsKt.removePrefix((String)authorizationHeader, (CharSequence)BEARER_PREFIX);
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (!Intrinsics.areEqual((Object)signedJWT.getJWTClaimsSet().getIssuer(), (Object)ISSUER_BOT_CONNECTOR_SERVICE)) {
                throw new ForbiddenException("Issuer is not valid");
            }
            if (!signedJWT.getJWTClaimsSet().getAudience().contains(this.appId)) {
                throw new ForbiddenException("Audience is not valid");
            }
            Intrinsics.checkNotNull((Object)signedJWT);
            this.checkValidity(signedJWT);
            this.checkSignature(signedJWT, jwkHandler);
            Object object = signedJWT.getJWTClaimsSet().getClaim("serviceurl");
            if (object == null) {
                throw new ForbiddenException("Token doesn't contains any serviceUrl Claims");
            }
            if (!Intrinsics.areEqual((Object)object, (Object)activity.getServiceUrl())) {
                throw new ForbiddenException("ServiceUrl in token Authorization and in activity doesn't match");
            }
        }
        catch (Exception e) {
            throw new ForbiddenException("Unvalid JWT in Authorization Header : " + e.getMessage());
        }
        return true;
    }

    private final void checkValidity(SignedJWT signedJWT) {
        Date notBefore = signedJWT.getJWTClaimsSet().getNotBeforeTime();
        Date expiration = signedJWT.getJWTClaimsSet().getExpirationTime();
        Date now = Date.from(Instant.now());
        if (now.after(expiration)) {
            throw new ForbiddenException("Authorization header is expired");
        }
        if (now.before(notBefore)) {
            throw new ForbiddenException("Authorization header is not valid yet");
        }
    }

    private final void checkSignature(SignedJWT signedJWT, JWKHandler jwkHandler) {
        block5: {
            Object object = jwkHandler.getJWK();
            if (object == null || (object = ((MicrosoftValidSigningKeys)object).getKeys()) == null) break block5;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JWSVerifier verifier;
                JWSVerifier jWSVerifier;
                MicrosoftValidSigningKey it = (MicrosoftValidSigningKey)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKid(), (Object)signedJWT.getHeader().getKeyID())) continue;
                String algo = it.getKty();
                String string = algo;
                if (Intrinsics.areEqual((Object)string, (Object)"RSA")) {
                    jWSVerifier = (JWSVerifier)new RSASSAVerifier(RSAKey.parse((String)it.toString()));
                } else if (Intrinsics.areEqual((Object)string, (Object)"EC")) {
                    jWSVerifier = (JWSVerifier)new ECDSAVerifier(ECKey.parse((String)it.toString()));
                } else {
                    throw new ForbiddenException(algo + " is not a supported algorithm");
                }
                if (!signedJWT.verify(verifier = jWSVerifier)) continue;
                this.logger.debug("the token received from botconnector is good");
                return;
            }
        }
        throw new JOSEException("Signature verification unsuccessfull");
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$checkTokenValidityFromConnectorService(AuthenticateBotConnectorService $this, JWKHandler jwkHandler, MultiMap headers, Activity activity) {
        return $this.checkTokenValidityFromConnectorService(jwkHandler, headers, activity);
    }

    public static final /* synthetic */ boolean access$checkTokenValidityFromEmulator(AuthenticateBotConnectorService $this, JWKHandler jwkHandler, MultiMap headers) {
        return $this.checkTokenValidityFromEmulator(jwkHandler, headers);
    }

    static {
        Object[] objectArray = new String[]{"https://sts.windows.net/d6d49420-f39b-4df7-a1dc-d59a935871db/", "https://sts.windows.net/f8cdef31-a31e-4b4a-93e4-5f571e91255a/", "https://login.microsoftonline.com/d6d49420-f39b-4df7-a1dc-d59a935871db/v2.0"};
        ISSUER_BOT_FWK_EMULATOR = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/tock/bot/connector/teams/auth/AuthenticateBotConnectorService$Companion;", "", "<init>", "()V", "AUTHORIZATION_HEADER", "", "ISSUER_BOT_CONNECTOR_SERVICE", "ISSUER_BOT_FWK_EMULATOR", "", "getISSUER_BOT_FWK_EMULATOR", "()Ljava/util/List;", "BEARER_PREFIX", "tock-bot-connector-teams"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getISSUER_BOT_FWK_EMULATOR() {
            return ISSUER_BOT_FWK_EMULATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

