/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.teams.token;

import ai.tock.bot.connector.teams.token.LoginMicrosoftOnline;
import ai.tock.bot.connector.teams.token.LoginResponse;
import ai.tock.shared.Level;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001fH\u0002J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lai/tock/bot/connector/teams/token/TokenHandler;", "", "appId", "", "password", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "logger", "Lmu/KLogger;", "token", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "tokenExpiration", "Ljava/time/Instant;", "logLevel", "Lai/tock/shared/Level;", "teamsMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getTeamsMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "tokenTimerTask", "Ljava/util/Timer;", "loginApi", "Lai/tock/bot/connector/teams/token/LoginMicrosoftOnline;", "getLoginApi", "()Lai/tock/bot/connector/teams/token/LoginMicrosoftOnline;", "setLoginApi", "(Lai/tock/bot/connector/teams/token/LoginMicrosoftOnline;)V", "checkToken", "", "isTokenExpired", "", "fetchToken", "launchTokenCollector", "connectorId", "msInterval", "", "stopTokenCollector", "tock-bot-connector-teams"})
@SourceDebugExtension(value={"SMAP\nTokenHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenHandler.kt\nai/tock/bot/connector/teams/token/TokenHandler\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,121:1\n71#2:122\n*S KotlinDebug\n*F\n+ 1 TokenHandler.kt\nai/tock/bot/connector/teams/token/TokenHandler\n*L\n67#1:122\n*E\n"})
public final class TokenHandler {
    @NotNull
    private final String appId;
    @NotNull
    private final String password;
    @NotNull
    private final KLogger logger;
    @Nullable
    private volatile String token;
    @Nullable
    private volatile Instant tokenExpiration;
    @NotNull
    private final Level logLevel;
    @NotNull
    private final ObjectMapper teamsMapper;
    private volatile Timer tokenTimerTask;
    @NotNull
    private LoginMicrosoftOnline loginApi;

    public TokenHandler(@NotNull String appId, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.appId = appId;
        this.password = password;
        this.logger = KotlinLogging.INSTANCE.logger(TokenHandler::logger$lambda$0);
        this.logLevel = this.logger.isDebugEnabled() ? Level.BODY : Level.BASIC;
        ObjectMapper objectMapper = JacksonKt.getMapper().copy().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"setPropertyNamingStrategy(...)");
        this.teamsMapper = objectMapper;
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_microsoft_request_timeout", (long)30000L), (KLogger)this.logger, (Level)this.logLevel, null, (boolean)false, (boolean)false, null, (int)120, null).baseUrl("https://login.microsoftonline.com");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"baseUrl(...)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)this.teamsMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(LoginMicrosoftOnline.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.loginApi = (LoginMicrosoftOnline)object;
    }

    @Nullable
    public final String getToken() {
        return this.token;
    }

    public final void setToken(@Nullable String string) {
        this.token = string;
    }

    @NotNull
    public final ObjectMapper getTeamsMapper() {
        return this.teamsMapper;
    }

    @NotNull
    public final LoginMicrosoftOnline getLoginApi() {
        return this.loginApi;
    }

    public final void setLoginApi(@NotNull LoginMicrosoftOnline loginMicrosoftOnline) {
        Intrinsics.checkNotNullParameter((Object)loginMicrosoftOnline, (String)"<set-?>");
        this.loginApi = loginMicrosoftOnline;
    }

    public final void checkToken() {
        if (this.token == null || this.isTokenExpired()) {
            this.fetchToken();
        }
    }

    public final boolean isTokenExpired() {
        this.logger.debug(TokenHandler::isTokenExpired$lambda$1);
        Instant instant = this.tokenExpiration;
        return Instant.now().isAfter(instant != null ? instant.minus(10L, ChronoUnit.SECONDS) : null);
    }

    private final void fetchToken() {
        Response response = LoginMicrosoftOnline.DefaultImpls.login$default(this.loginApi, null, this.appId, this.password, null, 9, null).execute();
        Object object = (LoginResponse)response.body();
        if (object == null || (object = ((LoginResponse)object).getAccessToken()) == null) {
            throw new IllegalStateException("empty access token".toString());
        }
        this.token = object;
        Instant instant = Instant.now();
        LoginResponse loginResponse = (LoginResponse)response.body();
        Long l = loginResponse != null ? Long.valueOf(loginResponse.getExpiresIn()) : null;
        Intrinsics.checkNotNull((Object)l);
        this.tokenExpiration = instant.plus((long)l, ChronoUnit.SECONDS);
    }

    public final void launchTokenCollector(@NotNull String connectorId, long msInterval) {
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        try {
            Timer timer;
            this.checkToken();
            String string = "microsoft-api-token-handling-" + connectorId;
            long l = 0L;
            boolean bl = false;
            Timer timer2 = timer = TimersKt.timer((String)string, (boolean)bl);
            timer2.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ TokenHandler this$0;
                {
                    this.this$0 = tokenHandler;
                }

                public void run() {
                    TimerTask $this$launchTokenCollector_u24lambda_u242 = this;
                    boolean bl = false;
                    this.this$0.checkToken();
                }
            }, l, msInterval);
            this.tokenTimerTask = timer;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
        }
    }

    public static /* synthetic */ void launchTokenCollector$default(TokenHandler tokenHandler, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 3600000L;
        }
        tokenHandler.launchTokenCollector(string, l);
    }

    public final void stopTokenCollector() {
        if (this.tokenTimerTask != null) {
            Timer timer = this.tokenTimerTask;
            if (timer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokenTimerTask");
                timer = null;
            }
            timer.cancel();
            Timer timer2 = this.tokenTimerTask;
            if (timer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokenTimerTask");
                timer2 = null;
            }
            timer2.purge();
        } else {
            this.logger.error("Trying to stop an uninitialized tokentimertask !");
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object isTokenExpired$lambda$1() {
        return "IS TOKEN EXPIRED";
    }
}

