/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.twitter;

import ai.tock.bot.connector.ConnectorException;
import ai.tock.bot.connector.twitter.TwitterClient;
import ai.tock.bot.connector.twitter.model.AccessToken;
import ai.tock.bot.connector.twitter.model.Attachment;
import ai.tock.bot.connector.twitter.model.AttachmentMedia;
import ai.tock.bot.connector.twitter.model.Command;
import ai.tock.bot.connector.twitter.model.MediaCategory;
import ai.tock.bot.connector.twitter.model.MediaUpload;
import ai.tock.bot.connector.twitter.model.RequestToken;
import ai.tock.bot.connector.twitter.model.Tweet;
import ai.tock.bot.connector.twitter.model.User;
import ai.tock.bot.connector.twitter.model.Webhook;
import ai.tock.bot.connector.twitter.model.outcoming.OutcomingEvent;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import oauth.signpost.http.HttpParameters;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import se.akerfeldt.okhttp.signpost.OkHttpOAuthConsumer;
import se.akerfeldt.okhttp.signpost.SigningInterceptor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0006RSTUVWB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u0003J\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u001d\u00105\u001a\u0002022\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109\u00a2\u0006\u0002\u0010:J\u001c\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030<2\u0006\u0010=\u001a\u00020\u0003H\u0002J\u0006\u0010>\u001a\u000202J\u0006\u0010?\u001a\u000202J\u000e\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\u0003J\u0018\u0010B\u001a\u00020C2\u0006\u0010*\u001a\u00020+2\u0006\u0010D\u001a\u00020\u0003H\u0002J \u0010E\u001a\u0002022\u0006\u0010D\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020+H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010D\u001a\u00020\u0003H\u0002J \u0010J\u001a\u00020I2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010K\u001a\u000209H\u0002J\u000e\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020\u0003J\f\u0010N\u001a\b\u0012\u0004\u0012\u00020/0OJ\u0010\u0010P\u001a\u00020C*\u0006\u0012\u0002\b\u00030QH\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient;", "", "environment", "", "consumerKey", "consumerSecret", "token", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "BASE_MEDIA_URL", "BASE_URL", "MEDIA_CHUNK_SIZE", "", "accountActivityApi", "Lai/tock/bot/connector/twitter/TwitterClient$AccountActivityApi;", "getConsumerKey", "()Ljava/lang/String;", "getConsumerSecret", "directMessageApi", "Lai/tock/bot/connector/twitter/TwitterClient$DirectMessageApi;", "getEnvironment", "logger", "Lmu/KLogger;", "mediaApi", "Lai/tock/bot/connector/twitter/TwitterClient$MediaApi;", "statusApi", "Lai/tock/bot/connector/twitter/TwitterClient$StatusApi;", "userApi", "Lai/tock/bot/connector/twitter/TwitterClient$UserApi;", "accessToken", "Lai/tock/bot/connector/twitter/model/AccessToken;", "requestToken", "Lai/tock/bot/connector/twitter/model/RequestToken;", "oauthVerifier", "authorizationUrl", "b64HmacSHA256", "payload", "createAttachment", "Lai/tock/bot/connector/twitter/model/Attachment;", "mediaCategory", "Lai/tock/bot/connector/twitter/model/MediaCategory;", "contentType", "data", "", "defaultUser", "Lai/tock/bot/connector/twitter/model/User;", "registerWebhook", "Lai/tock/bot/connector/twitter/model/Webhook;", "url", "sendDirectMessage", "", "outcomingEvent", "Lai/tock/bot/connector/twitter/model/outcoming/OutcomingEvent;", "sendTweet", "tweet", "Lai/tock/bot/connector/twitter/model/outcoming/Tweet;", "threadId", "", "(Lai/tock/bot/connector/twitter/model/outcoming/Tweet;Ljava/lang/Long;)Z", "splitQuery", "", "query", "subscribe", "subscriptions", "unregisterWebhook", "webhookId", "uploadMedia", "", "mediaId", "uploadMediaAppend", "segmentIndex", "chunk", "uploadMediaFinalize", "Lai/tock/bot/connector/twitter/model/MediaUpload;", "uploadMediaInit", "totalBytes", "user", "userId", "webhooks", "", "logError", "Lretrofit2/Response;", "AccountActivityApi", "DirectMessageApi", "MediaApi", "OAuthApi", "StatusApi", "UserApi", "tock-bot-connector-twitter"})
public final class TwitterClient {
    private final String BASE_URL;
    private final String BASE_MEDIA_URL;
    private final int MEDIA_CHUNK_SIZE;
    private final KLogger logger;
    private final AccountActivityApi accountActivityApi;
    private final DirectMessageApi directMessageApi;
    private final UserApi userApi;
    private final MediaApi mediaApi;
    private final StatusApi statusApi;
    @NotNull
    private final String environment;
    @NotNull
    private final String consumerKey;
    @NotNull
    private final String consumerSecret;

    private final User defaultUser() {
        return new User("", "", "", new Date().getTime(), null, null, null, "", "", false, false, 0, 0, 0, "", "");
    }

    private final void logError(Response<?> $this$logError) {
        String error = $this$logError.message();
        int errorCode = $this$logError.code();
        this.logger.warn((Function0)new Function0<Object>(errorCode, error){
            final /* synthetic */ int $errorCode;
            final /* synthetic */ String $error;

            @Nullable
            public final Object invoke() {
                return "Twitter Error : " + this.$errorCode + ' ' + this.$error;
            }
            {
                this.$errorCode = n;
                this.$error = string;
                super(0);
            }
        });
        ResponseBody responseBody = $this$logError.errorBody();
        String errorBody = responseBody != null ? responseBody.string() : null;
        this.logger.warn((Function0)new Function0<Object>(errorBody){
            final /* synthetic */ String $errorBody;

            @Nullable
            public final Object invoke() {
                return "Twitter Error body : " + this.$errorBody;
            }
            {
                this.$errorBody = string;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> splitQuery(String query) {
        String[] pairs;
        void $this$toTypedArray$iv;
        List list;
        int n;
        CharSequence charSequence;
        Collection $this$dropLastWhile$iv;
        LinkedHashMap queryPairs = new LinkedHashMap();
        Object object = query;
        String string = "&";
        int n2 = 0;
        string = new Regex(string);
        n2 = 0;
        boolean bl = false;
        object = string.split((CharSequence)object, n2);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                charSequence = it;
                n = 0;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String pair : pairs = stringArray) {
            int idx = StringsKt.indexOf$default((CharSequence)pair, (String)"=", (int)0, (boolean)false, (int)6, null);
            Map map = queryPairs;
            charSequence = pair;
            n = 0;
            boolean bl3 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)charSequence2).substring(n, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = URLDecoder.decode(string2, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"URLDecoder.decode(pair.substring(0, idx), \"UTF-8\")");
            charSequence = pair;
            n = idx + 1;
            bl3 = false;
            CharSequence charSequence3 = charSequence;
            if (charSequence3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)charSequence3).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = URLDecoder.decode(string4, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"URLDecoder.decode(pair.s\u2026string(idx + 1), \"UTF-8\")");
            map.put(string3, string5);
        }
        return queryPairs;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RequestToken requestToken() {
        void $this$create$iv;
        OkHttpOAuthConsumer oAuthApiConsumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        HttpParameters httpParameters = new HttpParameters();
        httpParameters.put("oauth_callback", "oob");
        oAuthApiConsumer.setAdditionalParameters(httpParameters);
        Retrofit retrofit = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(oAuthApiConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026e())\n            .build()");
        Retrofit retrofit2 = retrofit;
        boolean $i$f$create2 = false;
        Object object = $this$create$iv.create(OAuthApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        OAuthApi oAuthApi = (OAuthApi)object;
        try {
            RequestToken requestToken2;
            Response response;
            Response response2 = response = oAuthApi.requestToken().execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (response2.isSuccessful()) {
                String string = (String)response.body();
                if (string != null) {
                    boolean bl;
                    String string2;
                    String $i$f$create2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = $i$f$create2;
                    boolean bl4 = false;
                    this.logger.debug((Function0)new Function0<Object>(it){
                        final /* synthetic */ String $it;

                        @Nullable
                        public final Object invoke() {
                            return this.$it;
                        }
                        {
                            this.$it = string;
                            super(0);
                        }
                    });
                    String string3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                    Map<String, String> queryPairs = this.splitQuery(string3);
                    String string4 = queryPairs.get("oauth_token");
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string2 = queryPairs.get("oauth_token_secret")) == null) {
                        string2 = "";
                    }
                    String string5 = queryPairs.get("oauth_callback_confirmed");
                    if (string5 != null) {
                        String string6 = string5;
                        boolean bl5 = false;
                        bl = Boolean.parseBoolean(string6);
                    } else {
                        bl = false;
                    }
                    requestToken2 = new RequestToken(string4, string2, bl);
                } else {
                    requestToken2 = null;
                }
            } else {
                this.logError(response);
                requestToken2 = null;
            }
            retrofit2 = requestToken2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            retrofit2 = null;
        }
        return retrofit2;
    }

    @NotNull
    public final String authorizationUrl(@NotNull RequestToken requestToken2) {
        Intrinsics.checkNotNullParameter((Object)requestToken2, (String)"requestToken");
        return this.BASE_URL + "/oauth/authorize?oauth_token=" + requestToken2.getOauthToken();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AccessToken accessToken(@NotNull RequestToken requestToken2, @NotNull String oauthVerifier) {
        void $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)requestToken2, (String)"requestToken");
        Intrinsics.checkNotNullParameter((Object)oauthVerifier, (String)"oauthVerifier");
        OkHttpOAuthConsumer oAuthApiConsumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        oAuthApiConsumer.setTokenWithSecret(requestToken2.getOauthToken(), requestToken2.getOauthTokenSecret());
        HttpParameters httpParameters = new HttpParameters();
        httpParameters.put("oauth_verifier", oauthVerifier);
        oAuthApiConsumer.setAdditionalParameters(httpParameters);
        Retrofit retrofit = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(oAuthApiConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026e())\n            .build()");
        Retrofit retrofit2 = retrofit;
        boolean $i$f$create2 = false;
        Object object = $this$create$iv.create(OAuthApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        OAuthApi oAuthApi = (OAuthApi)object;
        try {
            AccessToken accessToken2;
            Response response;
            Response response2 = response = oAuthApi.accessToken().execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (response2.isSuccessful()) {
                String string = (String)response.body();
                if (string != null) {
                    String string2;
                    String string3;
                    String string4;
                    String $i$f$create2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = $i$f$create2;
                    boolean bl3 = false;
                    this.logger.debug((Function0)new Function0<Object>(it){
                        final /* synthetic */ String $it;

                        @Nullable
                        public final Object invoke() {
                            return this.$it;
                        }
                        {
                            this.$it = string;
                            super(0);
                        }
                    });
                    String string5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
                    Map<String, String> queryPairs = this.splitQuery(string5);
                    String string6 = queryPairs.get("oauth_token");
                    if (string6 == null) {
                        string6 = "";
                    }
                    if ((string4 = queryPairs.get("oauth_token_secret")) == null) {
                        string4 = "";
                    }
                    if ((string3 = queryPairs.get("user_id")) == null) {
                        string3 = "";
                    }
                    if ((string2 = queryPairs.get("screen_name")) == null) {
                        string2 = "";
                    }
                    accessToken2 = new AccessToken(string6, string4, string3, string2);
                } else {
                    accessToken2 = null;
                }
            } else {
                this.logError(response);
                accessToken2 = null;
            }
            retrofit2 = accessToken2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            retrofit2 = null;
        }
        return retrofit2;
    }

    @Nullable
    public final Webhook registerWebhook(@NotNull String url) {
        Webhook webhook;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Webhook webhook2;
            Response response;
            Response response2 = response = this.accountActivityApi.registerWebhook(this.environment, url).execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (response2.isSuccessful()) {
                Webhook webhook3 = (Webhook)response.body();
                if (webhook3 != null) {
                    Webhook webhook4 = webhook3;
                    boolean bl = false;
                    boolean bl2 = false;
                    Webhook it = webhook4;
                    boolean bl3 = false;
                    this.logger.debug((Function0)new Function0<Object>(it){
                        final /* synthetic */ Webhook $it;

                        @Nullable
                        public final Object invoke() {
                            return this.$it;
                        }
                        {
                            this.$it = webhook;
                            super(0);
                        }
                    });
                    webhook2 = webhook4;
                } else {
                    webhook2 = null;
                }
            } else {
                this.logError(response);
                webhook2 = null;
            }
            webhook = webhook2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            webhook = null;
        }
        return webhook;
    }

    public final boolean subscribe() {
        boolean bl;
        try {
            boolean bl2;
            Response response;
            Response response2 = response = this.accountActivityApi.subscribe("develop").execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (!response2.isSuccessful()) {
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean subscriptions() {
        boolean bl;
        try {
            Response response = this.accountActivityApi.subscriptions("develop").execute();
            bl = response.code() == 204;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean unregisterWebhook(@NotNull String webhookId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)webhookId, (String)"webhookId");
        try {
            boolean bl2;
            Response response;
            Response response2 = response = this.accountActivityApi.unregisterWebhook(this.environment, webhookId).execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (!response2.isSuccessful()) {
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final User user(@NotNull String userId) {
        User user2;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            User user3;
            block6: {
                Response response;
                block4: {
                    block5: {
                        Response response2 = response = this.userApi.user(userId).execute();
                        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                        if (!response2.isSuccessful()) break block4;
                        user3 = (User)response.body();
                        if (user3 == null) break block5;
                        User user4 = user3;
                        boolean bl = false;
                        boolean bl2 = false;
                        User it = user4;
                        boolean bl3 = false;
                        this.logger.debug((Function0)new Function0<Object>(it){
                            final /* synthetic */ User $it;

                            @Nullable
                            public final Object invoke() {
                                return this.$it;
                            }
                            {
                                this.$it = user2;
                                super(0);
                            }
                        });
                        user3 = user4;
                        if (user3 != null) break block6;
                    }
                    user3 = this.defaultUser();
                    break block6;
                }
                this.logError(response);
                user3 = this.defaultUser();
            }
            Intrinsics.checkNotNullExpressionValue((Object)user3, (String)"if (response.isSuccessfu\u2026faultUser()\n            }");
            user2 = user3;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            user2 = this.defaultUser();
        }
        return user2;
    }

    @NotNull
    public final List<Webhook> webhooks() {
        List list;
        try {
            List list2;
            block6: {
                Response response;
                block4: {
                    block5: {
                        Response response2 = response = this.accountActivityApi.webhooks(this.environment).execute();
                        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                        if (!response2.isSuccessful()) break block4;
                        list2 = (List)response.body();
                        if (list2 == null) break block5;
                        List list3 = list2;
                        boolean bl = false;
                        boolean bl2 = false;
                        List it = list3;
                        boolean bl3 = false;
                        this.logger.debug((Function0)new Function0<Object>(it){
                            final /* synthetic */ List $it;

                            @Nullable
                            public final Object invoke() {
                                return this.$it;
                            }
                            {
                                this.$it = list;
                                super(0);
                            }
                        });
                        list2 = list3;
                        if (list2 != null) break block6;
                    }
                    list2 = CollectionsKt.emptyList();
                    break block6;
                }
                this.logError(response);
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean sendDirectMessage(@NotNull OutcomingEvent outcomingEvent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)outcomingEvent, (String)"outcomingEvent");
        try {
            boolean bl2;
            Response response;
            Response response2 = response = this.directMessageApi.new(outcomingEvent).execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (!response2.isSuccessful()) {
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean sendTweet(@NotNull ai.tock.bot.connector.twitter.model.outcoming.Tweet tweet, @Nullable Long threadId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
        try {
            boolean bl2;
            Response response;
            boolean enableDefaultMessage;
            boolean enableDM = tweet.getDmRecipientID() != null;
            boolean enableWelcomeMessage = tweet.getWelcomeMessageID() != null;
            boolean bl3 = enableDefaultMessage = tweet.getDefaultMessage() != null;
            String message = enableDM ? tweet.getText() + " https://twitter.com/messages/compose?recipient_id=" + tweet.getDmRecipientID() + (enableWelcomeMessage ? "&welcome_message_id=" + tweet.getWelcomeMessageID() : "") + (enableDefaultMessage ? "&text=" + URLEncoder.encode(tweet.getDefaultMessage(), "UTF-8") : "") : tweet.getText();
            Long l = threadId;
            Response response2 = response = StatusApi.DefaultImpls.status$default(this.statusApi, message, l != null ? String.valueOf(l) : null, null, String.valueOf(enableDM), 4, null).execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
            if (!response2.isSuccessful()) {
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Attachment createAttachment(@NotNull MediaCategory mediaCategory, @NotNull String contentType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaCategory), (String)"mediaCategory");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MediaUpload mediaUploadInit = this.uploadMediaInit(mediaCategory, contentType, data.length);
        this.uploadMedia(data, mediaUploadInit.getMediaIdString());
        MediaUpload mediaUpload = this.uploadMediaFinalize(mediaUploadInit.getMediaIdString());
        return new Attachment("media", new AttachmentMedia(mediaUpload.getMediaIdString()));
    }

    private final void uploadMedia(byte[] data, String mediaId) {
        int segmentCount = (data.length + this.MEDIA_CHUNK_SIZE - 1) / this.MEDIA_CHUNK_SIZE;
        for (int segmentIndex = 0; segmentIndex < segmentCount; ++segmentIndex) {
            int start = segmentIndex * this.MEDIA_CHUNK_SIZE;
            int end = segmentIndex < segmentCount - 1 ? this.MEDIA_CHUNK_SIZE * (segmentIndex + 1) : data.length;
            byte[] byArray = data;
            boolean bl = false;
            byte[] chunk = ArraysKt.copyOfRange((byte[])byArray, (int)start, (int)end);
            boolean append = this.uploadMediaAppend(mediaId, segmentIndex, chunk);
            if (append) continue;
            throw (Throwable)new ConnectorException("Media upload append segment_index " + segmentIndex + " failed");
        }
    }

    private final MediaUpload uploadMediaInit(MediaCategory mediaCategory, String contentType, long totalBytes) {
        Response response;
        block2: {
            MediaUpload mediaUpload;
            block4: {
                block3: {
                    Response response2 = response = this.mediaApi.init(Command.INIT, totalBytes, contentType, mediaCategory.getMediaCategory(), null).execute();
                    Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                    if (!response2.isSuccessful()) break block2;
                    mediaUpload = (MediaUpload)response.body();
                    if (mediaUpload == null) break block3;
                    MediaUpload mediaUpload2 = mediaUpload;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaUpload it = mediaUpload2;
                    boolean bl3 = false;
                    this.logger.debug((Function0)new Function0<Object>(it){
                        final /* synthetic */ MediaUpload $it;

                        @Nullable
                        public final Object invoke() {
                            return this.$it;
                        }
                        {
                            this.$it = mediaUpload;
                            super(0);
                        }
                    });
                    mediaUpload = mediaUpload2;
                    if (mediaUpload != null) break block4;
                }
                throw (Throwable)new ConnectorException("null body");
            }
            return mediaUpload;
        }
        this.logError(response);
        throw (Throwable)new ConnectorException("Media upload init failed");
    }

    private final boolean uploadMediaAppend(String mediaId, int segmentIndex, byte[] chunk) {
        Response response;
        RequestBody requestChunk = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)MediaType.Companion.get("application/octet-stream"), (byte[])chunk, (int)0, (int)0, (int)12, null);
        MultipartBody.Part body = MultipartBody.Part.Companion.createFormData("media", "chunk-segment-" + segmentIndex, requestChunk);
        Response response2 = response = this.mediaApi.append(Command.APPEND, mediaId, segmentIndex, body).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
        if (!response2.isSuccessful()) {
            this.logError(response);
        }
        return response.isSuccessful();
    }

    private final MediaUpload uploadMediaFinalize(String mediaId) {
        Response response;
        block2: {
            MediaUpload mediaUpload;
            block4: {
                block3: {
                    Response response2 = response = this.mediaApi.finalize(Command.FINALIZE, mediaId).execute();
                    Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                    if (!response2.isSuccessful()) break block2;
                    mediaUpload = (MediaUpload)response.body();
                    if (mediaUpload == null) break block3;
                    MediaUpload mediaUpload2 = mediaUpload;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaUpload it = mediaUpload2;
                    boolean bl3 = false;
                    this.logger.debug((Function0)new Function0<Object>(it){
                        final /* synthetic */ MediaUpload $it;

                        @Nullable
                        public final Object invoke() {
                            return this.$it;
                        }
                        {
                            this.$it = mediaUpload;
                            super(0);
                        }
                    });
                    mediaUpload = mediaUpload2;
                    if (mediaUpload != null) break block4;
                }
                throw (Throwable)new ConnectorException("null body");
            }
            return mediaUpload;
        }
        this.logError(response);
        throw (Throwable)new ConnectorException("Media upload finalize failed");
    }

    @NotNull
    public final String b64HmacSHA256(@NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = this.consumerSecret;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        SecretKeySpec signingKey = new SecretKeySpec(byArray, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        Object object = payload;
        Charset charset2 = Charsets.UTF_8;
        boolean bl2 = false;
        byte[] byArray2 = ((String)object).getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = mac.doFinal(byArray2);
        byte[] byArray3 = Base64.getEncoder().encode(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"Base64.getEncoder().encode(bytes)");
        object = byArray3;
        boolean bl3 = false;
        return new String((byte[])object, Charsets.UTF_8);
    }

    @NotNull
    public final String getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final String getConsumerKey() {
        return this.consumerKey;
    }

    @NotNull
    public final String getConsumerSecret() {
        return this.consumerSecret;
    }

    public TwitterClient(@NotNull String environment, @NotNull String consumerKey, @NotNull String consumerSecret, @Nullable String token, @Nullable String secret) {
        Retrofit $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)consumerKey, (String)"consumerKey");
        Intrinsics.checkNotNullParameter((Object)consumerSecret, (String)"consumerSecret");
        this.environment = environment;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.BASE_URL = "https://api.twitter.com";
        this.BASE_MEDIA_URL = "https://upload.twitter.com";
        this.MEDIA_CHUNK_SIZE = 512000;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        OkHttpOAuthConsumer twitterOAuthConsumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        if (token != null) {
            twitterOAuthConsumer.setTokenWithSecret(token, secret);
        }
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026       .baseUrl(BASE_URL)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        Retrofit retrofit2 = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(AccountActivityApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.accountActivityApi = (AccountActivityApi)object;
        Retrofit.Builder builder2 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"retrofitBuilderWithTimeo\u2026       .baseUrl(BASE_URL)");
        Retrofit retrofit3 = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder2, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit3, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        $this$create$iv = retrofit3;
        $i$f$create = false;
        Object object2 = $this$create$iv.create(DirectMessageApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(T::class.java)");
        this.directMessageApi = (DirectMessageApi)object2;
        Retrofit.Builder builder3 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"retrofitBuilderWithTimeo\u2026       .baseUrl(BASE_URL)");
        Retrofit retrofit4 = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder3, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit4, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        $this$create$iv = retrofit4;
        $i$f$create = false;
        Object object3 = $this$create$iv.create(UserApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"create(T::class.java)");
        this.userApi = (UserApi)object3;
        Retrofit.Builder builder4 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_MEDIA_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"retrofitBuilderWithTimeo\u2026 .baseUrl(BASE_MEDIA_URL)");
        Retrofit retrofit5 = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder4, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit5, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        $this$create$iv = retrofit5;
        $i$f$create = false;
        Object object4 = $this$create$iv.create(MediaApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"create(T::class.java)");
        this.mediaApi = (MediaApi)object4;
        Retrofit.Builder builder5 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"retrofitBuilderWithTimeo\u2026       .baseUrl(BASE_URL)");
        Retrofit retrofit6 = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder5, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit6, (String)"retrofitBuilderWithTimeo\u2026er()\n            .build()");
        $this$create$iv = retrofit6;
        $i$f$create = false;
        Object object5 = $this$create$iv.create(StatusApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"create(T::class.java)");
        this.statusApi = (StatusApi)object5;
    }

    public /* synthetic */ TwitterClient(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, string5);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\u0006"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$OAuthApi;", "", "accessToken", "Lretrofit2/Call;", "", "requestToken", "tock-bot-connector-twitter"})
    public static interface OAuthApi {
        @POST(value="/oauth/request_token")
        @NotNull
        public Call<String> requestToken();

        @POST(value="/oauth/access_token")
        @NotNull
        public Call<String> accessToken();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$UserApi;", "", "user", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/User;", "userId", "", "tock-bot-connector-twitter"})
    public static interface UserApi {
        @GET(value="/1.1/users/show.json")
        @NotNull
        public Call<User> user(@Query(value="user_id") @NotNull String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H'J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H'J\u001e\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u000f"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$AccountActivityApi;", "", "registerWebhook", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/Webhook;", "environment", "", "url", "subscribe", "", "subscriptions", "unregisterWebhook", "webhookId", "webhooks", "", "tock-bot-connector-twitter"})
    public static interface AccountActivityApi {
        @POST(value="/1.1/account_activity/all/{environment}/webhooks.json")
        @NotNull
        public Call<Webhook> registerWebhook(@Path(value="environment") @NotNull String var1, @Query(value="url") @NotNull String var2);

        @POST(value="/1.1/account_activity/all/{environment}/subscriptions.json")
        @NotNull
        public Call<Unit> subscribe(@Path(value="environment") @NotNull String var1);

        @GET(value="/1.1/account_activity/all/{environment}/subscriptions.json")
        @NotNull
        public Call<Unit> subscriptions(@Path(value="environment") @NotNull String var1);

        @DELETE(value="/1.1/account_activity/all/{environment}/webhooks/{webhook_id}.json")
        @NotNull
        public Call<Unit> unregisterWebhook(@Path(value="environment") @NotNull String var1, @Path(value="webhook_id") @NotNull String var2);

        @GET(value="/1.1/account_activity/all/{environment}/webhooks.json")
        @NotNull
        public Call<List<Webhook>> webhooks(@Path(value="environment") @NotNull String var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0007\u001a\u00020\bH'J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\n"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$DirectMessageApi;", "", "destroy", "Lretrofit2/Call;", "", "events", "new", "OutcomingEvent", "Lai/tock/bot/connector/twitter/model/outcoming/OutcomingEvent;", "show", "tock-bot-connector-twitter"})
    public static interface DirectMessageApi {
        @POST(value="/1.1/direct_messages/events/new.json")
        @NotNull
        public Call<Unit> new(@Body @NotNull OutcomingEvent var1);

        @GET(value="/1.1/direct_messages/events/show.json")
        @NotNull
        public Call<Unit> show();

        @GET(value="/1.1/direct_messages/events/list.json")
        @NotNull
        public Call<Unit> events();

        @DELETE(value="/1.1/direct_messages/events/destroy.json")
        @NotNull
        public Call<Unit> destroy();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J6\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH'J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH'JD\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\b2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\bH'\u00a8\u0006\u0015"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$MediaApi;", "", "append", "Lretrofit2/Call;", "", "command", "Lai/tock/bot/connector/twitter/model/Command;", "mediaId", "", "segmentIndex", "", "file", "Lokhttp3/MultipartBody$Part;", "finalize", "Lai/tock/bot/connector/twitter/model/MediaUpload;", "init", "totalBytes", "", "mediaTYpe", "mediaCategory", "additionalOwners", "tock-bot-connector-twitter"})
    public static interface MediaApi {
        @POST(value="/1.1/media/upload.json")
        @NotNull
        public Call<MediaUpload> init(@Query(value="command") @NotNull Command var1, @Query(value="total_bytes") long var2, @Query(value="media_type") @NotNull String var4, @Query(value="media_category") @Nullable String var5, @Query(value="additional_owners") @Nullable String var6);

        @Multipart
        @POST(value="/1.1/media/upload.json")
        @NotNull
        public Call<Unit> append(@Query(value="command") @NotNull Command var1, @Query(value="media_id") @NotNull String var2, @Query(value="segment_index") int var3, @Part @NotNull MultipartBody.Part var4);

        @POST(value="/1.1/media/upload.json")
        @NotNull
        public Call<MediaUpload> finalize(@Query(value="command") @NotNull Command var1, @Query(value="media_id") @NotNull String var2);

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ Call init$default(MediaApi mediaApi, Command command, long l, String string, String string2, String string3, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
                }
                if ((n & 1) != 0) {
                    command = Command.INIT;
                }
                return mediaApi.init(command, l, string, string2, string3);
            }

            public static /* synthetic */ Call append$default(MediaApi mediaApi, Command command, String string, int n, MultipartBody.Part part, int n2, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
                }
                if ((n2 & 1) != 0) {
                    command = Command.APPEND;
                }
                return mediaApi.append(command, string, n, part);
            }

            public static /* synthetic */ Call finalize$default(MediaApi mediaApi, Command command, String string, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: finalize");
                }
                if ((n & 1) != 0) {
                    command = Command.FINALIZE;
                }
                return mediaApi.finalize(command, string);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0003\u0010\b\u001a\u00020\u00062\b\b\u0003\u0010\t\u001a\u00020\u0006H'\u00a8\u0006\n"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$StatusApi;", "", "status", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/Tweet;", "statusMessage", "", "replyStatusId", "autoPopulateMetadata", "enableDM", "tock-bot-connector-twitter"})
    public static interface StatusApi {
        @POST(value="/1.1/statuses/update.json")
        @NotNull
        public Call<Tweet> status(@Query(value="status") @NotNull String var1, @Query(value="in_reply_to_status_id") @Nullable String var2, @Query(value="auto_populate_reply_metadata") @NotNull String var3, @Query(value="enable_dmcommands") @NotNull String var4);

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ Call status$default(StatusApi statusApi, String string, String string2, String string3, String string4, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: status");
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = "true";
                }
                if ((n & 8) != 0) {
                    string4 = "false";
                }
                return statusApi.status(string, string2, string3, string4);
            }
        }
    }
}

