/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.twitter.model.incoming;

import ai.tock.bot.connector.twitter.model.Text;
import ai.tock.bot.connector.twitter.model.Tweet;
import ai.tock.bot.connector.twitter.model.User;
import ai.tock.bot.connector.twitter.model.incoming.IncomingEvent;
import ai.tock.bot.connector.twitter.model.incoming.TweetIncomingEvent;
import ai.tock.bot.engine.action.ActionMetadata;
import ai.tock.bot.engine.action.ActionQuote;
import ai.tock.bot.engine.action.ActionReply;
import ai.tock.bot.engine.action.ActionVisibility;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0017\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lai/tock/bot/connector/twitter/model/incoming/TweetIncomingEvent;", "Lai/tock/bot/connector/twitter/model/incoming/IncomingEvent;", "forUserId", "", "tweets", "", "Lai/tock/bot/connector/twitter/model/Tweet;", "(Ljava/lang/String;Ljava/util/List;)V", "getForUserId", "()Ljava/lang/String;", "ignored", "", "getIgnored", "()Z", "getTweets", "()Ljava/util/List;", "users", "", "Lai/tock/bot/connector/twitter/model/User;", "getUsers", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "playerType", "Lai/tock/bot/engine/user/PlayerType;", "toEvent", "Lai/tock/bot/engine/event/Event;", "applicationId", "toString", "Companion", "tock-bot-connector-twitter"})
public final class TweetIncomingEvent
extends IncomingEvent {
    @NotNull
    private final String forUserId;
    @NotNull
    private final List<Tweet> tweets;
    private static final KLogger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean getIgnored() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, User> getUsers() {
        return MapsKt.mapOf((Pair)new Pair((Object)((Tweet)CollectionsKt.first(this.tweets)).getUser().getId(), (Object)((Tweet)CollectionsKt.first(this.tweets)).getUser()));
    }

    @Override
    @NotNull
    public PlayerId playerId(@NotNull PlayerType playerType) {
        Intrinsics.checkNotNullParameter((Object)playerType, (String)"playerType");
        return ((Tweet)CollectionsKt.first(this.tweets)).playerId(playerType);
    }

    @Override
    @Nullable
    public Event toEvent(@NotNull String applicationId) {
        Event event;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Tweet tweet = (Tweet)CollectionsKt.first(this.tweets);
        boolean isReplyMessage = tweet.getInReplyToStatusId() != null;
        boolean isFromAccountListened = Intrinsics.areEqual((Object)this.getForUserId(), (Object)tweet.getUser().getId());
        if (!isFromAccountListened) {
            PlayerId playerId = this.playerId(PlayerType.user);
            PlayerId playerId2 = new PlayerId(this.getForUserId(), PlayerType.bot, null, 4, null);
            Object object = tweet.getExtendedTweet();
            if (object == null || (object = ((Text)object).getText()) == null) {
                object = tweet.getText();
            }
            event = (Event)new SendSentence(playerId, applicationId, playerId2, (CharSequence)object, null, null, null, null, new ActionMetadata(false, null, null, ActionVisibility.PUBLIC, isReplyMessage ? ActionReply.ISREPLY : ActionReply.NOREPLY, tweet.isQuote() ? ActionQuote.ISQUOTE : ActionQuote.NOQUOTE, false, null, 199, null), null, null, 1776, null);
        } else {
            logger.debug((Function0)new Function0<Object>(this, tweet){
                final /* synthetic */ TweetIncomingEvent this$0;
                final /* synthetic */ Tweet $tweet;

                @Nullable
                public final Object invoke() {
                    return "ignore event " + this.this$0 + " with tweet text = [" + this.$tweet.getText() + "] from [" + this.$tweet.getUser().getId() + "][" + this.$tweet.getUser().getName() + ']';
                }
                {
                    this.this$0 = tweetIncomingEvent;
                    this.$tweet = tweet;
                    super(0);
                }
            });
            event = null;
        }
        return event;
    }

    @Override
    @NotNull
    public String getForUserId() {
        return this.forUserId;
    }

    @NotNull
    public final List<Tweet> getTweets() {
        return this.tweets;
    }

    public TweetIncomingEvent(@JsonProperty(value="for_user_id") @NotNull String forUserId, @JsonProperty(value="tweet_create_events") @NotNull List<Tweet> tweets) {
        Intrinsics.checkNotNullParameter((Object)forUserId, (String)"forUserId");
        Intrinsics.checkNotNullParameter(tweets, (String)"tweets");
        this.forUserId = forUserId;
        this.tweets = tweets;
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    @NotNull
    public final String component1() {
        return this.getForUserId();
    }

    @NotNull
    public final List<Tweet> component2() {
        return this.tweets;
    }

    @NotNull
    public final TweetIncomingEvent copy(@JsonProperty(value="for_user_id") @NotNull String forUserId, @JsonProperty(value="tweet_create_events") @NotNull List<Tweet> tweets) {
        Intrinsics.checkNotNullParameter((Object)forUserId, (String)"forUserId");
        Intrinsics.checkNotNullParameter(tweets, (String)"tweets");
        return new TweetIncomingEvent(forUserId, tweets);
    }

    public static /* synthetic */ TweetIncomingEvent copy$default(TweetIncomingEvent tweetIncomingEvent, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = tweetIncomingEvent.getForUserId();
        }
        if ((n & 2) != 0) {
            list = tweetIncomingEvent.tweets;
        }
        return tweetIncomingEvent.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "TweetIncomingEvent(forUserId=" + this.getForUserId() + ", tweets=" + this.tweets + ")";
    }

    public int hashCode() {
        String string = this.getForUserId();
        List<Tweet> list = this.tweets;
        return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TweetIncomingEvent)) break block3;
                TweetIncomingEvent tweetIncomingEvent = (TweetIncomingEvent)object;
                if (!Intrinsics.areEqual((Object)this.getForUserId(), (Object)tweetIncomingEvent.getForUserId()) || !Intrinsics.areEqual(this.tweets, tweetIncomingEvent.tweets)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/twitter/model/incoming/TweetIncomingEvent$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-bot-connector-twitter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

