/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.twitter;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.ConnectorQueue;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.twitter.TwitterBuildersKt;
import ai.tock.bot.connector.twitter.TwitterClient;
import ai.tock.bot.connector.twitter.TwitterConnectorCallback;
import ai.tock.bot.connector.twitter.TwitterConnectorProvider;
import ai.tock.bot.connector.twitter.TwitterMessageConverter;
import ai.tock.bot.connector.twitter.model.Attachment;
import ai.tock.bot.connector.twitter.model.CTA;
import ai.tock.bot.connector.twitter.model.MediaCategory;
import ai.tock.bot.connector.twitter.model.MediaCategoryKt;
import ai.tock.bot.connector.twitter.model.MessageCreate;
import ai.tock.bot.connector.twitter.model.MessageData;
import ai.tock.bot.connector.twitter.model.OptionWithoutDescription;
import ai.tock.bot.connector.twitter.model.Recipient;
import ai.tock.bot.connector.twitter.model.User;
import ai.tock.bot.connector.twitter.model.WebUrl;
import ai.tock.bot.connector.twitter.model.Webhook;
import ai.tock.bot.connector.twitter.model.incoming.IncomingEvent;
import ai.tock.bot.connector.twitter.model.incoming.TweetIncomingEvent;
import ai.tock.bot.connector.twitter.model.outcoming.DirectMessageOutcomingEvent;
import ai.tock.bot.connector.twitter.model.outcoming.OutcomingEvent;
import ai.tock.bot.connector.twitter.model.outcoming.Tweet;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.definition.StoryHandlerDefinition;
import ai.tock.bot.definition.StoryStep;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.I18nTranslator;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.ActionNotificationType;
import ai.tock.bot.engine.action.ActionVisibility;
import ai.tock.bot.engine.action.SendChoice;
import ai.tock.bot.engine.config.UploadedFilesService;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.monitoring.RequestTimerKt;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.translator.I18nKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.invoke.LambdaMetafactory;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.lang3.LocaleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SB1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0016Jd\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\u0010\u0010/\u001a\f\u0012\u0006\b\u0001\u0012\u000201\u0018\u0001002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003032\b\u00104\u001a\u0004\u0018\u0001052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\"07H\u0016J(\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010'\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020A2\u0006\u0010'\u001a\u00020?2\u0006\u0010B\u001a\u00020CH\u0002J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u0003H\u0002J1\u0010H\u001a\u0015\u0012\u0004\u0012\u00020I\u0012\u0006\u0012\u0004\u0018\u00010J07\u00a2\u0006\u0002\bK2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020M0OH\u0016J'\u0010P\u001a\u0019\u0012\u0004\u0012\u00020I\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0O07\u00a2\u0006\u0002\bK2\u0006\u0010Q\u001a\u00020RH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lai/tock/bot/connector/twitter/TwitterConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "accountId", "baseUrl", "path", "client", "Lai/tock/bot/connector/twitter/TwitterClient;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lai/tock/bot/connector/twitter/TwitterClient;)V", "getApplicationId", "()Ljava/lang/String;", "getAccountId", "getBaseUrl", "getPath", "getClient", "()Lai/tock/bot/connector/twitter/TwitterClient;", "url", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "queue", "Lai/tock/bot/connector/ConnectorQueue;", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "userId", "Lai/tock/bot/engine/user/PlayerId;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "unregister", "send", "event", "Lai/tock/bot/engine/event/Event;", "delayInMs", "", "notify", "recipientId", "intent", "Lai/tock/bot/definition/IntentAware;", "step", "Lai/tock/bot/definition/StoryStep;", "Lai/tock/bot/definition/StoryHandlerDefinition;", "parameters", "", "notificationType", "Lai/tock/bot/engine/action/ActionNotificationType;", "errorListener", "Lkotlin/Function1;", "", "sendDirectMessageWithAttachment", "mediaCategory", "Lai/tock/bot/connector/twitter/model/MediaCategory;", "contentType", "bytes", "", "Lai/tock/bot/connector/twitter/model/outcoming/DirectMessageOutcomingEvent;", "buildDirectMessageOutcomingEventWithAttachment", "Lai/tock/bot/connector/twitter/model/outcoming/OutcomingEvent;", "attachment", "Lai/tock/bot/connector/twitter/model/Attachment;", "isSignedByTwitter", "", "payload", "twitterSignature", "addSuggestions", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "text", "", "suggestions", "", "toConnectorMessage", "message", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-twitter"})
@SourceDebugExtension(value={"SMAP\nTwitterConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwitterConnector.kt\nai/tock/bot/connector/twitter/TwitterConnector\n+ 2 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 3 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,368:1\n80#2:369\n277#3:370\n1#4:371\n58#5:372\n51#5:373\n1557#6:374\n1628#6,3:375\n774#6:380\n865#6,2:381\n1557#6:383\n1628#6,3:384\n1755#6,3:389\n774#6:392\n865#6,2:393\n1557#6:395\n1628#6,3:396\n1557#6:401\n1628#6,3:402\n37#7,2:378\n37#7,2:387\n37#7,2:399\n37#7,2:405\n*S KotlinDebug\n*F\n+ 1 TwitterConnector.kt\nai/tock/bot/connector/twitter/TwitterConnector\n*L\n80#1:369\n80#1:370\n148#1:372\n148#1:373\n322#1:374\n322#1:375,3\n341#1:380\n341#1:381,2\n341#1:383\n341#1:384,3\n348#1:389,3\n351#1:392\n351#1:393,2\n351#1:395\n351#1:396,3\n356#1:401\n356#1:402,3\n322#1:378,2\n341#1:387,2\n351#1:399,2\n356#1:405,2\n*E\n"})
public final class TwitterConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String accountId;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String path;
    @NotNull
    private final TwitterClient client;
    @NotNull
    private final String url;
    @NotNull
    private final InjectedProperty executor$delegate;
    @NotNull
    private final ConnectorQueue queue;
    @NotNull
    private static final KLogger logger;

    public TwitterConnector(@NotNull String applicationId, @NotNull String accountId, @NotNull String baseUrl, @NotNull String path, @NotNull TwitterClient client) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(TwitterConnectorProvider.INSTANCE.getConnectorType(), null, 2, null);
        this.applicationId = applicationId;
        this.accountId = accountId;
        this.baseUrl = baseUrl;
        this.path = path;
        this.client = client;
        this.url = this.baseUrl + this.path;
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
        this.queue = new ConnectorQueue(this.getExecutor());
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getAccountId() {
        return this.accountId;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final TwitterClient getClient() {
        return this.client;
    }

    private final Executor getExecutor() {
        return (Executor)this.executor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            Object object;
            ZoneId zoneId;
            String string;
            String string2;
            String string3;
            User userProfile;
            block9: {
                block8: {
                    Locale locale;
                    userProfile = this.client.user(userId.getId());
                    logger.debug(() -> TwitterConnector.loadProfile$lambda$0(userProfile, userId));
                    string3 = userProfile.getScreenName();
                    string2 = "";
                    string = null;
                    String string4 = userProfile.getUtcOffset();
                    if (string4 == null) {
                        string4 = "Z";
                    }
                    ZoneOffset zoneOffset = ZoneOffset.of(string4);
                    Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"of(...)");
                    zoneId = zoneOffset;
                    object = userProfile.getLang();
                    if (object == null) break block8;
                    String string5 = object;
                    ZoneId zoneId2 = zoneId;
                    String string6 = string;
                    String string7 = string2;
                    String string8 = string3;
                    boolean bl = false;
                    try {
                        void it;
                        locale = LocaleUtils.toLocale((String)it);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)logger, (Throwable)e);
                        locale = null;
                    }
                    Locale locale2 = locale;
                    string3 = string8;
                    string2 = string7;
                    string = string6;
                    zoneId = zoneId2;
                    Locale locale3 = locale2;
                    object = locale3;
                    if (locale3 != null) break block9;
                }
                object = LocalesKt.getDefaultLocale();
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 448;
            Locale locale = null;
            boolean bl = false;
            String string9 = null;
            String string10 = userProfile.getProfileImageUrlHttps();
            Object object2 = object;
            ZoneId zoneId3 = zoneId;
            String string11 = string;
            String string12 = string2;
            String string13 = string3;
            return new UserPreferences(string13, string12, string11, zoneId3, (Locale)object2, string10, string9, bl, locale, n, defaultConstructorMarker);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            return new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
        }
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        controller.registerServices(this.path, arg_0 -> TwitterConnector.register$lambda$14(this, controller, arg_0));
    }

    public void unregister(@NotNull ConnectorController controller) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                super.unregister(controller);
                List<Webhook> existingWebhooks = this.client.webhooks();
                Iterable iterable = existingWebhooks;
                for (Object t : iterable) {
                    Webhook webhook = (Webhook)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)webhook.getUrl(), (Object)this.url)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Webhook webhook = v0;
            if (webhook == null) break block2;
            Webhook it = webhook;
            boolean bl = false;
            this.client.unregisterWebhook(it.getId());
        }
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        TwitterConnectorCallback cfr_ignored_0 = (TwitterConnectorCallback)callback;
        logger.debug(() -> TwitterConnector.send$lambda$17(event));
        if (event instanceof Action) {
            if (((Action)event).getMetadata().getVisibility() == ActionVisibility.UNKNOWN) {
                ((Action)event).getMetadata().setVisibility(((TwitterConnectorCallback)callback).getVisibility());
            }
            this.queue.add((Action)event, delayInMs, arg_0 -> TwitterConnector.send$lambda$20(this, callback, arg_0));
        }
    }

    public void notify(@NotNull ConnectorController controller, @NotNull PlayerId recipientId, @NotNull IntentAware intent, @Nullable StoryStep<? extends StoryHandlerDefinition> step, @NotNull Map<String, String> parameters, @Nullable ActionNotificationType notificationType, @NotNull Function1<? super Throwable, Unit> errorListener) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)recipientId, (String)"recipientId");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(errorListener, (String)"errorListener");
        controller.handle((Event)new SendChoice(recipientId, this.applicationId, new PlayerId(this.accountId, PlayerType.bot, null, 4, null), intent.wrappedIntent().getName(), step, parameters, null, null, null, null, 960, null), new ConnectorData((ConnectorCallback)new TwitterConnectorCallback(this.applicationId, ActionVisibility.PRIVATE, null, false), null, false, null, null, null, 62, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void sendDirectMessageWithAttachment(MediaCategory mediaCategory, String contentType, byte[] bytes, DirectMessageOutcomingEvent event) {
        outcomingEvent = null;
        try {
            attachment = this.client.createAttachment(mediaCategory, contentType, bytes);
            outcomingEvent = this.buildDirectMessageOutcomingEventWithAttachment(event, attachment);
            v0 = outcomingEvent;
            ** if (v0 != null) goto lbl10
        }
        catch (Exception e) {
            try {
                TwitterConnector.logger.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, sendDirectMessageWithAttachment$lambda$21(java.lang.Exception ), ()Ljava/lang/Object;)((Exception)e));
                outcomingEvent = new OutcomingEvent(event, null, 2, null);
                ** if (this.client.sendDirectMessage((OutcomingEvent)outcomingEvent)) goto lbl-1000
            }
            catch (Throwable var6_8) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outcomingEvent");
                if (!this.client.sendDirectMessage(null)) {
                    TwitterConnector.logger.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, sendDirectMessageWithAttachment$lambda$22(), ()Ljava/lang/Object;)());
                }
                throw var6_8;
            }
lbl-1000:
            // 1 sources

            {
                TwitterConnector.logger.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, sendDirectMessageWithAttachment$lambda$22(), ()Ljava/lang/Object;)());
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outcomingEvent");
            v0 = null;
        }
lbl10:
        // 2 sources

        if (!this.client.sendDirectMessage(v0)) {
            TwitterConnector.logger.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, sendDirectMessageWithAttachment$lambda$22(), ()Ljava/lang/Object;)());
        }
    }

    private final OutcomingEvent buildDirectMessageOutcomingEventWithAttachment(DirectMessageOutcomingEvent event, Attachment attachment) {
        Recipient recipient = event.getMessageCreate().getTarget();
        String string = event.getMessageCreate().getSourceAppId();
        String string2 = event.getMessageCreate().getSenderId();
        MessageData messageData = new MessageData(event.getMessageCreate().getMessageData().getText(), event.getMessageCreate().getMessageData().getEntities(), event.getMessageCreate().getMessageData().getCtas(), attachment, event.getMessageCreate().getMessageData().getQuickReply(), event.getMessageCreate().getMessageData().getQuickReplyResponse());
        return new OutcomingEvent(new DirectMessageOutcomingEvent(new MessageCreate(recipient, string2, string, messageData)), null, 2, null);
    }

    private final boolean isSignedByTwitter(String payload, String twitterSignature) {
        return Intrinsics.areEqual((Object)("sha256=" + this.client.b64HmacSHA256(payload)), (Object)twitterSignature);
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> TwitterConnector.addSuggestions$lambda$24(text, suggestions, arg_0);
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return arg_0 -> TwitterConnector.toConnectorMessage$lambda$33(message, arg_0);
    }

    private static final Object loadProfile$lambda$0(User $userProfile, PlayerId $userId) {
        return "User profile : " + $userProfile + " for " + $userId;
    }

    private static final Object register$lambda$14$lambda$5$lambda$2() {
        return "get twitter crc";
    }

    private static final Object register$lambda$14$lambda$5$lambda$3(String $crcToken) {
        return "Twitter crc_token: " + $crcToken;
    }

    private static final Object register$lambda$14$lambda$5$lambda$4(String $sha256) {
        return "Twitter CRC response: " + $sha256;
    }

    private static final void register$lambda$14$lambda$5(TwitterConnector this$0, RoutingContext context) {
        try {
            logger.info(TwitterConnector::register$lambda$14$lambda$5$lambda$2);
            List list = context.queryParam("crc_token");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryParam(...)");
            String crcToken = (String)CollectionsKt.first((List)list);
            logger.info(() -> TwitterConnector.register$lambda$14$lambda$5$lambda$3(crcToken));
            TwitterClient twitterClient = this$0.client;
            Intrinsics.checkNotNull((Object)crcToken);
            String sha256 = twitterClient.b64HmacSHA256(crcToken);
            logger.info(() -> TwitterConnector.register$lambda$14$lambda$5$lambda$4(sha256));
            context.response().end("{\"response_token\":\"sha256=" + sha256 + "\"}");
        }
        catch (Throwable e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            context.fail(500);
        }
    }

    private static final Object register$lambda$14$lambda$13$lambda$6() {
        return "get twitter Message";
    }

    private static final Object register$lambda$14$lambda$13$lambda$7(String $twitterHeader) {
        return "Twitter signature:  " + $twitterHeader;
    }

    private static final Object register$lambda$14$lambda$13$lambda$8(RoutingContext $context) {
        return "Twitter headers:  " + $context.request().headers().entries();
    }

    private static final Object register$lambda$14$lambda$13$lambda$9(String $body) {
        return "Twitter request input : " + $body;
    }

    private static final Object register$lambda$14$lambda$13$lambda$10() {
        return "Unknown event";
    }

    private static final Object register$lambda$14$lambda$13$lambda$11(IncomingEvent $incomingEvent) {
        return "Ignored event : " + $incomingEvent.getClass().getSimpleName();
    }

    private static final Unit register$lambda$14$lambda$13$lambda$12(IncomingEvent $incomingEvent, TwitterConnector this$0, ConnectorController $controller) {
        Event event = $incomingEvent.toEvent(this$0.applicationId);
        Triple triple = $incomingEvent instanceof TweetIncomingEvent ? new Triple((Object)((ai.tock.bot.connector.twitter.model.Tweet)CollectionsKt.first(((TweetIncomingEvent)$incomingEvent).getTweets())).getId(), (Object)ActionVisibility.PUBLIC, (Object)(((ai.tock.bot.connector.twitter.model.Tweet)CollectionsKt.first(((TweetIncomingEvent)$incomingEvent).getTweets())).getInReplyToStatusId() != null ? 1 : 0)) : new Triple(null, (Object)ActionVisibility.PRIVATE, (Object)false);
        Long threadId = (Long)triple.component1();
        ActionVisibility visibility = (ActionVisibility)triple.component2();
        boolean reply = (Boolean)triple.component3();
        TwitterConnectorCallback callback = new TwitterConnectorCallback(this$0.applicationId, visibility, threadId, reply);
        if (event != null) {
            $controller.handle(event, new ConnectorData((ConnectorCallback)callback, null, false, null, null, null, 62, null));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void register$lambda$14$lambda$13(TwitterConnector this$0, ConnectorController $controller, RoutingContext context) {
        block17: {
            RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("twitter_webhook");
            try {
                logger.info(TwitterConnector::register$lambda$14$lambda$13$lambda$6);
                String twitterHeader = context.request().getHeader("X-Twitter-Webhooks-Signature");
                logger.debug(() -> TwitterConnector.register$lambda$14$lambda$13$lambda$7(twitterHeader));
                logger.debug(() -> TwitterConnector.register$lambda$14$lambda$13$lambda$8(context));
                String body = context.body().asString();
                if (twitterHeader != null) {
                    Intrinsics.checkNotNull((Object)body);
                    if (this$0.isSignedByTwitter(body, twitterHeader)) {
                        try {
                            void $this$readValue$iv;
                            logger.debug(() -> TwitterConnector.register$lambda$14$lambda$13$lambda$9(body));
                            ObjectMapper objectMapper = JacksonKt.getMapper();
                            String content$iv = body;
                            boolean $i$f$readValue = false;
                            boolean $i$f$jacksonTypeRef = false;
                            IncomingEvent incomingEvent = (IncomingEvent)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<IncomingEvent>(){});
                            if (incomingEvent == null) {
                                logger.debug(TwitterConnector::register$lambda$14$lambda$13$lambda$10);
                                break block17;
                            }
                            if (incomingEvent.getIgnored()) {
                                logger.debug(() -> TwitterConnector.register$lambda$14$lambda$13$lambda$11(incomingEvent));
                                break block17;
                            }
                            this$0.getExecutor().executeBlocking(() -> TwitterConnector.register$lambda$14$lambda$13$lambda$12(incomingEvent, this$0, $controller));
                        }
                        catch (Throwable t) {
                            RequestTimerKt.logError((KLogger)logger, (Throwable)t, (RequestTimerData)requestTimerData);
                        }
                        break block17;
                    }
                }
                RequestTimerKt.logError((KLogger)logger, (String)("Not signed by twitter!!! : " + twitterHeader + " \n " + body), (RequestTimerData)requestTimerData);
            }
            catch (Throwable e) {
                RequestTimerKt.logError((KLogger)logger, (Throwable)e, (RequestTimerData)requestTimerData);
            }
            finally {
                try {
                    BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                    context.response().end();
                }
                catch (Throwable e) {
                    LoggersKt.error((KLogger)logger, (Throwable)e);
                }
            }
        }
    }

    private static final Unit register$lambda$14(TwitterConnector this$0, ConnectorController $controller, Router router) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        logger.info("deploy rest twitter connector services for root path " + this$0.path + " ");
        router.get(this$0.path).handler(arg_0 -> TwitterConnector.register$lambda$14$lambda$5(this$0, arg_0));
        router.post(this$0.path).handler(arg_0 -> TwitterConnector.register$lambda$14$lambda$13(this$0, $controller, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object send$lambda$17(Event $event) {
        return "event: " + $event;
    }

    private static final Object send$lambda$20$lambda$19$lambda$18(ConnectorMessage $message) {
        return "Unknown message to send by twitter : " + $message.getClass();
    }

    private static final Unit send$lambda$20(TwitterConnector this$0, ConnectorCallback $callback, Action action) {
        block4: {
            ConnectorMessage connectorMessage;
            ConnectorMessage message;
            block5: {
                ConnectorMessage connectorMessage2;
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                ConnectorMessage connectorMessage3 = TwitterMessageConverter.INSTANCE.toEvent(action);
                if (connectorMessage3 == null) break block4;
                message = connectorMessage2 = connectorMessage3;
                boolean bl = false;
                connectorMessage = message;
                if (!(connectorMessage instanceof OutcomingEvent)) break block5;
                if (!(((OutcomingEvent)message).getEvent() instanceof DirectMessageOutcomingEvent)) break block4;
                if (((OutcomingEvent)message).getAttachmentData() != null) {
                    this$0.sendDirectMessageWithAttachment(((OutcomingEvent)message).getAttachmentData().getMediaCategory(), ((OutcomingEvent)message).getAttachmentData().getContentType(), ((OutcomingEvent)message).getAttachmentData().getBytes(), (DirectMessageOutcomingEvent)((OutcomingEvent)message).getEvent());
                } else {
                    this$0.client.sendDirectMessage((OutcomingEvent)message);
                }
                break block4;
            }
            if (connectorMessage instanceof Tweet) {
                this$0.client.sendTweet((Tweet)message, ((TwitterConnectorCallback)$callback).getThreadId());
            } else {
                logger.error(() -> TwitterConnector.send$lambda$20$lambda$19$lambda$18(message));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Object sendDirectMessageWithAttachment$lambda$21(Exception $e) {
        return $e;
    }

    private static final Object sendDirectMessageWithAttachment$lambda$22() {
        return "sendDirectMessage with attachment failed";
    }

    /*
     * WARNING - void declaration
     */
    private static final OutcomingEvent addSuggestions$lambda$24(CharSequence $text, List $suggestions, BotBus botBus) {
        void $this$toTypedArray$iv;
        Collection<OptionWithoutDescription> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        Iterable iterable = $suggestions;
        CharSequence charSequence = $text;
        Bus bus = (Bus)botBus;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CharSequence charSequence2 = (CharSequence)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TwitterBuildersKt.nlpOption((I18nTranslator)botBus, (CharSequence)it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        OptionWithoutDescription[] optionWithoutDescriptionArray = thisCollection$iv.toArray(new OptionWithoutDescription[0]);
        return TwitterBuildersKt.directMessageWithOptions(bus, charSequence, Arrays.copyOf(optionWithoutDescriptionArray, optionWithoutDescriptionArray.length));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final List toConnectorMessage$lambda$33(MediaMessage $message, BotBus <this>) {
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)<this>, (String)"<this>");
                if (!($message instanceof MediaCard)) break block19;
                v0 = f = ((MediaCard)$message).getFile();
                type = v0 != null ? MediaCategoryKt.toMediaCategory(v0) : null;
                v1 /* !! */  = f;
                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getUrl()) == null) ** GOTO lbl-1000
                var7_4 = v1 /* !! */ ;
                it /* !! */  = var7_4;
                $i$a$-takeUnless-TwitterConnector$toConnectorMessage$1$content$1 = false;
                v1 /* !! */  = type == null == false ? var7_4 : null;
                if (v1 /* !! */  != null) {
                    it /* !! */  = v1 /* !! */ ;
                    $i$a$-let-TwitterConnector$toConnectorMessage$1$content$2 = false;
                    v2 = UploadedFilesService.INSTANCE.getFileContentFromUrl((String)it /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                content = v2;
                title = ((MediaCard)$message).getTitle();
                subTitle = ((MediaCard)$message).getSubTitle();
                if (type != null && content != null) {
                    v3 = (Bus)<this>;
                    v4 = title;
                    if (v4 == null && (v4 = subTitle) == null) {
                        v4 = (CharSequence)I18nKt.getRaw((CharSequence)"");
                    }
                    it /* !! */  = ((MediaCard)$message).getActions();
                    var22_12 = content;
                    var21_13 = UploadedFilesService.INSTANCE.guessContentType(f.getUrl());
                    var20_14 = type;
                    var19_17 = v4;
                    var18_20 = v3;
                    $i$f$filter = false;
                    var10_23 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (MediaAction)element$iv$iv;
                        $i$a$-filter-TwitterConnector$toConnectorMessage$1$1 = false;
                        if (!(it.getUrl() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var23_42 = (List)destination$iv$iv;
                    $this$filter$iv = var23_42;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (MediaAction)item$iv$iv;
                        var23_42 = destination$iv$iv;
                        $i$a$-map-TwitterConnector$toConnectorMessage$1$2 = false;
                        var23_42.add(TwitterBuildersKt.nlpOption((I18nTranslator)<this>, it.getTitle()));
                    }
                    var23_42 = (List)destination$iv$iv;
                    $this$map$iv = var23_42;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    var7_4 = thisCollection$iv.toArray(new OptionWithoutDescription[0]);
                    v5 = CollectionsKt.listOf((Object)TwitterBuildersKt.directMessageWithAttachment(var18_20, var19_17, var20_14, var21_13, var22_12, Arrays.copyOf(var7_4, var7_4.length)));
                } else if (title != null || subTitle != null) {
                    block18: {
                        v6 = title;
                        if (v6 == null) {
                            v7 = subTitle;
                            v6 = v7;
                            Intrinsics.checkNotNull((Object)v7);
                        }
                        firstText = v6;
                        $this$any$iv = ((MediaCard)$message).getActions();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v8 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (MediaAction)element$iv;
                                $i$a$-any-TwitterConnector$toConnectorMessage$1$3 = false;
                                if (!(it.getUrl() != null)) continue;
                                v8 = true;
                                break block18;
                            }
                            v8 = false;
                        }
                    }
                    if (v8) {
                        $i$f$any = ((MediaCard)$message).getActions();
                        var19_18 = firstText;
                        var18_21 = (Bus)<this>;
                        $i$f$filter = false;
                        element$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (MediaAction)element$iv$iv;
                            $i$a$-filter-TwitterConnector$toConnectorMessage$1$4 = false;
                            if (!(it.getUrl() != null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        var20_15 = (List)destination$iv$iv;
                        $this$filter$iv = var20_15;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (MediaAction)item$iv$iv;
                            var20_15 = destination$iv$iv;
                            $i$a$-map-TwitterConnector$toConnectorMessage$1$5 = false;
                            v9 = (Bus)<this>;
                            v10 = it.getTitle();
                            v11 = it.getUrl();
                            Intrinsics.checkNotNull((Object)v11);
                            var20_15.add(TwitterBuildersKt.webUrl(v9, v10, v11));
                        }
                        var20_15 = (List)destination$iv$iv;
                        $this$map$iv = var20_15;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        var8_5 = thisCollection$iv.toArray(new WebUrl[0]);
                        v12 = TwitterBuildersKt.directMessageWithButtons(var18_21, var19_18, (CTA[])Arrays.copyOf(var8_5, var8_5.length));
                    } else {
                        $this$toTypedArray$iv = ((MediaCard)$message).getActions();
                        var19_19 = firstText;
                        var18_22 = (Bus)<this>;
                        $i$f$map = false;
                        thisCollection$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (MediaAction)item$iv$iv;
                            var20_16 = destination$iv$iv;
                            $i$a$-map-TwitterConnector$toConnectorMessage$1$6 = false;
                            var20_16.add(TwitterBuildersKt.nlpOption((I18nTranslator)<this>, it.getTitle()));
                        }
                        var20_16 = (List)destination$iv$iv;
                        $this$map$iv = var20_16;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        var8_5 = thisCollection$iv.toArray(new OptionWithoutDescription[0]);
                        v12 = TwitterBuildersKt.directMessageWithOptions(var18_22, var19_19, Arrays.copyOf(var8_5, var8_5.length));
                    }
                    v5 = CollectionsKt.listOfNotNull((Object)v12);
                } else {
                    v5 = CollectionsKt.emptyList();
                }
                break block20;
            }
            v5 = CollectionsKt.emptyList();
        }
        return v5;
    }

    private static final Unit logger$lambda$34() {
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TwitterConnector.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger(TwitterConnector::logger$lambda$34);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/tock/bot/connector/twitter/TwitterConnector$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "tock-bot-connector-twitter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

