/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.twitter;

import ai.tock.bot.connector.ConnectorException;
import ai.tock.bot.connector.twitter.model.AccessToken;
import ai.tock.bot.connector.twitter.model.Attachment;
import ai.tock.bot.connector.twitter.model.AttachmentMedia;
import ai.tock.bot.connector.twitter.model.Command;
import ai.tock.bot.connector.twitter.model.MediaCategory;
import ai.tock.bot.connector.twitter.model.MediaUpload;
import ai.tock.bot.connector.twitter.model.RequestToken;
import ai.tock.bot.connector.twitter.model.Tweet;
import ai.tock.bot.connector.twitter.model.User;
import ai.tock.bot.connector.twitter.model.Webhook;
import ai.tock.bot.connector.twitter.model.outcoming.OutcomingEvent;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import oauth.signpost.http.HttpParameters;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import se.akerfeldt.okhttp.signpost.OkHttpOAuthConsumer;
import se.akerfeldt.okhttp.signpost.SigningInterceptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u0006STUVWXB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!*\u0006\u0012\u0002\b\u00030\"H\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010%\u001a\u00020\u0003H\u0002J\b\u0010&\u001a\u0004\u0018\u00010'J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'J\u0018\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0003J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0003J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u000e\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u0003J\u000e\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u0003J\f\u00106\u001a\b\u0012\u0004\u0012\u00020-07J\u000e\u00108\u001a\u0002002\u0006\u00109\u001a\u00020:J\u001d\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?\u00a2\u0006\u0002\u0010@J\u001e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020GJ\u0018\u0010H\u001a\u00020!2\u0006\u0010F\u001a\u00020G2\u0006\u0010I\u001a\u00020\u0003H\u0002J \u0010J\u001a\u00020K2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010L\u001a\u00020?H\u0002J \u0010M\u001a\u0002002\u0006\u0010I\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\u00112\u0006\u0010O\u001a\u00020GH\u0002J\u0010\u0010P\u001a\u00020K2\u0006\u0010I\u001a\u00020\u0003H\u0002J\u000e\u0010Q\u001a\u00020\u00032\u0006\u0010R\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient;", "", "environment", "", "consumerKey", "consumerSecret", "token", "secret", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEnvironment", "()Ljava/lang/String;", "getConsumerKey", "getConsumerSecret", "BASE_URL", "BASE_MEDIA_URL", "MEDIA_CHUNK_SIZE", "", "logger", "Lmu/KLogger;", "accountActivityApi", "Lai/tock/bot/connector/twitter/TwitterClient$AccountActivityApi;", "directMessageApi", "Lai/tock/bot/connector/twitter/TwitterClient$DirectMessageApi;", "userApi", "Lai/tock/bot/connector/twitter/TwitterClient$UserApi;", "mediaApi", "Lai/tock/bot/connector/twitter/TwitterClient$MediaApi;", "statusApi", "Lai/tock/bot/connector/twitter/TwitterClient$StatusApi;", "defaultUser", "Lai/tock/bot/connector/twitter/model/User;", "logError", "", "Lretrofit2/Response;", "splitQuery", "", "query", "requestToken", "Lai/tock/bot/connector/twitter/model/RequestToken;", "authorizationUrl", "accessToken", "Lai/tock/bot/connector/twitter/model/AccessToken;", "oauthVerifier", "registerWebhook", "Lai/tock/bot/connector/twitter/model/Webhook;", "url", "subscribe", "", "subscriptions", "unregisterWebhook", "webhookId", "user", "userId", "webhooks", "", "sendDirectMessage", "outcomingEvent", "Lai/tock/bot/connector/twitter/model/outcoming/OutcomingEvent;", "sendTweet", "tweet", "Lai/tock/bot/connector/twitter/model/outcoming/Tweet;", "threadId", "", "(Lai/tock/bot/connector/twitter/model/outcoming/Tweet;Ljava/lang/Long;)Z", "createAttachment", "Lai/tock/bot/connector/twitter/model/Attachment;", "mediaCategory", "Lai/tock/bot/connector/twitter/model/MediaCategory;", "contentType", "data", "", "uploadMedia", "mediaId", "uploadMediaInit", "Lai/tock/bot/connector/twitter/model/MediaUpload;", "totalBytes", "uploadMediaAppend", "segmentIndex", "chunk", "uploadMediaFinalize", "b64HmacSHA256", "payload", "OAuthApi", "UserApi", "AccountActivityApi", "DirectMessageApi", "MediaApi", "StatusApi", "tock-bot-connector-twitter"})
@SourceDebugExtension(value={"SMAP\nTwitterClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwitterClient.kt\nai/tock/bot/connector/twitter/TwitterClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,643:1\n71#2:644\n71#2:645\n71#2:646\n71#2:647\n71#2:648\n71#2:660\n71#2:661\n739#3,9:649\n37#4,2:658\n*S KotlinDebug\n*F\n+ 1 TwitterClient.kt\nai/tock/bot/connector/twitter/TwitterClient\n*L\n211#1:644\n221#1:645\n231#1:646\n241#1:647\n251#1:648\n295#1:660\n350#1:661\n268#1:649,9\n268#1:658,2\n*E\n"})
public final class TwitterClient {
    @NotNull
    private final String environment;
    @NotNull
    private final String consumerKey;
    @NotNull
    private final String consumerSecret;
    @NotNull
    private final String BASE_URL;
    @NotNull
    private final String BASE_MEDIA_URL;
    private final int MEDIA_CHUNK_SIZE;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final AccountActivityApi accountActivityApi;
    @NotNull
    private final DirectMessageApi directMessageApi;
    @NotNull
    private final UserApi userApi;
    @NotNull
    private final MediaApi mediaApi;
    @NotNull
    private final StatusApi statusApi;

    public TwitterClient(@NotNull String environment, @NotNull String consumerKey, @NotNull String consumerSecret, @Nullable String token, @Nullable String secret) {
        Retrofit $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)consumerKey, (String)"consumerKey");
        Intrinsics.checkNotNullParameter((Object)consumerSecret, (String)"consumerSecret");
        this.environment = environment;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.BASE_URL = "https://api.twitter.com";
        this.BASE_MEDIA_URL = "https://upload.twitter.com";
        this.MEDIA_CHUNK_SIZE = 512000;
        this.logger = KotlinLogging.INSTANCE.logger(TwitterClient::logger$lambda$0);
        OkHttpOAuthConsumer twitterOAuthConsumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        if (token != null) {
            twitterOAuthConsumer.setTokenWithSecret(token, secret);
        }
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"baseUrl(...)");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(AccountActivityApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.accountActivityApi = (AccountActivityApi)object;
        Retrofit.Builder builder2 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"baseUrl(...)");
        $this$create$iv = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder2, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"build(...)");
        $i$f$create = false;
        Object object2 = $this$create$iv.create(DirectMessageApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(...)");
        this.directMessageApi = (DirectMessageApi)object2;
        Retrofit.Builder builder3 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"baseUrl(...)");
        $this$create$iv = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder3, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"build(...)");
        $i$f$create = false;
        Object object3 = $this$create$iv.create(UserApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"create(...)");
        this.userApi = (UserApi)object3;
        Retrofit.Builder builder4 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_MEDIA_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"baseUrl(...)");
        $this$create$iv = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder4, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"build(...)");
        $i$f$create = false;
        Object object4 = $this$create$iv.create(MediaApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"create(...)");
        this.mediaApi = (MediaApi)object4;
        Retrofit.Builder builder5 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(twitterOAuthConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"baseUrl(...)");
        $this$create$iv = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)builder5, null, (int)1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"build(...)");
        $i$f$create = false;
        Object object5 = $this$create$iv.create(StatusApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"create(...)");
        this.statusApi = (StatusApi)object5;
    }

    public /* synthetic */ TwitterClient(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, string5);
    }

    @NotNull
    public final String getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final String getConsumerKey() {
        return this.consumerKey;
    }

    @NotNull
    public final String getConsumerSecret() {
        return this.consumerSecret;
    }

    private final User defaultUser() {
        return new User("", "", "", new Date().getTime(), null, null, null, "", "", false, false, 0, 0, 0, "", "");
    }

    private final void logError(Response<?> $this$logError) {
        String error = $this$logError.message();
        int errorCode = $this$logError.code();
        this.logger.warn(() -> TwitterClient.logError$lambda$1(errorCode, error));
        ResponseBody responseBody = $this$logError.errorBody();
        String errorBody = responseBody != null ? responseBody.string() : null;
        this.logger.warn(() -> TwitterClient.logError$lambda$2(errorBody));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> splitQuery(String query) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        LinkedHashMap queryPairs = new LinkedHashMap();
        Object object = query;
        Regex regex = new Regex("&");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String pair : thisCollection$iv.toArray(new String[0])) {
            int idx = StringsKt.indexOf$default((CharSequence)pair, (String)"=", (int)0, (boolean)false, (int)6, null);
            Map map = queryPairs;
            String string = pair.substring(0, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = URLDecoder.decode(string, "UTF-8");
            String string3 = pair.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            map.put(string2, URLDecoder.decode(string3, "UTF-8"));
        }
        return queryPairs;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RequestToken requestToken() {
        void $this$create$iv;
        OkHttpOAuthConsumer oAuthApiConsumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        HttpParameters httpParameters = new HttpParameters();
        httpParameters.put("oauth_callback", "oob");
        oAuthApiConsumer.setAdditionalParameters(httpParameters);
        Retrofit retrofit = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(oAuthApiConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit retrofit2 = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(OAuthApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        OAuthApi oAuthApi = (OAuthApi)object;
        try {
            RequestToken requestToken;
            Response response = oAuthApi.requestToken().execute();
            if (response.isSuccessful()) {
                String string = (String)response.body();
                if (string != null) {
                    String string2;
                    String it = string;
                    boolean bl = false;
                    this.logger.debug(() -> TwitterClient.requestToken$lambda$5$lambda$4(it));
                    Map<String, String> queryPairs = this.splitQuery(it);
                    String string3 = queryPairs.get("oauth_token");
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((string2 = queryPairs.get("oauth_token_secret")) == null) {
                        string2 = "";
                    }
                    String string4 = queryPairs.get("oauth_callback_confirmed");
                    requestToken = new RequestToken(string3, string2, string4 != null ? Boolean.parseBoolean(string4) : false);
                } else {
                    requestToken = null;
                }
            } else {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                requestToken = null;
            }
            retrofit2 = requestToken;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            retrofit2 = null;
        }
        return retrofit2;
    }

    @NotNull
    public final String authorizationUrl(@NotNull RequestToken requestToken) {
        Intrinsics.checkNotNullParameter((Object)requestToken, (String)"requestToken");
        return this.BASE_URL + "/oauth/authorize?oauth_token=" + requestToken.getOauthToken();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AccessToken accessToken(@NotNull RequestToken requestToken, @NotNull String oauthVerifier) {
        void $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)requestToken, (String)"requestToken");
        Intrinsics.checkNotNullParameter((Object)oauthVerifier, (String)"oauthVerifier");
        OkHttpOAuthConsumer oAuthApiConsumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        oAuthApiConsumer.setTokenWithSecret(requestToken.getOauthToken(), requestToken.getOauthTokenSecret());
        HttpParameters httpParameters = new HttpParameters();
        httpParameters.put("oauth_verifier", oauthVerifier);
        oAuthApiConsumer.setAdditionalParameters(httpParameters);
        Retrofit retrofit = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_twitter_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)new SigningInterceptor(oAuthApiConsumer)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(this.BASE_URL).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit retrofit2 = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(OAuthApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        OAuthApi oAuthApi = (OAuthApi)object;
        try {
            AccessToken accessToken;
            Response response = oAuthApi.accessToken().execute();
            if (response.isSuccessful()) {
                String string = (String)response.body();
                if (string != null) {
                    String string2;
                    String string3;
                    String string4;
                    String it = string;
                    boolean bl = false;
                    this.logger.debug(() -> TwitterClient.accessToken$lambda$7$lambda$6(it));
                    Map<String, String> queryPairs = this.splitQuery(it);
                    String string5 = queryPairs.get("oauth_token");
                    if (string5 == null) {
                        string5 = "";
                    }
                    if ((string4 = queryPairs.get("oauth_token_secret")) == null) {
                        string4 = "";
                    }
                    if ((string3 = queryPairs.get("user_id")) == null) {
                        string3 = "";
                    }
                    if ((string2 = queryPairs.get("screen_name")) == null) {
                        string2 = "";
                    }
                    accessToken = new AccessToken(string5, string4, string3, string2);
                } else {
                    accessToken = null;
                }
            } else {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                accessToken = null;
            }
            retrofit2 = accessToken;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            retrofit2 = null;
        }
        return retrofit2;
    }

    @Nullable
    public final Webhook registerWebhook(@NotNull String url) {
        Webhook webhook;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Webhook webhook2;
            Response response = this.accountActivityApi.registerWebhook(this.environment, url).execute();
            if (response.isSuccessful()) {
                Webhook webhook3 = (Webhook)response.body();
                if (webhook3 != null) {
                    Webhook webhook4;
                    Webhook it = webhook4 = webhook3;
                    boolean bl = false;
                    this.logger.debug(() -> TwitterClient.registerWebhook$lambda$9$lambda$8(it));
                    webhook2 = webhook4;
                } else {
                    webhook2 = null;
                }
            } else {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                webhook2 = null;
            }
            webhook = webhook2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            webhook = null;
        }
        return webhook;
    }

    public final boolean subscribe() {
        boolean bl;
        try {
            boolean bl2;
            Response response = this.accountActivityApi.subscribe("develop").execute();
            if (!response.isSuccessful()) {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean subscriptions() {
        boolean bl;
        try {
            Response response = this.accountActivityApi.subscriptions("develop").execute();
            bl = response.code() == 204;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean unregisterWebhook(@NotNull String webhookId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)webhookId, (String)"webhookId");
        try {
            boolean bl2;
            Response response = this.accountActivityApi.unregisterWebhook(this.environment, webhookId).execute();
            if (!response.isSuccessful()) {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final User user(@NotNull String userId) {
        User user;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            User user2;
            Response response = this.userApi.user(userId).execute();
            if (response.isSuccessful()) {
                User user3 = (User)response.body();
                if (user3 != null) {
                    User user4;
                    User it = user4 = user3;
                    boolean bl = false;
                    this.logger.debug(() -> TwitterClient.user$lambda$11$lambda$10(it));
                    user2 = user4;
                } else {
                    user2 = this.defaultUser();
                }
            } else {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                user2 = this.defaultUser();
            }
            user = user2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            user = this.defaultUser();
        }
        return user;
    }

    @NotNull
    public final List<Webhook> webhooks() {
        List list;
        try {
            List list2;
            Response response = this.accountActivityApi.webhooks(this.environment).execute();
            if (response.isSuccessful()) {
                List list3 = (List)response.body();
                if (list3 != null) {
                    List list4;
                    List it = list4 = list3;
                    boolean bl = false;
                    this.logger.debug(() -> TwitterClient.webhooks$lambda$13$lambda$12(it));
                    list2 = list4;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
            } else {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean sendDirectMessage(@NotNull OutcomingEvent outcomingEvent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)outcomingEvent, (String)"outcomingEvent");
        try {
            boolean bl2;
            Response response = this.directMessageApi.new(outcomingEvent).execute();
            if (!response.isSuccessful()) {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean sendTweet(@NotNull ai.tock.bot.connector.twitter.model.outcoming.Tweet tweet, @Nullable Long threadId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
        try {
            boolean bl2;
            boolean enableDefaultMessage;
            boolean enableDM = tweet.getDmRecipientID() != null;
            boolean enableWelcomeMessage = tweet.getWelcomeMessageID() != null;
            boolean bl3 = enableDefaultMessage = tweet.getDefaultMessage() != null;
            String message = enableDM ? tweet.getText() + " https://twitter.com/messages/compose?recipient_id=" + tweet.getDmRecipientID() + (String)(enableWelcomeMessage ? "&welcome_message_id=" + tweet.getWelcomeMessageID() : "") + (String)(enableDefaultMessage ? "&text=" + URLEncoder.encode(tweet.getDefaultMessage(), "UTF-8") : "") : tweet.getText();
            Long l = threadId;
            Response response = StatusApi.DefaultImpls.status$default(this.statusApi, message, l != null ? l.toString() : null, null, String.valueOf(enableDM), 4, null).execute();
            if (!response.isSuccessful()) {
                Intrinsics.checkNotNull((Object)response);
                this.logError(response);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Attachment createAttachment(@NotNull MediaCategory mediaCategory, @NotNull String contentType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaCategory), (String)"mediaCategory");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MediaUpload mediaUploadInit = this.uploadMediaInit(mediaCategory, contentType, data.length);
        this.uploadMedia(data, mediaUploadInit.getMediaIdString());
        MediaUpload mediaUpload = this.uploadMediaFinalize(mediaUploadInit.getMediaIdString());
        return new Attachment("media", new AttachmentMedia(mediaUpload.getMediaIdString()));
    }

    private final void uploadMedia(byte[] data, String mediaId) {
        int segmentCount = (data.length + this.MEDIA_CHUNK_SIZE - 1) / this.MEDIA_CHUNK_SIZE;
        for (int segmentIndex = 0; segmentIndex < segmentCount; ++segmentIndex) {
            byte[] byArray = data;
            int start = segmentIndex * this.MEDIA_CHUNK_SIZE;
            int end = segmentIndex < segmentCount - 1 ? this.MEDIA_CHUNK_SIZE * (segmentIndex + 1) : data.length;
            byte[] chunk = ArraysKt.copyOfRange((byte[])byArray, (int)start, (int)end);
            boolean append = this.uploadMediaAppend(mediaId, segmentIndex, chunk);
            if (append) continue;
            throw new ConnectorException("Media upload append segment_index " + segmentIndex + " failed");
        }
    }

    private final MediaUpload uploadMediaInit(MediaCategory mediaCategory, String contentType, long totalBytes) {
        Response response = this.mediaApi.init(Command.INIT, totalBytes, contentType, mediaCategory.getMediaCategory(), null).execute();
        if (response.isSuccessful()) {
            MediaUpload mediaUpload;
            MediaUpload mediaUpload2 = (MediaUpload)response.body();
            if (mediaUpload2 == null) {
                throw new ConnectorException("null body");
            }
            MediaUpload it = mediaUpload = mediaUpload2;
            boolean bl = false;
            this.logger.debug(() -> TwitterClient.uploadMediaInit$lambda$15$lambda$14(it));
            return mediaUpload;
        }
        Intrinsics.checkNotNull((Object)response);
        this.logError(response);
        throw new ConnectorException("Media upload init failed");
    }

    private final boolean uploadMediaAppend(String mediaId, int segmentIndex, byte[] chunk) {
        RequestBody requestChunk = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)MediaType.Companion.get("application/octet-stream"), (byte[])chunk, (int)0, (int)0, (int)12, null);
        MultipartBody.Part body = MultipartBody.Part.Companion.createFormData("media", "chunk-segment-" + segmentIndex, requestChunk);
        Response response = this.mediaApi.append(Command.APPEND, mediaId, segmentIndex, body).execute();
        if (!response.isSuccessful()) {
            Intrinsics.checkNotNull((Object)response);
            this.logError(response);
        }
        return response.isSuccessful();
    }

    private final MediaUpload uploadMediaFinalize(String mediaId) {
        Response response = this.mediaApi.finalize(Command.FINALIZE, mediaId).execute();
        if (response.isSuccessful()) {
            MediaUpload mediaUpload;
            MediaUpload mediaUpload2 = (MediaUpload)response.body();
            if (mediaUpload2 == null) {
                throw new ConnectorException("null body");
            }
            MediaUpload it = mediaUpload = mediaUpload2;
            boolean bl = false;
            this.logger.debug(() -> TwitterClient.uploadMediaFinalize$lambda$17$lambda$16(it));
            return mediaUpload;
        }
        Intrinsics.checkNotNull((Object)response);
        this.logError(response);
        throw new ConnectorException("Media upload finalize failed");
    }

    @NotNull
    public final String b64HmacSHA256(@NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = this.consumerSecret;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec signingKey = new SecretKeySpec(byArray, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        Object object = payload;
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] bytes = mac.doFinal(byArray2);
        byte[] byArray3 = Base64.getEncoder().encode(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"encode(...)");
        object = byArray3;
        return new String((byte[])object, Charsets.UTF_8);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object logError$lambda$1(int $errorCode, String $error) {
        return "Twitter Error : " + $errorCode + " " + $error;
    }

    private static final Object logError$lambda$2(String $errorBody) {
        return "Twitter Error body : " + $errorBody;
    }

    private static final Object requestToken$lambda$5$lambda$4(String $it) {
        return $it;
    }

    private static final Object accessToken$lambda$7$lambda$6(String $it) {
        return $it;
    }

    private static final Object registerWebhook$lambda$9$lambda$8(Webhook $it) {
        return $it;
    }

    private static final Object user$lambda$11$lambda$10(User $it) {
        return $it;
    }

    private static final Object webhooks$lambda$13$lambda$12(List $it) {
        return $it;
    }

    private static final Object uploadMediaInit$lambda$15$lambda$14(MediaUpload $it) {
        return $it;
    }

    private static final Object uploadMediaFinalize$lambda$17$lambda$16(MediaUpload $it) {
        return $it;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H'J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H'J\u001e\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u000f"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$AccountActivityApi;", "", "registerWebhook", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/Webhook;", "environment", "", "url", "subscribe", "", "subscriptions", "unregisterWebhook", "webhookId", "webhooks", "", "tock-bot-connector-twitter"})
    public static interface AccountActivityApi {
        @POST(value="/1.1/account_activity/all/{environment}/webhooks.json")
        @NotNull
        public Call<Webhook> registerWebhook(@Path(value="environment") @NotNull String var1, @Query(value="url") @NotNull String var2);

        @POST(value="/1.1/account_activity/all/{environment}/subscriptions.json")
        @NotNull
        public Call<Unit> subscribe(@Path(value="environment") @NotNull String var1);

        @GET(value="/1.1/account_activity/all/{environment}/subscriptions.json")
        @NotNull
        public Call<Unit> subscriptions(@Path(value="environment") @NotNull String var1);

        @DELETE(value="/1.1/account_activity/all/{environment}/webhooks/{webhook_id}.json")
        @NotNull
        public Call<Unit> unregisterWebhook(@Path(value="environment") @NotNull String var1, @Path(value="webhook_id") @NotNull String var2);

        @GET(value="/1.1/account_activity/all/{environment}/webhooks.json")
        @NotNull
        public Call<List<Webhook>> webhooks(@Path(value="environment") @NotNull String var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\n"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$DirectMessageApi;", "", "new", "Lretrofit2/Call;", "", "OutcomingEvent", "Lai/tock/bot/connector/twitter/model/outcoming/OutcomingEvent;", "show", "events", "destroy", "tock-bot-connector-twitter"})
    public static interface DirectMessageApi {
        @POST(value="/1.1/direct_messages/events/new.json")
        @NotNull
        public Call<Unit> new(@Body @NotNull OutcomingEvent var1);

        @GET(value="/1.1/direct_messages/events/show.json")
        @NotNull
        public Call<Unit> show();

        @GET(value="/1.1/direct_messages/events/list.json")
        @NotNull
        public Call<Unit> events();

        @DELETE(value="/1.1/direct_messages/events/destroy.json")
        @NotNull
        public Call<Unit> destroy();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JD\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\nH'J6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H'J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000f\u001a\u00020\nH'\u00a8\u0006\u0015"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$MediaApi;", "", "init", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/MediaUpload;", "command", "Lai/tock/bot/connector/twitter/model/Command;", "totalBytes", "", "mediaTYpe", "", "mediaCategory", "additionalOwners", "append", "", "mediaId", "segmentIndex", "", "file", "Lokhttp3/MultipartBody$Part;", "finalize", "tock-bot-connector-twitter"})
    public static interface MediaApi {
        @POST(value="/1.1/media/upload.json")
        @NotNull
        public Call<MediaUpload> init(@Query(value="command") @NotNull Command var1, @Query(value="total_bytes") long var2, @Query(value="media_type") @NotNull String var4, @Query(value="media_category") @Nullable String var5, @Query(value="additional_owners") @Nullable String var6);

        @Multipart
        @POST(value="/1.1/media/upload.json")
        @NotNull
        public Call<Unit> append(@Query(value="command") @NotNull Command var1, @Query(value="media_id") @NotNull String var2, @Query(value="segment_index") int var3, @Part @NotNull MultipartBody.Part var4);

        @POST(value="/1.1/media/upload.json")
        @NotNull
        public Call<MediaUpload> finalize(@Query(value="command") @NotNull Command var1, @Query(value="media_id") @NotNull String var2);

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ Call init$default(MediaApi mediaApi, Command command, long l, String string, String string2, String string3, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
                }
                if ((n & 1) != 0) {
                    command = Command.INIT;
                }
                return mediaApi.init(command, l, string, string2, string3);
            }

            public static /* synthetic */ Call append$default(MediaApi mediaApi, Command command, String string, int n, MultipartBody.Part part, int n2, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
                }
                if ((n2 & 1) != 0) {
                    command = Command.APPEND;
                }
                return mediaApi.append(command, string, n, part);
            }

            public static /* synthetic */ Call finalize$default(MediaApi mediaApi, Command command, String string, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: finalize");
                }
                if ((n & 1) != 0) {
                    command = Command.FINALIZE;
                }
                return mediaApi.finalize(command, string);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\u0006"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$OAuthApi;", "", "requestToken", "Lretrofit2/Call;", "", "accessToken", "tock-bot-connector-twitter"})
    public static interface OAuthApi {
        @POST(value="/oauth/request_token")
        @NotNull
        public Call<String> requestToken();

        @POST(value="/oauth/access_token")
        @NotNull
        public Call<String> accessToken();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0003\u0010\b\u001a\u00020\u00062\b\b\u0003\u0010\t\u001a\u00020\u0006H'\u00a8\u0006\n"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$StatusApi;", "", "status", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/Tweet;", "statusMessage", "", "replyStatusId", "autoPopulateMetadata", "enableDM", "tock-bot-connector-twitter"})
    public static interface StatusApi {
        @POST(value="/1.1/statuses/update.json")
        @NotNull
        public Call<Tweet> status(@Query(value="status") @NotNull String var1, @Query(value="in_reply_to_status_id") @Nullable String var2, @Query(value="auto_populate_reply_metadata") @NotNull String var3, @Query(value="enable_dmcommands") @NotNull String var4);

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ Call status$default(StatusApi statusApi, String string, String string2, String string3, String string4, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: status");
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = "true";
                }
                if ((n & 8) != 0) {
                    string4 = "false";
                }
                return statusApi.status(string, string2, string3, string4);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lai/tock/bot/connector/twitter/TwitterClient$UserApi;", "", "user", "Lretrofit2/Call;", "Lai/tock/bot/connector/twitter/model/User;", "userId", "", "tock-bot-connector-twitter"})
    public static interface UserApi {
        @GET(value="/1.1/users/show.json")
        @NotNull
        public Call<User> user(@Query(value="user_id") @NotNull String var1);
    }
}

