/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.twitter.model.incoming;

import ai.tock.bot.connector.twitter.model.Text;
import ai.tock.bot.connector.twitter.model.Tweet;
import ai.tock.bot.connector.twitter.model.User;
import ai.tock.bot.connector.twitter.model.incoming.IncomingEvent;
import ai.tock.bot.engine.action.ActionMetadata;
import ai.tock.bot.engine.action.ActionQuote;
import ai.tock.bot.engine.action.ActionReply;
import ai.tock.bot.engine.action.ActionVisibility;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u001f\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lai/tock/bot/connector/twitter/model/incoming/TweetIncomingEvent;", "Lai/tock/bot/connector/twitter/model/incoming/IncomingEvent;", "forUserId", "", "tweets", "", "Lai/tock/bot/connector/twitter/model/Tweet;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getForUserId", "()Ljava/lang/String;", "getTweets", "()Ljava/util/List;", "ignored", "", "getIgnored", "()Z", "users", "", "Lai/tock/bot/connector/twitter/model/User;", "getUsers", "()Ljava/util/Map;", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "playerType", "Lai/tock/bot/engine/user/PlayerType;", "toEvent", "Lai/tock/bot/engine/event/Event;", "applicationId", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "tock-bot-connector-twitter"})
public final class TweetIncomingEvent
extends IncomingEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String forUserId;
    @NotNull
    private final List<Tweet> tweets;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(TweetIncomingEvent::logger$lambda$1);

    public TweetIncomingEvent(@JsonProperty(value="for_user_id") @NotNull String forUserId, @JsonProperty(value="tweet_create_events") @NotNull List<Tweet> tweets) {
        Intrinsics.checkNotNullParameter((Object)forUserId, (String)"forUserId");
        Intrinsics.checkNotNullParameter(tweets, (String)"tweets");
        this.forUserId = forUserId;
        this.tweets = tweets;
    }

    @Override
    @NotNull
    public String getForUserId() {
        return this.forUserId;
    }

    @NotNull
    public final List<Tweet> getTweets() {
        return this.tweets;
    }

    @Override
    public boolean getIgnored() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, User> getUsers() {
        return MapsKt.mapOf((Pair)new Pair((Object)((Tweet)CollectionsKt.first(this.tweets)).getUser().getId(), (Object)((Tweet)CollectionsKt.first(this.tweets)).getUser()));
    }

    @Override
    @NotNull
    public PlayerId playerId(@NotNull PlayerType playerType) {
        Intrinsics.checkNotNullParameter((Object)playerType, (String)"playerType");
        return ((Tweet)CollectionsKt.first(this.tweets)).playerId(playerType);
    }

    @Override
    @Nullable
    public Event toEvent(@NotNull String applicationId) {
        Event event;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Tweet tweet = (Tweet)CollectionsKt.first(this.tweets);
        boolean isReplyMessage = tweet.getInReplyToStatusId() != null;
        boolean isFromAccountListened = Intrinsics.areEqual((Object)this.getForUserId(), (Object)tweet.getUser().getId());
        if (!isFromAccountListened) {
            PlayerId playerId = this.playerId(PlayerType.user);
            PlayerId playerId2 = new PlayerId(this.getForUserId(), PlayerType.bot, null, 4, null);
            Object object = tweet.getExtendedTweet();
            if (object == null || (object = ((Text)object).getText()) == null) {
                object = tweet.getText();
            }
            event = (Event)new SendSentence(playerId, applicationId, playerId2, (CharSequence)object, null, null, null, null, new ActionMetadata(false, null, null, ActionVisibility.PUBLIC, isReplyMessage ? ActionReply.ISREPLY : ActionReply.NOREPLY, tweet.isQuote() ? ActionQuote.ISQUOTE : ActionQuote.NOQUOTE, false, null, false, false, false, false, 4039, null), null, null, 1776, null);
        } else {
            logger.debug(() -> TweetIncomingEvent.toEvent$lambda$0(this, tweet));
            event = null;
        }
        return event;
    }

    @NotNull
    public final String component1() {
        return this.forUserId;
    }

    @NotNull
    public final List<Tweet> component2() {
        return this.tweets;
    }

    @NotNull
    public final TweetIncomingEvent copy(@JsonProperty(value="for_user_id") @NotNull String forUserId, @JsonProperty(value="tweet_create_events") @NotNull List<Tweet> tweets) {
        Intrinsics.checkNotNullParameter((Object)forUserId, (String)"forUserId");
        Intrinsics.checkNotNullParameter(tweets, (String)"tweets");
        return new TweetIncomingEvent(forUserId, tweets);
    }

    public static /* synthetic */ TweetIncomingEvent copy$default(TweetIncomingEvent tweetIncomingEvent, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = tweetIncomingEvent.forUserId;
        }
        if ((n & 2) != 0) {
            list = tweetIncomingEvent.tweets;
        }
        return tweetIncomingEvent.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "TweetIncomingEvent(forUserId=" + this.forUserId + ", tweets=" + this.tweets + ")";
    }

    public int hashCode() {
        int result = this.forUserId.hashCode();
        result = result * 31 + ((Object)this.tweets).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TweetIncomingEvent)) {
            return false;
        }
        TweetIncomingEvent tweetIncomingEvent = (TweetIncomingEvent)other;
        if (!Intrinsics.areEqual((Object)this.forUserId, (Object)tweetIncomingEvent.forUserId)) {
            return false;
        }
        return Intrinsics.areEqual(this.tweets, tweetIncomingEvent.tweets);
    }

    private static final Object toEvent$lambda$0(TweetIncomingEvent this$0, Tweet $tweet) {
        return "ignore event " + this$0 + " with tweet text = [" + $tweet.getText() + "] from [" + $tweet.getUser().getId() + "][" + $tweet.getUser().getName() + "]";
    }

    private static final Unit logger$lambda$1() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/tock/bot/connector/twitter/model/incoming/TweetIncomingEvent$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "tock-bot-connector-twitter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

