/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.web;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaCarousel;
import ai.tock.bot.connector.media.MediaFile;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.web.WebBuildersKt;
import ai.tock.bot.connector.web.WebConnector;
import ai.tock.bot.connector.web.WebConnectorCallback;
import ai.tock.bot.connector.web.WebConnectorKt;
import ai.tock.bot.connector.web.WebConnectorRequest;
import ai.tock.bot.connector.web.WebConnectorResponse;
import ai.tock.bot.connector.web.WebMessage;
import ai.tock.bot.connector.web.WebOrchestrationJacksonConfiguration;
import ai.tock.bot.connector.web.channel.Channel;
import ai.tock.bot.connector.web.channel.Channels;
import ai.tock.bot.connector.web.send.Button;
import ai.tock.bot.connector.web.send.UrlButton;
import ai.tock.bot.connector.web.send.WebCard;
import ai.tock.bot.connector.web.send.WebCarousel;
import ai.tock.bot.connector.web.send.WebWidget;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.orchestration.bot.primary.OrchestrationKt;
import ai.tock.bot.orchestration.bot.secondary.OrchestrationCallback;
import ai.tock.bot.orchestration.bot.secondary.RestOrchestrationCallback;
import ai.tock.bot.orchestration.shared.AskEligibilityToOrchestratedBotRequest;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.ResumeOrchestrationRequest;
import ai.tock.bot.orchestration.shared.SecondaryBotEligibilityResponse;
import ai.tock.bot.orchestration.shared.SecondaryBotResponse;
import ai.tock.shared.Dice;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J1\u0010\r\u001a\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J1\u0010\r\u001a\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020&2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010-\u001a\u00020\u00182\u0006\u0010 \u001a\u00020.2\u0006\u0010\u001e\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0016J'\u00101\u001a\u0019\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00140\u000e\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u000202H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u00064"}, d2={"Lai/tock/bot/connector/web/WebConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "getPath", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "message", "suggestions", "", "", "text", "handleEligibility", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "context", "Lio/vertx/ext/web/RoutingContext;", "handleOrchestrationCallback", "callback", "Lai/tock/bot/orchestration/bot/secondary/OrchestrationCallback;", "event", "Lai/tock/bot/engine/action/Action;", "handleProxy", "handleRequest", "body", "handleWebConnectorCallback", "Lai/tock/bot/connector/web/WebConnectorCallback;", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "Lai/tock/bot/connector/ConnectorCallback;", "userId", "Lai/tock/bot/engine/user/PlayerId;", "register", "send", "Lai/tock/bot/engine/event/Event;", "delayInMs", "", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "Companion", "tock-bot-connector-web"})
public final class WebConnector
extends ConnectorBase {
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    private static final KLogger logger;
    private static final ObjectMapper webMapper;
    private static final Lazy channels$delegate;
    public static final Companion Companion;

    private final Executor getExecutor() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<Executor>(){};
        return (Executor)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ WebConnector this$0;
            final /* synthetic */ ConnectorController $controller;

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkParameterIsNotNull((Object)router, (String)"router");
                WebConnector.access$getLogger$cp().debug("deploy web connector services for root path " + this.this$0.getPath() + ' ');
                CorsHandler corsHandler = CorsHandler.create((String)"*").allowedMethod(HttpMethod.POST);
                Route route = router.route(this.this$0.getPath());
                boolean bl = false;
                boolean bl2 = false;
                CorsHandler $this$run = corsHandler;
                boolean bl3 = false;
                CorsHandler corsHandler2 = WebConnectorKt.access$getSseEnabled$p() ? $this$run.allowedMethod(HttpMethod.GET) : $this$run;
                route.handler((Handler)corsHandler2.allowedHeader("Access-Control-Allow-Origin").allowedHeader("Content-Type").allowedHeader("X-Requested-With"));
                if (WebConnectorKt.access$getSseEnabled$p()) {
                    router.route(this.this$0.getPath() + "/sse").handler((Handler)new Handler<RoutingContext>(this){
                        final /* synthetic */ register.1 this$0;

                        public final void handle(RoutingContext context) {
                            try {
                                HttpServerResponse response;
                                String userId = context.queryParams().get("userId");
                                HttpServerResponse httpServerResponse = response = context.response();
                                Intrinsics.checkExpressionValueIsNotNull((Object)httpServerResponse, (String)"response");
                                httpServerResponse.setChunked(true);
                                response.headers().add("Content-Type", "text/event-stream;charset=UTF-8");
                                response.headers().add("Connection", "keep-alive");
                                response.headers().add("Cache-Control", "no-cache");
                                long timerId2 = VertXsKt.getVertx().setPeriodic(Duration.ofSeconds(WebConnectorKt.access$getSseKeepaliveDelay$p()).toMillis(), (Handler)new Handler<Long>(response){
                                    final /* synthetic */ HttpServerResponse $response;

                                    public final void handle(Long it) {
                                        this.$response.write("event: ping\n");
                                        this.$response.write("data: 1\n\n");
                                    }
                                    {
                                        this.$response = httpServerResponse;
                                    }
                                });
                                Channels channels2 = ai.tock.bot.connector.web.WebConnector$Companion.access$getChannels$p(WebConnector.Companion);
                                String string = this.this$0.this$0.getApplicationId();
                                String string2 = userId;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"userId");
                                Channel channelId2 = channels2.register(string, string2, (Function1<? super WebConnectorResponse, Unit>)((Function1)new Function1<WebConnectorResponse, Unit>(response){
                                    final /* synthetic */ HttpServerResponse $response;

                                    public final void invoke(@NotNull WebConnectorResponse webConnectorResponse) {
                                        Intrinsics.checkParameterIsNotNull((Object)webConnectorResponse, (String)"webConnectorResponse");
                                        this.$response.write("event: message\n");
                                        this.$response.write("data: " + WebConnector.access$getWebMapper$cp().writeValueAsString((Object)webConnectorResponse) + "\n\n");
                                    }
                                    {
                                        this.$response = httpServerResponse;
                                        super(1);
                                    }
                                }));
                                response.closeHandler((Handler)new Handler<Void>(timerId2, channelId2){
                                    final /* synthetic */ long $timerId;
                                    final /* synthetic */ Channel $channelId;

                                    public final void handle(Void it) {
                                        VertXsKt.getVertx().cancelTimer(this.$timerId);
                                        ai.tock.bot.connector.web.WebConnector$Companion.access$getChannels$p(WebConnector.Companion).unregister(this.$channelId);
                                    }
                                    {
                                        this.$timerId = l;
                                        this.$channelId = channel;
                                    }
                                });
                            }
                            catch (Throwable t) {
                                context.fail(t);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                router.post(this.this$0.getPath()).handler((Handler)new Handler<RoutingContext>(this){
                    final /* synthetic */ register.1 this$0;

                    public final void handle(RoutingContext context) {
                        try {
                            WebConnector.access$getExecutor$p(this.this$0.this$0).executeBlocking((Function0)new Function0<Unit>(this, context){
                                final /* synthetic */ register.3 this$0;
                                final /* synthetic */ RoutingContext $context;

                                public final void invoke() {
                                    WebConnector webConnector = this.this$0.this$0.this$0;
                                    ConnectorController connectorController = this.this$0.this$0.$controller;
                                    RoutingContext routingContext = this.$context;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)routingContext, (String)"context");
                                    RoutingContext routingContext2 = this.$context;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)routingContext2, (String)"context");
                                    String string = routingContext2.getBodyAsString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.bodyAsString");
                                    WebConnector.access$handleRequest(webConnector, connectorController, routingContext, string);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$context = routingContext;
                                    super(0);
                                }
                            });
                        }
                        catch (Throwable e) {
                            context.fail(e);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (OrchestrationKt.getOrchestrationEnabled()) {
                    router.post(this.this$0.getPath() + "/orchestration/eligibility").handler((Handler)new Handler<RoutingContext>(this){
                        final /* synthetic */ register.1 this$0;

                        public final void handle(RoutingContext context) {
                            WebConnector.access$getExecutor$p(this.this$0.this$0).executeBlocking((Function0)new Function0<Unit>(this, context){
                                final /* synthetic */ register.4 this$0;
                                final /* synthetic */ RoutingContext $context;

                                public final void invoke() {
                                    WebConnector webConnector = this.this$0.this$0.this$0;
                                    ConnectorController connectorController = this.this$0.this$0.$controller;
                                    RoutingContext routingContext = this.$context;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)routingContext, (String)"context");
                                    WebConnector.access$handleEligibility(webConnector, connectorController, routingContext);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$context = routingContext;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    router.post(this.this$0.getPath() + "/orchestration/proxy").handler((Handler)new Handler<RoutingContext>(this){
                        final /* synthetic */ register.1 this$0;

                        public final void handle(RoutingContext context) {
                            WebConnector.access$getExecutor$p(this.this$0.this$0).executeBlocking((Function0)new Function0<Unit>(this, context){
                                final /* synthetic */ register.5 this$0;
                                final /* synthetic */ RoutingContext $context;

                                public final void invoke() {
                                    WebConnector webConnector = this.this$0.this$0.this$0;
                                    ConnectorController connectorController = this.this$0.this$0.$controller;
                                    RoutingContext routingContext = this.$context;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)routingContext, (String)"context");
                                    WebConnector.access$handleProxy(webConnector, connectorController, routingContext);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$context = routingContext;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = webConnector;
                this.$controller = connectorController;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleRequest(ConnectorController controller, RoutingContext context, String body) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook");
        try {
            logger.debug((Function0)new Function0<String>(body){
                final /* synthetic */ String $body;

                @NotNull
                public final String invoke() {
                    return "Web request input : " + this.$body;
                }
                {
                    this.$body = string;
                    super(0);
                }
            });
            ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
            boolean $i$f$readValue = false;
            String string = body;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            com.fasterxml.jackson.core.type.TypeReference typeReference = (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<WebConnectorRequest>(){};
            WebConnectorRequest request = (WebConnectorRequest)objectMapper.readValue(string, typeReference);
            Locale locale = request.getLocale();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"webMapper");
            WebConnectorCallback callback = new WebConnectorCallback(this.applicationId, locale, context, null, objectMapper2, 8, null);
            controller.handle(request.toEvent(this.applicationId), new ConnectorData((ConnectorCallback)callback, null, false, null, null, 30, null));
        }
        catch (Throwable t) {
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
            context.fail(t);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleProxy(ConnectorController controller, RoutingContext context) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook_orchestred");
        try {
            void $this$readValue$iv;
            logger.debug((Function0)new Function0<String>(context){
                final /* synthetic */ RoutingContext $context;

                @NotNull
                public final String invoke() {
                    return "Web proxy request input : " + this.$context.getBodyAsString();
                }
                {
                    this.$context = routingContext;
                    super(0);
                }
            });
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string = context.getBodyAsString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.bodyAsString");
            String content$iv = string;
            boolean $i$f$readValue = false;
            String string2 = content$iv;
            void var9_8 = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            com.fasterxml.jackson.core.type.TypeReference typeReference = (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<ResumeOrchestrationRequest>(){};
            ResumeOrchestrationRequest request = (ResumeOrchestrationRequest)var9_8.readValue(string2, typeReference);
            ConnectorType connectorType = WebConnectorKt.getWebConnectorType();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"webMapper");
            RestOrchestrationCallback callback = new RestOrchestrationCallback(connectorType, this.applicationId, context, null, objectMapper2, 8, null);
            controller.handle(request.toAction(), new ConnectorData((ConnectorCallback)callback, null, false, null, null, 30, null));
        }
        catch (Throwable t) {
            new RestOrchestrationCallback(WebConnectorKt.getWebConnectorType(), this.applicationId, context, null, null, 24, null).sendError();
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleEligibility(ConnectorController controller, RoutingContext context) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook_support");
        try {
            void $this$readValue$iv;
            logger.debug((Function0)new Function0<String>(context){
                final /* synthetic */ RoutingContext $context;

                @NotNull
                public final String invoke() {
                    return "Web support request input : " + this.$context.getBodyAsString();
                }
                {
                    this.$context = routingContext;
                    super(0);
                }
            });
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string = context.getBodyAsString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.bodyAsString");
            String content$iv = string;
            boolean $i$f$readValue = false;
            String string2 = content$iv;
            void var9_9 = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            com.fasterxml.jackson.core.type.TypeReference typeReference = (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<AskEligibilityToOrchestratedBotRequest>(){};
            AskEligibilityToOrchestratedBotRequest request = (AskEligibilityToOrchestratedBotRequest)var9_9.readValue(string2, typeReference);
            ConnectorType connectorType = WebConnectorKt.getWebConnectorType();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"webMapper");
            RestOrchestrationCallback callback = new RestOrchestrationCallback(connectorType, this.applicationId, context, null, objectMapper2, 8, null);
            double support = controller.support(request.toAction(this.applicationId), new ConnectorData((ConnectorCallback)callback, null, false, null, null, 30, null));
            PlayerId playerId = new PlayerId(this.applicationId, PlayerType.bot, null, 4, null);
            OrchestrationMetaData orchestrationMetaData = request.getMetadata();
            if (orchestrationMetaData == null || (orchestrationMetaData = orchestrationMetaData.getPlayerId()) == null) {
                orchestrationMetaData = new PlayerId(Dice.INSTANCE.newId(), PlayerType.user, null, 4, null);
            }
            SecondaryBotEligibilityResponse sendEligibility = new SecondaryBotEligibilityResponse(support, new OrchestrationMetaData(playerId, this.applicationId, (PlayerId)orchestrationMetaData));
            callback.sendResponse((SecondaryBotResponse)sendEligibility);
        }
        catch (Throwable t) {
            new RestOrchestrationCallback(WebConnectorKt.getWebConnectorType(), this.applicationId, context, null, null, 24, null).sendError();
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (event instanceof Action) {
            ConnectorCallback connectorCallback = callback;
            if (connectorCallback instanceof WebConnectorCallback) {
                this.handleWebConnectorCallback((WebConnectorCallback)callback, (Action)event);
            } else if (connectorCallback instanceof OrchestrationCallback) {
                this.handleOrchestrationCallback((OrchestrationCallback)callback, (Action)event);
            }
        } else {
            logger.trace((Function0)new Function0<String>(event){
                final /* synthetic */ Event $event;

                @NotNull
                public final String invoke() {
                    return "unsupported event: " + this.$event;
                }
                {
                    this.$event = event;
                    super(0);
                }
            });
        }
    }

    private final void handleWebConnectorCallback(WebConnectorCallback callback, Action event) {
        callback.addAction(event);
        if (WebConnectorKt.access$getSseEnabled$p()) {
            WebConnector.Companion.getChannels().send(event);
        }
        if (event.getMetadata().getLastAnswer()) {
            callback.sendResponse();
        }
    }

    private final void handleOrchestrationCallback(OrchestrationCallback callback, Action event) {
        callback.getActions().add(event);
        if (event.getMetadata().getLastAnswer()) {
            callback.sendResponse();
        }
    }

    @NotNull
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        UserPreferences userPreferences;
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        ConnectorCallback connectorCallback = callback;
        if (connectorCallback instanceof WebConnectorCallback) {
            UserPreferences userPreferences2 = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
            boolean bl = false;
            boolean bl2 = false;
            UserPreferences $this$apply = userPreferences2;
            boolean bl3 = false;
            $this$apply.setLocale(((WebConnectorCallback)callback).getLocale());
            userPreferences = userPreferences2;
        } else {
            userPreferences = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
        }
        return userPreferences;
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, WebMessage>(text, suggestions){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ List $suggestions;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final WebMessage invoke(@NotNull BotBus $receiver) {
                Collection<Button> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable iterable = this.$suggestions;
                String string = ((Object)this.$text).toString();
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CharSequence charSequence = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Button button = WebBuildersKt.webPostbackButton$default((Bus)$receiver, (CharSequence)it, null, null, null, 14, null);
                    collection.add(button);
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 60;
                String string2 = null;
                WebWidget webWidget = null;
                WebCarousel webCarousel = null;
                WebCard webCard = null;
                List list = collection;
                String string3 = string;
                return new WebMessage(string3, list, webCard, webCarousel, webWidget, string2, n, defaultConstructorMarker);
            }
            {
                this.$text = charSequence;
                this.$suggestions = list;
                super(1);
            }
        };
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, ConnectorMessage>(message, suggestions){
            final /* synthetic */ ConnectorMessage $message;
            final /* synthetic */ List $suggestions;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final ConnectorMessage invoke(@NotNull BotBus $receiver) {
                ConnectorMessage connectorMessage;
                WebMessage webMessage;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                ConnectorMessage connectorMessage2 = this.$message;
                if (!(connectorMessage2 instanceof WebMessage)) {
                    connectorMessage2 = null;
                }
                if ((webMessage = (WebMessage)connectorMessage2) != null) {
                    WebMessage webMessage2 = webMessage;
                    boolean bl = false;
                    boolean bl2 = false;
                    WebMessage it = webMessage2;
                    boolean bl3 = false;
                    webMessage = it.getButtons().isEmpty() ? webMessage2 : null;
                    if (webMessage != null) {
                        Collection<Button> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        webMessage2 = webMessage;
                        bl = false;
                        bl2 = false;
                        it = webMessage2;
                        boolean bl4 = false;
                        Iterable iterable = this.$suggestions;
                        String string = null;
                        WebMessage webMessage3 = it;
                        boolean $i$f$map = false;
                        void var11_11 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            CharSequence charSequence = (CharSequence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl5 = false;
                            Button button = WebBuildersKt.webPostbackButton$default((Bus)$receiver, (CharSequence)it2, null, null, null, 14, null);
                            collection.add(button);
                        }
                        collection = (List)destination$iv$iv;
                        webMessage = WebMessage.copy$default(webMessage3, string, (List)collection, null, null, null, null, 61, null);
                        if (webMessage != null) {
                            connectorMessage = webMessage;
                            return connectorMessage;
                        }
                    }
                }
                connectorMessage = this.$message;
                return connectorMessage;
            }
            {
                this.$message = connectorMessage;
                this.$suggestions = list;
                super(1);
            }
        };
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return (Function1)new Function1<BotBus, List<? extends WebMessage>>(message){
            final /* synthetic */ MediaMessage $message;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<WebMessage> invoke(@NotNull BotBus $receiver) {
                WebMessage webMessage;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                MediaMessage mediaMessage = this.$message;
                if (mediaMessage instanceof MediaCard) {
                    Collection<UrlButton> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    MediaFile mediaFile;
                    MediaFile mediaFile2;
                    String string;
                    List list;
                    CharSequence charSequence;
                    CharSequence charSequence2;
                    Object object;
                    String string2 = null;
                    List list2 = null;
                    CharSequence charSequence3 = ((MediaCard)this.$message).getTitle();
                    CharSequence charSequence4 = ((MediaCard)this.$message).getSubTitle();
                    Object object2 = ((MediaCard)this.$message).getFile();
                    if (object2 != null && (object2 = object2.getUrl()) != null) {
                        object = object2;
                        charSequence2 = charSequence4;
                        charSequence = charSequence3;
                        list = list2;
                        string = string2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object;
                        boolean bl3 = false;
                        MediaFile mediaFile3 = ((MediaCard)this.$message).getFile();
                        String string3 = mediaFile3 != null ? mediaFile3.getUrl() : null;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        MediaFile mediaFile4 = ((MediaCard)this.$message).getFile();
                        String string4 = mediaFile4 != null ? mediaFile4.getName() : null;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        mediaFile2 = new MediaFile(string3, string4, null, 4, null);
                        string2 = string;
                        list2 = list;
                        charSequence3 = charSequence;
                        charSequence4 = charSequence2;
                        mediaFile = mediaFile2;
                    } else {
                        mediaFile = null;
                    }
                    object = ((MediaCard)this.$message).getActions();
                    mediaFile2 = mediaFile;
                    charSequence2 = charSequence4;
                    charSequence = charSequence3;
                    list = list2;
                    string = string2;
                    boolean $i$f$map = false;
                    void var5_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        MediaAction mediaAction = (MediaAction)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        UrlButton urlButton = new UrlButton(((Object)it.getTitle()).toString(), String.valueOf(it.getUrl()));
                        collection.add(urlButton);
                    }
                    Collection<UrlButton> collection2 = collection = (List)destination$iv$iv;
                    MediaFile mediaFile5 = mediaFile2;
                    CharSequence charSequence5 = charSequence2;
                    CharSequence charSequence6 = charSequence;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 59;
                    String string5 = null;
                    WebWidget webWidget = null;
                    WebCarousel webCarousel = null;
                    WebCard webCard = new WebCard(charSequence6, charSequence5, mediaFile5, (List<? extends Button>)collection2);
                    List list3 = list;
                    String string6 = string;
                    webMessage = new WebMessage(string6, list3, webCard, webCarousel, webWidget, string5, n, defaultConstructorMarker);
                } else if (mediaMessage instanceof MediaCarousel) {
                    Collection<WebCard> collection;
                    Iterable $this$map$iv = ((MediaCarousel)this.$message).getCards();
                    WebCard webCard = null;
                    List list = null;
                    String string = null;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        Collection<UrlButton> collection3;
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        MediaFile mediaFile;
                        MediaFile mediaFile6;
                        CharSequence charSequence;
                        CharSequence charSequence7;
                        Object object;
                        void mediaCard;
                        MediaCard it = (MediaCard)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        CharSequence charSequence8 = mediaCard.getTitle();
                        CharSequence charSequence9 = mediaCard.getSubTitle();
                        Object object3 = mediaCard.getFile();
                        if (object3 != null && (object3 = object3.getUrl()) != null) {
                            object = object3;
                            charSequence7 = charSequence9;
                            charSequence = charSequence8;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Object it2 = object;
                            boolean bl6 = false;
                            MediaFile mediaFile7 = mediaCard.getFile();
                            String string7 = mediaFile7 != null ? mediaFile7.getUrl() : null;
                            if (string7 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            MediaFile mediaFile8 = mediaCard.getFile();
                            String string8 = mediaFile8 != null ? mediaFile8.getName() : null;
                            if (string8 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            mediaFile6 = new MediaFile(string7, string8, null, 4, null);
                            charSequence8 = charSequence;
                            charSequence9 = charSequence7;
                            mediaFile = mediaFile6;
                        } else {
                            mediaFile = null;
                        }
                        object = mediaCard.getActions();
                        mediaFile6 = mediaFile;
                        charSequence7 = charSequence9;
                        charSequence = charSequence8;
                        boolean $i$f$map2 = false;
                        void var18_50 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                            void button;
                            MediaAction mediaAction = (MediaAction)item$iv$iv2;
                            collection3 = destination$iv$iv2;
                            boolean bl7 = false;
                            UrlButton urlButton = new UrlButton(((Object)button.getTitle()).toString(), String.valueOf(button.getUrl()));
                            collection3.add(urlButton);
                        }
                        collection3 = (List)destination$iv$iv2;
                        List list4 = collection3;
                        MediaFile mediaFile9 = mediaFile6;
                        CharSequence charSequence10 = charSequence7;
                        CharSequence charSequence11 = charSequence;
                        WebCard webCard2 = new WebCard(charSequence11, charSequence10, mediaFile9, list4);
                        collection.add(webCard2);
                    }
                    collection = (List)destination$iv$iv;
                    List list5 = collection;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 55;
                    String string9 = null;
                    WebWidget webWidget = null;
                    WebCarousel webCarousel = new WebCarousel(list5);
                    WebCard webCard3 = webCard;
                    List list6 = list;
                    String string10 = string;
                    webMessage = new WebMessage(string10, list6, webCard3, webCarousel, webWidget, string9, n, defaultConstructorMarker);
                } else {
                    webMessage = null;
                }
                return CollectionsKt.listOfNotNull(webMessage);
            }
            {
                this.$message = mediaMessage;
                super(1);
            }
        };
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public WebConnector(@NotNull String applicationId, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        super(WebConnectorKt.getWebConnectorType());
        this.applicationId = applicationId;
        this.path = path;
    }

    static {
        Module[] moduleArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        SimpleModule simpleModule = new SimpleModule();
        int n = 0;
        Module[] moduleArray2 = moduleArray = new Module[2];
        ObjectMapper objectMapper = JacksonKt.getMapper().copy();
        boolean bl = false;
        boolean bl2 = false;
        SimpleModule $this$apply = simpleModule;
        boolean bl3 = false;
        $this$apply.addSerializer(CharSequence.class, (JsonSerializer)new ToStringSerializer());
        SimpleModule simpleModule2 = simpleModule;
        moduleArray[n] = (Module)simpleModule2;
        moduleArray2[1] = (Module)WebOrchestrationJacksonConfiguration.INSTANCE.getModule();
        webMapper = objectMapper.registerModules(moduleArray2);
        channels$delegate = LazyKt.lazy((Function0)Companion.channels.2.INSTANCE);
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ObjectMapper access$getWebMapper$cp() {
        return webMapper;
    }

    public static final /* synthetic */ Executor access$getExecutor$p(WebConnector $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ void access$handleRequest(WebConnector $this, ConnectorController controller, RoutingContext context, String body) {
        $this.handleRequest(controller, context, body);
    }

    public static final /* synthetic */ void access$handleEligibility(WebConnector $this, ConnectorController controller, RoutingContext context) {
        $this.handleEligibility(controller, context);
    }

    public static final /* synthetic */ void access$handleProxy(WebConnector $this, ConnectorController controller, RoutingContext context) {
        $this.handleProxy(controller, context);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/tock/bot/connector/web/WebConnector$Companion;", "", "()V", "channels", "Lai/tock/bot/connector/web/channel/Channels;", "getChannels", "()Lai/tock/bot/connector/web/channel/Channels;", "channels$delegate", "Lkotlin/Lazy;", "logger", "Lmu/KLogger;", "webMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "tock-bot-connector-web"})
    public static final class Companion {
        private final Channels getChannels() {
            Lazy lazy = channels$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Channels)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

